 /*
 *  file      : cd_cddb.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib/gprintf.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <cddb/cddb.h>
#include <sys/types.h>
#include <cdio/cdio.h>
#include <cdio/cdtext.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "cd_audio.h"
#include "get_info.h"
#include "cd_cue.h"
#include "configuser.h"
#include "poche.h"
#include "cd_cddb.h"



#define CDDA_DATA_SIZE 2352





typedef struct {
	gchar		*Duree;
	gchar		*Artist;
	gchar		*Title;
	gint		Sector;
	gint		SectorCdParanoia;
} VAR_STRUCT_CDDB;

typedef struct {
	gint		TotalTracks;
	gchar		Message [ 100 ];
	gchar		*TitleCD;
	gchar		*Title;
	gchar		*Artiste;
	gchar		*StrDureeCd;
	gint		NumGenre;
	gchar		*StrGenre;
	gint		NumYear;
	gchar		*StrYear;
	gboolean	BoolMultiArtiste;
	
	VAR_STRUCT_CDDB	*VarStructCddb;		// 0 .. TotalTracks -1
	
} VAR_CDDB;

VAR_CDDB VarCddb = {
		0,
		"",
		NULL,
		NULL,
		NULL,
		NULL,
		0,
		NULL,
		0,
		NULL,
		FALSE
		};



// 
// 
void CdCddb_init_entete_cd (void)
{
	if( NULL != EnteteCD.TitleCD ) {
		g_free( EnteteCD.TitleCD );
		EnteteCD.TitleCD = NULL;
	}
	if( NULL != EnteteCD.Title ) {
		g_free( EnteteCD.Title );
		EnteteCD.Title = NULL;
	}
	if( NULL != EnteteCD.Artiste ) {
		g_free( EnteteCD.Artiste );
		EnteteCD.Artiste = NULL;
	}
	if( NULL != EnteteCD.StrDureeCd ) {
		g_free( EnteteCD.StrDureeCd );
		EnteteCD.StrDureeCd = NULL;
	}
	if( NULL != EnteteCD.StrGenre ) {
		g_free( EnteteCD.StrGenre );
		EnteteCD.StrGenre = NULL;
	}
	if( NULL != EnteteCD.StrYear ) {
		g_free( EnteteCD.StrYear );
		EnteteCD.StrYear = NULL;
	}
	
	cdaudio_deallocate_glist();
	
	if( NULL != EnteteCD.Message ) {
		g_free( EnteteCD.Message );
		EnteteCD.Message = NULL;
	}
	if( NULL != EnteteCD.StrMemoTagComment ) {
		g_free( EnteteCD.StrMemoTagComment );
		EnteteCD.StrMemoTagComment = NULL;
	}
}
// 
// 
void CdCddb_remove_struct( void )
{
	gint	NumList;
	
	VarCddb . TotalTracks = 0;
	VarCddb . Message [ 0 ] = '\0';
	if( NULL != VarCddb . TitleCD )		{ g_free( VarCddb . TitleCD );		VarCddb . TitleCD = NULL; }
	if( NULL != VarCddb . Title )		{ g_free( VarCddb . Title );		VarCddb . Title = NULL; }
	if( NULL != VarCddb . Artiste )		{ g_free( VarCddb . Artiste );		VarCddb . Artiste = NULL; }
	if( NULL != VarCddb . StrDureeCd )	{ g_free( VarCddb . StrDureeCd );	VarCddb . StrDureeCd = NULL; }
	if( NULL != VarCddb . StrGenre )	{ g_free( VarCddb . StrGenre );		VarCddb . StrGenre = NULL; }
	if( NULL != VarCddb . StrYear )		{ g_free( VarCddb . StrYear );		VarCddb . StrYear = NULL; }
	
	if( NULL != VarCddb . VarStructCddb ) {
		for( NumList = 0; NumList < VarCddb . TotalTracks; NumList++ ) {
			
			if( NULL != VarCddb . VarStructCddb [ NumList ] . Duree ) {
				g_free( VarCddb . VarStructCddb [ NumList ] . Duree );		VarCddb . VarStructCddb [ NumList ] . Duree = NULL;
			}
			if( NULL != VarCddb . VarStructCddb [ NumList ] . Artist ) {
				g_free( VarCddb . VarStructCddb [ NumList ] . Artist );		VarCddb . VarStructCddb [ NumList ] . Artist = NULL;
			}
			if( NULL != VarCddb . VarStructCddb [ NumList ] . Title ) {
				g_free( VarCddb . VarStructCddb [ NumList ] . Title );		VarCddb . VarStructCddb [ NumList ] . Title = NULL;
			}
		}
		g_free( VarCddb . VarStructCddb );	VarCddb . VarStructCddb = NULL;
	}
}
// 
// 
gint CdCddb_cdparanoia_get_total_tracks( gchar *buffer )
{
	gchar  **Larrbuf = NULL;
	gint     Track;
	gint     TotalTracks = -1;
	gchar    *ptr;

	Larrbuf = g_strsplit( buffer, "\n", 0 );

	for( Track = 0; Larrbuf[ Track ]; Track++ ) {
		if( strstr (Larrbuf[ Track ], "TOTAL" )) {
			Track --;
			break;
		}
	}
	if( NULL != ( ptr = Larrbuf[ Track ] )) {
		while( *ptr == ' ' ) ptr ++;
		TotalTracks = atoi( ptr );
	}
	g_strfreev( Larrbuf );
	
	return( TotalTracks );
}
// 
// 
void CdCddb_cdparanoia_get_sectors ( gchar *buffer )
{
	gchar	**Larrbuf = NULL;
	gint	piste;
	gchar	*ptr = NULL;
	gint	Track = 0;
	
	Larrbuf = g_strsplit( buffer, "\n", 0 );
	for( piste = 0; Larrbuf[ piste ]; piste ++ ) {
		if( strstr( Larrbuf[ piste ], "TOTAL" )) {
			ptr = Larrbuf[ piste ];
			while( *ptr && *ptr != ' ' ) ptr ++;
			while( *ptr && *ptr == ' ' ) ptr ++;
			if( *ptr ) {
				VarCddb . VarStructCddb [ Track ] . SectorCdParanoia = atoi( ptr );
			}
			break;
		}
		
		if( NULL != ( ptr = strchr( Larrbuf[ piste ], ']' ))) {
			ptr ++;
			while( *ptr && *ptr == ' ' ) ptr ++;
			if( *ptr )
				VarCddb . VarStructCddb [ Track ] . SectorCdParanoia = atoi( ptr );
				Track ++;
		}
	}
	g_strfreev( Larrbuf );
}
// 
// GET TOTAL TRACKS WITH DATA_TRACK IF EXIST
// GET SECTORS
// 
void CdCddb_disc_info( CdIo_t *p_cdio )
{
	track_t		i_first_track = cdio_get_first_track_num( p_cdio );
	track_t		i_tracks      = cdio_get_num_tracks( p_cdio );
	track_t		i_last_track  = i_first_track + i_tracks;
	lba_t		SectorMoins   = cdio_get_track_lba( p_cdio, i_first_track );
	lba_t		Sector;
	gint		Track = 0;
	  
	PRINT_FUNC_LF();
	
	g_print( "\ttotal_tracks with cdio  = %d\n", i_last_track -1 );
	
	// GET TOTAL TRACKS WITH DATA_TRACK IF EXIST
	VarCddb . TotalTracks = i_last_track -1;
	
	// ALLOCATE DATAS SECTORS
	VarCddb . VarStructCddb = ( VAR_STRUCT_CDDB * ) g_malloc0( sizeof( VAR_STRUCT_CDDB ) * ( VarCddb . TotalTracks + 6 ));

	// INIT DATAS SECTORS
	for( Track = 0 ; Track < VarCddb . TotalTracks + 4; Track++ ) {
		VarCddb . VarStructCddb [ Track ] . Duree   = NULL;
		VarCddb . VarStructCddb [ Track ] . Artist  = NULL;
		VarCddb . VarStructCddb [ Track ] . Title   = NULL;
		VarCddb . VarStructCddb [ Track ] . Sector = -1;
		VarCddb . VarStructCddb [ Track ] . SectorCdParanoia = -1;
	}
	
	SectorMoins = cdio_get_track_lba( p_cdio, i_first_track );
	
	for ( ; i_first_track <= i_last_track; i_first_track++ ) {

		Sector = cdio_get_track_lba( p_cdio, i_first_track );
		VarCddb . VarStructCddb [ i_first_track -1 ] . Sector = ( Sector - SectorMoins );
		
		// g_print ("%02d  ", i_first_track );
		// g_print ("SECTOR = %d   ", Sector - SectorMoins );
		// g_print ( "\n" );
	}
}
// 
// 
gboolean CdCddb_get_from_cdio( void )
{
	CdIo_t		*p_cdio = NULL;
	discmode_t	cd_discmode;
	
	// PRINT_FUNC_LF();
	
	p_cdio = cdio_open( EnteteCD.NameCD_Device, DRIVER_DEVICE );	// DRIVER_DEVICE  DRIVER_UNKNOWN
	cd_discmode  = cdio_get_discmode(p_cdio);
	if( cd_discmode == CDIO_DISC_MODE_CD_DA ) {
		g_print("discmode2str = %s\n", discmode2str[ cd_discmode ] );
	} else {
		g_print( "\tCouldn't find CD\n" );
		return( FALSE );
	}
	
	if (NULL == p_cdio) {
		g_print("\tCouldn't find CD\n");
		return( FALSE );
	} else {
		CdCddb_disc_info( p_cdio );
		cdio_destroy( p_cdio );
	}
	
	return( TRUE );
}

#define CDDB_RET_OK		0
#define CDDB_RET_NO_CD		1
#define CDDB_RET_NO_CONNECT	2
#define CDDB_RET_NO_BASE	3
#define CDDB_RET_NO_ALLOC	4

// RETURN
// 	0  OK
// 	1  COULDN'T FIND CD
//	2  PAS DE CONNEXION WEB
//	3  PAS DE BASE POUR CE DISQUE
// 	4  PROBLEME D'ALLOCATION MEMOIRE
// 
gint CdCddb_read_datas (void)
{
	cddb_conn_t	*p_cddb = NULL;
   	cddb_disc_t	*p_disc = NULL;
   	gint		Track;
	gint		NbrMatchsFound;
	gint		min;
	gint		len;
	gint		TempDiv;
	gint		TempMod;
	gint		RetValue = CDDB_RET_OK;
	GString		*gstr = NULL;
	gint		TotalTracks;
	
	// PRINT_FUNC_LF();
	
	// REMOVE VarCddb
	CdCddb_remove_struct();
	
	// GET TOTAL TRACKS WITH DATA_TRACK IF EXIST
	// GET SECTORS
	if( FALSE == CdCddb_get_from_cdio() ) {
		g_print( "COULDN'T FIND CD\n" );
 		strcpy( VarCddb . Message, _("Couldn't find CD") );
		RetValue = CDDB_RET_NO_CD;
		return( RetValue );
	}
	
	// GET REAL TRACKS AND GET REAL SECTORS FROM CDPARANOIA
	gstr = GetInfo_cdparanoia (EnteteCD.NameCD_Device);
	g_print("gstr->str=\n%s", gstr->str);
	if( ( TotalTracks = CdCddb_cdparanoia_get_total_tracks( gstr->str ) ) > -1 ) {
		CdCddb_cdparanoia_get_sectors( gstr->str );
	}
	g_string_free (gstr, TRUE);
	gstr = NULL;
	
	g_print( "total_tracks with cdparanoia = %d\n", TotalTracks );
	
	// CALL LIBCDDB
	if( NULL != ( p_cddb = cddb_new() ) ) {
		if( SERVER_CDDB_PARAM == Config.ServeurCddb ) {
			cddb_set_server_name( p_cddb, Config.entry_cddp_server );
			g_print( "With SERVER_CDDB_PARAM       = %s\n", Config.entry_cddp_server);
		}
		else {
			cddb_set_server_name( p_cddb, "freedb.org" );
			g_print( "With SERVER_CDDB_AUTO        = freedb.org\n" );
		}
		g_print( "-------------------------------------------------\n" );
		g_print( "SET ...\n" );
		cddb_set_server_port( p_cddb, 888 );
		g_print( "\tcddb_set_server_port: OK\n" );
		cddb_cache_disable( p_cddb );
		g_print( "\tcddb_cache_disable: OK\n" );
		cddb_set_timeout( p_cddb, 10 );
		g_print( "\tcddb_set_timeout: OK\n" );
		cddb_http_disable( p_cddb );
		g_print( "\tcddb_http_disable: OK\n" );
	
		if( NULL != ( p_disc = cddb_disc_new() ) ) {
			
			int64_t i_length = 0;
			
			g_print( "RECHERCHE CDDB\n" );
			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
				cddb_track_t *t = cddb_track_new();
				cddb_track_set_frame_offset( t, VarCddb . VarStructCddb [ Track ] . Sector );
				cddb_disc_add_track( p_disc, t );
				const int64_t i_size = ( VarCddb . VarStructCddb [ Track +1 ] . Sector - VarCddb . VarStructCddb [ Track ] . Sector ) *(int64_t)CDDA_DATA_SIZE;
				i_length += 1000000 * i_size / 44100 / 4;
			}
			g_print( "\tframe + track: OK\n" );
			cddb_disc_set_length( p_disc, (int)( i_length / 1000000 ) );
			cddb_disc_calc_discid( p_disc );
			g_print( "\tlength + discid: OK\n" );
			
			g_print( "-------------------------------------------------\n" );
			NbrMatchsFound = cddb_query( p_cddb, p_disc );
			g_print( "cddb_query()   = %d\n", NbrMatchsFound );
			g_print( "NbrMatchsFound = %d\n", NbrMatchsFound );
			if( NbrMatchsFound < 0 ) {
				g_print( "LA LIAISON INTERNET EST ABSENTE\n" );
 				strcpy( VarCddb . Message, _("La liaison internet est absente") );
				RetValue = CDDB_RET_NO_CONNECT;
			}
			
			if( NbrMatchsFound < 0 ) {
				g_print( "LA LIAISON INTERNET EST ABSENTE\n" );
 				strcpy( VarCddb . Message, _("La liaison internet est absente") );
				RetValue = CDDB_RET_NO_CONNECT;
			}
			else if( NbrMatchsFound == 0 ) {
				g_print( "PAS DE BASE CDDB POUR CE DISQUE\n" );
 				strcpy( VarCddb . Message, _("Pas de base CDDB pour ce disque") );
				RetValue = CDDB_RET_NO_BASE;
			}
			else if( NbrMatchsFound > 1 ) {
				g_print( "found %d matches in CDDB. Using first one.\n", NbrMatchsFound );
			}
			
			if( cddb_read( p_cddb, p_disc ) < 0 ) {
				g_print( "LA LIAISON INTERNET EST ABSENTE\n" );
 				strcpy( VarCddb . Message, _("La liaison internet est absente") );
				RetValue = CDDB_RET_NO_CONNECT;
			}

			g_print( "-------------------------------------------------\n" );
			if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue )
				VarCddb . TitleCD = g_strdup( cddb_disc_get_title( p_disc ));
			else	VarCddb . TitleCD = g_strdup( "TitleCD" );
			g_print( "TITLE  = %s\n", VarCddb . TitleCD);
			
			if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue )
				VarCddb . Artiste = g_strdup( cddb_disc_get_artist( p_disc ));
			else	VarCddb . Artiste = g_strdup( " " );
			g_print( "ARTIST = %s\n", VarCddb . Artiste);
			
			if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue )
				VarCddb . StrGenre = g_strdup( cddb_disc_get_genre( p_disc ));
			else	VarCddb . StrGenre = g_strdup( "StrGenre" );
			g_print( "GENRE  = %s\n", VarCddb . StrGenre);
			
			if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue )
				VarCddb . NumYear = cddb_disc_get_year( p_disc );
			else	VarCddb . NumYear = 1962;
			VarCddb . StrYear = g_strdup_printf( "%d", VarCddb . NumYear );
			g_print( "YEAR   = %d\n", VarCddb . NumYear);
			
			// g_sprintf (CdToc->Str_ID_CD, "%08lx", CdToc->Num_ID_CD);
			if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue )
				g_print( "DISCID = %x\n", cddb_disc_get_discid( p_disc ));
			else	g_print( "DISCID = 0\n");
			
			len = VarCddb . VarStructCddb [ TotalTracks ] . SectorCdParanoia - VarCddb . VarStructCddb [ 0 ] . SectorCdParanoia;
			VarCddb . StrDureeCd = g_strdup_printf( "%02d:%02d", ( len / 60 ) / 75,  ( len / 75 ) % 60 );
			g_print( "DUREE  = %s\n", VarCddb . StrDureeCd );
			g_print( "-------------------------------------------------\n" );
			len = 0;
			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
				
				g_print( "%02d  ", Track +1 );
								
				// CONNECT IS OK
				if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue ) {
					
					cddb_track_t *t = cddb_disc_get_track( p_disc, Track );
				
					if( NULL == t ) continue;
				
					// ARTISTE
					VarCddb . VarStructCddb [ Track ] . Artist = g_strdup( cddb_track_get_artist( t ));
					g_print( "%s\t", VarCddb . VarStructCddb [ Track ] . Artist);
				
					// TITRE PISTE
					VarCddb . VarStructCddb [ Track ] . Title = g_strdup( cddb_track_get_title( t ));
					g_print( "%s       ", VarCddb . VarStructCddb [ Track ] . Title);
					
				}
				// NO CONNECT
				else {
					// ARTISTE
					VarCddb . VarStructCddb [ Track ] . Artist = g_strdup( "Artist" );
					g_print( "%s\t", VarCddb . VarStructCddb [ Track ] . Artist);
				
					// TITRE PISTE
					VarCddb . VarStructCddb [ Track ] . Title = g_strdup( "Title" );
					g_print( "%s", VarCddb . VarStructCddb [ Track ] . Title);
				}
				
				g_print( "\n" );
			}
			
			g_print( "-------------------------------------------------\n" );
			g_print( "cddb_disc_get_category_str() = %s\n", cddb_disc_get_category_str( p_disc ));
			g_print( "cddb_disc_get_category()     = %d\n", cddb_disc_get_category( p_disc ));
			
			if( CDDB_RET_NO_CONNECT != RetValue && CDDB_RET_NO_BASE != RetValue )
				VarCddb . StrGenre = g_strdup( cddb_disc_get_genre( p_disc ));
			else	VarCddb . StrGenre = g_strdup( "Rock" );
			g_print( "VarCddb . StrGenre           = %s\n", VarCddb . StrGenre);
			VarCddb . NumGenre = tags_get_genre_by_value( VarCddb . StrGenre );
			g_print( "VarCddb . NumGenre           = %d\n", VarCddb . NumGenre);
			
			// cddb_disc_print (p_disc);
			
			// BASE ADJUSTMENT FROM CDPARANOIA
			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
				VarCddb . VarStructCddb [ Track ] . Sector = VarCddb . VarStructCddb [ Track ] . SectorCdParanoia;
			}
			VarCddb . TotalTracks = TotalTracks;
			g_print( "RECTIF FOR : DataTrack\n" );
			g_print( "\tVarCddb . TotalTracks       = %d\n",  VarCddb . TotalTracks );
			g_print( "\tTotalTracks with cdparanoia = %d\n\n",  TotalTracks );
			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
				 // DUREE D'ECOUTE DES PISTES
				min = VarCddb . VarStructCddb [ Track +1 ] . Sector - VarCddb . VarStructCddb [ Track ] . Sector;
				VarCddb . VarStructCddb [ Track ] . Duree = g_strdup_printf( "%02d:%02d", ( min / 60 ) / 75, ( min / 75 ) % 60 );
			}
			
			// SET DATAS FOR CD_CUE
			cdcue_alloc_base_ioctl( VarCddb . TotalTracks );
			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
				BaseIoctl.Datas[ Track ].length = -1;
				BaseIoctl.Datas[ Track ].begin  = -1;
			}

			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
		
				BaseIoctl.Datas[ Track ].length = VarCddb . VarStructCddb [ Track +1 ] . Sector - VarCddb . VarStructCddb [ Track ] . Sector;
				TempDiv = BaseIoctl.Datas[ Track ].length / 75;
				TempMod = BaseIoctl.Datas[ Track ].length % 75;
				BaseIoctl.Datas[ Track ].length_min  = TempDiv / 60;
				BaseIoctl.Datas[ Track ].length_sec  = TempDiv % 60;
				BaseIoctl.Datas[ Track ].length_cent = TempMod;
			}
			BaseIoctl.Datas[ 0 ].begin = VarCddb . VarStructCddb [ 0 ] . Sector % 75;
	
			for( Track = 0; Track < VarCddb . TotalTracks; Track++ ) {
		
				BaseIoctl.Datas[ Track +1 ].begin = BaseIoctl.Datas[ Track ].length + BaseIoctl.Datas[ Track ].begin;
				TempDiv = BaseIoctl.Datas[ Track ].begin / 75;
				TempMod = BaseIoctl.Datas[ Track ].begin % 75;
				BaseIoctl.Datas[ Track ].begin_min  = TempDiv / 60;
				BaseIoctl.Datas[ Track ].begin_sec  = TempDiv % 60;
				BaseIoctl.Datas[ Track ].begin_cent = TempMod;
			}
			BaseIoctl.Datas[ VarCddb . TotalTracks ].begin  = BaseIoctl.Datas[ Track ].length + BaseIoctl.Datas[ Track ].begin;
			BaseIoctl.Datas[ VarCddb . TotalTracks ].begin -= BaseIoctl.Datas[ 0 ].begin;
			TempDiv = BaseIoctl.Datas[ VarCddb . TotalTracks ].begin / 75;
			TempMod = BaseIoctl.Datas[ VarCddb . TotalTracks ].begin % 75;
			BaseIoctl.Datas[ VarCddb . TotalTracks ].begin_min  = TempDiv / 60;
			BaseIoctl.Datas[ VarCddb . TotalTracks ].begin_sec  = TempDiv % 60;
			BaseIoctl.Datas[ VarCddb . TotalTracks ].begin_cent = TempMod;
			
			cdcue_make_cue();

			BaseIoctl.Performer = g_strdup( VarCddb . TitleCD );
			BaseIoctl.Title     = g_strdup( VarCddb . TitleCD );
			BaseIoctl.File      = g_strdup_printf ("%s.wav", VarCddb . TitleCD);
	
			for( Track = 0; Track < BaseIoctl.TotalTracks; Track++ ) {
				BaseIoctl.Cue [ Track ].Performer = g_strdup( VarCddb . TitleCD );
				BaseIoctl.Cue [ Track ].Title     = g_strdup( VarCddb . VarStructCddb [ Track ] . Title );
			}

			cdcue_print_base_ioctl();
			
			cddb_disc_destroy( p_disc );
		}
		cddb_destroy( p_cddb );
	}

	return( RetValue );
}
// P_ETAT = 
// 	->0  OK
// 	  1  PROBLEME D'ALLOCATION MEMOIRE
// 	  2  CD NON AUDIO OU CD ABSENT DU LECTEUR
// 	  3  LE CD DANS LECTEUR N'EST PAS UN CD-AUDIO
//	->4  PAS DE CONNEXION WEB
//	->5  PAS DE BASE POUR CE DISQUE
//	  6  ERREUR DE LECTURE DEPUIS LE CD
//	  7  CD ABSENT DU LECTEUR
// 
void CdCddb_set_toc_to_glist_audio (gint p_etat)
{
	gint		NumList;
	CD_AUDIO	*Audio = NULL;
	GString 	*gstr_buffer_title             = g_string_new (NULL);
	GString 	*gstr_buffer_title_time        = g_string_new (NULL);
	GString 	*gstr_buffer_artist_title_time = g_string_new (NULL);
	
	// TODO: DEBUG: manuker: http://forum.ubuntu-fr.org/viewtopic.php?pid=4631891#p4631891
	PRINT_FUNC_LF();

	// REMOVE DATAS entete
	CdCddb_init_entete_cd();
	poche_remove_view();
	
	EnteteCD.Message = g_strdup( VarCddb . Message );
	
	// 
	switch( p_etat ) {
	case CDDB_RET_OK :		// OK
		
		view.TitleCD = g_strdup_printf( "%s  -  %s", VarCddb . Artiste, VarCddb . TitleCD );
		
		EnteteCD.TitleCD     = g_strdup_printf( "%s  -  %s", VarCddb . Artiste, VarCddb . TitleCD );
		EnteteCD.Artiste     = g_strdup( VarCddb . TitleCD );
		EnteteCD.TotalTracks = VarCddb . TotalTracks;
		EnteteCD.NumGenre    = VarCddb . NumGenre;
		EnteteCD.StrGenre    = g_strdup( VarCddb . StrGenre );
		EnteteCD.NumYear     = VarCddb . NumYear;
		EnteteCD.StrYear     = g_strdup( VarCddb . StrYear );
		EnteteCD.StrDureeCd  = g_strdup( VarCddb . StrDureeCd );
		break;
	case CDDB_RET_NO_CONNECT :	// PAS DE CONNEXION WEB
	case CDDB_RET_NO_BASE :		// PAS DE BASE POUR CE DISQUE
		
		view.TitleCD = g_strdup( "Track" );
		
		EnteteCD.TitleCD     = g_strdup( "Track" );
		EnteteCD.Title       = g_strdup( "Track" );
		EnteteCD.Artiste     = g_strdup( "Track" );
		EnteteCD.TotalTracks = VarCddb . TotalTracks;
		EnteteCD.StrDureeCd  = g_strdup( VarCddb . StrDureeCd );
		break;
	}
	
	for( NumList = 0; NumList < VarCddb . TotalTracks; NumList++ ) {

		Audio = ( CD_AUDIO * )g_malloc0( sizeof( CD_AUDIO ));
		
		Audio->EtatPlay                 = CD_ETAT_PLAY_ATTENTE;

		Audio->Bool_Delette_Flac	= FALSE;
		Audio->Bool_Delette_Wav		= FALSE;
		Audio->Bool_Delette_Mp3		= FALSE;
		Audio->Bool_Delette_Ogg		= FALSE;
		Audio->Bool_Delette_M4a		= FALSE;
		Audio->Bool_Delette_Mpc		= FALSE;
		Audio->Bool_Delette_Ape		= FALSE;
		Audio->Bool_Delette_WavPack	= FALSE;

		Audio->EtatSelection_Flac	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_Wav	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_Mp3	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_Ogg	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_M4a	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_Mpc	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_Ape	= CD_ETAT_ATTENTE;
		Audio->EtatSelection_WavPack	= CD_ETAT_ATTENTE;

		Audio->Etat_Flac		= ETAT_CONV_CD_NONE;
		Audio->Etat_Wav			= ETAT_CONV_CD_NONE;
		Audio->Etat_Mp3			= ETAT_CONV_CD_NONE;
		Audio->Etat_Ogg			= ETAT_CONV_CD_NONE;
		Audio->Etat_m4a			= ETAT_CONV_CD_NONE;
		Audio->Etat_Mpc			= ETAT_CONV_CD_NONE;
		Audio->Etat_Ape			= ETAT_CONV_CD_NONE;
		Audio->Etat_WavPack		= ETAT_CONV_CD_NONE;
		Audio->EtatNormalise		= CD_NORM_PEAK_NONE;

		Audio->PathName_Dest_Flac	= NULL;
		Audio->PathName_Dest_Wav	= NULL;
		Audio->PathName_Dest_Mp3	= NULL;
		Audio->PathName_Dest_Ogg	= NULL;
		Audio->PathName_Dest_M4a	= NULL;
		Audio->PathName_Dest_Mpc	= NULL;
		Audio->PathName_Dest_Ape	= NULL;
		Audio->PathName_Dest_WavPack	= NULL;
				
		Audio->tags = ( TAGS * )tags_alloc( TRUE );
	
		Audio->Num_Track		= NumList + 1;
		Audio->Str_Track		= g_strdup_printf ("%02d", NumList + 1);
		Audio->Duree			= g_strdup( VarCddb . VarStructCddb [ NumList ] . Duree );
		Audio->NameSong			= g_strdup_printf ("Track_%02d", NumList + 1);
		
		// view.TitleCD = g_strdup ( VarCddb . TitleCD );
		view.Buffer_none = 
		view.Buffer_title = 
		view.Buffer_title_time = 
		view.Buffer_artist_title_time = NULL;
		
		// OK
		if( CDDB_RET_OK == p_etat ) {
			
			g_print( "TITLE_CD: %s  ", VarCddb . TitleCD );
			g_print( "TRACK: %d  ", NumList + 1 );
			g_print( "DUREE: %s  ", VarCddb . VarStructCddb [ NumList ] . Duree );
			g_print( "ARTIST: %s  ", VarCddb . VarStructCddb [ NumList ] . Artist );
			g_print( "TITLE: %s  ", VarCddb . VarStructCddb [ NumList ] . Title );
			g_print( "YEAR: %d  ", VarCddb . NumYear );
			g_print( "\n" );
		
			// TITRE
			g_string_append_printf( gstr_buffer_title, "%s\n", VarCddb . VarStructCddb [ NumList ] . Title );
			// TITRE - TEMPS
			g_string_append_printf( gstr_buffer_title_time, "%s  ][  ", VarCddb . VarStructCddb [ NumList ] . Title );
			g_string_append_printf( gstr_buffer_title_time, "%s\n", VarCddb . VarStructCddb [ NumList ] . Duree );
			// ARTISTE - TITRE - TEMPS
			g_string_append_printf( gstr_buffer_artist_title_time, "%s  -  ", VarCddb . VarStructCddb [ NumList ] . Artist );
			g_string_append_printf( gstr_buffer_artist_title_time, "%s  ][  ", VarCddb . VarStructCddb [ NumList ] . Title );
			g_string_append_printf( gstr_buffer_artist_title_time, "%s\n", VarCddb . VarStructCddb [ NumList ] . Duree );

			if( NULL != VarCddb . VarStructCddb [ NumList ] . Title ) {
				g_free( Audio->NameSong );	Audio->NameSong = NULL;
				Audio->NameSong = g_strdup( VarCddb . VarStructCddb [ NumList ] . Title );
			}
			Audio->tags = (TAGS *)tags_remove (Audio->tags);
			Audio->tags = (TAGS *)tags_alloc (TRUE);
			Audio->tags->Album = g_strdup( VarCddb . TitleCD );
			if( NULL != VarCddb . VarStructCddb [ NumList ] . Title ) {
				Audio->tags->Artist = g_strdup( VarCddb . VarStructCddb [ NumList ] . Artist );
				Audio->tags->Title  = g_strdup( VarCddb . VarStructCddb [ NumList ] . Title );
			}
			Audio->tags->Year      = g_strdup( EnteteCD.StrYear );
			Audio->tags->IntYear   = EnteteCD.NumYear;
			Audio->tags->IntGenre  = EnteteCD.NumGenre;
			Audio->tags->Genre     = g_strdup( EnteteCD.StrGenre );
			Audio->tags->Number    = g_strdup_printf ("%d", NumList +1);
			Audio->tags->IntNumber = NumList +1;
			Audio->tags->Comment   = g_strdup ("By Xcfa");
		}
		
		// PAS DE CONNEXION WEB
		else if( CDDB_RET_NO_CONNECT == p_etat ) {
			
			// TITRE
			g_string_append_printf( gstr_buffer_title, "Track_%02d\n", NumList +1 );
			// TITRE - TEMPS
			g_string_append_printf( gstr_buffer_title_time, "Track_%02d  ][  ", NumList +1 );
			g_string_append_printf( gstr_buffer_title_time, "%s\n", VarCddb . VarStructCddb [ NumList ] . Duree );
			// ARTISTE - TITRE - TEMPS
			// g_string_append_printf( gstr_buffer_artist_title_time, "%s  -  ", VarCddb . VarStructCddb [ NumList ] . Artist );
			g_string_append_printf( gstr_buffer_artist_title_time, "Track_%02d  ][  ", NumList +1 );
			g_string_append_printf( gstr_buffer_artist_title_time, "%s\n", VarCddb . VarStructCddb [ NumList ] . Duree );

			Audio->tags = (TAGS *)tags_remove (Audio->tags);
			Audio->tags = (TAGS *)tags_alloc (TRUE);
			
			Audio->tags->Album       = g_strdup ("Track");
			Audio->tags->Artist      = g_strdup ("");
			Audio->tags->Title       = g_strdup_printf ("Track_%02d", NumList +1);
			Audio->tags->Number      = g_strdup_printf ("%d", NumList +1);
			Audio->tags->IntNumber   = NumList +1;
			Audio->tags->Genre       = g_strdup ("A Cappella");
			Audio->tags->IntGenre    = 123;
			Audio->tags->Year        = g_strdup ("1962");
			Audio->tags->IntYear     = 1962;
			Audio->tags->Comment     = g_strdup ("By Xcfa");
			Audio->tags->Description = g_strdup ("By Xcfa");
		}
		
		// PAS DE BASE POUR CE DISQUE
		else if( CDDB_RET_NO_BASE == p_etat ) {
				
			// TITRE
			g_string_append_printf( gstr_buffer_title, "Track_%02d\n", NumList +1 );
			// TITRE - TEMPS
			g_string_append_printf( gstr_buffer_title_time, "Track_%02d  ][  ", NumList +1 );
			g_string_append_printf( gstr_buffer_title_time, "%s\n", VarCddb . VarStructCddb [ NumList ] . Duree );
			// ARTISTE - TITRE - TEMPS
			// g_string_append_printf( gstr_buffer_artist_title_time, "%s  -  ", VarCddb . VarStructCddb [ NumList ] . Artist );
			g_string_append_printf( gstr_buffer_artist_title_time, "Track_%02d  ][  ", NumList +1 );
			g_string_append_printf( gstr_buffer_artist_title_time, "%s\n", VarCddb . VarStructCddb [ NumList ] . Duree );

			Audio->tags = (TAGS *)tags_remove (Audio->tags);
			Audio->tags = (TAGS *)tags_alloc (TRUE);
			
			Audio->tags->Album       = g_strdup ("Track");
			Audio->tags->Artist      = g_strdup ("");
			Audio->tags->Title       = g_strdup_printf ("Track_%02d", NumList +1);
			Audio->tags->Number      = g_strdup_printf ("%d", NumList +1);
			Audio->tags->IntNumber   = NumList +1;
			Audio->tags->Genre       = g_strdup ("A Cappella");
			Audio->tags->IntGenre    = 123;
			Audio->tags->Year        = g_strdup ("1962");
			Audio->tags->IntYear     = 1962;
			Audio->tags->Comment     = g_strdup ("By Xcfa");
			Audio->tags->Description = g_strdup ("By Xcfa");
		}
		
		EnteteCD.GList_Audio_cd = g_list_append (EnteteCD.GList_Audio_cd, (CD_AUDIO *)Audio);
	}
	if( CDDB_RET_OK == p_etat || CDDB_RET_NO_CONNECT == p_etat || CDDB_RET_NO_BASE == p_etat ) {
		
		view.Buffer_none = g_strdup( " " );
		
		view.Buffer_title = g_strdup( gstr_buffer_title->str );
		g_string_free( gstr_buffer_title, TRUE );
		
		view.Buffer_title_time = g_strdup( gstr_buffer_title_time->str );
		g_string_free( gstr_buffer_title_time, TRUE );
		
		view.Buffer_artist_title_time = g_strdup( gstr_buffer_artist_title_time->str );
		g_string_free( gstr_buffer_artist_title_time, TRUE );
	}
}
// 
// 
gboolean CdCddb_read_toc (void)
{
	gint	Etat;
	
	// 
	Etat = CdCddb_read_datas();
	
	// TODO: DEBUG: manuker: http://forum.ubuntu-fr.org/viewtopic.php?pid=4631891#p4631891
	g_print("Return after call CdCddb_read_datas(): ");
	switch( Etat ) {
	case CDDB_RET_OK :		g_print( "CDDB_RET_OK\n" );		break;
	case CDDB_RET_NO_CD:		g_print( "CDDB_RET_NO_CD\n" );		break;
	case CDDB_RET_NO_CONNECT :	g_print( "CDDB_RET_NO_CONNECT\n" );	break;
	case CDDB_RET_NO_BASE :		g_print( "CDDB_RET_NO_BASE\n" );	break;
	case CDDB_RET_NO_ALLOC :	g_print( "CDDB_RET_NO_ALLOC\n" );	break;
	}
	
	// 
	CdCddb_set_toc_to_glist_audio( Etat );
	
	// REMOVE VarCddb
	CdCddb_remove_struct();
	
	if( CDDB_RET_OK == Etat || CDDB_RET_NO_CONNECT == Etat || CDDB_RET_NO_BASE == Etat ) {
		return( TRUE );
	}
	return ( FALSE );
}



gboolean bool_cancel_cddb = FALSE;	/* FALSE = continue ELSE STOP */

// int strcasecmp (const char *s1, const char *s2);
// int strncasecmp (const char *s1, const char *s2, size_t n);




// Si 'FLAG == FALSE', force l'arret de la recherche sur le serveur freedb
//
void CdCddb_set_bool_cancel_cddb (gboolean FLAG)
{
	/*PRINT_FUNC_LF();*/
	bool_cancel_cddb = FLAG;
}
// 
// 
gboolean CdCddb_get_bool_cancel_cddb (void)
{
	return (bool_cancel_cddb);
}
//
//
gboolean CdCddb_test_access_web (void)
{
	// PRINT_FUNC_LF();
	
	if (libutils_find_file ("wget") == FALSE) {
		g_print ("WGET absent !\n");
		return (FALSE);
	}
	return (GetInfo_wget ());
}



void CdCddb_set_combobox_choice( gint p_activate )
{
	if( p_activate > -1 ) {
		view.BoolAccessChanged = FALSE;
		gtk_combo_box_set_active( GTK_COMBO_BOX (view.AdrComboBoxChoice), p_activate );
		view.BoolAccessChanged = TRUE;
	}
}
gchar *CdCddb_get_title_cd( void )
{
	return( view.TitleCD );
}





















