/* -*-Mode: C;-*-
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el,v 1.11 2001/12/08 03:17:21 jmacd Exp $
 */

#include "edsio.h"

#include "edsio.h"

#ifndef _EDSIO_EDSIO_H_
#define _EDSIO_EDSIO_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Initialize this library. */

gboolean edsio_edsio_init (void);

/* Types defined here. */

/* EdsioStringIntEventCode.
 */

typedef struct _EdsioStringIntEventCode EdsioStringIntEventCode;
struct _EdsioStringIntEventCode { gint code; };

typedef struct _EdsioStringIntEvent EdsioStringIntEvent;
struct _EdsioStringIntEvent { gint code; const char* srcfile; guint srcline; const char* name; int err; };

/* EdsioStringErrnoEventCode.
 */

typedef struct _EdsioStringErrnoEventCode EdsioStringErrnoEventCode;
struct _EdsioStringErrnoEventCode { gint code; };

typedef struct _EdsioStringErrnoEvent EdsioStringErrnoEvent;
struct _EdsioStringErrnoEvent { gint code; const char* srcfile; guint srcline; const char* name; gint ev_errno; };

/* EdsioHandleStringEventCode.
 */

typedef struct _EdsioHandleStringEventCode EdsioHandleStringEventCode;
struct _EdsioHandleStringEventCode { gint code; };

typedef struct _EdsioHandleStringEvent EdsioHandleStringEvent;
struct _EdsioHandleStringEvent { gint code; const char* srcfile; guint srcline; FileHandle* handle; const char* op; };

/* EdsioHandleIntEventCode.
 */

typedef struct _EdsioHandleIntEventCode EdsioHandleIntEventCode;
struct _EdsioHandleIntEventCode { gint code; };

typedef struct _EdsioHandleIntEvent EdsioHandleIntEvent;
struct _EdsioHandleIntEvent { gint code; const char* srcfile; guint srcline; FileHandle* handle; int page; };

/* EdsioStringStringStringEventCode.
 */

typedef struct _EdsioStringStringStringEventCode EdsioStringStringStringEventCode;
struct _EdsioStringStringStringEventCode { gint code; };

typedef struct _EdsioStringStringStringEvent EdsioStringStringStringEvent;
struct _EdsioStringStringStringEvent { gint code; const char* srcfile; guint srcline; const char* name; const char* recv; const char* expect; };

/* EdsioIntEventCode.
 */

typedef struct _EdsioIntEventCode EdsioIntEventCode;
struct _EdsioIntEventCode { gint code; };

typedef struct _EdsioIntEvent EdsioIntEvent;
struct _EdsioIntEvent { gint code; const char* srcfile; guint srcline; int num; };

/* EdsioStringEventCode.
 */

typedef struct _EdsioStringEventCode EdsioStringEventCode;
struct _EdsioStringEventCode { gint code; };

typedef struct _EdsioStringEvent EdsioStringEvent;
struct _EdsioStringEvent { gint code; const char* srcfile; guint srcline; const char* name; };

/* EdsioStringStringEventCode.
 */

typedef struct _EdsioStringStringEventCode EdsioStringStringEventCode;
struct _EdsioStringStringEventCode { gint code; };

typedef struct _EdsioStringStringEvent EdsioStringStringEvent;
struct _EdsioStringStringEvent { gint code; const char* srcfile; guint srcline; const char* msg; const char* arg; };

/* EdsioHandleEventCode.
 */

typedef struct _EdsioHandleEventCode EdsioHandleEventCode;
struct _EdsioHandleEventCode { gint code; };

typedef struct _EdsioHandleEvent EdsioHandleEvent;
struct _EdsioHandleEvent { gint code; const char* srcfile; guint srcline; FileHandle* handle; };

/* EdsioSourceEventCode.
 */

typedef struct _EdsioSourceEventCode EdsioSourceEventCode;
struct _EdsioSourceEventCode { gint code; };

typedef struct _EdsioSourceEvent EdsioSourceEvent;
struct _EdsioSourceEvent { gint code; const char* srcfile; guint srcline; SerialSource* source; };

/* EdsioVoidEventCode.
 */

typedef struct _EdsioVoidEventCode EdsioVoidEventCode;
struct _EdsioVoidEventCode { gint code; };

typedef struct _EdsioVoidEvent EdsioVoidEvent;
struct _EdsioVoidEvent { gint code; const char* srcfile; guint srcline; };

/* EdsioIntIntEventCode.
 */

typedef struct _EdsioIntIntEventCode EdsioIntIntEventCode;
struct _EdsioIntIntEventCode { gint code; };

typedef struct _EdsioIntIntEvent EdsioIntIntEvent;
struct _EdsioIntIntEvent { gint code; const char* srcfile; guint srcline; int library; int number; };

/* EdsioErrnoEventCode.
 */

typedef struct _EdsioErrnoEventCode EdsioErrnoEventCode;
struct _EdsioErrnoEventCode { gint code; };

typedef struct _EdsioErrnoEvent EdsioErrnoEvent;
struct _EdsioErrnoEvent { gint code; const char* srcfile; guint srcline; gint ev_errno; };

typedef struct _SerialTest SerialTest;
typedef struct _SerialGenericTime SerialGenericTime;
typedef struct _SerialEdsioString SerialEdsioString;
typedef struct _SerialEdsioBytes SerialEdsioBytes;
typedef struct _SerialEdsioUint SerialEdsioUint;
/* Functions declared here. */

/* Serial Types */

enum _SerialEdsioType {

  ST_EdsioUint = (1<<(1+EDSIO_LIBRARY_OFFSET_BITS))+6, 
  ST_EdsioBytes = (1<<(2+EDSIO_LIBRARY_OFFSET_BITS))+6, 
  ST_EdsioString = (1<<(3+EDSIO_LIBRARY_OFFSET_BITS))+6, 
  ST_GenericTime = (1<<(4+EDSIO_LIBRARY_OFFSET_BITS))+6, 
  ST_Test = (1<<(5+EDSIO_LIBRARY_OFFSET_BITS))+6
};



/* EdsioUint Structure
 */

struct _SerialEdsioUint {
  guint32 val;
};

void     serializeio_print_edsiouint_obj        (SerialEdsioUint* obj, guint indent_spaces);

gboolean unserialize_edsiouint                  (SerialSource *source, SerialEdsioUint**);
gboolean unserialize_edsiouint_internal         (SerialSource *source, SerialEdsioUint** );
gboolean unserialize_edsiouint_internal_noalloc (SerialSource *source, SerialEdsioUint* );
gboolean serialize_edsiouint                    (SerialSink *sink, guint32 val);
gboolean serialize_edsiouint_obj                (SerialSink *sink, const SerialEdsioUint* obj);
gboolean serialize_edsiouint_internal           (SerialSink *sink, guint32 val);
gboolean serialize_edsiouint_obj_internal (SerialSink *sink, SerialEdsioUint* obj);
guint    serializeio_count_edsiouint            (guint32 val);
guint    serializeio_count_edsiouint_obj        (SerialEdsioUint const* obj);

/* EdsioBytes Structure
 */

struct _SerialEdsioBytes {
  guint32 val_len;
  const guint8* val;
};

void     serializeio_print_edsiobytes_obj        (SerialEdsioBytes* obj, guint indent_spaces);

gboolean unserialize_edsiobytes                  (SerialSource *source, SerialEdsioBytes**);
gboolean unserialize_edsiobytes_internal         (SerialSource *source, SerialEdsioBytes** );
gboolean unserialize_edsiobytes_internal_noalloc (SerialSource *source, SerialEdsioBytes* );
gboolean serialize_edsiobytes                    (SerialSink *sink, guint32 val_len, const guint8* val);
gboolean serialize_edsiobytes_obj                (SerialSink *sink, const SerialEdsioBytes* obj);
gboolean serialize_edsiobytes_internal           (SerialSink *sink, guint32 val_len, const guint8* val);
gboolean serialize_edsiobytes_obj_internal (SerialSink *sink, SerialEdsioBytes* obj);
guint    serializeio_count_edsiobytes            (guint32 val_len, const guint8* val);
guint    serializeio_count_edsiobytes_obj        (SerialEdsioBytes const* obj);

/* EdsioString Structure
 */

struct _SerialEdsioString {
  const gchar* val;
};

void     serializeio_print_edsiostring_obj        (SerialEdsioString* obj, guint indent_spaces);

gboolean unserialize_edsiostring                  (SerialSource *source, SerialEdsioString**);
gboolean unserialize_edsiostring_internal         (SerialSource *source, SerialEdsioString** );
gboolean unserialize_edsiostring_internal_noalloc (SerialSource *source, SerialEdsioString* );
gboolean serialize_edsiostring                    (SerialSink *sink, const gchar* val);
gboolean serialize_edsiostring_obj                (SerialSink *sink, const SerialEdsioString* obj);
gboolean serialize_edsiostring_internal           (SerialSink *sink, const gchar* val);
gboolean serialize_edsiostring_obj_internal (SerialSink *sink, SerialEdsioString* obj);
guint    serializeio_count_edsiostring            (const gchar* val);
guint    serializeio_count_edsiostring_obj        (SerialEdsioString const* obj);

/* GenericTime Structure
 */

struct _SerialGenericTime {
  guint32 seconds;
  guint32 nanos;
};

void     serializeio_print_generictime_obj        (SerialGenericTime* obj, guint indent_spaces);

gboolean unserialize_generictime                  (SerialSource *source, SerialGenericTime**);
gboolean unserialize_generictime_internal         (SerialSource *source, SerialGenericTime** );
gboolean unserialize_generictime_internal_noalloc (SerialSource *source, SerialGenericTime* );
gboolean serialize_generictime                    (SerialSink *sink, guint32 seconds, guint32 nanos);
gboolean serialize_generictime_obj                (SerialSink *sink, const SerialGenericTime* obj);
gboolean serialize_generictime_internal           (SerialSink *sink, guint32 seconds, guint32 nanos);
gboolean serialize_generictime_obj_internal (SerialSink *sink, SerialGenericTime* obj);
guint    serializeio_count_generictime            (guint32 seconds, guint32 nanos);
guint    serializeio_count_generictime_obj        (SerialGenericTime const* obj);

/* Test Structure
 */

struct _SerialTest {
  guint32 b_len;
  guint32* b;
  guint32 c_len;
  SerialGenericTime** c;
  guint32 d_len;
  SerialGenericTime* d;
};

void     serializeio_print_test_obj        (SerialTest* obj, guint indent_spaces);

gboolean unserialize_test                  (SerialSource *source, SerialTest**);
gboolean unserialize_test_internal         (SerialSource *source, SerialTest** );
gboolean unserialize_test_internal_noalloc (SerialSource *source, SerialTest* );
gboolean serialize_test                    (SerialSink *sink, guint32 b_len, guint32 const* b, guint32 c_len, SerialGenericTime* const* c, guint32 d_len, SerialGenericTime const* d);
gboolean serialize_test_obj                (SerialSink *sink, const SerialTest* obj);
gboolean serialize_test_internal           (SerialSink *sink, guint32 b_len, guint32 const* b, guint32 c_len, SerialGenericTime* const* c, guint32 d_len, SerialGenericTime const* d);
gboolean serialize_test_obj_internal (SerialSink *sink, SerialTest* obj);
guint    serializeio_count_test            (guint32 b_len, guint32 const* b, guint32 c_len, SerialGenericTime* const* c, guint32 d_len, SerialGenericTime const* d);
guint    serializeio_count_test_obj        (SerialTest const* obj);

void edsio_generate_errno_event_internal (EdsioErrnoEventCode code, const char* srcfile, gint srcline);
#define edsio_generate_errno_event(ecode) edsio_generate_errno_event_internal((ecode),__FILE__,__LINE__)

extern const EdsioErrnoEventCode EC_EdsioGetTimeOfDayFailure;
#define EC_EdsioGetTimeOfDayFailureValue ((0<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioErrnoEventCode EC_EdsioTimeFailure;
#define EC_EdsioTimeFailureValue ((1<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_intint_event_internal (EdsioIntIntEventCode code, const char* srcfile, gint srcline, int library, int number);
#define edsio_generate_intint_event(ecode, library, number) edsio_generate_intint_event_internal((ecode),__FILE__,__LINE__, (library), (number))

extern const EdsioIntIntEventCode EC_EdsioUnregisteredType;
#define EC_EdsioUnregisteredTypeValue ((2<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioIntIntEventCode EC_EdsioUnexpectedLibraryType;
#define EC_EdsioUnexpectedLibraryTypeValue ((3<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_void_event_internal (EdsioVoidEventCode code, const char* srcfile, gint srcline);
#define edsio_generate_void_event(ecode) edsio_generate_void_event_internal((ecode),__FILE__,__LINE__)

extern const EdsioVoidEventCode EC_EdsioUnexpectedType;
#define EC_EdsioUnexpectedTypeValue ((4<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioOutputBufferShort;
#define EC_EdsioOutputBufferShortValue ((5<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioInvalidBase64Encoding;
#define EC_EdsioInvalidBase64EncodingValue ((6<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioMissingChecksum;
#define EC_EdsioMissingChecksumValue ((7<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioInvalidChecksum;
#define EC_EdsioInvalidChecksumValue ((8<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_source_event_internal (EdsioSourceEventCode code, const char* srcfile, gint srcline, SerialSource* source);
#define edsio_generate_source_event(ecode, source) edsio_generate_source_event_internal((ecode),__FILE__,__LINE__, (source))

extern const EdsioSourceEventCode EC_EdsioSourceEof;
#define EC_EdsioSourceEofValue ((9<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_handle_event_internal (EdsioHandleEventCode code, const char* srcfile, gint srcline, FileHandle* handle);
#define edsio_generate_handle_event(ecode, handle) edsio_generate_handle_event_internal((ecode),__FILE__,__LINE__, (handle))

extern const EdsioHandleEventCode EC_EdsioHandleEof;
#define EC_EdsioHandleEofValue ((10<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioSourceEventCode EC_EdsioIncorrectAllocation;
#define EC_EdsioIncorrectAllocationValue ((11<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_stringstring_event_internal (EdsioStringStringEventCode code, const char* srcfile, gint srcline, const char* msg, const char* arg);
#define edsio_generate_stringstring_event(ecode, msg, arg) edsio_generate_stringstring_event_internal((ecode),__FILE__,__LINE__, (msg), (arg))

extern const EdsioStringStringEventCode EC_EdsioInvalidIntegerString;
#define EC_EdsioInvalidIntegerStringValue ((12<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioIntegerOutOfRange;
#define EC_EdsioIntegerOutOfRangeValue ((13<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioInvalidIntegerSign;
#define EC_EdsioInvalidIntegerSignValue ((14<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_string_event_internal (EdsioStringEventCode code, const char* srcfile, gint srcline, const char* name);
#define edsio_generate_string_event(ecode, name) edsio_generate_string_event_internal((ecode),__FILE__,__LINE__, (name))

extern const EdsioStringEventCode EC_EdsioDuplicatePropertyTypeRegistered;
#define EC_EdsioDuplicatePropertyTypeRegisteredValue ((15<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringEventCode EC_EdsioDuplicateHostTypeRegistered;
#define EC_EdsioDuplicateHostTypeRegisteredValue ((16<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringEventCode EC_EdsioDuplicatePropertyNameRegistered;
#define EC_EdsioDuplicatePropertyNameRegisteredValue ((17<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_int_event_internal (EdsioIntEventCode code, const char* srcfile, gint srcline, int num);
#define edsio_generate_int_event(ecode, num) edsio_generate_int_event_internal((ecode),__FILE__,__LINE__, (num))

extern const EdsioIntEventCode EC_EdsioNoSuchProperty;
#define EC_EdsioNoSuchPropertyValue ((18<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringEventCode EC_EdsioNoSuchPropertyType;
#define EC_EdsioNoSuchPropertyTypeValue ((19<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringEventCode EC_EdsioNoSuchHostType;
#define EC_EdsioNoSuchHostTypeValue ((20<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_stringstringstring_event_internal (EdsioStringStringStringEventCode code, const char* srcfile, gint srcline, const char* name, const char* recv, const char* expect);
#define edsio_generate_stringstringstring_event(ecode, name, recv, expect) edsio_generate_stringstringstring_event_internal((ecode),__FILE__,__LINE__, (name), (recv), (expect))

extern const EdsioStringStringStringEventCode EC_EdsioWrongHostType;
#define EC_EdsioWrongHostTypeValue ((21<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringStringEventCode EC_EdsioWrongDataType;
#define EC_EdsioWrongDataTypeValue ((22<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringEventCode EC_EdsioPropertyNotSet;
#define EC_EdsioPropertyNotSetValue ((23<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioPersistenceUnavailable;
#define EC_EdsioPersistenceUnavailableValue ((24<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioInvalidStreamChecksum;
#define EC_EdsioInvalidStreamChecksumValue ((25<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioInvalidHexDigit;
#define EC_EdsioInvalidHexDigitValue ((26<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioDigestStringShort;
#define EC_EdsioDigestStringShortValue ((27<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioDigestStringLong;
#define EC_EdsioDigestStringLongValue ((28<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioIntEventCode EC_EdsioUnregisteredLibrary;
#define EC_EdsioUnregisteredLibraryValue ((29<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioGModuleError;
#define EC_EdsioGModuleErrorValue ((30<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringEventCode EC_EdsioMissingMessageDigest;
#define EC_EdsioMissingMessageDigestValue ((31<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioHandleClosed;
#define EC_EdsioHandleClosedValue ((32<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_handleint_event_internal (EdsioHandleIntEventCode code, const char* srcfile, gint srcline, FileHandle* handle, int page);
#define edsio_generate_handleint_event(ecode, handle, page) edsio_generate_handleint_event_internal((ecode),__FILE__,__LINE__, (handle), (page))

extern const EdsioHandleIntEventCode EC_EdsioInvalidPage;
#define EC_EdsioInvalidPageValue ((33<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_handlestring_event_internal (EdsioHandleStringEventCode code, const char* srcfile, gint srcline, FileHandle* handle, const char* op);
#define edsio_generate_handlestring_event(ecode, handle, op) edsio_generate_handlestring_event_internal((ecode),__FILE__,__LINE__, (handle), (op))

extern const EdsioHandleStringEventCode EC_EdsioInvalidHandleMode;
#define EC_EdsioInvalidHandleModeValue ((34<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioIllegalSeek;
#define EC_EdsioIllegalSeekValue ((35<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioIllegalMapSeek;
#define EC_EdsioIllegalMapSeekValue ((36<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioIllegalMapUnmapFirst;
#define EC_EdsioIllegalMapUnmapFirstValue ((37<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioIllegalUnmap;
#define EC_EdsioIllegalUnmapValue ((38<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioIllegalDigest;
#define EC_EdsioIllegalDigestValue ((39<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioHandleHasNoLength;
#define EC_EdsioHandleHasNoLengthValue ((40<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_stringerrno_event_internal (EdsioStringErrnoEventCode code, const char* srcfile, gint srcline, const char* name);
#define edsio_generate_stringerrno_event(ecode, name) edsio_generate_stringerrno_event_internal((ecode),__FILE__,__LINE__, (name))

extern const EdsioStringErrnoEventCode EC_EdsioFseekFailed;
#define EC_EdsioFseekFailedValue ((41<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringErrnoEventCode EC_EdsioFreadFailed;
#define EC_EdsioFreadFailedValue ((42<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringErrnoEventCode EC_EdsioFwriteFailed;
#define EC_EdsioFwriteFailedValue ((43<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioDigestComputationLate;
#define EC_EdsioDigestComputationLateValue ((44<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioDigestNotComputed;
#define EC_EdsioDigestNotComputedValue ((45<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioDigestNotFinished;
#define EC_EdsioDigestNotFinishedValue ((46<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleEventCode EC_EdsioDigestFault;
#define EC_EdsioDigestFaultValue ((47<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleIntEventCode EC_EdsioMmapFailed;
#define EC_EdsioMmapFailedValue ((48<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioHandleIntEventCode EC_EdsioMunmapFailed;
#define EC_EdsioMunmapFailedValue ((49<<EDSIO_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_stringint_event_internal (EdsioStringIntEventCode code, const char* srcfile, gint srcline, const char* name, int err);
#define edsio_generate_stringint_event(ecode, name, err) edsio_generate_stringint_event_internal((ecode),__FILE__,__LINE__, (name), (err))

extern const EdsioStringIntEventCode EC_EdsioFopenWriteFailed;
#define EC_EdsioFopenWriteFailedValue ((50<<EDSIO_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringIntEventCode EC_EdsioFopenReadFailed;
#define EC_EdsioFopenReadFailedValue ((51<<EDSIO_LIBRARY_OFFSET_BITS)+6)

#ifdef __cplusplus
}
#endif

#endif /* _EDSIO_EDSIO_H_ */

