/* -*-Mode: C++;-*-
 * $Id: dirc.h 1.11 Tue, 24 Apr 2001 03:53:40 +0400 jmacd $
 *
 * Copyright (C) 1998, 1999, 2000, Joshua P. MacDonald
 * <jmacd@CS.Berkeley.EDU> and The Regents of the University of
 * California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _DIRC_H_
#define _DIRC_H_

//////////////////////////////////////////////////////////////////////
//				 DIRC
//////////////////////////////////////////////////////////////////////

class DIRC
{
    friend class NODEC;
    friend class DBREF;

private:

    DIRC                 (const DIRC &nocopy);
    DIRC& operator=      (const DIRC &noassign);

    int  set_curs        (int          dbflag,
			  DBFS_RMWFLAG rmwflag);

    void set_open        (const NODEC &node);

public:

    DIRC::DIRC           ();

    // Note: open with NODEC::read_dir ()

    int close            ();

    // Information about the current cursor position
    int  get_key         (DKEY         &key);
    int  get_seqno       (XSEQNO       &seqno);
    int  get_node        (MAJORC       &major);
    int  get_number      (XNUM         &num);

    // These set the cursor position
    bool next            ();
    bool prev            ();
    int  first           ();
    int  last            ();
    int  set_key         (const DKEY   &key,
			  int           flags);
    int  set_seqno       (const XSEQNO &seqno,
			  int           flags);

    // These modify the current cursor position
    int  repl_link       (const MAJORC &major, // current link must exist, position unchanged
			  int           flags);
    int  del_link        ();

    // To insert a new link, set its position
    int  insert_link     (const DKEY   &dkey,
			  const MAJORC &major,
			  int           flags);

    // These are a combination set_key/seqno() and get_node()
    int  set_node        (const DKEY   &key,
			  MAJORC       &major,
			  int           flags);
    int  set_node_seqno  (const XSEQNO &key,
			  MAJORC       &major,
			  int           flags);


private:

    const NODEC *_dnode;
    TXN         *_txn;
    int          _close_ret;
    int          _get_ret;

    DKEY         _set_key;
    DKEY         _get_key;
    XNUM         _get_num;

    DBCREF       _dbc;
};

#endif /* _DIRC_H_ */
