/* -*-Mode: C;-*-
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el,v 1.7 2000/11/22 06:13:45 jmacd Exp $
 */

#include "edsio.h"

#include "xdfs_cpp.h"

#ifndef _XDFS_EDSIO_H_
#define _XDFS_EDSIO_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "edsio_edsio.h"

/* Initialize this library. */

gboolean xdfs_edsio_init (void);

/* Types defined here. */

typedef struct _SerialXdfsState SerialXdfsState;
typedef struct _SerialXdfsInstruction SerialXdfsInstruction;
/* Functions declared here. */

/* Serial Types */

enum _SerialXdfsType {

  ST_XdfsInstruction = (1<<(1+EDSIO_LIBRARY_OFFSET_BITS))+10, 
  ST_XdfsState = (1<<(3+EDSIO_LIBRARY_OFFSET_BITS))+10
};



/* XdfsInstruction Structure
 */

struct _SerialXdfsInstruction {
  guint32 offset;
  guint32 length;
  guint32 output_start;
  MAJORC node;
};

void     serializeio_print_xdfsinstruction_obj        (SerialXdfsInstruction* obj, guint indent_spaces);

gboolean unserialize_xdfsinstruction                  (SerialSource *source, SerialXdfsInstruction**);
gboolean unserialize_xdfsinstruction_internal         (SerialSource *source, SerialXdfsInstruction** );
gboolean unserialize_xdfsinstruction_internal_noalloc (SerialSource *source, SerialXdfsInstruction* );
gboolean serialize_xdfsinstruction                    (SerialSink *sink, guint32 offset, guint32 length, guint32 output_start);
gboolean serialize_xdfsinstruction_obj                (SerialSink *sink, const SerialXdfsInstruction* obj);
gboolean serialize_xdfsinstruction_internal           (SerialSink *sink, guint32 offset, guint32 length, guint32 output_start);
gboolean serialize_xdfsinstruction_obj_internal (SerialSink *sink, SerialXdfsInstruction* obj);
guint    serializeio_count_xdfsinstruction            (guint32 offset, guint32 length, guint32 output_start);
guint    serializeio_count_xdfsinstruction_obj        (SerialXdfsInstruction const* obj);

/* XdfsState Structure
 */

struct _SerialXdfsState {
  guint32 src_buffer_files;
  guint32 src_buffer_size;
  guint32 total_version_count;
  guint32 unique_version_count;
  guint32 unencoded_size;
  guint32 literal_size;
  guint32 control_size;
  guint32 patch_size;
  guint32 patches;
  guint32 literals;
  guint32 cluster_versions;
  guint32 cluster_compressed_size;
  guint32 cluster_uncompressed_size;
  guint32 policy;
  guint32 flags;
  guint32 cluster_max_versions;
};

void     serializeio_print_xdfsstate_obj        (SerialXdfsState* obj, guint indent_spaces);

gboolean unserialize_xdfsstate                  (SerialSource *source, SerialXdfsState**);
gboolean unserialize_xdfsstate_internal         (SerialSource *source, SerialXdfsState** );
gboolean unserialize_xdfsstate_internal_noalloc (SerialSource *source, SerialXdfsState* );
gboolean serialize_xdfsstate                    (SerialSink *sink, guint32 src_buffer_files, guint32 src_buffer_size, guint32 total_version_count, guint32 unique_version_count, guint32 unencoded_size, guint32 literal_size, guint32 control_size, guint32 patch_size, guint32 patches, guint32 literals, guint32 cluster_versions, guint32 cluster_compressed_size, guint32 cluster_uncompressed_size, guint32 policy, guint32 flags, guint32 cluster_max_versions);
gboolean serialize_xdfsstate_obj                (SerialSink *sink, const SerialXdfsState* obj);
gboolean serialize_xdfsstate_internal           (SerialSink *sink, guint32 src_buffer_files, guint32 src_buffer_size, guint32 total_version_count, guint32 unique_version_count, guint32 unencoded_size, guint32 literal_size, guint32 control_size, guint32 patch_size, guint32 patches, guint32 literals, guint32 cluster_versions, guint32 cluster_compressed_size, guint32 cluster_uncompressed_size, guint32 policy, guint32 flags, guint32 cluster_max_versions);
gboolean serialize_xdfsstate_obj_internal (SerialSink *sink, SerialXdfsState* obj);
guint    serializeio_count_xdfsstate            (guint32 src_buffer_files, guint32 src_buffer_size, guint32 total_version_count, guint32 unique_version_count, guint32 unencoded_size, guint32 literal_size, guint32 control_size, guint32 patch_size, guint32 patches, guint32 literals, guint32 cluster_versions, guint32 cluster_compressed_size, guint32 cluster_uncompressed_size, guint32 policy, guint32 flags, guint32 cluster_max_versions);
guint    serializeio_count_xdfsstate_obj        (SerialXdfsState const* obj);

#ifdef __cplusplus
}
#endif

#endif /* _XDFS_EDSIO_H_ */

