#include "socket.h"

pthread_mutex_t gethostbynameMutex = PTHREAD_MUTEX_INITIALIZER;

Socket::Socket() {
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  start = buffer;
  length = 0;
}

Socket::Socket(int fd) {
  sockfd = fd;
  start = buffer;
  length = 0;
}

Socket::~Socket() {
  if (sockfd != -1) {
    close(sockfd);
  }
}

void Socket::reset() {
  if (sockfd != -1) {
    close(sockfd);
    sockfd = -1;
  }
  start = buffer;
  length = 0;
}

bool Socket::bind(int port) {
  int optVal = 1;
  struct sockaddr_in serverAddr;

  if (sockfd == -1) {
    return false;
  }
  if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, (void*) &optVal, sizeof(int)) == -1) {
    return false;
  }

  memset(&serverAddr, 0, sizeof(serverAddr));
  serverAddr.sin_family = AF_INET;
  serverAddr.sin_port = htons(port);
  serverAddr.sin_addr.s_addr = htonl(INADDR_ANY);

  return (::bind(sockfd, (struct sockaddr *) &serverAddr, sizeof(serverAddr)) != -1);
}

bool Socket::connect(char *host, int port) {
  struct hostent *hEnt;
  struct sockaddr_in serverAddr;

  pthread_mutex_lock(&gethostbynameMutex);
  hEnt = gethostbyname(host);
  pthread_mutex_unlock(&gethostbynameMutex);
  if (hEnt == NULL) {
    return false; // server name lookup failed
  }

  memset(&serverAddr, 0, sizeof(struct sockaddr_in));
  serverAddr.sin_family=AF_INET;
  serverAddr.sin_port=htons(port);
  memcpy(&(serverAddr.sin_addr), (hEnt->h_addr_list)[0], hEnt->h_length);

  return (::connect(sockfd, (struct sockaddr *) &serverAddr, sizeof(serverAddr)) != -1);
}

bool Socket::listen(int backlog) {
  return (::listen(sockfd, backlog) != -1);
}

Socket* Socket::accept() {
  int newfd;

  if ((newfd = ::accept(sockfd, NULL, NULL)) == -1) {
    return NULL;
  }

  return (new Socket(newfd));
}

int Socket::recvBytes(char *str, int n) {
  int receivedBytes;

  // Nothing to do if number of bytes to be received is zero or less.
  if (n <= 0) {
    return n;
  }

  if (str == NULL) {
    // Write to internal socket buffer and return number of bytes read (NOT the total number of bytes in the socket buffer).
    if (start != buffer && length > 0) {
      memmove(buffer, start, length);
    }
    start = buffer;
    buffer[length] = '\0';
    receivedBytes = recv(sockfd, buffer+length, ((n < (MAX_SOCKET_BUFFER-length)) ? n : (MAX_SOCKET_BUFFER-length)), 0);
    if (receivedBytes > 0) {
      length += receivedBytes;
      buffer[length] = '\0';
    }
    return receivedBytes;
  }
  else {
    // Write to argument buffer and return number of bytes read.
    // Copy first bytes from the data buffer.
    if (n <= length) {
      // All bytes already available in the data buffer.
      memcpy(str, start, n);
      start += n;
      length -= n;
      str[n] = '\0';
      receivedBytes = n;
    }
    else {
      // Copy bytes from the data buffer and receive additional bytes.
      memcpy(str, start, length);
      start += length;
      receivedBytes = recv(sockfd, str + length, n - length, 0);
      // Check to see if socket error; if not, only then add the number of bytes moved from the data buffer to the number of bytes read from the socket; if an error occurs, it's not worth returning the number of bytes copied from the data buffer (if any) because the on subsequent recvBytes() calls the error will be caught by the caller anyways (basically, the error is caught earlier this way, although discarding any data copied from the buffer).
      if (receivedBytes != -1) {
	receivedBytes += length;
	str[receivedBytes] = '\0';
      }
      length = 0;
    }
    return receivedBytes;
  }
}

int Socket::sendBytes(char *str, int n) {
  return (send(sockfd, str, n, 0));
}
