#include "xdo_cmd.h"

int cmd_window_reparent(context_t *context) {
  int ret = 0;
  Window wid;
  char *cmd = *context->argv;
  int opsync = 0;
  Window parent;

  int c;
  typedef enum {
    opt_unused, opt_help
  } optlist_t;
  static struct option longopts[] = {
    { "help", no_argument, NULL, opt_help },
    { 0, 0, 0, 0 },
  };
  static const char *usage = "Usage: %s <window> <new_parent_window>\n";

  int option_index;
  while ((c = getopt_long_only(context->argc, context->argv, "+h",
                               longopts, &option_index)) != -1) {
    switch (c) {
      case 'h':
      case opt_help:
        printf(usage, cmd);
        consume_args(context, context->argc);
        return EXIT_SUCCESS;
        break;
      default:
        fprintf(stderr, usage, cmd);
        return EXIT_FAILURE;
    }
  }

  consume_args(context, optind);

  if (context->argc != 2) {
    fprintf(stderr, usage, cmd);
    return 1;
  }

  wid = (Window)strtol(context->argv[0], NULL, 0);
  parent = (Window)strtol(context->argv[1], NULL, 0);

  int x, y;
  Screen *screen;
  /* TODO(sissel): ensure parent is on the same screen as wid */
  xdo_get_window_location(context->xdo, wid, &x, &y, &screen);

  XSetWindowAttributes swattr;
  if (parent == 0) {
    /* Default to the root window if 0 is given */
    parent = screen->root;
    swattr.override_redirect = 1;
  } else {
    swattr.override_redirect = 0;
  }
  //XChangeWindowAttributes(context->xdo->xdpy, wid, CWOverrideRedirect, &swattr);

  printf("%d\n", ret);

  xdo_window_unmap(context->xdo, wid);
  xdo_window_wait_for_map_state(context->xdo, wid, IsUnmapped);
  ret = XReparentWindow(context->xdo->xdpy, wid, parent, x, y);
  XSync(context->xdo->xdpy, False);
  xdo_window_map(context->xdo, wid);
  xdo_window_wait_for_map_state(context->xdo, wid, IsViewable);

  if (parent == screen->root) {
    XWindowChanges wchange;
    wchange.stack_mode = BottomIf;
    XConfigureWindow(context->xdo->xdpy, wid, CWStackMode, &wchange);
  }

  if (ret) {
    fprintf(stderr, "xdo_window_reparent reported an error\n");
  } else {
  }
  
  consume_args(context, 2);
  return ret;
}

