/*
  Conexant AccessRunner definitions
  Copyright (C) 2003 Josep Comas

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author     : Josep Comas <jcomas@gna.es>
  Creation   : 13/6/2003

  Description: Definitions for Conexant AccessRunner USB ADSL Modem and compatibles.

*/

#ifndef _CXACRU_H_
#define _CXACRU_H_


/* uncomment following line to print debug info or define in compiler parameters: */
/* #define DEBUG 1 */
/* uncomment following line to print debug transfers or define in compiler parameters: */
/* #define DEBUG_TRANSFER 1 */

#ifdef DEBUG
#define PDEBUG(arg...)  printf(arg)
#else
#define PDEBUG(arg...)
#endif

/* FCLK/BCLK */
#define PLL_FAST_144MHZ_RM 0x00000005
#define PLL_FAST_100MHZ_RM 0x00000003
#define PLL_FAST_144MHZ 0x02D874DF  /* Divide by 3, F=144Mhz, U=72Mhz */
#define PLL_FAST_100MHZ 0x0196a51a  /* Divide by 4, B=100Mhz, P=50Mhz */

/* patch and boot possibilities */
#define CXPATCH 1
#define CXJUMP 2

/* ARM940T registers */
#define ARM_PLL_F    0x00350068  /* FCLK PLL Register */
#define ARM_PLL_B    0x0035006c  /* BCLK PLL Register */
#define ARM_EMCR     0x00350010  /* External Memory Control Register */
#define SDRAM_ENABLE 0x00000001

/* P52 */
#define BR_ADDRESS       0x00180600
#define WB_SIGN_ADDRESS  0x00180500
#define BR_STACK_ADDRESS 0x00187f10

#define FW_ADDRESS       0x00801000

/* modem commands */
#define CMD_USB_CMD_ERR                 0x00
#define CMD_USB_GET_VER                 0x01
#define CMD_USB_READ_MEM                0X02
#define CMD_USB_WRITE_MEM               0x03
#define CMD_USB_RMW_MEM                 0x04
#define CMD_USB_CHECKSUM_MEM            0x05
#define CMD_USB_GOTO_MEM                0x06
#define CMD_CHIP_ADSL_LINE_START        0x84
#define CMD_CHIP_ADSL_LINE_STOP         0x85
#define CMD_CARD_INFO_GET               0x88
#define CMD_CARD_DATA_GET               0x89
#define CMD_CARD_DATA_SET               0x8a
#define CMD_CARD_SERIAL_DATA_PATH_GET   0x8d
#define CMD_CARD_SERIAL_DATA_PATH_SET   0x8e
#define CMD_CARD_CONTROLLER_VERSION_GET 0x8f
#define CMD_CARD_GET_STATUS             0x90
#define CMD_CARD_GET_MAC_ADDRESS        0X91
#define CMD_CARD_GET_DATA_LINK_STATUS   0X92

#define REPLY_CMD 1

#define FIRST_CMD 0x80
#define ONE_ANSWER 1
#define FOUR_ANSWERS 4

/* link status */
#define LINK_STATUS_NOT_CONNECTED 1  /* link not established */
#define LINK_STATUS_CONNECTED     2  /* link connected */
#define LINK_STATUS_LOST          3  /* link lost */

/* line status */
/* a possible secuence: 0 -> 1 -> 7 -> 1 -> 2 -> 1 -> 2 -> 3 -> 5 */
#define LINE_STATUS_DOWN                    0
#define LINE_STATUS_ATTEMPTING_TO_ACTIVATE  1
#define LINE_STATUS_TRAINING                2
#define LINE_STATUS_CHANNEL_ANALYSIS        3
#define LINE_STATUS_EXCHANGE                4
#define LINE_STATUS_UP                      5
#define LINE_STATUS_WAITING                 6
#define LINE_STATUS_INITIALIZING            7

/* adsl open mode */
#define ADSL_OPEN_AUTO1 0  /* Auto selection with G.Handshake preferred - default setting */
#define ADSL_OPEN_AUTO2 1  /* Auto selection with T1.413 preferred */
#define ADSL_OPEN_HAND  2  /* G.Handshake only */
#define ADSL_OPEN_ANSI  3  /* T1.413 only */
#define ADSL_OPEN_GDMT  4  /* G.hs, G.dmt Only */
#define ADSL_OPEN_GLITE 5  /* G.hs, G.lite Only */

/* adsl modes */
#define ADSL_ANSI  1
#define ADSL_GDMT  2
#define ADSL_GLITE 3

/* usb input and ouput address against modem */
#define USB_IN_INFO  0x81    /* IN endpoint address, receive info */
#define USB_OUT_INFO 0x01    /* OUT endpoint address, ask info, send firmware */
#define USB_IN_DATA  0x82    /* IN endpoint address, receive ATM cells */
#define USB_OUT_DATA 0x02    /* OUT endpoint address, send ATM cells */

/* timeouts & retries */
#define DATA_TIMEOUT 5000     /* Timeout (ms) for in/out data packets */ 
#define CTRL_TIMEOUT 1000     /* Timeout (ms) for in/out control packets */
#define TIMEOUT_ADD  1000     /* We get timeout then add additional time */
#define SEND_BULK_RETRIES 4   /* Max retries when you send a bulk packet */
#define READ_BULK_RETRIES 4   /* Max retries when you wait a bulk packet */
#define CTRL_MSG_RETRIES  4   /* Max retries when you transfer a control message */
#define MAX_WAIT_LINE_UP 90   /* Seconds to wait until ADSL line is up */

/* usb errors */
#define EPIPE      32        /* When we receive a STALL */
#define ETIMEDOUT 110        /* When we receive a NAK */

/* messages */
#define MA_BYTE  0  /* access type byte */
#define MA_WORD  1  /* access type word */
#define MA_DWORD 2  /* access type double word */
#define MAX_MESSAGE_SIZE 64       /* Maximum bytes of a message */
#define MAX_DATA_MESSAGE_SIZE 56  /* Maximum data bytes of a message */
#define MAX_DATA_TRANSFER 4096    /* Maximum bytes that we can transfer through USB bus */
#define SIZE_VALUE 4              /* Size of a value */

#endif /* _CXACRU_H_ */
