# nonstd-cmds.tcl
# $Id: nonstd-cmds.tcl,v 1.5 1999/07/28 09:01:18 chris Exp $
# Handles nonstandard extension commands.
#
#
# XED --- an X-enabled implementation of ed, the standard editor.
# Copyright (C) 1999  Chris Laas
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# Chris Laas
# golem@mit.edu
# 22 Pratt Court
# Cohasset, MA 02025 USA


# The C command.
# This is an inherently GUI command; the tty version is near-useless.
proc command-change-interactive {addr1 addr2 command line} {
	global line_source entry_line input_mode current_addr last_addr \
		cut_buffer dirty
	if {$addr1 == 0} {
		error "Address out of range, cannot interactively change address 0"
	}

	set cut_buffer [buffer-get $addr1 $addr2]
	set current_addr [expr $addr1-1]
	if {$cut_buffer == {}} { set lines {{}} } else { set lines [split $cut_buffer \n] }
	foreach bufline $lines {
		buffer-delete [expr $current_addr+1] [expr $current_addr+1]
		incr last_addr -1
		switch $line_source {
			stdin { puts-response $bufline }
			X { after idle [list set entry_line $bufline] ; raise .e }
		}
		set input_mode "text $input_mode"
		vwait dirty
		set input_mode [lrange $input_mode 1 end]
	}

	set dirty 1
	print-lines {} {} $line
}

# The | command.
proc command-pipe {addr1 addr2 command line} {
	global is_tclet last_pipe_command default_filename
	global current_addr last_addr cut_buffer dirty

	if $is_tclet { error "Executing programs is not permitted in a Tclet" }

	if {[string index $line 0] == "|"} {
		if ![info exists last_pipe_command] {
			error "No previous pipe command"
		}
		set line $last_pipe_command[string range $line 1 end]
	}
	regsub {%} $line $default_filename line

	set in_lines [buffer-get $addr1 $addr2]
	set f [open |[list sh -c $line <<$in_lines 2>@stderr] r]
	while {![eof $f]} { lappend out_lines [gets $f] }
	close $f

	set cut_buffer $in_lines
	buffer-delete $addr1 $addr2
	buffer-put [expr $addr1 - 1] [join $out_lines \n]

	set current_addr [expr $addr1 - 1 + [llength $out_lines]]
	set last_addr [expr $last_addr - ($addr2-$addr1) + [llength $out_lines]-1]

	set dirty 1
	puts-response !
}

# The I command.
proc command-indent {addr1 addr2 command line} {
	global current_addr dirty

	if {$addr1 == 0} {
		error "Address out of range, cannot indent address 0"
	}

	set addr $addr1
	while 1 {
		incr addr -1
		if {$addr == 0} { set bufline {} ; set indent {} ; break }
		set bufline [buffer-get $addr $addr]
		if {$bufline != {}} { regexp "^(\t*)" $bufline indent ; break }
	}
	for {set addr $addr1} {$addr <= $addr2} {incr addr} {
		switch -- [string range $bufline end end] \{ - \\ {
			append indent \t
		}
		set bufline [buffer-get $addr $addr]
		if {$bufline == {}} { continue }
		if {[string index [string trimleft $bufline] 0] == "\}"} {
			set indent [string range $indent 1 end]
		}
		if {$bufline != "$indent[string trimleft $bufline]"} {
			buffer-delete $addr $addr
			buffer-put [expr $addr-1] $indent[string trimleft $bufline]
			set dirty 1
			set current_addr $addr
		}
	}

	print-lines {} {} $line
}
