.TH XED 1 "19 July 1999"
.SH NAME
xed \- text editor for X
.SH SYNOPSIS
xed [-s] [-p \fIstring\fR] [-nb] [-P] [-ttymode] [-fn \fIfont\fR]
    [-x \fIN\fR] [-nsb] [-help] [-version] [\fIfile\fR]
.SH DESCRIPTION
.B Xed
is the standard text editor, conveniently re-written for use in the standard
windowing system.

.B Xed
is a completely backward-compatible implementation of the
.B ed
line-oriented text editor.  See the
.IR ed (1)
manual page for a description of the basic
.B ed
syntax and command set; what follows is a description of the features unique to
.B xed.

.SS OPTIONS
.TP 8
-s
Suppresses diagnostics.

.TP 8
.RI \-p \ string
Specifies a command prompt.  This may be toggled on and off with the
.I `P'
command.

.TP 8
-nb
Turns off automatic file backup.  By default,
.B xed
will back up a file to
.I filename\~
before writing to that file.

.TP 8
-P
Causes
.B xed
to start up in
.I playback mode.
In this mode,
.B xed
reads lines from stdin (usually fed from an ed-style patch or script),
places them sequentially in the GUI command buffer, and waits for the user
to hit <Return> in the window before proceeding.  This allows a user
to "step through" an ed script and observe the results.

.TP 8
-ttymode
Prevents
.B xed
from connecting to the X server and creating an X window.
In this mode,
.BR xed's
interface closely emulates the original
.B ed.
Note, however, that the tty interface is available when there
.B is
an X window, as well.

.TP 8
.RI \-fn \ font
Sets the font to use in the X window.  Defaults to "fixed".

.TP 8
.RI \-x \ N
Sets tab stops at every N spaces in the X window.  Defaults to 8.

.TP 8
-nwl
Prevents long lines from being wrapped in the GUI, and truncates
them instead.

.TP 8
-nsb
Disables the scroll bar in the X window.

.TP 8
-help
Print a usage message on stdout and exit successfully.

.TP 8
-version
Print version information on stdout and exit successfully.

.TP 8
.I file
Specifies the name of a file to read.  If given, the first command
executed by
.B xed
is "e file".

.SS RESOURCES
As a Tk-based application,
.B Xed
understands all the standard X Toolkit resources, as well as the standard
.B wish
resources, in particular those relating to the Text, Entry, Label, and
Scrollbar widgets.

In addition, the application supports the following set of X resources.
For an example of usage, see the file
.I rvideo.xrdb
in the distribution.

.TP 8
.B "tabWidth (class TabWidth)"
Specifies the same thing as the -x command line option:
set tab stops every N characters.

.TP 8
.B "wrapLines (class WrapLines)"
A boolean "on" or "off" value, which specifies whether to wrap or truncate
long lines in the GUI.  Corresponds to the -nwl command line option.

.TP 8
.B "scrollbar (class Scrollbar)"
A boolean "on" or "off" value, which determines whether the scrollbar is
displayed.  Corresponds to the -nsb command line option.

.TP 8
.B "currentForeground (class Foreground)"
Specifies the foreground color of the current line.
.TP 8
.B "currentBackground (class Background)"
Specifies the background color of the current line.
.TP 8
.B "subcmdForeground (class Foreground)"
Specifies the foreground color of the current line while executing a
`G' or `V' command.
.TP 8
.B "subcmdBackground (class Background)"
Specifies the background color of the current line while executing a
`G' or `V' command.
.TP 8
.B "rangeForeground (class Foreground)"
Specifies the foreground color of the lines selected by the current command.
.TP 8
.B "rangeBackground (class Background)"
Specifies the background color of the lines selected by the current command.
.TP 8
.B "destForeground (class Foreground)"
Specifies the foreground color of the destination line selected by an
`m' or `t' command.
.TP 8
.B "destBackground (class Background)"
Specifies the background color of the destination line selected by an
`m' or `t' command.
.TP 8
.B "insertForeground (class Foreground)"
Specifies the foreground color of the input line while in input mode.
.TP 8
.B "insertBackground (class Background)"
Specifies the background color of the input line while in input mode.

.TP 8
.B "status.foreground (class Foreground)"
Specifies the foreground color of the status bar in normal state.
.TP 8
.B "status.background (class Background)"
Specifies the background color of the status bar in normal state.
.TP 8
.B "status.errorForeground (class Foreground)"
Specifies the foreground color of the status bar when displaying an error.
.TP 8
.B "status.errorBackground (class Background)"
Specifies the background color of the status bar when displaying an error.

.SS COMMANDS
In addition to
.BR ed's
standard command set,
.B xed
recognizes the following nonstandard commands.
The commands are shown together with
the default address or address range supplied if none is
specified (in parenthesis).

.TP 8
(.)C
Interactively changes the addressed lines.  In GUI mode, the lines
are sequentially loaded into the input buffer, and the user is prompted
to modify them interactively.  In tty mode, the lines are printed
in sequence, and the user is prompted to input a replacement for each line.

.TP 8
(1,$)|
Pipes the addressed lines through the given command, and replaces them
in the buffer with the output of the command.

.TP 8
(.)I
Indents the addressed lines in a simple C-friendly, unobtrusive format.
The indent level of a line is the number of leading tabs in the line;
blocks, delimited by curly braces, are offset from their surroundings by
one indentation level.

.SS GUI BINDINGS
.B xed
is equipped with an intuitive set of mouse and keyboard bindings for
its graphical user interface.  In addition to EM*CS-like bindings for
the keyboard in the input area,
.B xed
recognizes the following mouse actions in the text area:

.TP 8
Button 1 Click
Sets the current address to the clicked line.

.TP 8
Button 1 Drag
Places a region of text in the X selection.

.TP 8
Button 2 Drag
Scrolls the text area.

.TP 8
Button 3 Click/Drag
Sets the selected address range in the input area to the range of lines
dragged out by the mouse pointer.

.TP 8
Button 3 Shift-Click
Sets the target address for an m or t command to the clicked line.

.SH SEE ALSO

.IR ed (1),
.IR wish (1),
.IR regex (3).

.SH KNOWN BUGS

The \\`, \\', \\b, and \\B escapes in standard
.B ed
regular expression syntax are not implemented, due to the non-existence
of corresponding escapes in the Tcl regexp library.

Trailing tab characters in the input area of the X window are not displayed
properly, although they can still be manipulated normally.  There is no
simple workaround for this, so it'll have to wait for a patch to the Tk core.
A bug report has been submitted.
