;;; install.el --- Lookup installer
;; Copyright (C) 1999 NISHIDA Keisuke <knishida@ring.aist.go.jp>

;; $Id: install.el,v 1.3 1999/05/02 05:21:40 satoru-lookup Exp $

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Code:

(if (string< emacs-version "19.29")
    (setq command-line-args-left (cdr command-line-args-left)))

(defconst install-elisp-files
  '("evi.el" "evi-mule.el" "lookup.el" "lookup-utils.el" "lookup-types.el"
    "lookup-vars.el" "lookup-vse.el" "lookup-package.el"
    "lookup-entry.el" "lookup-content.el" "lookup-select.el"
    "ndic.el" "ndeb.el" "ndtp.el" "ndict.el" "ndkks.el" "ndsrd.el"
    "ndspell.el" "ndcookie.el" "ndmisc.el" "sdicf.el" "stem-english.el"))

(defconst install-info-files
  '("lookup.info" "lookup-guide.info"))

(defvar install-lisp-directory nil)
(defvar install-info-directory nil)
(defvar install-lookup-version "unknown")

(defun install-check-directory (directory)
  (and (not (file-exists-p directory))
       (y-or-n-p (format "Directory %s is not exist.  Creat it? " directory))
       (make-directory directory t))
  (if (not (file-directory-p directory))
      (error "%s is not directory" directory))
  (directory-file-name (expand-file-name directory)))

(or (fboundp 'with-current-buffer)
    (defmacro with-current-buffer (buffer &rest body)
      (` (save-current-buffer
	   (set-buffer (, buffer))
	   (,@ body)))))

;; get the version number of lookup
(with-current-buffer (get-buffer-create " *work lookup-version*")
  (erase-buffer)
  (setq install-lookup-version
	(condition-case nil
	    (progn
	      (insert-file-contents "VERSION")
	      (goto-char (point-min))
	      (buffer-substring (point-min) (progn (end-of-line) (point))))
	  (error "unknown")))
  (kill-buffer (current-buffer)))

;; message

(if noninteractive nil
  (switch-to-buffer (generate-new-buffer "*Lookup Installer*"))
  (insert "Lookup $B%$%s%9%H!<%i(B\n")
  (insert "===================\n\n")
  (insert "Lookup $B$N%$%s%9%H!<%k$r;O$a$^$9!#(B")
  (insert "$BESCf$GCfCG$9$k$K$O(B C-g $B$r2!$7$F2<$5$$!#(B\n\n"))

;; directory

(if noninteractive nil
  (insert "$B%G%#%l%/%H%j$N7hDj(B\n")
  (insert "------------------\n\n")
  (insert "elisp $B%U%!%$%k$N%G%#%l%/%H%j$rF~NO$7$F2<$5$$(B:\n"))
(let ((default "~/emacs/lisp/lookup/"))
  (setq install-lisp-directory
	(install-check-directory
	 (if noninteractive
	     (or (car command-line-args-left) default)
	   (read-file-name "Lisp directory: " default default)))))
(if noninteractive nil
  (insert "    -> " install-lisp-directory "\n\n") (sit-for 0))

(if noninteractive nil
  (insert "info $B%U%!%$%k$N%G%#%l%/%H%j$rF~NO$7$F2<$5$$(B:\n"))
(let ((default "~/emacs/info/"))
  (setq install-info-directory
	(install-check-directory
	 (if noninteractive
	     (or (car (cdr command-line-args-left)) default)
	   (read-file-name "Info directory: " default default)))))
(if noninteractive nil
  (insert "    -> " install-info-directory "\n\n") (sit-for 0))

;; lookup-vars.el

(if noninteractive nil
  (insert "$B%$%s%9%H!<%k$N<B9T(B\n")
  (insert "------------------\n\n")
  (insert "lookup-vars.el.in $B$+$i(B lookup-vars.el $B$r@8@.Cf(B...") (sit-for 0))
(with-current-buffer (find-file-noselect "lisp/lookup-vars.el.in" t)
  (if (search-forward "@VERSION@")
      (replace-match install-lookup-version))
  (if (search-forward "@pkgemacsdir@")	;needs to be fixed to the correct one
      (replace-match install-lisp-directory))
  (write-file "lookup-vars.el")
  (kill-buffer (current-buffer))
  )
(message "Copied lookup-vars.el.in to lookup-vars.el")
(if (not noninteractive) (insert "done\n"))

;; compile

(if noninteractive nil
  (insert "elisp $B%U%!%$%k$N%3%s%Q%$%kCf(B...") (sit-for 0))
(let* ((default-directory (expand-file-name "lisp/"))
       (lookup-compile-directory default-directory)
       (command-line-args-left (if (string< emacs-version "19.29")
				   (cons nil install-elisp-files)
				 install-elisp-files)))
  (load (expand-file-name "lookup-compile.el")))
(if (not noninteractive) (insert "done\n"))

;; install

(if noninteractive nil
  (insert "elisp $B%U%!%$%k$N%$%s%9%H!<%kCf(B...") (sit-for 0))
(mapcar (lambda (file)
	  (copy-file (expand-file-name file "lisp/")
		     (expand-file-name file install-lisp-directory) t)
	  (message "Installed %s to %s" file install-lisp-directory)
	  (setq file (byte-compile-dest-file file))
	  (copy-file (expand-file-name file "lisp/")
		     (expand-file-name file install-lisp-directory) t)
	  (message "Installed %s to %s" file install-lisp-directory))
	install-elisp-files)
(if (not noninteractive) (insert "done\n"))

(if noninteractive nil
  (insert "info $B%U%!%$%k$N%U%)!<%^%C%HCf(B...") (sit-for 0))
(mapcar (lambda (info)
	  (if (file-readable-p (expand-file-name info "texi/"))
	      t
	    ;; the pre-formatted .info file does not exist; format it here
	    (let ((texi (concat (file-name-sans-extension info) ".texi")))
	      (save-current-buffer
		      (let ((buf (find-file-noselect 
				  (expand-file-name texi "texi/") t)))
			(set-buffer buf)
			(texinfo-format-buffer t) ; t for nosplit
			(save-buffer 0)
			(kill-buffer (current-buffer))
			(kill-buffer buf))))))
	install-info-files)
(if (not noninteractive) (insert "done\n"))

(if noninteractive nil
  (insert "info $B%U%!%$%k$N%$%s%9%H!<%kCf(B...") (sit-for 0))
(mapcar (lambda (info)
	  (mapcar (lambda (file)
		    (copy-file (expand-file-name file "texi/")
			       (expand-file-name file install-info-directory)
			       t)
		    (message "Installed %s to %s" file install-info-directory))
		  (directory-files "texi/" nil info)))
	install-info-files)
(if (not noninteractive) (insert "done\n"))

;; clean

(if noninteractive nil
  (insert "$B0l;~%U%!%$%k$N:o=|Cf(B...") (sit-for 0))
(let ((default-directory (expand-file-name "lisp/")))
  (delete-file "lookup-vars.el")
  (mapcar (lambda (file)
	    (delete-file (byte-compile-dest-file (expand-file-name file))))
	  install-elisp-files))
(message "Removed lookup-vars.el, *.elc")
(if (not noninteractive) (insert "done\n"))

;; initialize

(if noninteractive nil
  (insert "Lookup $B$N=i4|2=Cf(B...")
  (sit-for 0)
  (lookup-initialize)
  (insert "done\n")
  (kill-buffer (current-buffer)))

;; congratulate

(if noninteractive
    (message "\nSee etc/SETUP for the setup after installation")
  (switch-to-buffer (generate-new-buffer "*Congratulations!*"))
  (insert-file-contents "etc/SETUP")
  (if (search-forward "@install-lisp-directory@")
      (replace-match install-lisp-directory))
  (if (search-forward "@install-info-directory@")
      (replace-match install-info-directory))
  (goto-char (point-min))
  (set-buffer-modified-p nil)
  (view-mode)
  (local-set-key "\C-c\C-c" 'install-open-info))

(defun install-open-info ()
  (interactive)
  (require 'info)
  (Info-find-node (expand-file-name "lookup-guide" install-info-directory)
		  "Top"))

;;; install.el ends here
