/*
 *	xeno_style.h:
 *		GTK 1.2: XenoStyleData
 *		GTK 2.0: XenoStyle
 */

#ifndef XENO_STYLE_H
#define XENO_STYLE_H

#include "xeno_theme.h"
#include "xeno_color.h"


/*
 *	Images
 */
typedef enum {
	XENO_STYLE_IMAGE_RADIO_BUTTON_NORMAL_OUT,
	XENO_STYLE_IMAGE_RADIO_BUTTON_PRELIGHT_OUT,
	XENO_STYLE_IMAGE_RADIO_BUTTON_INSENSITIVE_OUT,
	XENO_STYLE_IMAGE_RADIO_BUTTON_NORMAL_IN,
	XENO_STYLE_IMAGE_RADIO_BUTTON_PRELIGHT_IN,
	XENO_STYLE_IMAGE_RADIO_BUTTON_INSENSITIVE_IN,
	XENO_STYLE_IMAGE_RADIO_BUTTON_ACTIVE_IN,
	
	XENO_STYLE_IMAGE_CHECK_BUTTON_NORMAL,
	XENO_STYLE_IMAGE_CHECK_BUTTON_PRELIGHT,
	XENO_STYLE_IMAGE_CHECK_BUTTON_INSENSITIVE,
	XENO_STYLE_IMAGE_CHECK_BUTTON_ACTIVE,

	XENO_STYLE_IMAGE_RADIO_MENU_NORMAL,
	XENO_STYLE_IMAGE_RADIO_MENU_PRELIGHT,
	XENO_STYLE_IMAGE_RADIO_MENU_INSENSITIVE,
	
	XENO_STYLE_IMAGE_CHECK_MENU_NORMAL,
	XENO_STYLE_IMAGE_CHECK_MENU_PRELIGHT,
	XENO_STYLE_IMAGE_CHECK_MENU_INSENSITIVE,

	XENO_STYLE_IMAGE_NOTEBOOK_TAB_NORMAL,
	XENO_STYLE_IMAGE_NOTEBOOK_TAB_ACTIVE,
	XENO_STYLE_IMAGE_NOTEBOOK_TAB_INSENSITIVE,
	
	XENO_STYLE_IMAGE_DIMPLE_IN_NORMAL,
	XENO_STYLE_IMAGE_DIMPLE_IN_PRELIGHT,
	XENO_STYLE_IMAGE_DIMPLE_IN_INSENSITIVE,
	
	XENO_STYLE_IMAGE_DIMPLE_OUT_NORMAL,
	XENO_STYLE_IMAGE_DIMPLE_OUT_PRELIGHT,
	XENO_STYLE_IMAGE_DIMPLE_OUT_INSENSITIVE,
	
	XENO_STYLE_IMAGE_TRIANGLE_NORMAL,
	XENO_STYLE_IMAGE_TRIANGLE_PRELIGHT,
	XENO_STYLE_IMAGE_TRIANGLE_INSENSITIVE,
	XENO_STYLE_IMAGE_TRIANGLE_ACTIVE,
	/*
	XENO_STYLE_IMAGE_ARROW_NORMAL,
	XENO_STYLE_IMAGE_ARROW_PRELIGHT,
	XENO_STYLE_IMAGE_ARROW_INSENSITIVE,
	XENO_STYLE_IMAGE_ARROW_ACTIVE,
	*/
	XENO_STYLE_IMAGE_END,
	
	/* Aliases */
	XENO_STYLE_IMAGE_RADIO_BUTTON_FIRST = XENO_STYLE_IMAGE_RADIO_BUTTON_NORMAL_OUT,
	XENO_STYLE_IMAGE_RADIO_BUTTON_LAST  = XENO_STYLE_IMAGE_RADIO_BUTTON_ACTIVE_IN,
	
	XENO_STYLE_IMAGE_CHECK_BUTTON_FIRST = XENO_STYLE_IMAGE_CHECK_BUTTON_NORMAL,
	XENO_STYLE_IMAGE_CHECK_BUTTON_LAST = XENO_STYLE_IMAGE_CHECK_BUTTON_ACTIVE,
	
	XENO_STYLE_IMAGE_MENU_FIRST = XENO_STYLE_IMAGE_RADIO_MENU_NORMAL,
	XENO_STYLE_IMAGE_MENU_LAST = XENO_STYLE_IMAGE_CHECK_MENU_INSENSITIVE,
} XenoStyleImageType;


/*
 *	XenoGradientSet
 */
typedef struct _XenoGradient	XenoGradient;

typedef struct {
	XenoGradient	*gradients;
	guint8			redirect[5];
} XenoGradientSet;

#define xeno_gradient_set_init(g)	\
	{ (g)->gradients   = NULL;	\
	  (g)->redirect[0] = 0;		\
	  (g)->redirect[1] = 1;		\
	  (g)->redirect[2] = 2;		\
	  (g)->redirect[3] = 3;		\
	  (g)->redirect[4] = 4;		\
	}


/*
 *	XenoStyle / XenoStyleData
 */
#if XENO_GTK2
#define XENO_TYPE_STYLE					(xeno_style_get_type ())
#define XENO_STYLE(object)				(G_TYPE_CHECK_INSTANCE_CAST ((object), XENO_TYPE_STYLE, XenoStyle))
#define XENO_STYLE_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST ((klass), XENO_TYPE_STYLE, XenoStyleClass))
#define XENO_IS_STYLE(object)			(G_TYPE_CHECK_INSTANCE_TYPE ((object), XENO_TYPE_STYLE))
#define XENO_IS_STYLE_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), XENO_TYPE_STYLE))
#define XENO_STYLE_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), XENO_TYPE_STYLE, XenoStyleClass))

#define XENO_STYLE_DATA(style)			XENO_STYLE(style)
#define XENO_STYLE_RC_DATA(style)		XENO_RC_STYLE(GTK_STYLE(style)->rc_style)
#define XENO_STYLE_IS_XENO(style)		XENO_IS_STYLE(style)
#define XENO_STYLE_HAS_DATA(style)		XENO_IS_STYLE(style)

#define XENO_STYLE_XTHICKNESS(style)	((GtkStyle *)style)->xthickness
#define XENO_STYLE_YTHICKNESS(style)	((GtkStyle *)style)->ythickness

#define XENO_STYLE_FONT(style)			(XENO_STYLE(style)->font)
#define XENO_STYLE_FONT_HEIGHT(style)	(XENO_STYLE_FONT(style)->ascent + XENO_STYLE_FONT(style)->descent)
#define XENO_STYLE_FONT_ASCENT(style)	(XENO_STYLE_FONT(style)->ascent)
#define XENO_STYLE_FONT_DESCENT(style)	(XENO_STYLE_FONT(style)->descent)

typedef struct _XenoStyleData	XenoStyle;
#else
#define XENO_STYLE_DATA(style)			((XenoStyleData *)((style)->engine_data))
#define XENO_STYLE_RC_DATA(style)		((XenoRcData *)((style)->rc_style->engine_data))
#define XENO_STYLE_IS_XENO(style)		((style)->engine == xeno_theme_engine)
#define XENO_STYLE_HAS_DATA(style)		(XENO_STYLE_IS_XENO(style) && XENO_STYLE_DATA(style))

#define	XENO_IS_STYLE(style)			XENO_STYLE_HAS_DATA(style)

#define XENO_STYLE_XTHICKNESS(style)	((style)->klass->xthickness)
#define XENO_STYLE_YTHICKNESS(style)	((style)->klass->ythickness)

#define XENO_STYLE_FONT(style)			((style)->font)
#define XENO_STYLE_FONT_HEIGHT(style)	(XENO_STYLE_FONT(style)->ascent + XENO_STYLE_FONT(style)->descent)
#define XENO_STYLE_FONT_ASCENT(style)	(XENO_STYLE_FONT(style)->ascent)
#define XENO_STYLE_FONT_DESCENT(style)	(XENO_STYLE_FONT(style)->descent)

typedef GtkStyle	XenoStyle;	/* A GtkStyle where engine_data is_a XenoStyleData */

#define XENO_STYLE_MAGIC				0x7a15D011
#endif

#define XENO_STYLE_THICKNESS(style)		MIN(MIN(XENO_STYLE_XTHICKNESS(style), XENO_STYLE_YTHICKNESS(style)), 3)


typedef struct _XenoStyleData	XenoStyleData;

struct _XenoStyleData {
  #if XENO_GTK2
	GtkStyle		parent_instance;
	GdkFont			*font;
  #endif
	XenoColor		white[5];
	XenoColor		black[5];
	
	guint			check_variant : 2;
	guint			radio_variant : 2;
	guint			menu_variant : 2;
	
	GdkGC			*white_gc[5];
	GdkGC			*black_gc[5];
	GdkGC			*focus_gc;
	
	XenoPixmap		*pixmaps[XENO_STYLE_IMAGE_END];
	
	XenoGradientSet	gradient_set;
};

typedef struct {
	GtkStyleClass	parent_class;
	
  #if XENO_GTK2
	void	(*fill_background)		(GtkStyle		*style,
									 GdkDrawable	*drawable,
									 GtkStateType	state_type,
									 GdkRectangle	*area,
									 GtkWidget		*widget,
									 gint			x,
									 gint			y,
									 gint			width,
									 gint			height);
	
	void	(*fill_base)			(GtkStyle		*style,
									 GdkWindow		*window,
									 GtkStateType	state_type,
									 GdkRectangle	*area,
									 GtkWidget		*widget,
									 gint			x,
									 gint			y,
									 gint			width,
									 gint			height);
	
  #else
	guint32			magic; /* XENO_STYLE_MAGIC */
  #endif
} XenoStyleClass;

#if XENO_GTK2
GType			xeno_style_get_type		(void) G_GNUC_CONST;
#define			xeno_style_new()		g_object_new(xeno_style_get_type(), NULL)
void			xeno_style_realize		(GtkStyle	*style);
void			xeno_style_unrealize	(GtkStyle	*style);
#else
void			xeno_realize_style		(GtkStyle	*style);
void			xeno_style_data_destroy	(XenoStyleData *style_data);

extern XenoStyleClass	xeno_style_classes[4];
extern GMemChunk	  *	xeno_style_data_chunk;
#endif



#endif /* XENO_STYLE_H */

