/*  $Id$
 *
 *  Copyright © 2008-2009 Jérôme Guelfucci <jerome.guelfucci@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef HAVE_GLOBAL_H
#define HAVE_GLOBAL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

/* Possible actions */
enum {
  ACTION_0,
  SAVE,
  CLIPBOARD,
  OPEN,
#ifdef HAVE_XMLRPC
#ifdef HAVE_CURL
  UPLOAD,
#endif
#endif
};



/* Struct to store the screenshot options */
typedef struct
{
  gint region;
  gint show_save_dialog;
  gint show_mouse;
  gint delay;
  gint action;
  gint close;
  gchar *screenshot_dir;
  gchar *app;
#ifdef HAVE_XMLRPC
#ifdef HAVE_CURL
  gchar *last_user;
#endif
#endif
  gboolean cli;
}
ScreenshotData;



/* Screenshot Modes */
enum {
  MODE_0,
  FULLSCREEN,
  ACTIVE_WINDOW,
  SELECT,
};

#endif
