/* $Id: xdg-menu.h,v 1.5 2004/11/04 16:02:52 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XDG_MENU_H__
#define __XDG_MENU_H__

#include <glib.h>

#include <modules/menu/xdg-pattern.h>

G_BEGIN_DECLS;

#define XDG_APP_DIR(obj)  ((XdgAppDir *)(obj))
#define XDG_MENU(obj)     ((XdgMenu *)(obj))

typedef struct _XdgAppDir XdgAppDir;
typedef struct _XdgMenu   XdgMenu;

struct _XdgAppDir
{
  gchar prefix[PATH_MAX];
  gchar path[PATH_MAX];
};

struct _XdgMenu
{
  /* elements specified in the menu-spec */
  XdgAppDir   *app_dir;           // =NULL after compress
  GList       *default_app_dirs;  // =NULL after compress
  gchar       *directory_dir;
  GList       *default_directory_dirs;
  gchar       *name;
  gchar       *directory;
  gboolean     only_unallocated;
  gboolean     deleted;

  XdgPattern  *include;
  XdgPattern  *exclude;

  GHashTable  *moves;

  GList       *appdirs;

  XdgMenu     *parent;
  XdgMenu     *next;
  XdgMenu     *prev;
  XdgMenu     *cfirst;
  XdgMenu     *clast;
};


XdgMenu *xdg_menu_load          (const gchar   *filename,
                                 GError       **error);
void     xdg_menu_free          (XdgMenu       *menu);
XdgMenu *xdg_menu_query         (XdgMenu       *menu,
                                 const gchar   *path);
gchar   *xdg_menu_get_directory (const XdgMenu *menu);

G_END_DECLS;

#endif /* !__XDG_MENU_H__ */
