/* $Id: xfce-menu-entry-item.c,v 1.3 2004/08/04 22:26:40 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "xfce-menu-entry-item.h"


static void xfce_menu_entry_item_class_init (XfceMenuEntryItemClass *klass);
static void xfce_menu_entry_item_finalize   (GObject                *object);
static void xfce_menu_entry_item_changed    (XdgDesktopEntry        *entry,
                                             XfceMenuEntryItem      *item);



GType
xfce_menu_entry_item_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      static const GTypeInfo type_info = {
        sizeof (XfceMenuEntryItemClass),
        NULL,
        NULL,
        (GClassInitFunc) xfce_menu_entry_item_class_init,
        NULL,
        NULL,
        sizeof (XfceMenuEntryItem),
        0,
        NULL,
      };

      type = g_type_register_static (XFCE_TYPE_MENU_APP_ITEM,
                                     "XfceMenuEntryItem",
                                     &type_info,
                                     0);
    }

  return type;
}



GtkWidget*
xfce_menu_entry_item_new (XdgDesktopEntry *entry)
{
  XfceMenuEntryItem *item;

  item = g_object_new (XFCE_TYPE_MENU_ENTRY_ITEM, NULL);
  item->entry = (XdgDesktopEntry *) g_object_ref (G_OBJECT (entry));

  item->changed_id = g_signal_connect (G_OBJECT (entry),
                                       "changed",
                                       G_CALLBACK (xfce_menu_entry_item_changed),
                                       item);

  xfce_menu_entry_item_changed (entry, item);

  return (GtkWidget *) item;
}



static void
xfce_menu_entry_item_class_init (XfceMenuEntryItemClass *klass)
{
  G_OBJECT_CLASS (klass)->finalize = xfce_menu_entry_item_finalize;
}



static void
xfce_menu_entry_item_finalize (GObject *object)
{
  XfceMenuEntryItem *item;
  GObjectClass      *parent_class;

  item = XFCE_MENU_ENTRY_ITEM (object);

  /* disconnect from entry */
  g_signal_handler_disconnect (item->entry, item->changed_id);
  g_object_unref (G_OBJECT (item->entry));

  parent_class = g_type_class_peek_parent (XFCE_MENU_ENTRY_ITEM_GET_CLASS (item));
  parent_class->finalize (object);
}



static void
xfce_menu_entry_item_changed (XdgDesktopEntry   *entry,
                              XfceMenuEntryItem *item)
{
  xfce_menu_item_set_text (XFCE_MENU_ITEM (item), item->entry->name);
  xfce_menu_item_set_icon (XFCE_MENU_ITEM (item), item->entry->icon);
  xfce_menu_item_set_tip  (XFCE_MENU_ITEM (item), item->entry->comment);

  xfce_menu_app_item_set_command (XFCE_MENU_APP_ITEM (item),
                                  item->entry->command);
  xfce_menu_app_item_set_use_sn (XFCE_MENU_APP_ITEM (item),
                                 item->entry->use_sn);
  xfce_menu_app_item_set_use_term (XFCE_MENU_APP_ITEM (item),
                                   item->entry->use_term);
}

