/* $Id: xfce-menu-entry-item.h,v 1.4 2004/08/08 14:08:52 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XFCE_MENU_ENTRY_ITEM_H__
#define __XFCE_MENU_ENTRY_ITEM_H__

#include "xdg-desktop-support.h"
#include "xfce-menu-app-item.h"

G_BEGIN_DECLS;

#define XFCE_TYPE_MENU_ENTRY_ITEM             (xfce_menu_entry_item_get_type ())
#define XFCE_MENU_ENTRY_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFCE_TYPE_MENU_ENTRY_ITEM, XfceMenuEntryItem))
#define XFCE_MENU_ENTRY_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((obj), XFCE_TYPE_MENU_ENTRY_ITEM, XfceMenuEntryItemClass))
#define XFCE_IS_MENU_ENTRY_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFCE_TYPE_MENU_ENTRY_ITEM))
#define XFCE_IS_MENU_ENTRY_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), XFCE_TYPE_MENU_ENTRY_ITEM))
#define XFCE_MENU_ENTRY_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), XFCE_TYPE_MENU_ENTRY_ITEM, XfceMenuEntryItemClass))


typedef struct _XfceMenuEntryItemClass XfceMenuEntryItemClass;
typedef struct _XfceMenuEntryItem      XfceMenuEntryItem;

struct _XfceMenuEntryItemClass
{
  XfceMenuAppItemClass __parent__;
};

struct _XfceMenuEntryItem
{
  XfceMenuAppItem   __parent__;
  gulong            changed_id;
  XdgDesktopEntry  *entry;
};


GType        xfce_menu_entry_item_get_type  (void) G_GNUC_CONST;

GtkWidget   *xfce_menu_entry_item_new       (XdgDesktopEntry *entry);

G_END_DECLS;

#endif /* !__XFCE_MENU_ENTRY_ITEM_H__ */
