// Message box. Taken from the FOX library and slightly modified for translation purpose.

#include "config.h"
#include "i18n.h"

#include <fox/fx.h>
#include <fox/FXPNGIcon.h>

#include "icons.h"
#include "MessageBox.h"


// Padding for message box buttons
#define HORZ_PAD 30
#define VERT_PAD 2

#define MBOX_BUTTON_MASK   (MBOX_OK|MBOX_OK_CANCEL|MBOX_YES_NO|MBOX_YES_NO_CANCEL|MBOX_QUIT_CANCEL|MBOX_QUIT_SAVE_CANCEL)


// Map
FXDEFMAP(MessageBox) MessageBoxMap[]={
                                         FXMAPFUNC(SEL_COMMAND,MessageBox::ID_CANCEL,MessageBox::onCmdCancel),
                                         FXMAPFUNCS(SEL_COMMAND,MessageBox::ID_CLICKED_YES,MessageBox::ID_CLICKED_SAVE,MessageBox::onCmdClicked),
                                     };



// Object implementation
FXIMPLEMENT(MessageBox,FXDialogBox,MessageBoxMap,ARRAYNUMBER(MessageBoxMap))


// Construct message box with given caption, icon, and message text
MessageBox::MessageBox(FXWindow* owner,const FXString& caption,const FXString& text,FXIcon* ic,FXuint opts,FXint x,FXint y):
        FXDialogBox(owner,caption,opts|DECOR_TITLE|DECOR_BORDER,x,y,0,0, 0,0,0,0, 4,4)
{
    initialize(text,ic,opts&MBOX_BUTTON_MASK);
}


// Construct free floating message box with given caption, icon, and message text
MessageBox::MessageBox(FXApp* a,const FXString& caption,const FXString& text,FXIcon* ic,FXuint opts,FXint x,FXint y):
        FXDialogBox(a,caption,opts|DECOR_TITLE|DECOR_BORDER,x,y,0,0, 0,0,0,0, 4,4)
{
    initialize(text,ic,opts&MBOX_BUTTON_MASK);
}


// Build contents
void MessageBox::initialize(const FXString& text,FXIcon* ic,FXuint whichbuttons)
{
    FXButton *initial;
    FXVerticalFrame* content=new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);
    FXHorizontalFrame* info=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,10,10,10,10);
    new FXLabel(info,NULL,ic,ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(info,text,NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXHorizontalSeparator(content,SEPARATOR_GROOVE|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
    FXHorizontalFrame* buttons=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,10,10,10,10);
    if(whichbuttons==MBOX_OK)
    {
        initial=new FXButton(buttons,_("&OK"),NULL,this,ID_CLICKED_OK,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==MBOX_OK_CANCEL)
    {
        initial=new FXButton(buttons,_("&OK"),NULL,this,ID_CLICKED_OK,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==MBOX_YES_NO)
    {
		initial=new FXButton(buttons,_("&Yes"),NULL,this,ID_CLICKED_YES,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&No"),NULL,this,ID_CLICKED_NO,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==MBOX_YES_NO_CANCEL)
    {
        initial=new FXButton(buttons,_("&Yes"),NULL,this,ID_CLICKED_YES,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&No"),NULL,this,ID_CLICKED_NO,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==MBOX_QUIT_CANCEL)
    {
        initial=new FXButton(buttons,_("&Quit"),NULL,this,ID_CLICKED_QUIT,BUTTON_INITIAL|BUTTON_DEFAULT|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==MBOX_QUIT_SAVE_CANCEL)
    {
        new FXButton(buttons,_("&Quit"),NULL,this,ID_CLICKED_QUIT,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial=new FXButton(buttons,_("&Save"),NULL,this,ID_CLICKED_SAVE,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
}


// Close dialog with a cancel
long MessageBox::onCmdClicked(FXObject*,FXSelector sel,void*)
{
    getApp()->stopModal(this,MBOX_CLICKED_YES+(SELID(sel)-ID_CLICKED_YES));
    hide();
    return 1;
}


// Close dialog with a cancel
long MessageBox::onCmdCancel(FXObject* sender,FXSelector,void* ptr)
{
    return MessageBox::onCmdClicked(sender,MKUINT(ID_CLICKED_CANCEL,SEL_COMMAND),ptr);
}

// Show a modal error message
FXuint MessageBox::error(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    FXPNGIcon icon(owner->getApp(),errorIcon);
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),&icon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal warning message
FXuint MessageBox::warning(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    FXPNGIcon icon(owner->getApp(),warningIcon);
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),&icon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal question dialog
FXuint MessageBox::question(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    FXPNGIcon icon(owner->getApp(),questionIcon);
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),&icon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal information dialog
FXuint MessageBox::information(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    FXPNGIcon icon(owner->getApp(),infoIcon);
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),&icon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}

