// Directory box for the "extract to" command

#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#include <fox-1.4/fx.h>

#include "File.h"
#include "DirList.h"
#include "DirListBox.h"


// Map
FXDEFMAP(DirListBox) DirListBoxMap[]={
                                         FXMAPFUNC(SEL_EXPANDED,DirListBox::ID_DIRLIST_BOX,DirListBox::onExpand),
                                     };


// Object implementation
FXIMPLEMENT(DirListBox,FXDialogBox,DirListBoxMap,ARRAYNUMBER(DirListBoxMap))

// Make some windows
DirListBox::DirListBox(FXWindow *win): FXDialogBox(win,_("Directory List"),DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE|DECOR_MAXIMIZE,0,0,420,480)
{
    FXVerticalFrame *contents=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    // Directory tree
    FXHorizontalFrame *treeframe=new FXHorizontalFrame(contents,PACK_UNIFORM_WIDTH|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|
                                 LAYOUT_FILL_Y|FRAME_SUNKEN);
    dirtree=new DirList(treeframe,this,ID_DIRLIST_BOX,HSCROLLING_OFF|TREELIST_BROWSESELECT|TREELIST_SHOWS_LINES|
                        TREELIST_SHOWS_BOXES|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    // Buttons
    FXHorizontalFrame *frame1=new FXHorizontalFrame(contents,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
    new FXCheckButton(frame1,_("Show hidden folders"),dirtree,DirList::ID_TOGGLE_HIDDEN,LAYOUT_LEFT|ICON_BEFORE_TEXT);
    FXHorizontalFrame *frame2=new FXHorizontalFrame(contents,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
    new FXButton(frame2,_("  &OK   "),NULL,this,ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    new FXButton(frame2,_("&Cancel"),NULL,this,ID_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
}

void DirListBox::create()
{
    FXDialogBox::create();
	dirtree->create();
}

void DirListBox::setPath(const FXString &path)
{
    dirtree->setDirectory(path,TRUE);
}

FXString DirListBox::getPath()
{
    TreeItem *item;
    item = (TreeItem*)dirtree->getCurrentItem();
    if (item == NULL)
        return "";
    FXString path;
    path = dirtree->getItemPathname(item);
    if (!::isReadExecutable(path))
        return "";
    return path;
}

FXuint DirListBox::execute()
{
    FXint rx,ry;
    rx = ry = 0;
    show(PLACEMENT_OWNER);
    dirtree->expandTree((TreeItem*)dirtree->getFirstItem());
    return getApp()->runModalFor(this);
}


// To pass the expand message to DirList
long DirListBox::onExpand(FXObject*,FXSelector,void* ptr)
{
    dirtree->handle(this,FXSEL(SEL_EXPANDED,0),(void*)ptr);
    return 1;
}

// Cleanup
DirListBox::~DirListBox()
{
	delete dirtree;
	dirtree=(DirList*)-1;
}

