/*
 * Copyright (C) 2002-2005 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <dirent.h>
#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <glob.h>
#include <dbh.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"

#include "bookmarks.h"


/* this should be first 2 lines after headers: */
G_MODULE_EXPORT
LIBXFFM_MODULE


#define MODULE_EXEC_NAME "xffm-book"
#define MODULE_NAME "xffm_book"
#include "bookmarks.i"

G_MODULE_EXPORT
const gchar * 
g_module_check_init(GModule *module){
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    TRACE("domain=%s", GETTEXT_PACKAGE);
#endif
    return NULL;
}


/****************   void  functions  ***********************/

/**** logical void functions... */


G_MODULE_EXPORT
void *
module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return NULL;
}

/**** gchar_p void functions... */

G_MODULE_EXPORT
void *
module_name(void){
    return (void *)MODULE_NAME;
}

G_MODULE_EXPORT
void *
parent_label(void){
    return (void *)_("Book");
}

G_MODULE_EXPORT
void *
exec_name(void){
    return MODULE_EXEC_NAME;
}

G_MODULE_EXPORT
void *
empty_text(void){
    return _("Use drag+drop to add");
}



/*******************  natural functions **********************/
G_MODULE_EXPORT
void *
window_title(void * p){
    static gchar *t=NULL;
    gchar *b;
    record_entry_t *en=p;
    if (!en || !en->path) return NULL;
    g_free(t);
    b=g_path_get_basename(en->path);
    t=g_strdup_printf(_("Book: %s"),b);
    g_free(b);
    return (void *) t;
}

G_MODULE_EXPORT
void *
module_icon_id(void * p){
    return (void *) "xffm-book.png";
}

G_MODULE_EXPORT
void *
module_label(void * p){
    record_entry_t *en=(record_entry_t *)p;
    if (en && en->path && !g_file_test(en->path,G_FILE_TEST_EXISTS)) {
	return (void *)(en->path);
    }
    return (void *)_("Default book");
}

G_MODULE_EXPORT
void *
parent_module_name(void *p){
    return (void *)"xffm_bookshelf";
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
set_drop_entry(void *p){
    drop_en=(record_entry_t *)p;
    return (GINT_TO_POINTER(1));
}

G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en || !en->path) return NULL;
    TRACE("valid drop site : %s",en->path);
    return (GINT_TO_POINTER(1));
}


/*******************  rational functions **********************/
G_MODULE_EXPORT
void *
up_entry(void *en_p, void *en_c){
    record_entry_t *new_en=mk_entry(0);
    new_en->path=g_strdup(_("Book"));
    new_en->module="xffm_bookshelf";
    return (void *)new_en;
}

G_MODULE_EXPORT
void *
process_drop(void *p, void *q){
    gchar *url;
    book_widgets_p=(widgets_t *)q;
    GList *tmp=(GList *)p;
    for(tmp = (GList *)p; tmp != NULL; tmp = tmp->next) {
        url = (gchar *)tmp->data;
        add2bookmarks(url);
        TRACE("TRACE: adding %s to bookmarks\n",url);
    }
    
    return (GINT_TO_POINTER(1));
}

G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    book_widgets_p=(widgets_t *)q;
    return private_get_xfdir(en);
}

G_MODULE_EXPORT
void *
extend_popup(void *p, void *q){
    GtkWidget *w;
    book_widgets_p=(widgets_t *)q;

    if (!GTK_IS_CONTAINER (p)) {
	return GINT_TO_POINTER(1);
    } 

    showit(book_widgets_p->window,"module1");
    
  w = gtk_image_menu_item_new_with_mnemonic (_("Remove item from book"));
  gtk_widget_show (w);
  gtk_container_add (GTK_CONTAINER ((GtkWidget *)p), w);
  gui_mk_pixmap_menu(book_widgets_p, "xffm/stock_undo",w,MENU_PIXMAP);
  g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_remove_from_bookmarks_activate),
                    book_widgets_p);

    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
    GtkWidget *w;
    const gchar *label=_("Default book");
    record_entry_t *en=(record_entry_t *)p;
    book_widgets_p=(widgets_t *)q;
    if (!en) {
	return NULL;
    }
    
    if (private_popup_widget) gtk_widget_destroy(private_popup_widget);
    if (en && en->path && !g_file_test(en->path,G_FILE_TEST_EXISTS)) label=en->path;
    private_popup_widget=gui_mk_menu(
	  book_widgets_p,		  /* window */
	  label, /* label */
	  NULL,   /* name */
	  NULL, 	  /* parent */
	  NULL,NULL); /* callback (or NULL)*/

    if (book_widgets_p->back_activate) {
	w = gtk_image_menu_item_new_with_mnemonic (_("Back"));
	gui_mk_pixmap_menu(book_widgets_p, "xffm/stock_go-back",w,MENU_PIXMAP);
	gtk_widget_show (w);
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	g_signal_connect ((gpointer) w, "activate",
                   G_CALLBACK (book_widgets_p->back_activate),
                   book_widgets_p);

    }
	
    w = gtk_image_menu_item_new_with_mnemonic (_("Reload"));
    gui_mk_pixmap_menu(book_widgets_p, "xffm/stock_refresh",w,MENU_PIXMAP);
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
    g_signal_connect ((gpointer) w, "activate",
                   G_CALLBACK (bookmarks_refresh_activate),
                   book_widgets_p);


    w = gtk_image_menu_item_new_with_mnemonic (_("Save as"));
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
    gui_mk_pixmap_menu(book_widgets_p, "xffm/stock_save-as",w,MENU_PIXMAP);
    g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_save_book),
                    book_widgets_p);
    w = gtk_image_menu_item_new_with_mnemonic (_("Clear all bookmarks"));
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
    gui_mk_pixmap_menu(book_widgets_p, "xffm/stock_clear",w,MENU_PIXMAP);
    g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_clear_all_bookmarks_activate),
                    book_widgets_p);
    
    gtk_menu_popup(GTK_MENU(private_popup_widget), NULL, NULL, NULL, NULL, 3, xffm_details->eventtime);	

    return GINT_TO_POINTER(1);
}


