static gboolean is_smb;
static gchar *smb_browse=NULL;

static int childFD;
static xfdir_t fstat_xfdir;
/********/

static gint watch_stop(gpointer data)
{

    widgets_t *widgets_p=data;
    if(!widgets_p->tubo_object) return FALSE;
    if(widgets_p->stop)
    {
	gchar *m=g_strdup_printf("%d", TuboPID(widgets_p->tubo_object));
	print_diagnostics(widgets_p,"xffm/warning", strerror(ECANCELLED)," pid=", m, "\n",NULL);
	g_free(m);
	/*cancelled = TRUE;*/
	TuboCancel(widgets_p->tubo_object, NULL, NULL);
	widgets_p->stop = FALSE;
	widgets_p->tubo_object = NULL;
	hide_stop(widgets_p);
	cursor_reset(widgets_p->window);
	return FALSE;
    }
    set_progress_generic(widgets_p,-1, -1,1);
    return TRUE;
}




static int operate_stderr(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*D(printf("stderr:%s",line);)*/
    if (strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics(widgets_p,"xffm/warning",_("Sudo password requested"),"\n", NULL);
	p=xffm_get_password(widgets_p,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));

	return TRUE;
    }
    if (line[0] != '\n'){
	show_text(widgets_p);
	print_diagnostics(widgets_p,"xffm/error", line, NULL);
    }
    return TRUE;
}
static int operate_stdout(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*D(printf("stdout:%s",line);)*/
    print_diagnostics(widgets_p,NULL, line, NULL);
    return TRUE;
}


static void fork_finished_function(pid_t pid, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char m[32];
    record_entry_t *en;
    int status;
    sprintf(m, "%d\n", pid);

	hide_stop(widgets_p);
    /* another wait just in case the one in tubo misses 
     * (shouldn't happen, but it does)*/
    
    waitpid(pid, &status, WNOHANG);
    en = xffm_get_selected_entry(widgets_p);
    if (!en) {
	TRACE("fork_finished_function all done");
#if 0
	if (fstab_reference) {
	    gtk_tree_row_reference_free(fstab_reference);
	    fstab_reference=NULL;
	}
#endif
	widgets_p->tubo_object = NULL;
	return;
    }
   status=GPOINTER_TO_INT(is_mounted((void *)(en->path)));
    if (status < 0) TOGGLE_MOUNTED(en->type);
    else {
	    if (status) SET_MOUNTED(en->type);
	    else UNSET_MOUNTED(en->type);
    }
    xffm_refresh(widgets_p);
    widgets_p->tubo_object = NULL;
 
    TRACE("TRACE:fstab over by fork_finished_function\n");
}

/* NOTE: linux will fail if HAVE_STATFS is before HAVE_GETMNTENT section */
G_MODULE_EXPORT
void *is_mounted (void *p){
    const gchar *mnt_point=(const gchar *)p;
	
#if defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)
	struct mntent *m;
	const gchar *mnttab;
	FILE *mtab_fd;
	FILE *tab_file;

	
#if defined(MNT_MNTTAB)
	mnttab = MNT_MNTTAB;
#else
	/*
	 * try /proc/mounts first
	 */
	if ((mtab_fd = fopen("/proc/mounts", "r")) != NULL) {
		(void)fclose(mtab_fd);
		mnttab = "/proc/mounts";
	}
	else
		mnttab = "/etc/mtab";
#endif
	tab_file=setmntent(mnttab, "r");

	if (!tab_file) {
	      perror("setmntent:");
	      return GINT_TO_POINTER(-1);
	}
	while ((m=getmntent(tab_file))!=NULL){
		/*printf("TRACE2:%s=%s\n",m->mnt_dir,mnt_point);*/
	   if (strcmp(m->mnt_dir,mnt_point)==0){
	        endmntent(tab_file);
		return GINT_TO_POINTER(1);
	   }	   
	}
	endmntent(tab_file);
	return NULL; 
#elif defined(HAVE_STATFS) && defined(HAVE_STRUCT_STATFS_F_MNTONNAME)
      struct statfs statfsbuf;	
      if (statfs(mnt_point, &statfsbuf) == 0) {
	if (strcmp(mnt_point, statfsbuf.f_mntonname) == 0) return GINT_TO_POINTER(1);
	else return NULL;
      }
      return GINT_TO_POINTER(-1); 
#elif defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTTAB_MNT_MOUNTP)
	/*
	 * The Solaris way...
	 */
	struct mnttab mbuf;
	FILE *fp;
	int r=-1;

	if ((fp = fopen("/etc/mnttab", "r")) != NULL) {
		for (;;) {
			if (getmntent(fp, &mbuf) != 0){
				r=0;
				break;
			}

			if (strcmp(mbuf.mnt_mountp,mnt_point) == 0) {
				r=1;
				break;
			}
		}
		(void)fclose(fp);
	}
	return GINT_TO_POINTER(r);
#else
    return GINT_TO_POINTER(-1);
#warning "missing code here. " 
#endif
}

G_MODULE_EXPORT
void *
fstab_mount (void *p,void *q)
{
    gchar *argument[15];
    gchar **ap;
    int i;
    gchar *g=NULL;
    static gchar *sudo_prompt=NULL;
    gboolean use_sudo=FALSE;
    gchar *umount="umount",*mount="mount";
    const char *smb_user;
    gchar *smb_options=NULL;
    gboolean umnt;
    record_entry_t *en=(record_entry_t *)p;
    static gchar *mnt_point=NULL;
    widgets_t *widgets_p = (widgets_t *)q;

   
    if (!widgets_p) return NULL;
    if (widgets_p->tubo_object) {
	g_warning("mount process busy");
	return NULL;
    }
    
    
    if (!en) return NULL;
#if 0
    if (xffm_details->arbol && xffm_details->arbol->widgets.window){
	GtkTreePath *tpath;
	GtkTreeIter iter;
	int tree_id=(*xffm_details->arbol->get_active_tree_id)();
	(*xffm_details->arbol->widgets.get_selected_entry)(&iter);
	tpath = gtk_tree_model_get_path(xffm_details->arbol->treestuff[tree_id].treemodel, &iter);
	fstab_reference = gtk_tree_row_reference_new(xffm_details->arbol->treestuff[tree_id].treemodel, tpath);
	gtk_tree_path_free(tpath);
    }
#endif
   
    g_free(mnt_point);
    mnt_point = g_strdup(en->path);
    umnt = IS_MOUNTED(en->type);
    g_free(smb_browse);
    smb_browse=NULL;
    /* this will set the is_smb variable: */
    if (!is_in_fstab((void *)mnt_point) && !is_mounted((gchar *)mnt_point)) {
	if (en && IS_XF_NETSHARE(en->subtype))
	{	    
	    is_smb=TRUE;
	    smb_browse=randomTmpName(NULL);
	    unlink(smb_browse);
	    print_diagnostics(widgets_p,NULL,"$mkdir ",smb_browse,"\n",NULL);
	    mkdir(smb_browse, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
	}
	else {
	    print_diagnostics(widgets_p,"xffm/error",strerror(ENODEV),":\n","unknown fs type\n",NULL);
	    return GINT_TO_POINTER(0);
    
	}
    }
    
    if (getenv("XFFM_USE_SUDO") && strlen(getenv("XFFM_USE_SUDO"))) use_sudo=TRUE;
    /* sudo will change the mount point owner/group to root/root
       which will negate write access to real owner.
       Instead of not using sudo, which causes mount to fail
       we shall return ownership to real owner after mounting...*/
    /*if (smb_browse) use_sudo=FALSE;*/

    if (!getuid()) use_sudo=FALSE;
    ap = argument;

    if (use_sudo) {
       if ((g = g_find_program_in_path("sudo")) != NULL){
	    *ap++ = "sudo";
	    *ap++ = "-S";
	    g_free(g);
       } else {
	   print_diagnostics(widgets_p,"xffm/error",strerror(ENOENT),": sudo",NULL);
       }
    }
		 
    
    if (smb_browse) i=0;
    else i=GPOINTER_TO_INT(is_mounted((void *)mnt_point));
    
    if (i >= 0){
      if (i) *ap++ = umount;
      else *ap++ =mount;
    } else {
      if (umnt)	*ap++ = umount;
      else	*ap++ = mount;
    }
    if (is_smb && i==0) {
	if (smb_browse) {
	    static char options[64];
	    sprintf(options,"uid=%d,gid=%d",(int)getuid(),(int)getgid());
	    *ap++="-t";
	    *ap++="smbfs";
	    *ap++="-o";
	    *ap++=options; 
	}
	smb_user=xffm_get_smbuserpass(widgets_p,en);
	if (!smb_user || !strlen(smb_user)){
	  smb_options=g_strdup_printf("guest");
	} else {
	  smb_options=g_strdup_printf("username=%s",smb_user);
	}
     	*ap++ = "-o";
	*ap++ = smb_options;
    }

#if 0
#if !defined(HAVE_GETVFSENT) && !defined(STAT_STATVFS) 
    /* XXX - This test is BAD */
    /* -v is different on Solaris */
    *ap++ = "-v";
#endif
#endif
    
    if (strncmp(mnt_point,"smb://",strlen("smb://"))==0 ||
	strncmp(mnt_point,"SMB://",strlen("SMB://"))==0){
	    *ap++ = (gchar *)(mnt_point+strlen("SMB:"));
    } else {
	    *ap++ = (gchar *)mnt_point;
    }

    if (smb_browse){
	*ap++ = smb_browse;
    }
    *ap++ = NULL;

    show_text(widgets_p);
    print_diagnostics(widgets_p,NULL,"$",argument[0],NULL);
    for (i=1;argument[i];i++){
	if (strstr(argument[i],"username=")) print_diagnostics(widgets_p,NULL," username=*****",NULL);
	else 
	    print_diagnostics(widgets_p,NULL," ",argument[i],NULL);
    }
    print_diagnostics(widgets_p,NULL,"\n",NULL);
    
    chdir(GETWD);

    show_stop(widgets_p);
	
    /*printf("TRACE: envars=%s\n",env_vars[i]);
    printf("TRACE: value=%s\n",value);*/
    
    /* put in a \n to the password prompt to flush the pipe: fluusshh */
    if (sudo_prompt) g_free(sudo_prompt);
    sudo_prompt = g_strconcat("SUDO_PROMPT=","Password:","\n",NULL);
    putenv(sudo_prompt);
    cursor_wait(widgets_p->window);
    widgets_p->tubo_object = 
		Tubo_full(fork_function, 
				(void *)argument, 
				fork_finished_function, 
				&childFD, 
				operate_stdout, 
				operate_stderr,
				widgets_p,
				0);
    	
    g_timeout_add(260,(GtkFunction) watch_stop, widgets_p);
    	
    g_free(smb_options);
    while (widgets_p->tubo_object){
	while (gtk_events_pending()) gtk_main_iteration();
	usleep(100);
    }
    hide_text(widgets_p->diagnostics);
    cursor_reset(widgets_p->window);
    if (smb_browse) {
	return smb_browse;
    }

    TRACE("fstab_mount %s done ",mnt_point);
    return (void *) (mnt_point);
}


/* NOTE: Cygwin does have FS mounts, but they work differently from
   all other environments. For the moment, we will not support any
   mounting functionality, although in the future we might add
   cygwin specific support
*/
#if defined (__CYGWIN__)
static
xfdir_t *
private_get_xfdir(record_entry_t *en){
	fstat_xfdir.gl=NULL;
	return(NULL);
}

G_MODULE_EXPORT
void *
is_in_fstab (void *p)
{
    is_smb=FALSE;
    return NULL;
}

#elif defined(HAVE_GETVFSENT) && defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTTAB_MNT_MOUNTP)
/*  */
/*
 * Solaris
 */

#define MNTTYPE_CACHEFS	"cachefs"
#define MNTTYPE_HSFS	"hsfs"
#define MNTTYPE_NFS	"nfs"
#define MNTTYPE_SWAP	"swap"
#define MNTTYPE_SMB	"smbfs"
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	struct vfstab vbuf;
	struct mnttab mbuf;
	FILE *vfstab_fp;
	FILE *mnttab_fp;
	struct stat st;
	int i;

	if ((vfstab_fp = fopen("/etc/vfstab", "r")) == NULL)
		return(0);

	for (i = 0;; ) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;
		if(strcmp(MNTTYPE_SMB, vbuf.vfs_fstype) == 0)
			is_smb=TRUE;
		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;

		i++;
	}

	if ((mnttab_fp = fopen("/etc/mnttab", "r")) == NULL) {
		(void)fclose(vfstab_fp);
		return(0);
	}

	(void)rewind(vfstab_fp);

	if ((fstat_xfdir.gl = (dir_t *)malloc(i * sizeof(dir_t))) == NULL) {
		(void)fclose(mnttab_fp);
		(void)fclose(vfstab_fp);
		return(0);
	}

	fstat_xfdir.pathc = i;


	for (i = 0;;) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(vbuf.vfs_mountp, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(vbuf.vfs_mountp);

		/*SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);*/
		SET_FSTAB_TYPE(fstat_xfdir.gl[i].en->type);
	
		if (strcmp(MNTTYPE_NFS, vbuf.vfs_fstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_HSFS, vbuf.vfs_fstype) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CACHEFS, vbuf.vfs_fstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);

		/*
		 * Check if filesystem is already mounted
		 *  
		 */
		(void)rewind(mnttab_fp);
		for (;;) {
			if (getmntent(mnttab_fp, &mbuf) != 0)
				break;

			if (strcmp(mbuf.mnt_mountp, vbuf.vfs_mountp) == 0){ 
		    		TOGGLE_MOUNTED(fstat_xfdir.gl[i].en->type);
				break;
			}
		}
		i++;
	}

        (void)fclose(mnttab_fp);
        (void)fclose(vfstab_fp);
	

        return(&fstat_xfdir);
}

void *
is_in_fstab (void *p)
{
	int result=0;
	struct vfstab vbuf;
	FILE *vfstab_fp;
	const gchar *path = (const gchar *)p;
	is_smb=FALSE;

	if ((vfstab_fp = fopen("/etc/vfstab", "r")) == NULL)
		return(NULL);

	while (1) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;
		if (strcmp(path,vbuf.vfs_mountp)==0) {
		    if (strcmp(MNTTYPE_NFS, vbuf.vfs_fstype) == 0)
			result=__NFS_TYPE;
		    else if (strcmp(MNTTYPE_HSFS, vbuf.vfs_fstype) == 0)
			result=__CDFS_TYPE;
		    else if (strcmp(MNTTYPE_CACHEFS, vbuf.vfs_fstype) == 0)
			result=__PROC_TYPE;
		    else result=-1;
		    break;
		}

	}
	(void)fclose(vfstab_fp);
        return GINT_TO_POINTER(result);
}

/* NOTE: FreeBSD will fail if is HAVE_GETVFSENT before HAVE_STATFS */
#elif defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)

/*
 * HP-UX, Linux, SunOS 4.x
 */

#if !defined(MNTTYPE_PROCFS)
#define MNTTYPE_PROCFS	"proc"
#endif

#if !defined(MNTTYPE_SMBFS)
#define MNTTYPE_SMBFS	"smbfs"
#endif

#if !defined(MNTTYPE_DEV)
#define MNTTYPE_DEV	"devpts"
#endif

#if !defined(MNTTYPE_SHM)
#define MNTTYPE_SHM	"tmpfs"
#endif

#if !defined(MNTTYPE_CDFS)
#define	MNTTYPE_CDFS	"hfs"		/* HP-UX */
#endif

#if !defined(MNTTYPE_SWAP)
#define MNTTYPE_SWAP	"swap"
#endif

#if !defined(MNTTYPE_SWAPFS)
#define	MNTTYPE_SWAPFS	"swapfs"	/* HP-UX */
#endif

#if !defined(MNTTYPE_NFS)
#define MNTTYPE_NFS	"nfs"
#endif

#if !defined(MNT_CHECKLIST)
#if defined(_PATH_FSTAB)
#define MNT_CHECKLIST	_PATH_FSTAB
#else
#define MNT_CHECKLIST	"/etc/fstab"
#endif
#endif
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	/*struct mntent *mnt_mounted;*/
        struct mntent *mnt_struct;
	const gchar *mnttab;
	/*struct stat st;*/
	FILE *fstab_fd;
	FILE *mtab_fd;
	int i;

#if defined(MNT_MNTTAB)
	mnttab = MNT_MNTTAB;
#else
	/*
	 * try /proc/mounts first
	 */
	if ((mtab_fd = fopen("/proc/mounts", "r")) != NULL) {
		(void)fclose(mtab_fd);
		mnttab = "/proc/mounts";
	}
	else
		mnttab = "/etc/mtab";
#endif
	
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(0);
	}

	fstat_xfdir.pathc = 0;
	
	for (mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;

#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;

		fstat_xfdir.pathc++;
        }

        (void)endmntent(fstab_fd);
	

	fstat_xfdir.gl = (dir_t *)malloc(fstat_xfdir.pathc * sizeof(dir_t));

        if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		g_free(fstat_xfdir.gl);
		fstat_xfdir.gl=NULL;
		return(0);
	}

	for (i = 0, mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;

#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(mnt_struct->mnt_dir, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(mnt_struct->mnt_dir);

		/*SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);*/
		SET_FSTAB_TYPE(fstat_xfdir.gl[i].en->type);

		if (strcmp(MNTTYPE_NFS, mnt_struct->mnt_type) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			SET_SMB_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_PROCFS, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_DEV, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SHM, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SWAPFS, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CDFS, mnt_struct->mnt_type) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);

		i++;

	}

        (void)endmntent(fstab_fd);


        return(&fstat_xfdir);
}

/* 
 * This should return the fstab type, -1 if default or NULL is not in fstab...
 * Fstab types *are* (or should be) supported in xffm/libs/constants.h.
 */
void *
is_in_fstab (void *p)
{
        struct mntent *mnt_struct;
	FILE *fstab_fd;
	int result=0;
	const gchar *path = (const gchar *)p;
	is_smb=FALSE;
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(NULL);
	}

	
	for (mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;
		if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			is_smb=TRUE;
#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;
		if (strcmp(path,mnt_struct->mnt_dir)==0) {
		    TRACE("%s ---> %s",path,mnt_struct->mnt_type);
		    if (strcmp(MNTTYPE_NFS, mnt_struct->mnt_type) == 0)
			result = __NFS_TYPE;
		    else if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			result = __SMB_TYPE;
		    else if (strcmp(MNTTYPE_PROCFS, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_DEV, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_SHM, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_SWAPFS, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_CDFS, mnt_struct->mnt_type) == 0)
			result = __CDFS_TYPE;
		    else if (strcmp("iso9660", mnt_struct->mnt_type) == 0)
			result = __CDFS_TYPE;
		    else result=-1;
		    break;
		}
        }

        (void)endmntent(fstab_fd);

        return GINT_TO_POINTER(result);
}

#elif defined(HAVE_GETFSENT)

/*
 * AIX, BSD, OSF1, ULTRIX
 */

#if defined(MOUNT_CD9660)
#define MNTTYPE_CDFS	MOUNT_CD9660
#else
#define MNTTYPE_CDFS	"cdrfs"		/* AIX */
#endif

#if defined(MOUNT_CFS)
#define MNTTYPE_CODAFS	MOUNT_CFS
#elif defined(MOUNT_CODA)
#define MNTTYPE_CODAFS	MOUNT_CODA
#else
#define MNTTYPE_CODAFS	"coda"
#endif

#if defined(MOUNT_KERNFS)
#define MNTTYPE_KERNFS	MOUNT_KERNFS
#else
#define MNTTYPE_KERNFS	"kernfs"
#endif

#if defined(MOUNT_MFS)
#define MNTTYPE_MFS	MOUNT_MFS
#else
#define MNTTYPE_MFS	"mfs"
#endif

#if defined(MOUNT_NFS)
#define MNTTYPE_NFS	MOUNT_NFS
#else
#define MNTTYPE_NFS	"nfs"
#endif

#if defined(MOUNT_PROCFS)
#define MNTTYPE_PROCFS	MOUNT_PROCFS
#else
#define MNTTYPE_PROCFS "procfs"
#endif

#if defined(MOUNT_SMBFS)
#define MNTTYPE_SMBFS	MOUNT_SMBFS
#else
#define MNTTYPE_SMBFS	"smbfs"
#endif

#define MNTTYPE_SWAP	"swap"
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	struct fstab *fs;
	int i;


	if (!setfsent())
		return(0);

	for (i = 0, fs = getfsent(); fs != NULL;
			fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;

		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;

		i++;
	}

	if (!setfsent())
		return(0);
	
	if ((fstat_xfdir.gl = (dir_t *)malloc(i * sizeof(dir_t))) == NULL) {
		endfsent();
		return(0);
	}

	fstat_xfdir.pathc = i;

	for (i = 0, fs = getfsent(); fs != NULL; 
			fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;

		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(fs->fs_file, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(fs->fs_file);

		/*SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);*/
		SET_FSTAB_TYPE(fstat_xfdir.gl[i].en->type);

		if (strcmp(MNTTYPE_CDFS, fs->fs_vfstype) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CODAFS, fs->fs_vfstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_KERNFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_MFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_NFS, fs->fs_vfstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_PROCFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			SET_SMB_TYPE(fstat_xfdir.gl[i].en->subtype);

		i++;
	}

	endfsent();
	
		
        return(&fstat_xfdir);
}

void *
is_in_fstab (void *p)
{
	int result=0;
	struct fstab *fs;
	const gchar *path = (const gchar *)p;

	is_smb=FALSE;
	if (!setfsent()) return(NULL);

	for ( fs = getfsent(); fs != NULL; fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;
		if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			is_smb=TRUE;
		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;
		
		if (strcmp(path,fs->fs_file)==0) {
		    if (strcmp(MNTTYPE_CDFS, fs->fs_vfstype) == 0)
			result=__CDFS_TYPE;
		    else if (strcmp(MNTTYPE_CODAFS, fs->fs_vfstype) == 0)
			result=__NFS_TYPE;
		    else if (strcmp(MNTTYPE_KERNFS, fs->fs_vfstype) == 0)
			result=__PROC_TYPE;
		    else if (strcmp(MNTTYPE_MFS, fs->fs_vfstype) == 0)
			result=__PROC_TYPE;
		    else if (strcmp(MNTTYPE_NFS, fs->fs_vfstype) == 0)
			result=__NFS_TYPE;
		    else if (strcmp(MNTTYPE_PROCFS, fs->fs_vfstype) == 0)
			result=__PROC_TYPE;
		    else if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			result=__SMB_TYPE;
		    else result=-1;
		    break;
		}
	}
	endfsent();		
        return GINT_TO_POINTER(result);
}


#else
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	fstat_xfdir.gl=NULL;
	return(NULL);
}

void *
is_in_fstab (void *p)
{
    is_smb=FALSE;
    return NULL;
}

#endif


