/**********************************************************************/
/* Copywrite Edscott Wilson Garcia 2005 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

/*******************************************************************/

	

#define X_OFFSET 5
#define Y_OFFSET ICON_SIZE

static
desk_view_t *
create_deskview(){
    gint root_w,root_h;    
    desk_view_t *desk_view_p=create_deskview_p();

    desk_view_p->serial=1;
    desk_view_p->widgets.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_decorated ((GtkWindow *)desk_view_p->widgets.window,FALSE);
    /* this doesn't do the trick with twm, so we'll just lower the window
       at the monitor step: */
    /*gdk_window_set_keep_below (((GtkWidget *)desk_view_p->widgets.window)->window,TRUE);*/
    desk_view_p->widgets.type = DESKVIEW_TYPE;
    gtk_window_set_title (GTK_WINDOW (desk_view_p->widgets.window), "xffm-deskview");
#if 0
    desk_view_p->scrolled_window=(GtkScrolledWindow *)gtk_scrolled_window_new (NULL,NULL);
    gtk_scrolled_window_set_policy  (desk_view_p->scrolled_window,GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (desk_view_p->widgets.window),GTK_WIDGET(desk_view_p->scrolled_window));
    gtk_widget_show (GTK_WIDGET(desk_view_p->scrolled_window));
#endif

    desk_view_p->paper = gtk_drawing_area_new ();
    if(GTK_WIDGET_DOUBLE_BUFFERED(desk_view_p->paper))
	gtk_widget_set_double_buffered(desk_view_p->paper, FALSE);
    gtk_widget_show (desk_view_p->paper);
    
#if 0
    gtk_scrolled_window_add_with_viewport (desk_view_p->scrolled_window,desk_view_p->paper);
#else
    gtk_container_add (GTK_CONTAINER (desk_view_p->widgets.window),GTK_WIDGET(desk_view_p->paper));
#endif

    gdk_window_get_geometry  (gdk_get_default_root_window(),
			    NULL,NULL,&root_w,&root_h,NULL);	
    gtk_window_set_default_size ((GtkWindow *)desk_view_p->widgets.window, 	     root_w,root_h);
    gtk_window_set_resizable ((GtkWindow *)desk_view_p->widgets.window, FALSE);
    
    desk_view_p->grid_extent=root_w*root_h/ICON_SIZE/ICON_SIZE;
    desk_view_p->grid_flags=(char *)malloc(desk_view_p->grid_extent*sizeof(char));
    memset(desk_view_p->grid_flags, 0, desk_view_p->grid_extent*sizeof(char));

    
    desk_view_p->paperX = root_w+ICON_SIZE*2;
    desk_view_p->paperY = root_h+ICON_SIZE*2;
    
	
    TRACE("paperX=%d",desk_view_p->paperX);
    TRACE("paperY=%d",desk_view_p->paperY);
    gtk_widget_set_size_request (desk_view_p->paper, desk_view_p->paperX,desk_view_p->paperY);
    
    do_atoms(desk_view_p);

    gtk_widget_add_events (desk_view_p->paper,
	  GDK_POINTER_MOTION_MASK|
	  GDK_BUTTON_MOTION_MASK|
	  GDK_BUTTON_PRESS_MASK|
	  GDK_BUTTON_RELEASE_MASK|
	  GDK_ENTER_NOTIFY_MASK|
	  GDK_LEAVE_NOTIFY_MASK|
	  GDK_SCROLL_MASK |
	  GDK_EXPOSURE_MASK);

     g_signal_connect(G_OBJECT(desk_view_p->paper), "scroll-event",
				G_CALLBACK(scroll_cb), NULL);
     g_signal_connect (G_OBJECT (desk_view_p->paper), 
	      "configure-event", G_CALLBACK (on_configure), desk_view_p);    
      g_signal_connect (G_OBJECT (desk_view_p->paper), 
	      "size-allocate", G_CALLBACK (on_size), desk_view_p);
    
    g_signal_connect (G_OBJECT (desk_view_p->paper), "expose-event", 
		  GTK_SIGNAL_FUNC (on_expose), desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper), "configure-event", 
		  GTK_SIGNAL_FUNC (on_expose),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper), "button-press-event",
		  GTK_SIGNAL_FUNC (on_button_press),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper), "button-release-event",
		  GTK_SIGNAL_FUNC (on_button_release), desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper),"enter-notify-event",
		  GTK_SIGNAL_FUNC (on_enter),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper),"leave-notify-event",
		  GTK_SIGNAL_FUNC (on_leave),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper),"motion-notify-event",
		  GTK_SIGNAL_FUNC (on_motion),desk_view_p);
  
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_data_received", 
	  G_CALLBACK(drag_data), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_data_get", 
	    G_CALLBACK(drag_data_get), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_motion", 
	    G_CALLBACK(drag_motion), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_end", 
	    G_CALLBACK(drag_end), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_begin", 
	    G_CALLBACK(drag_begin), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag-leave",
	    G_CALLBACK(drag_leave), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag-data-delete",
	    G_CALLBACK(drag_delete), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag-drop",
	    G_CALLBACK(drag_drop), desk_view_p);
  
    g_signal_connect(G_OBJECT(desk_view_p->widgets.window), "destroy_event", 
	    G_CALLBACK(destroy_event), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->widgets.window), "delete_event", 
	    G_CALLBACK(destroy_event), desk_view_p);
   
    if (!target_list) target_list = gtk_target_list_new   (target_table,NUM_TARGETS);
  
    gtk_drag_source_set((GtkWidget *) desk_view_p->paper, 
	  GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
    gtk_drag_dest_set((GtkWidget *) desk_view_p->paper, 
	  GTK_DEST_DEFAULT_DROP , target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
#if 0
    {
	TRACE("hscrollbar=%d",desk_view_p->scrolled_window->hscrollbar->allocation.height);
	TRACE("vscrollbar=%d",desk_view_p->scrolled_window->vscrollbar->allocation.width);
    }
#endif
    
    gtk_widget_show_all (desk_view_p->widgets.window);
    clean_paper(desk_view_p);
    screen_set_selection(desk_view_p);
    /* get around fvwm margins: */
    gtk_window_move((GtkWindow *)(desk_view_p->widgets.window),0,0);
    
#if 0
    /* Make the root window send events to me */
    gdk_window_set_user_data (GDK_ROOT_PARENT (), desk_view_p->paper);
    XSelectInput (GDK_DISPLAY (), GDK_ROOT_WINDOW (), PropertyChangeMask);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "property-notify-event", 
	    G_CALLBACK(handle_property_notify), desk_view_p);
#endif
    TRACE("create_deskview done----------------------------");
    
    return desk_view_p;
}

static
void
destroy_deskview(desk_view_t *desk_view_p){
    GList *tmp;
    if (!desk_view_p) return;
    for (tmp=desk_view_p->population_list; tmp; tmp=tmp->next){
	destroy_desk_population_p(desk_view_p, (desk_population_t *)tmp->data);
    }
    g_list_free(desk_view_p->population_list);
    gtk_widget_destroy(desk_view_p->widgets.window);
    destroy_entry(desk_view_p->en);
    g_free(desk_view_p);
}


static int
grid_item(desk_view_t *desk_view_p,int x, int y,int font_height){
	int row,column,item,items_per_column;
	items_per_column=desk_view_p->paper->allocation.height/(ICON_SIZE + font_height) - 3;
	column = (x-X_OFFSET) / (2*ICON_SIZE);
	row = (y-Y_OFFSET+ICON_SIZE + font_height) / (ICON_SIZE + font_height);
	item = column*items_per_column + row;
	TRACE("grid_item=%d: row=%d,column=%d",item,row,column);
	return item;
}

static void
grid_mark(desk_view_t *desk_view_p,const gchar *key,int x, int y,int font_height){
	int item;
	item=grid_item(desk_view_p, x, y, font_height);
	TRACE("grid_mark: %s, item=%d<%d, font_height=%d",key,item,desk_view_p->grid_extent,font_height);
	if (item < desk_view_p->grid_extent){
		*((desk_view_p->grid_flags)+item) = 1;
		TRACE("+++++marked %s");
	}
}
static void
grid_empty(desk_view_t *desk_view_p){
	memset(desk_view_p->grid_flags,0,desk_view_p->grid_extent);
}

static char
grid_occupied(desk_view_t *desk_view_p,int x, int y,int font_height){
	int item;
	char occupied=0;
	item=grid_item(desk_view_p, x, y,font_height);
	if (item < desk_view_p->grid_extent)
		occupied=*((desk_view_p->grid_flags)+item);
	TRACE("*(desk_view_p->grid_flags+item)=%d",occupied);
	return occupied;
}


/*********************************************************************/
static int
insert_desktop_icon(	desk_view_t *desk_view_p, 
			dir_t *gl,
			int *x, int *y, int *page,
			gchar *exec,
			gchar *icon_id
			)
{
	deskview_geometry_t *deskview_geometry_p;
	gboolean nonuser_geometry=TRUE;
	gint root_w,root_h;
	gchar *key;
	desk_population_t *desk_population_p;
	if (!gl->pathv){
	    g_warning("!gl->pathv");
	    return 0;
	}
	gdk_window_get_geometry  (gdk_get_default_root_window(),NULL,NULL,&root_w,&root_h,NULL);	
	
	desk_population_p=create_desk_population_t(desk_view_p,gl->en, *x, *y);

	if (!gl->en) key="ROOT_XFFM";
	else key=gl->en->path;

	if (gl->en) {
	    gl->en->exec=exec;
	    gl->en->icon=icon_id;
	}

	TRACE("key=%s",key);
	if (gl->en && strrchr(key,'.') && strcmp(strrchr(key,'.'),".desktop")==0){
	    gchar *name=get_desktop_string("Name", gl->en->path);
	    TRACE("---> name=%s",name);
	    
	    if (name) {
		TRACE("---> name=%s",name);
		g_free(gl->pathv);
		gl->pathv=name;
	    }
	    else TRACE("---> name=null");
	    gl->en->URL=get_desktop_string("URL", gl->en->path);
	    gl->en->exec=get_desktop_string("Exec", gl->en->path);
	    gl->en->icon=get_desktop_string("Icon", gl->en->path);
	    gl->en->terminal=get_desktop_bool("Terminal", gl->en->path);
	}
	if (strcmp("..Wastebasket",gl->pathv)==0){
	    g_free(gl->pathv);
	    gl->pathv=g_strdup(_("Wastebasket"));
	}
	
	make_layout(desk_view_p,desk_population_p,gl->pathv);
	if ((deskview_geometry_p = get_deskview_geometry_p(key))!=NULL)
	{
	    if (deskview_geometry_p->x < root_w && deskview_geometry_p->y < root_h)
	    {
		*x = desk_population_p->x = deskview_geometry_p->x;
		*y = desk_population_p->y = deskview_geometry_p->y;
    	 	grid_mark(desk_view_p,key,*x,*y,desk_population_p->logical_rect.height);
		nonuser_geometry=FALSE;
	    }
	}
	
	    
	if (gl->en && gl->en->icon){
		GdkPixbuf *pixbuf;
		pixbuf =icon_tell(&(desk_view_p->widgets), REAL_BIG, gl->en->icon);
		if (pixbuf) {
		    g_object_unref(G_OBJECT(desk_population_p->pixbuf));
		    desk_population_p->pixbuf = pixbuf;
		}
	}
	if (nonuser_geometry) {
	  int font_height = desk_population_p->logical_rect.height;
	  TRACE("nonuser_geometry for %s, font_height=%d",key,font_height);
	  if (grid_occupied(desk_view_p, *x, *y, font_height)) {
	   do {
	    TRACE("grid location is occupied.......");
	    (*y) += (ICON_SIZE + font_height);
	    /* not too close to the bottom, panel rules here */
	    if ((*y) + ICON_SIZE*4 >= desk_view_p->paper->allocation.height){
	     (*y)=Y_OFFSET;
	     (*x) += (ICON_SIZE*2);
	     if (desk_view_p->paper->allocation.width - (*x) - ICON_SIZE*3 < 0 ){
		g_warning("Too many items!");
		(*page)++;
		(*x)=X_OFFSET * (*page);
	     }
	    }
	   } while (*page<3 && grid_occupied(desk_view_p, *x, *y, font_height));
	  }
	  desk_population_p->x = *x;
	  desk_population_p->y = *y;
    	  grid_mark(desk_view_p,key,*x,*y,font_height);
	}
	insert_pixbuf(desk_view_p,desk_population_p);
	insert_layout(desk_view_p,desk_population_p);
	desk_population_p->en = gl->en;
	return desk_population_p->logical_rect.height;
}

static 
int
load_xffm_icons(desk_view_t *desk_view_p, int *x, int *y, int *page){
    dir_t gl;
    int height;

    grid_empty(desk_view_p);
    
    gl.en=mk_entry(0);
    gl.pathv = g_strdup(OUR_HOST_NAME(&(desk_view_p->widgets)));
    gl.en->path=g_strdup(gl.pathv);
    SET_ROOT_TYPE(gl.en->type);
    height=insert_desktop_icon(desk_view_p, &gl, x, y, page, g_strdup("xffm-iconview"), g_strdup("xffm-system.png"));

    gl.en=mk_entry(0);
    gl.pathv = g_strdup(_("Home"));
    gl.en->path=g_strdup(gl.pathv);
    SET_ROOT_TYPE(gl.en->type);
    height=insert_desktop_icon(desk_view_p, &gl, x, y, page,
	    g_strdup_printf("%s",g_get_home_dir()), 
	    g_strdup("xffm/stock_home"));
    
    gl.en=mk_entry(0);
    gl.pathv = g_strdup(_("Run"));
    gl.en->path=g_strdup(gl.pathv);
    SET_ROOT_TYPE(gl.en->type);
    height=insert_desktop_icon(desk_view_p, &gl, x, y, page, 
	    g_strdup("xffm-run"), g_strdup("xffm/stock_execute"));
    return height;
    
}

static
void load_xfdir_icons(desk_view_t *desk_view_p,xfdir_t *xfdir_p){
    int height,j,x=X_OFFSET,y=Y_OFFSET,page=0;
    
    height=load_xffm_icons(desk_view_p, &x, &y, &page);
   
    TRACE("pathc=%d",xfdir_p->pathc);
    for(j = 0; j < xfdir_p->pathc; j++) {
	deskview_geometry_t *deskview_geometry_p=get_deskview_geometry_p(xfdir_p->gl[j].en->path);
	if (deskview_geometry_p){
    		grid_mark(desk_view_p,xfdir_p->gl[j].en->path,deskview_geometry_p->x,deskview_geometry_p->y,height);
	}
    }

    
    for(j = 0; j < xfdir_p->pathc; j++) {
	x=X_OFFSET,y=Y_OFFSET;
	insert_desktop_icon(desk_view_p, (xfdir_p->gl)+j, &x, &y, &page,NULL, NULL);
    }
}


