/*   Copyright (C) 2002 Matthew Allum (http://projects.o-hand.com/matchbox/)
 *   Copyright (C) 1999-2004 Bill Wilson
 *   Copyright (C) 2005 Edscott Wilson Garcia
 *   Copyright 1993, Rob Nation
* See attached GPL licence for further information.

 ** http://projects.o-hand.com/matchbox/documentation/developers/api/index.html
 * */
/* include .desktop parsing stuff */
/***********mb  **/

static
Pixmap
mb_util_get_root_pixmap(Display *dpy)
{
  Pixmap root_pxm = None;
  Atom atom_root_pixmap_id;
  Atom type;
  int format;
  unsigned long bytes_after;
  unsigned long n_items;
  guchar *prop_return = NULL;
  static gboolean startup=TRUE;
      
  
  if (startup) {
    Atom atomo = XInternAtom(dpy, "_XROOTPMAP_ID", True); 
    if (atomo != None) {
	XGetWindowProperty( dpy, GDK_ROOT_WINDOW(), 
		atomo, 0L, 1L, False, AnyPropertyType,
		&type, &format, &n_items, &bytes_after, &prop_return);
	if (prop_return){
	    XDeleteProperty(dpy, GDK_ROOT_WINDOW(), atomo);
	}
    }
    startup=FALSE;  
    return None;
  } 

  atom_root_pixmap_id = XInternAtom(dpy, "_XROOTPMAP_ID", True); 
      
  if (atom_root_pixmap_id != None) {
    XGetWindowProperty(dpy, GDK_ROOT_WINDOW(), atom_root_pixmap_id, 
			0L, 1L, False,AnyPropertyType, 
			&type, &format, &n_items, &bytes_after,
			&prop_return);
  } else {
    prop_return=0;
  }

  if (prop_return && type == XA_PIXMAP) {
      root_pxm = *((Pixmap *) prop_return);
      XFree(prop_return);
      if (type == XA_PIXMAP) {
        /*TRACE("gotcha root pixmap, bytes after=%d, items=%d, format=%d",
		bytes_after,n_items,format);*/
	return root_pxm;
      }
  }
  /*else TRACE("no available root pixmap");*/

  return None;
}

