static
void on_treeview_activate(GtkMenuItem * menuitem, gpointer user_data) {
    GError *error=NULL;
    gchar *command_line=NULL;
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    const gchar *program="xffm-treeview";
    const gchar *argument=desk_view_p->en->path;
    
    command_line = g_strconcat(program, " \"", argument,"\"",NULL);
    TRACE("command=%s",command_line);
    g_spawn_command_line_async (command_line, &error);

    if (error){
	g_warning(error->message);
	xffm_confirm(NULL,error->message,NULL,NULL);
	g_error_free(error);
    }
    g_free(command_line);
}

static
void on_iconview_activate(GtkMenuItem * menuitem, gpointer user_data) {
    GError *error=NULL;
    gchar *command_line=NULL;
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    const gchar *program="xffm-iconview";
    const gchar *argument=desk_view_p->en->path;
    
    command_line = g_strconcat(program, " \"", argument,"\"",NULL);
    TRACE("command=%s",command_line);
    g_spawn_command_line_async (command_line, &error);

    if (error){
	g_warning(error->message);
	xffm_confirm(NULL,error->message,NULL,NULL);
	g_error_free(error);
    }
    g_free(command_line);
}

	
static
void gui_on_about_activate (GtkMenuItem *menuitem, gpointer data)
{
#ifdef HAVE_LIBXFCEGUI4
	desk_view_t *desk_view_p = (desk_view_t *)data;
	widgets_t *widgets_p = &(desk_view_p->widgets);
	XfceAboutInfo *info;
	GtkWidget *dialog;
	GdkPixbuf *pixbuf = icon_tell (widgets_p, REAL_BIG,"xffm/xffm");
	struct passwd *p;
	gchar *g;
	
	
	if((p = getpwuid(geteuid())) != NULL){
	    g=g_strdup_printf("%s@%s",p->pw_name,xffm_details->argv[0]);
	} else {
	    g=g_strdup_printf("%d@%s",geteuid(),xffm_details->argv[0]);
	}
	info = xfce_about_info_new(
		g,
		VERSION,
		_("Xfce fast file manager"),
		XFCE_COPYRIGHT_TEXT("2002-2005", "The Xfce development team"),
		XFCE_LICENSE_LGPL);

	xfce_about_info_set_homepage(info, "http://www.xfce.org/");
	xfce_about_info_add_credit(info,
		"Edscott Wilson Garcia and others",
		"xfce4-dev@xfce.org",
		"");

	dialog = xfce_about_dialog_new(NULL, info,pixbuf );
	gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 400);
	xfce_about_info_free(info);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
	if (pixbuf) g_object_unref(G_OBJECT(pixbuf));
	g_free(g);
#else
	{
	  gchar *g=g_strdup_printf("Xtra funky file manager: %s\nEdscott Wilson Garcia and others\nxfce4-dev@xfce.org",VERSION);
	  xffm_confirm(NULL,g,NULL,NULL);
	  g_free(g);
	}
#endif
}
static
void on_settings_show(GtkMenuItem *w,gpointer data){   
    void *p;
    GtkDialog *d;
    
    if ((p=function_void("mcs-shm","xffmsettings","module_init"))!=NULL){
	TRACE("module_init=0x%x",(unsigned)p);
	d=(GtkDialog *)function_natural("mcs-shm","xffmsettings",p,"run_xffm_settings_dialog");
	if (d) {
	    gtk_dialog_run(d);
	}
    }	
    else {
	    g_warning("cannot load libxffmsettings");
    }
    return;
 
}

static
void
deskview_autotype_C         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    const gchar *command;
    const gchar *dirname;
    static gchar *new_command=NULL;
    gboolean *queued;
    const gchar *querypath,*output_arg,*output_ext;
    record_entry_t *en;
    gint argc;
    gchar **argv=NULL;
    GError *error=NULL;
    record_entry_t *tmp_en=NULL;
    desk_view_t *desk_view_p=g_object_get_data(G_OBJECT(menuitem),"gui_data");
    widgets_t *widgets_p=&(desk_view_p->widgets);
    

    
    en=desk_view_p->selection_list->data;
    output_arg=g_object_get_data(G_OBJECT(menuitem),"output_arg");
    command=g_object_get_data(G_OBJECT(menuitem),"command");
    dirname=g_object_get_data(G_OBJECT(menuitem),"workdir");
    querypath=g_object_get_data(G_OBJECT(menuitem),"querypath");
    queued=g_object_get_data(G_OBJECT(menuitem),"queued");
    output_ext=g_object_get_data(G_OBJECT(menuitem),"output_ext");
    if (output_arg && !output_ext) g_warning("output_arg && !output_ext not met"); 
    
    if (querypath) widgets_p->workdir = g_strdup(desk_view_p->en->path); 
    
    if (output_arg) {
	gchar *outputdir=widgets_p->workdir;
	if(dirname) widgets_p->workdir=g_strdup(dirname);
	else widgets_p->workdir=NULL;
	TRACE("output dir is %s",outputdir);
	if (new_command) g_free(new_command);
	new_command = g_strconcat(command," \"",outputdir,G_DIR_SEPARATOR_S,output_arg,output_ext,"\" \"",output_arg,"\"",NULL);
	command = (const gchar *)new_command;
	g_free(outputdir);
    } else if (!querypath)
    {
	g_free(widgets_p->workdir);
	widgets_p->workdir=g_strdup(dirname);
	TRACE("*****widgets_p->workdir is %s",widgets_p->workdir);
    } else if (!widgets_p->workdir)
    {
	g_warning("widgets_p->workdir==NULL");
	return;
    }
    
    TRACE("output_arg=%s, command=%s, querypath=%s, output_ext=%s, dirname=%s",
	    output_arg, command, querypath, output_ext, dirname);
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics(widgets_p,"xffm/error",msg,": ",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
    }
	    cursor_wait(widgets_p->window);
    if (fork()) {
	    int i,j=0;
	    char *n_argv[argc+1];
	    n_argv[j++]="xffm-run";
	    for (i=0;i<argc;i++){
		n_argv[j++]=argv[i];
	    }
	    n_argv[j++]=NULL;
	    chdir(dirname);
	    execvp(n_argv[0],n_argv);
	    _exit(123);
    }
	    sleep(1);
	    cursor_reset(widgets_p->window);
    g_strfreev (argv);
    if (tmp_en) destroy_entry(tmp_en);
    return;
}



static
void deskview_on_refresh(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
	reload_deskview(desk_view_p);
    return;
}

static
void on_open_with_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    int argc;
    GError *error=NULL;
    gchar **argv;
    const gchar *g;
    gchar *q;
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    record_entry_t *en=desk_view_p->selection_list->data;
    widgets_t *widgets_p=&(desk_view_p->widgets);
    
    /*g=gui_get_response(NULL,_("Open with..."),_("Open with"),NULL);*/
    {
      gchar *f=g_build_filename(xdg_cache_dir(),RUN_DBH_FILE,NULL); 
      g=gui_get_response_history(NULL,_("Open with..."),_("Open with"),f,en->path,NULL);
      g_free(f);
    }

    if (!g) return;
    q=g_strdup_printf("%s \"%s\"",g,en->path);
    g_shell_parse_argv (q, &argc,&argv,&error);
    if (error){
        g_warning(error->message);
	g_error_free(error);
	return;
    }
    g_free(q);
    
    q=g_path_get_dirname(en->path);
	    cursor_wait(widgets_p->window);
    if (fork()) {
	    int i,j=0;
	    char *n_argv[argc+1];
	    n_argv[j++]="xffm-run";
	    for (i=0;i<argc;i++){
		n_argv[j++]=argv[i];
	    }
	    n_argv[j++]=NULL;
	    execvp(n_argv[0],n_argv);
	    _exit(123);
    }
	    sleep(1);
	    cursor_reset(widgets_p->window);
    
    /*xffm_runvwd_nopipes(widgets_p,q,argv);*/
    g_free(q);
}

 
static
void 
deskview_double_click_open_with(desk_view_t *desk_view_p)
{
    widgets_t *widgets_p=&(desk_view_p->widgets);
    /* open with */
    gchar *name;
    int argc;
    gchar **argv;
    const gchar *command;
    const gchar *command_fmt;
    GError *error=NULL;
    record_entry_t *en;

    if (!desk_view_p->selection_list || !desk_view_p->selection_list->data)
	return;
    en=(record_entry_t *)desk_view_p->selection_list->data;
    if (!en->path || !strlen(en->path)) return;
    name=g_path_get_basename(en->path);
    
    command_fmt = MIME_command(name);
    
    if(!command_fmt)
    {
	g_warning("FIXME: add get response with combo history");
    } else {
        gchar *wd=g_path_get_dirname((const gchar *)en->path);	    
	command =  MIME_mk_command_line(command_fmt,name,FALSE,FALSE);


	g_shell_parse_argv (command, &argc,&argv,&error);
	if (error){
	    gchar *msg = g_strcompress (error->message);
	    print_diagnostics(widgets_p,"xffm/error",msg,":\n",command,"\n",NULL);
	    g_error_free(error);
	    g_free (msg);
	    g_free(wd);
	    return;
	}
	    cursor_wait(widgets_p->window);
	if (fork()) {
	    int i,j=0;
	    char *n_argv[argc+1];
	    chdir(wd);
	    n_argv[j++]="xffm-run";
	    for (i=0;i<argc;i++){
		n_argv[j++]=argv[i];
	    }
	    n_argv[j++]=NULL;
	    execvp(n_argv[0],n_argv);
	    _exit(123);
	}
	    sleep(1);
	    cursor_reset(widgets_p->window);
	g_free(wd);
	g_strfreev (argv); 
    }
    g_free(name);
    return;
}

static
void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    deskview_double_click_open_with(desk_view_p);
    return;
}

static
void deskview_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    widgets_t *widgets_p;
    ATOMIC_CHECK return;
ATOMIC_ON
    widgets_p = &(desk_view_p->widgets);
    xffm_remove(widgets_p,desk_view_p->selection_list);
    if (desk_view_p->en && desk_view_p->en->path) 
	unlink(get_local_cache_path(desk_view_p->en->path));
ATOMIC_OFF
    reload_deskview(desk_view_p);
}


static
void 
deskview_on_prop_activate(GtkMenuItem * menuitem, gpointer user_data) {
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    if (!desk_view_p) return;
    PROP_do_prop(NULL,desk_view_p->selection_list);
#ifndef LINKED_MODULES
    unload_prop_module();
#endif
}

static
void 
deskview_on_autoplace(GtkMenuItem * menuitem, gpointer user_data) {
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    if (!desk_view_p) return;
    {
	gchar *f=g_build_filename(xdg_cache_dir(),DESKVIEW_GEOMETRY_DBH_FILE,NULL);
	unlink(f);
	g_free(f);
	reload_deskview(desk_view_p);
    }
    return;
}




/***********************************************************************/




static
void
private_mount   (desk_view_t *desk_view_p, int mounted){
    record_entry_t *en=NULL;
    if (!desk_view_p->selection_list || desk_view_p->selection_list->data) return;
    en=desk_view_p->selection_list->data;
    
    TRACE("<<<<<<<<<<< on mount %d (0x%x)",mounted,(unsigned)desk_view_p);
    if(!en->path || !strlen(en->path)) {
	g_warning("no entry to mount");
	return;
    }
    if (mounted) SET_MOUNTED(en->type); else UNSET_MOUNTED(en->type);
    FSTAB_fstab_mount(en,&(desk_view_p->widgets));
    TRACE("<<<<<<<<<<< on mount done");
}


static
void
deskview_mount   (GtkMenuItem     *menuitem, gpointer         user_data){
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    private_mount(desk_view_p, FALSE);
}
static
void
deskview_unmount   (GtkMenuItem     *menuitem, gpointer         user_data){
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    private_mount(desk_view_p, TRUE);
}

static 
void deskview_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer data)
{
    gchar *path=NULL;
    desk_view_t *desk_view_p=(desk_view_t *)data;
    xffm_new_terminal_path(&(desk_view_p->widgets),desk_view_p->en->path);
    /*xffm_new_terminal_path(&(desk_view_p->widgets),g_get_home_dir());*/
    g_free(path);
    return;
}

static
void deskview_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    /*widgets_t *widgets_p=&(desk_view_p->widgets);*/
    record_entry_t *en=desk_view_p->selection_list->data;
	    
    if (!IS_FILE(en->type)) return;

    g_warning("FIXME: open a printwith response dialog");
   
}

/*************/
#if 0
static
void on_scramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   desk_view_t *desk_view_p=(desk_view_t *)user_data;
   record_entry_t *en;
   if (!desk_view_p || !desk_view_p->selection_list || !desk_view_p->selection_list->data)
	   return;
   en=(record_entry_t *)desk_view_p->selection_list->data;
   if (!en->path || !IS_PATH(en->type )) return;
	
   xffm_scramble(&(desk_view_p->widgets),en->path,TRUE); 
}

static
void on_unscramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
   record_entry_t *en;
   if (!desk_view_p || !desk_view_p->selection_list || !desk_view_p->selection_list->data)
	   return;
   en=(record_entry_t *)desk_view_p->selection_list->data;
   if (!en->path || !IS_PATH(en->type )) return;
	
   xffm_scramble(&(desk_view_p->widgets),en->path,TRUE); 
}
#endif

static
void deskview_differences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    /*widgets_t *widgets_p=&(desk_view_p->widgets);*/
    gchar *file1 = NULL, *file2 = NULL;
    
    if (desk_view_p->selection_list) {
	    file1 = ((record_entry_t *)(desk_view_p->selection_list->data))->path;
	    if (g_list_length(desk_view_p->selection_list)>1)
		file2 = ((record_entry_t *)(desk_view_p->selection_list->next->data))->path;
	
    }
    TRACE("xfdiff %s %s",(file1?file1:"null"),(file2?file2:"null"));
    xffm_diff(&(desk_view_p->widgets),file1, file2);
}
static
void deskview_xfmime_edit_activate(GtkMenuItem *w,gpointer data){
    desk_view_t *desk_view_p=(desk_view_t *)data;

    const gchar *argv[]={"xfmime-edit",NULL};
    xffm_runvwd(&(desk_view_p->widgets),NULL,argv);
    xffm_confirm(NULL,_("You can make xffm use an alternate icon theme with the XFFM_ICON_THEME environment variable"),NULL,"Ok");
    return;
 
}

static
void 
deskview_glob_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    TRACE("on_find_activate desk_view_p=0x%x",(unsigned)desk_view_p);
    if (desk_view_p || !desk_view_p->en || !desk_view_p->en->path) {
	TRACE("on_find_activate no path");
	FIND_do_find(&(desk_view_p->widgets));
    } else  {
	TRACE("on_find_activate path=%s",desk_view_p->en->path);
	FIND_do_find_path(&(desk_view_p->widgets),desk_view_p->en->path);
    }
}

static
void 
deskview_run_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
	TRACE("Self reference...");
	cursor_wait(desk_view_p->widgets.window);
	if (deskview_runit(&(desk_view_p->widgets), 0, NULL,TRUE)) sleep(1);
	cursor_reset(desk_view_p->widgets.window);
}
 
static
void on_newdir_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    const gchar *g=gui_get_response(NULL,_("New directory"),_("New directory"));
    
    if (g && strlen(g)) {
	gchar *p=g_build_filename(desk_view_p->en->path,g,NULL);
	if (!g_file_test(p,G_FILE_TEST_EXISTS)){
	    mkdir(p,0770);
	    reload_deskview(desk_view_p);
	} else {
	    xffm_confirm(NULL,my_utf_string(strerror(EEXIST)),NULL,NULL);
	}    
	g_free(p);
    }
}

static
void on_newfile_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    const gchar *g=gui_get_response(NULL,_("New file"),_("New file"));
    
    if (g && strlen(g)) {
	gchar *p=g_build_filename(desk_view_p->en->path,g,NULL);
	if (!g_file_test(p,G_FILE_TEST_EXISTS)){
	    fclose(fopen(p,"w"));
	    reload_deskview(desk_view_p);
	} else {
	    xffm_confirm(NULL,my_utf_string(strerror(EEXIST)),NULL,NULL);
	}
	g_free(p);
    }
}

static GSList *go_list=NULL;
static void
push_go_history(const gchar *path){
	gchar *p;
	if (!path || !strlen(path)) return;
	p=g_strdup(path);
	go_list=g_slist_append(go_list, p);
}
static 
const gchar *
pop_go_history(void){
	GSList *last;  
	static gchar *path=NULL;
	
	g_free(path);
	path=NULL;
	if (g_slist_length(go_list) > 0){
	  last = g_slist_last (go_list);
	  path = last->data;
	  go_list = g_slist_remove(go_list, (gconstpointer)path);
	}
	return (const gchar *)path;
}


static
void on_goto_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    gchar *f=g_build_filename(xdg_cache_dir(),GOTO_DBH_FILE,NULL);
    const gchar *g;
    
    g=gui_get_response_history(NULL,_("New file"),_("New file"),f,NULL,goto_path);
    g_free(f);
    
    
    if (g && strlen(g)) {
	gchar *ag=NULL;
	if (!g_path_is_absolute (g)){
		gchar *ag=g_build_filename(desk_view_p->en->path,g,NULL);
		g=(const gchar *)ag;
	}

	    
	if (g_file_test(g,G_FILE_TEST_IS_DIR)){
 	    record_entry_t *en,*o_en;
	    gchar *ag=NULL;
	    push_go_history(desk_view_p->en->path);
	    en=stat_entry(((ag==NULL)?g:ag),desk_view_p->en->type);
	    o_en=desk_view_p->en;
	    desk_view_p->en=en;
	    destroy_entry(o_en);
	    reload_deskview(desk_view_p);
	    gui_save_to_go_history(desk_view_p->en->path);
	} else {
	    xffm_confirm(NULL,my_utf_string(strerror(EINVAL)),NULL,NULL);
	}
	g_free(ag);
    }
}


static
void on_goback_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    const gchar *g=pop_go_history();
    record_entry_t *en,*o_en;

    
    en=stat_entry(g,desk_view_p->en->type);
    o_en=desk_view_p->en;
    desk_view_p->en=en;
    destroy_entry(o_en);
    reload_deskview(desk_view_p);
}


