/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/


static 
population_t *
find_in_population(	icon_view_t *icon_view_p,
			gdouble x, 
			gdouble y)
{
    int row=y/CELLHEIGHT;
    int column=x/CELLWIDTH;
    int element=row*icon_view_p->grid_columns+column;
    population_t *population_p;
    if (x<0 || y<0) return NULL;
    if (element >= icon_view_p->max_elements) return NULL;
    if (column >= icon_view_p->grid_columns)  return NULL;
    if (!icon_view_p->population_pp) return NULL;
    
    population_p = *(icon_view_p->population_pp+element);
    if (!population_p) return NULL;

    TRACE("row, column ok (%d,%d)",row,column);

    /* update row, column to consider posible window resizes */
    population_p->row=row;
    population_p->column=column;
    

    column = (int)x % CELLWIDTH;
    if (column < CELLWSPACING || column > CELLWSPACING+population_p->pixbufW)
	return NULL;
    row = (int)y % CELLHEIGHT;
    if (row ==0 || row > population_p->pixbufH)
	return NULL;
    return population_p;
}

static 
population_t *
find_in_labels(		icon_view_t *icon_view_p,
			gdouble x, 
			gdouble y)
{
    int row=y/CELLHEIGHT;
    int column=x/CELLWIDTH;
    int element=row*icon_view_p->grid_columns+column;
    population_t *population_p;
    if (x<0 || y<0) return NULL;
    if (element >= icon_view_p->max_elements) return NULL;
    if (column >= icon_view_p->grid_columns)  return NULL;
    if (!icon_view_p->population_pp) return NULL;
    
    population_p = *(icon_view_p->population_pp+element);
    if (!population_p) return NULL;

    TRACE("row, column ok (%d,%d)",row,column);

    /* update row, column to consider posible window resizes */
    population_p->row=row;
    population_p->column=column;
    

    column = (int)x % CELLWIDTH;
    row = (int)y % CELLHEIGHT;
    if (population_p->layout){
	if (column >= (CELLWIDTH-population_p->logical_rect.width)/2
	    && column <= (CELLWIDTH+population_p->logical_rect.width)/2){
	    if (row >= TEXTSPACING+population_p->pixbufH &&
		row <= TEXTSPACING+population_p->pixbufH+population_p->logical_rect.height){
		return population_p;
	    }
	}
    }
    if (population_p->layout2){
	if (column >= (CELLWIDTH-population_p->logical_rect2.width)/2
	    && column <= (CELLWIDTH+population_p->logical_rect2.width)/2){
	    if (row >= TEXTSPACING+population_p->pixbufH+population_p->logical_rect2.height &&
		row <= TEXTSPACING+population_p->pixbufH+2*population_p->logical_rect2.height){
		return population_p;
	    }
	}
    }
    return NULL;
}

/**
 *
 * create_population_t: create a population element
 *
 * @icon_view_p:
 * @en: the entry to assign to the population element.
 * @element: the element serial id number 
 * @icon_id: the mime_icon identifier. If NULL, then icon is obtained from entry information.
 * @label: the text which is to appear under the icon. If NULL, then the text is inferred from entry information.
 * 
 * **/

static 
population_t *
create_population_t(	icon_view_t *icon_view_p,
			record_entry_t *en,
			int element,
			const gchar *icon_id,
			const gchar *label) 
			
{
    gchar *actual_tag=NULL;
    GdkPixbuf *pixbuf;
    population_t *population_p;
    
    population_p =(population_t *)malloc(sizeof(population_t));
    memset(population_p,0,sizeof(population_t));

    population_p->en=en;
    /* incorrect: if (en) en->module = icon_view_p->module_name;*/
    if (population_p->en) population_p->en->module = icon_view_p->submodule_name;
    
    population_p->row=element/icon_view_p->grid_columns;
    population_p->column=element%icon_view_p->grid_columns;
    
    if (ICON_SIZE != 48){
	g_warning("need to fix icons.c for size other than ICON_SIZE = 48");
    }
    /*population_p->pixbuf = pixbuf = get_icon (&(icon_view_p->widgets),en,icon_view_p->en,ICON_SIZE);*/
    if (icon_id) pixbuf = icon_tell(&(icon_view_p->widgets),REAL_BIG, icon_id);
    else if (en) pixbuf = get_icon (&(icon_view_p->widgets),en,icon_view_p->en);
    else 
	pixbuf = NULL;
    population_p->pixbuf = population_p->normal_pixbuf = pixbuf;
    if (pixbuf) {
	population_p->pixbufW=gdk_pixbuf_get_width((const GdkPixbuf *)pixbuf);
	population_p->pixbufH=gdk_pixbuf_get_height((const GdkPixbuf *)pixbuf);
    } else {
	population_p->pixbufW=ICON_SIZE;
	population_p->pixbufH=ICON_SIZE;
    }

    /*population_p->submodule_name=NULL;*/
    population_p->saturated_pixbuf = NULL;
    population_p->selected_pixbuf = NULL;
    population_p->selected = FALSE;

    if (!en && !label) actual_tag=g_strdup("?");
    else {
	if (label) actual_tag = strdup(label);
	else actual_tag = g_path_get_basename(en->path);
    }

    if (actual_tag && strcmp(actual_tag,"..Wastebasket")==0){
	g_free(actual_tag);
	actual_tag=g_strdup(_("Wastebasket"));
    }
    graphics_layout(icon_view_p,population_p,actual_tag);
    g_free(actual_tag);
    
    icon_view_p->population_list = g_list_append (icon_view_p->population_list,(gpointer)population_p);
    return population_p;
}

static
void
destroy_population(	icon_view_t *icon_view_p)
{
    GList *tmp;
    if (!icon_view_p) return;
    if (icon_view_p->population_pp) {
	memset((void *)(icon_view_p->population_pp),
	    0,
	    icon_view_p->max_elements*sizeof(population_t *));
    }
    
    for (tmp=icon_view_p->population_list;tmp;tmp=tmp->next){
	population_t *population_p=(population_t *)tmp->data;
	if (!population_p) continue;
	 destroy_entry(population_p->en);
	/* unref g objects */
	if (population_p->normal_pixbuf) 
	    g_object_unref(population_p->normal_pixbuf);
	if (population_p->saturated_pixbuf) 
	    g_object_unref(population_p->saturated_pixbuf);
	if (population_p->selected_pixbuf) 
	    g_object_unref(population_p->selected_pixbuf);
	if (population_p->layout)
	    g_object_unref(population_p->layout);
	if (population_p->layout2)
	    g_object_unref(population_p->layout2);
	g_free(population_p);	
	population_p=NULL;
    }
    g_list_free(icon_view_p->population_list);
    icon_view_p->population_list=NULL;
}

static 
int
has_up_element(icon_view_t *icon_view_p)
{
    if (!icon_view_p->en && !icon_view_p->module_name) return 0;
    return 1;
}

static
population_t *
add_up_element(icon_view_t *icon_view_p, record_entry_t *parent_en){
    population_t *population_p;
    gchar *actual_tag=NULL;
    const gchar *icon_id="xffm/stock_go-up";
    

    if (!has_up_element(icon_view_p)) return NULL;
    
    population_p=create_population_t(icon_view_p, NULL, 0, NULL, NULL);

    /* local... */
    if (!icon_view_p->module_name){
	TRACE("!icon_view_p->module_name. Assuming local...");
	/*icon_id="xffm/open_folder";*/
	if (function_natural("plugins","xffm_fstab",icon_view_p->en->path,"is_in_fstab")){
	    actual_tag = function_natural("plugins","xffm_fstab",NULL,"module_label");
	    if (actual_tag) actual_tag = g_strdup(actual_tag);
	    population_p->en=mk_entry(0);
	    population_p->en->module=function_void("plugins","xffm_fstab","module_name");
	    population_p->en->path=g_strdup(function_natural("plugins","xffm_fstab",NULL,"module_name"));
	}
	else if (strcmp(icon_view_p->en->path,"/")==0){
	    actual_tag = (gchar *) OUR_HOST_NAME(&(icon_view_p->widgets));
	    if (actual_tag)actual_tag = g_strdup(actual_tag);
	} else {
	    gchar *parent=g_path_get_dirname(icon_view_p->en->path);
	    DBG("parent=%s",parent);
	    population_p->en=stat_entry(parent,0);
	    actual_tag = g_path_get_basename(parent);
	    DBG("actual_tag=%s",actual_tag);
	    g_free(parent);
	    population_p->en->tag = g_strdup(icon_view_p->en->tag);
	    if (actual_tag && strcmp(actual_tag,"..Wastebasket")==0){
		g_free(actual_tag);
		actual_tag = g_strdup(_("Wastebasket"));
	    }	    
	}
    } else { /* a module */
	TRACE("obtaining entry from grandparent: %s",((parent_en&&parent_en->path)?parent_en->path:"null"));
	TRACE("iconview path: %s",((icon_view_p->en&&icon_view_p->en->path)?icon_view_p->en->path:"null"));
	population_p->en = (record_entry_t *)function_rational("plugins",icon_view_p->module_name,(void *)(parent_en),(void *)icon_view_p->en,"up_entry");
	if (population_p->en && !population_p->en->path){
	    population_p->en->path = g_path_get_dirname(icon_view_p->en->path);
	}
	
	g_free(actual_tag);
	actual_tag=function_void("plugins",icon_view_p->module_name,"parent_label");
	if (actual_tag){
	    actual_tag=g_strdup(actual_tag);
	}
	else {
	    if (population_p->en && population_p->en->path) {
		g_free(actual_tag);	
		actual_tag = g_path_get_basename(population_p->en->path);
	    } else {
		g_free(actual_tag);	
		if (function_natural("plugins",icon_view_p->module_name,(void *)(icon_view_p->en),"parent_module_name")) actual_tag=g_strdup(_("Up"));
		else actual_tag = g_strdup(OUR_HOST_NAME(&(icon_view_p->widgets)));
	    }
	}
	if (population_p->en && !population_p->en->module) {
	    population_p->en->module=function_natural("plugins",icon_view_p->module_name,(void *)(icon_view_p->en),"parent_module_name");

	    TRACE("%s parent -> %s",icon_view_p->module_name,population_p->en->module);
	}
	TRACE("up path from module is: %s",((population_p&&population_p->en&&population_p->en->path)?population_p->en->path:"null"));
	/*population_p->en=copy_entry(icon_view_p->en);*/
	
    }
    if (population_p->en) SET_DUMMY_TYPE(population_p->en->type);
    
    population_p->normal_pixbuf=icon_tell(&(icon_view_p->widgets),REAL_BIG, icon_id);
    population_p->pixbuf = population_p->normal_pixbuf;
    if (population_p->pixbuf) {
	population_p->pixbufW=gdk_pixbuf_get_width((const GdkPixbuf *)population_p->pixbuf);
	population_p->pixbufH=gdk_pixbuf_get_height((const GdkPixbuf *)population_p->pixbuf);
    }
    
    graphics_layout(icon_view_p,population_p,actual_tag);
    g_free(actual_tag);

    
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
    return population_p;

}


