/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/




static
population_t * 
create_local_root(		icon_view_t *icon_view_p, 
				int i,
				const gchar *path)
{
    record_entry_t *en;
    population_t *population_p;
    const gchar *icon_id=NULL;
    const gchar *label=NULL;
    
    if (!path) {
	path="/";
	label="/";
    }
    if((en = stat_entry((char *)path, 0)) == NULL) {
        g_warning(" stat_entry((char *)path, 0) != NULL");
        return NULL;
    }
    if (strcmp(path,g_get_home_dir())==0) {
	icon_id = "xffm/stock_home";
	label = _("Home");
    }
    SET_LOCAL_TYPE(en->type);
    SET_ROOT_TYPE(en->type);
    en->tag=g_strdup(label);
    population_p=create_population_t(icon_view_p, en, i, icon_id, label);
    
    return population_p;
}


static
population_t * 
create_icon_root_element(	icon_view_t *icon_view_p, 
				int i,
				const gchar *module_name)
{
    record_entry_t *en;
    population_t *population_p;
    const gchar *icon_id=NULL;
    const gchar *submodule_name=NULL;
    const gchar *label=NULL;
    
    if (!module_name) return NULL;
    TRACE("create_icon_root_element: %s",module_name);
 
    {
      if (!function_void("plugins",module_name,"is_root_module")) {
	TRACE("%s is not root module",module_name);
	return NULL;
      }
      module_name=function_void("plugins",module_name,"module_name");
      icon_id=function_natural("plugins",module_name,NULL,"module_icon_id");
      label=function_natural("plugins",module_name,NULL,"module_label");
      submodule_name=function_void("plugins",module_name,"module_name");
      en=mk_entry(0);
      {
	  const gchar *g=(const gchar *)function_natural("plugins",module_name,NULL,"module_label");
	  const gchar *gg=(const gchar *)function_natural("plugins",module_name,NULL,"module_path");
	  if (!g) g="no module_label";
	  if (!gg) gg=g;
	  en->path = g_strdup(gg);
	  en->tag = g_strdup(g);
      }
    }
    if (!icon_id || !label) {
	g_warning("(!icon_id || !label)");
	return NULL;
    }   
    icon_view_p->module_name=NULL;
    population_p=create_population_t(icon_view_p, en, i, icon_id, label); 
    if (population_p->en) population_p->en->module=submodule_name;
    SET_ROOT_TYPE(en->type);
    return population_p;
}

static void add_icon_roots(icon_view_t *icon_view_p)
{
    int i=0;
    population_t *population_p;
    GSList *list,*plugin_list;
    
    TRACE("call to find_root_plugins");
    plugin_list = find_root_plugins();
    /*init_icon_view readjusts rows if necessary */
    init_icon_view(icon_view_p, NULL);
    init_grid(icon_view_p, g_slist_length(plugin_list)+2,NULL);
    TRACE("add_icon_roots: gdk_window_resize(%d,%d) rows=%d, cols=%d",icon_view_p->paperX,icon_view_p->paperY,icon_view_p->grid_rows,icon_view_p->grid_columns);
    gtk_widget_set_size_request (icon_view_p->paper, icon_view_p->paperX,icon_view_p->paperY);
    
    TRACE("hostname=%s",OUR_HOST_NAME(&(icon_view_p->widgets)));

    gtk_window_set_title (GTK_WINDOW (icon_view_p->widgets.window), OUR_HOST_NAME(&(icon_view_p->widgets)));
        
    /* previous value is freed in init_iconview() call: */
    icon_view_p->population_pp=
	graphics_mk_grid_elements(icon_view_p->grid_rows*icon_view_p->grid_columns);
    
    /* create basic local roots first */
    /* this is root directory (replaced by 
     * fstab plugin if installed) */
    if (function_void("plugins","xffm_fstab","module_name")) {
	population_p = icon_view_p->population_pp[i] = 
	    create_icon_root_element(icon_view_p,i,"xffm_fstab");
	if (population_p) gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
	i++;
    } else {
	population_p = icon_view_p->population_pp[i] = 
	create_local_root(icon_view_p,i,NULL); 
	i++;
	if (population_p) gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, 
		population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
    }

    
    population_p = icon_view_p->population_pp[i] = 
	create_local_root(icon_view_p,i,g_get_home_dir());
    i++;
    if (population_p) gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, 
		population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
    
    /* now come the plugin roots (except fstab) */
    for(list=plugin_list; list; list=list->next)
    {
	if (strcmp("xffm_fstab",(gchar *)list->data)==0) continue;
	population_p = icon_view_p->population_pp[i] = 
	    create_icon_root_element(icon_view_p,i,list->data);
	if (population_p) gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
	else continue;
	i++;
    }
    set_iconview_title(icon_view_p);
    print_status(&(icon_view_p->widgets),"xffm-system.png",OUR_HOST_NAME(&(icon_view_p->widgets)),NULL);
    return;
}


