/*
 * Copyright (C) 2002-6 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gridview.h"


#define PRINT_STATUS_INPUT print_status(widgets_p,"xffm/question", _("Input requested"), NULL)
#define PRINT_STATUS_DONE print_status(widgets_p,"xffm/info", _("Command done"), NULL)

#include "gridview_input.i"
	
/*******************************************************************************/

G_MODULE_EXPORT
void gridview_show_input (int which,icon_view_t *icon_view_p)
{
    GtkCheckButton *check_button1, *check_button2;
    GtkLabel *label;
    GtkEntry *entry;
    GtkCombo *combo;
    /*GtkToggleButton *w; */
    gchar *path=NULL, *name=NULL;
    record_entry_t *en;
    xfc_combo_info_t **combo_info;
    widgets_t *widgets_p = &(icon_view_p->widgets);
    combo_icon_view_p=icon_view_p;

    combo_info=(xfc_combo_info_t **)(&(icon_view_p->widgets.combo_info));




    TRACE("at gridview_show_input");

    if(icon_view_p->widgets.tubo_object){
	print_status(widgets_p,"xffm/error",strerror(EBUSY),NULL);
	return;
    }
	
    gridview_cancel_input(NULL,icon_view_p);
    

    label = (GtkLabel *) lookup_widget(icon_view_p->widgets.window,"input_label");
    entry = (GtkEntry *) lookup_widget(icon_view_p->widgets.window,"input_entry");

    /* combo setting up: */
    combo=(GtkCombo *)lookup_widget(icon_view_p->widgets.window,"input_combo");
    check_button1 = (GtkCheckButton *) lookup_widget(icon_view_p->widgets.window,"checkbutton1");
    if (*combo_info==NULL){
	TRACE("signal icon_view_p is 0x%x",(unsigned)icon_view_p);
	g_signal_connect((gpointer)check_button1,"toggled",G_CALLBACK (check1_toggle),&(icon_view_p->widgets));
	*combo_info = COMBO_init_combo(combo);
    } else {
	COMBO_clear_history(*combo_info);
    }

    (*combo_info)->activate_func = gridview_input_activate;
    (*combo_info)->activate_user_data=icon_view_p;
    /*(*combo_info)->activate_user_data=*combo_info;*/
    (*combo_info)->cancel_func = gridview_cancel_input;
    (*combo_info)->cancel_user_data=icon_view_p;
    
#ifndef LINKED_MODULES 
    /* not available in debug mode... */
    {
      xfc_combo_functions *xfc;
      xfc=load_xfc();
      if (xfc) switch (which) {
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	xfc->extra_key_completion = gui_extra_key_completion;
	xfc->extra_key_data = &(icon_view_p->widgets);
	/*xfc->extra_key_data = icon_view_p;*/
	TRACE("iconview_p=0x%x",(unsigned)icon_view_p);
	break;
	default:
	xfc->extra_key_completion = NULL;
	xfc->extra_key_data = NULL;
	break;
      } 
      else g_warning("xfc==NULL");
    }
#endif
    
    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"input_box"));
    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"input_combo"));
    COMBO_set_combo(*combo_info,NULL);
    
    /* check button initializations: */
    
    gtk_widget_hide(lookup_widget(icon_view_p->widgets.window,"checkbutton1"));
    gtk_widget_hide(lookup_widget(icon_view_p->widgets.window,"checkbutton2"));
    gtk_widget_hide(lookup_widget(icon_view_p->widgets.window,"checkbutton3"));

    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button1))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, FALSE);
    if (which==NEW_INPUT || which==NEW_DIR_INPUT)
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, TRUE);

    check_button2 = (GtkCheckButton *) lookup_widget(icon_view_p->widgets.window,"checkbutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button2))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button2, FALSE);

    icon_view_p->widgets.input = which;

    if (icon_view_p->selected_p) en=icon_view_p->selected_p->en;
    else en=NULL;

    if (en) TRACE("input.c, en->module is %s",((en->module)?en->module:"null"));
    else TRACE("input.c, entry is null");
        
    if(!en || !en->path)	    
    {
	path = g_strdup(GETWD);
	name = g_strdup(_("New"));
    }
    else
    {
	path = g_strdup(en->path);
	if(IS_PATH(en->type))
	{
	    if (!strrchr(path, '/')) {
		g_warning("show_input(): en->path is not absolute!\n");
		name=g_strdup(my_utf_string(path));
	    } else {
		name=g_path_get_basename(my_utf_string(path));
	    }
	}
	else
	{
	    name = g_strdup(_("New"));
	}
    }

    switch (which)
    {
	case PRINT_INPUT:
	{
	    gchar *pc=g_find_program_in_path("xfprint4");
	    gtk_label_set_text(label, _("Print command"));
	    if (pc) {
		gtk_entry_set_text(entry, "xfprint4");
		print_status(widgets_p,"xffm/question","xfprint4 ",FILENAME(en), NULL);
	    }
	    else {
		gtk_entry_set_text(entry, "lpr");
		print_status(widgets_p,"xffm/question","lpr ",FILENAME(en), NULL);
	    }
	    g_free(pc);
	    break;
	}
	case NEW_INPUT:
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	    set_new_combo(icon_view_p);
	    gtk_label_set_text(label, _("Name"));
	    print_status(widgets_p,"xffm/question", _("Name"), NULL);
	    if (which == NEW_INPUT){
	      gtk_button_set_label((GtkButton *) check_button1, _("Directory"));
	      showit(NULL,"checkbutton1");
	    }
	    break; 
	case WORKDIR_INPUT: 
	    {
	      gchar *f=g_build_filename(xdg_cache_dir(),WORKDIR_DBH_FILE,NULL);
	      gchar *dir=NULL;

	      if (en && en->path) dir = g_path_get_dirname(en->path);

	      COMBO_read_history(*combo_info,f);
    	      COMBO_set_combo(*combo_info,NULL);
	      
	      /* only suggest a valid utf8 path initially */
	      if (dir && g_utf8_validate (dir,-1,NULL)) {
		  COMBO_set_entry(*combo_info,dir);
	      }
   	      g_free (f);
   	      g_free (dir);
	    }
	    gtk_label_set_text(label,icon_view_p->widgets.workdir?_(icon_view_p->widgets.workdir):_("Output dir"));
	    PRINT_STATUS_INPUT;
	    break;
	case GOTO_INPUT:
	    {
	      gchar *f=g_build_filename(xdg_cache_dir(),GOTO_DBH_FILE,NULL);
	      COMBO_read_history(*combo_info,f);
	      COMBO_set_blank(*combo_info);
   	      g_free (f);
	    }
	    gtk_label_set_text(label, _("Go to"));
	    PRINT_STATUS_INPUT;
	    break;
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	    g_free(icon_view_p->widgets.workdir);
	    if (icon_view_p->en && icon_view_p->en->path)
		icon_view_p->widgets.workdir=g_strdup(icon_view_p->en->path);
	    else icon_view_p->widgets.workdir=g_strdup(g_get_home_dir());

	    switch (which)
	    {
		case RUN_INPUT:
	    	    xffm_set_run_combo(&(icon_view_p->widgets),en,*combo_info);
		    gtk_label_set_text(label, _("Run"));
		    PRINT_STATUS_INPUT;
		    break;
		case RUN_DOUBLE_CLICK:
	    	    xffm_set_run_combo(&(icon_view_p->widgets),en,*combo_info);
		    gtk_label_set_text(label, _("Open with"));
		    gtk_button_set_label((GtkButton *) check_button2, 
				    _("Remember"));
		    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"checkbutton2"));
		    if(en && en->path)
		    {
		      int in_term;
		      gchar **text_editors;
		      const gchar *p=xffm_get_from_open_history(en->path, &in_term);
		      if (p) {
			  /* XXX: this value is not in association hash...
			   * So if it is not a valid utf8, forget about it...*/
			  if ( g_utf8_validate (p,-1,NULL)) {
			    COMBO_set_entry(*combo_info,(gchar *)(p));
			    gtk_toggle_button_set_active((GtkToggleButton *) check_button2, (gboolean)in_term);	
			  }
		      }
		      else if ((text_editors=text_type_OK(en->path))!=NULL){  
			  /* OK to apply an editor */
			int k;
			for (k=0;text_editors[k];k++){
			    gchar *c=g_find_program_in_path(text_editors[k]);
			    if (c){
				g_free(c);
				COMBO_set_entry(*combo_info,(gchar *)text_editors[k]);
				break;
			    }
			}	
		      }
		      else {
			const gchar *p=MIME_command(en->path);
			/*printf("TRACE:no history to set for %s\n",en->path);*/
			if (p) COMBO_set_entry(*combo_info,(gchar *)my_valid_utf_pathstring(p));
			else COMBO_set_blank(*combo_info);
		      }
		    }
		    if (icon_view_p &&  g_list_length(icon_view_p->selection_list) > 1) {
			gchar *g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"%d item selected","%d items selected",icon_view_p->selection_count),icon_view_p->selection_count);
			print_status(widgets_p,"xffm/question", _("Input requested")," [",g,"]", NULL);
			g_free(g);
		    } else {
			PRINT_STATUS_INPUT;
		    }
		    break;

	    }

	    gtk_button_set_label((GtkButton *) check_button1, _("In terminal"));
	    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"checkbutton1"));
	    break;

	default:
	    break;
    }
    path=NULL;
    gtk_widget_grab_focus((GtkWidget *) entry);
    /* these will preselect */
    
    if (which == NEW_INPUT ||
	which == NEW_FILE_INPUT || which == NEW_DIR_INPUT ||
	which ==  RUN_INPUT || which == RUN_DOUBLE_CLICK){
      gtk_editable_set_position(GTK_EDITABLE (entry),0);
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
    } else {
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, 0);
      gtk_editable_set_position(GTK_EDITABLE (entry),-1);
    }
    if (which==WORKDIR_INPUT) gtk_main();
    g_free(path);
    g_free(name);
    return;
}


G_MODULE_EXPORT
void gridview_cancel_input (GtkEntry *entry,gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    widgets_t *widgets_p;
    if (!icon_view_p) return;
    
    widgets_p=&(icon_view_p->widgets);
    if (widgets_p->input == OTHER_INPUT) return;
    
    gtk_widget_hide(lookup_widget(widgets_p->window,"input_box"));
    print_status(widgets_p,NULL,_("Omitting"),NULL);
    gtk_paned_set_position(GTK_PANED(widgets_p->vpane), 10000);
    
    if (widgets_p->input==WORKDIR_INPUT){
	    g_free(icon_view_p->widgets.workdir);
	    icon_view_p->widgets.workdir=NULL;
	    widgets_p->input = OTHER_INPUT;
	    gtk_main_quit(); /* this lets on_autotype_C continue */
    } else {
	    widgets_p->input = OTHER_INPUT;
    }
}

/* callbacks */


G_MODULE_EXPORT
void gridview_input_ok (GtkButton * button, gpointer data)
{ 
    TRACE("--on inputok, iconview_p is 0x%x\n",(unsigned)data);
    private_ok_input((icon_view_t *)data);	
}


G_MODULE_EXPORT
void gridview_input_activate (GtkEntry * entry, gpointer data)
{
    private_ok_input ((icon_view_t *)data);
}
