/*
 * Copyright (C) 2002-6 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


static 
icon_view_t *combo_icon_view_p=NULL;

static
void set_new_combo(icon_view_t *icon_view_p)
{
    GtkWidget *w = lookup_widget(icon_view_p->widgets.window,"input_combo");
    GList *new_list = NULL;
    record_entry_t *en;
    gchar *path;

    TRACE("set_new_combo");

    if (!icon_view_p){
	g_warning("!icon_view_p");
	return;
    }
    en=icon_view_p->en;
    if (!icon_view_p->en || ! icon_view_p->en->path){
	g_warning("!icon_view_p->en || ! icon_view_p->en->path");
	return;
    }
    
    path = g_strdup(en->path);
    if(!IS_DIR(en->type)) *(strrchr(path, '/')) = 0;
    if (IS_NETTHING(en->subtype)) new_list = g_list_append(new_list,  (gpointer)_("New"));
    else new_list = g_list_append(new_list, (gpointer)xffm_new_name(path, _("New")));
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    g_list_free(new_list);
    g_free(path);
}

static 
const
gchar *
fix_relative_path(icon_view_t *icon_view_p,gchar *choice){
    static gchar *fixed_choice=NULL;
    /* invalid stuff */
    if (!choice || !icon_view_p) return NULL; 
    g_free(fixed_choice);
    fixed_choice=NULL;
    if (!strlen(choice)) {
	fixed_choice=g_strdup(choice);
    } else if (strncmp(choice,"//",2)==0 || strncmp(choice,"smb://",6)==0){
	/* network stuff */
	fixed_choice=g_strdup(choice);
    } else if (g_path_is_absolute(choice) && g_file_test(choice,G_FILE_TEST_IS_DIR)) 
    { 
	/* absolute path */
	fixed_choice=g_strdup(choice);
    } else if (icon_view_p->en && icon_view_p->en->path){
        fixed_choice=g_build_filename(icon_view_p->en->path,choice,NULL);    
        if (!g_file_test(fixed_choice,G_FILE_TEST_IS_DIR)) 
	{
        /* relative to homedir, maybe */
	    g_free(fixed_choice);
	    fixed_choice=g_build_filename(g_get_home_dir(),choice,NULL);
	    if (!g_file_test(fixed_choice,G_FILE_TEST_IS_DIR)) {
		g_free(fixed_choice);
		fixed_choice=NULL;
	    }
	}
    }
    return (const gchar *)fixed_choice;
}



/* **********************private*********************** */
static 
void check1_toggle (GtkToggleButton *togglebutton, gpointer data){
    widgets_t *widgets_p=(widgets_t *)data;
    GtkWidget *check = lookup_widget(widgets_p->window,"checkbutton3");
    if (widgets_p->input != RUN_INPUT && widgets_p->input !=  RUN_DOUBLE_CLICK) return;
    gtk_widget_hide(check);
#if 0
    gtk_button_set_label((GtkButton *) check, _("Hold"));
    if (!gtk_toggle_button_get_active (togglebutton)) gtk_widget_hide(check); 
    else gtk_widget_show(check);
#endif
}

static
const gchar *
get_selection_list_path(icon_view_t *icon_view_p){
    GList *tmp,*selection_list;
    int list_path_length=0;
    static gchar *list_path=NULL;

    selection_list=icon_view_p->selection_list;
    
    for (tmp = selection_list; tmp; tmp=tmp->next)
    {
	record_entry_t *en;
	en=(record_entry_t *) tmp->data;
	list_path_length += (strlen(en->path)+3);
    }

    g_free(list_path);
    list_path =(gchar *)malloc(list_path_length+1);
    memset(list_path,0,list_path_length+1);

    if (!list_path) return NULL;
    strcpy(list_path,"");
    for (tmp = selection_list; tmp; tmp=tmp->next)
    {
	record_entry_t *en;
	en=(record_entry_t *) tmp->data;
	strcat(list_path,"\"");
	strcat(list_path,en->path);
	strcat(list_path,"\"");
	if (tmp->next) strcat(list_path," ");
    }
    return (const gchar *) list_path;
}

static
void private_ok_input (icon_view_t *icon_view_p)
{
    /*gboolean result;*/
    gchar *choice=NULL;
    gchar *nfile=NULL;
    GtkEntry *entry;
    record_entry_t *en;
    xfc_combo_info_t **combo_info;
    widgets_t *widgets_p=&(icon_view_p->widgets);


    combo_info=(xfc_combo_info_t **)(&(widgets_p->combo_info));

    TRACE("-*************at input ok,widgets_p->input=%d (%d,%d,%d)",widgets_p->input,NEW_FILE_INPUT, NEW_DIR_INPUT,NEW_INPUT);

    print_status(widgets_p,NULL," ",NULL);
    entry = (GtkEntry *) lookup_widget(widgets_p->window,"input_entry");
    choice = g_strdup(COMBO_get_entry(*combo_info));

    gtk_widget_hide(lookup_widget(widgets_p->window,"input_box"));
   

    if (!choice && widgets_p->input==NEW_WIN_INPUT){
	choice=g_strdup(g_get_home_dir());
    }
    if (!choice) {
	TRACE("!choice\n");
	goto and_return;
    }
    g_strstrip(choice);
    if (!strlen(choice)) {
	TRACE("!strlen(choice)\n");
	goto and_return;
    }


    TRACE("*************at input ok,xffm_details->input=%d (%d,%d,%d)",widgets_p->input,NEW_FILE_INPUT, NEW_DIR_INPUT,NEW_INPUT);
    switch (widgets_p->input)
    {
	default:
	    break;
	case WORKDIR_INPUT:
	    g_free(widgets_p->workdir);
	    widgets_p->workdir=g_strdup(choice);
	    if (g_file_test(widgets_p->workdir,G_FILE_TEST_IS_DIR)){
		gui_save_workdir_history(widgets_p->workdir);
	    }
	    /* OTHER_INPUT should cancel whatever is waiting on gtk loop */
    	    /*xffm_details->input = OTHER_INPUT;*/
	    gtk_main_quit();
	    gtk_paned_set_position(GTK_PANED(widgets_p->vpane), 10000);
	    goto and_return;
	case PRINT_INPUT:
	{    
	    if (!icon_view_p->selection_list || g_list_length(icon_view_p->selection_list) < 1) return;
	    en=(record_entry_t *)icon_view_p->selection_list->data;
	    if (!en->path || !IS_FILE(en->type)) return;
	    xffm_print(widgets_p, choice, en->path);
 	    break;
	}
	case RUN_DOUBLE_CLICK:
	case RUN_INPUT:
	    {
		gboolean in_terminal, remember;
		GtkWidget *check;
		gchar *in_cmd=NULL;
		GList *selection_list;

		selection_list = icon_view_p->selection_list;
		TRACE("at RUN_INPUT");
		check = lookup_widget(widgets_p->window,"checkbutton1");
		in_terminal = gtk_toggle_button_get_active((GtkToggleButton *) check);
	

		if (g_file_test(choice,G_FILE_TEST_IS_DIR)){
		    if (in_terminal) {
			xffm_new_terminal_path(widgets_p,choice);
			{
			    gchar *f=g_strconcat(xdg_cache_dir(),RUN_DBH_FILE,NULL);
			    COMBO_save_to_history(f,choice);
			    xffm_save_flags(choice,in_terminal,0);
			    g_free(f);
			}
			break;
		    }
		    else in_cmd = g_strdup_printf("xffm %s",choice);
		} else {
		    in_cmd = g_strdup(choice);
		}
		
#ifdef TRACE
		TRACE("selection_list=0x%x, length=%d, icon_view_p->selected_p=0x%x",(unsigned)selection_list,g_list_length(selection_list),(unsigned)icon_view_p->selected_p);
		
#endif
	   
		if(widgets_p->input == RUN_INPUT)
		{
		    remember = FALSE;
		    en = NULL;
		    if (icon_view_p->en && icon_view_p->en->path && g_file_test(icon_view_p->en->path,G_FILE_TEST_IS_DIR)) chdir(icon_view_p->en->path);
		}
		else /*RUN_DOUBLE_CLICK */
		{		/*RUN_DOUBLE_CLICK */
		    check = lookup_widget(icon_view_p->widgets.window,"checkbutton2");
		    remember = gtk_toggle_button_get_active((GtkToggleButton *) check);
		    if (icon_view_p->selected_p) en=icon_view_p->selected_p->en;
		    else en=NULL;
		}
		TRACE("at input ok xffm_on_run %s en=0x%x",in_cmd,(unsigned)en);
		if (widgets_p->input == RUN_DOUBLE_CLICK && g_list_length(selection_list)==1){
		    TRACE("selection=%s",get_selection_list_path(icon_view_p));
		    if(xffm_on_run_path(widgets_p,in_cmd, get_selection_list_path(icon_view_p), in_terminal, remember, TRUE)) {

		    }

		}
		else { 
		    if(xffm_on_run(widgets_p,in_cmd, en, in_terminal, remember, TRUE));
		}
		chdir(g_get_home_dir());
		g_free(in_cmd);
	    }
	    break;
	case GOTO_INPUT:
	    {
		record_entry_t *new_en;
		const gchar *g=fix_relative_path(icon_view_p,choice);
		if (strncmp(g,"//",2) != 0 && !g_file_test(g,G_FILE_TEST_IS_DIR)){

		  if (!g_file_test(g,G_FILE_TEST_IS_DIR)){
		    print_diagnostics(widgets_p, "xffm/error","g is ", " : ", g, "\n", NULL);
		    print_diagnostics(widgets_p, "xffm/error", strerror(ENOENT), " : ", choice, "\n", NULL);
		    print_status(widgets_p, "xffm/error", strerror(ENOENT), NULL);
		    goto over;
		  }
		} 
	    
		push_iconview_go_history(icon_view_p); 
		if (strncmp(g,"//",2)==0) {
		    gchar *p;
		    for (p=(gchar *)g; *p; p++) *p=toupper(*p);
		    new_en=mk_entry(__NETWORK_TYPE);
		    new_en->st=(struct stat *)malloc(sizeof(struct stat));
		    new_en->st->st_size=0;
		    new_en->st->st_mtime=0;
		    new_en->st->st_ctime=0;
		    new_en->st->st_gid=-1;
		    new_en->st->st_uid=-1;
		    new_en->st->st_mode=0;
		    new_en->path=g_strdup(g);
		    
		    icon_view_p->module_name="xffm_smb_ws";
		    reload_iconview(icon_view_p,new_en,FALSE);
		} else {
		    new_en=stat_entry(g,__LOCAL_TYPE);
		    icon_view_p->module_name=NULL;
		    reload_iconview(icon_view_p,new_en,FALSE);
		}
		    
		
	      /* save relative path for autocompletion */
	      if (g && (g_file_test(g,G_FILE_TEST_IS_DIR) || strncmp(g,"//",2)==0)){
	        gui_save_to_go_history((gchar *)g);
	        TRACE("TRACE: RECENT_add2history(%s)\n",(char *)g);
	        RECENT_add2history( widgets_p, (char *)g);
	      }
	    }
	    break;
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	case NEW_INPUT:
	    {
		GtkWidget *w = lookup_widget(widgets_p->window,"checkbutton1");

		en=icon_view_p->en;

		TRACE("newinput, en=0x%x\n",(unsigned)en);
    		if(!en) break;
		TRACE("newinput en->module0x%x",(unsigned)en->module);
		if (en->module) {
		    const gchar *function_name="on_new";
		    switch (widgets_p->input) {
			case NEW_FILE_INPUT: function_name="on_new_file"; break;
			case NEW_DIR_INPUT:  function_name="on_new_dir"; break;
			case NEW_INPUT:
			    if (gtk_toggle_button_get_active((GtkToggleButton *) w)) {
				function_name="on_new_dir"; break;
			    } else {
				function_name="on_new_file"; break;
			    }
		    }
		    function_rational("plugins",en->module,en,widgets_p,function_name);
		    break;
		}
		else if(!IS_PATH(en->type))break;
		

		if (!en->module) {
		    char *path = g_strdup(en->path);
		    char *name = g_strdup(choice);
		    if(!IS_DIR(en->type)) *(strrchr(path, '/')) = 0;
		    xffm_new(&(icon_view_p->widgets), path, name, gtk_toggle_button_get_active((GtkToggleButton *) w));
		    g_free(path);
		    g_free(name);
		}

		{
		    record_entry_t *en=copy_entry(icon_view_p->en);
		    if (icon_view_p->en && icon_view_p->en->path) 
			unlink(get_local_cache_path(icon_view_p->en->path));
		    reload_iconview(icon_view_p,en,FALSE);
		}
	    }
	    break;
    }
over:
    widgets_p->input = OTHER_INPUT;
    gtk_paned_set_position(GTK_PANED(icon_view_p->widgets.vpane), 10000);
and_return:
    g_free(nfile);
    g_free(choice);
}



