

/*   callback  */

static
void on_scramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
   if (!icon_view_p || !icon_view_p->selected_p || !icon_view_p->selected_p->en || !icon_view_p->selected_p->en->path || !IS_PATH(icon_view_p->selected_p->en->type )) return;
	
   xffm_scramble(&(icon_view_p->widgets),icon_view_p->selected_p->en->path,TRUE); 
}

static
void on_unscramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
   if (!icon_view_p || !icon_view_p->selected_p || !icon_view_p->selected_p->en || !icon_view_p->selected_p->en->path || !IS_PATH(icon_view_p->selected_p->en->type )) return;
   xffm_scramble(&(icon_view_p->widgets),icon_view_p->selected_p->en->path,FALSE); 
}

static
void gui_on_about_activate (GtkMenuItem *menuitem, gpointer data)
{
	widgets_t *widgets_p = (widgets_t *)data;
#ifdef HAVE_LIBXFCEGUI4
	XfceAboutInfo *info;
	GtkWidget *dialog;
	GdkPixbuf *pixbuf = icon_tell (widgets_p, REAL_BIG,"xffm/xffm");
	struct passwd *p;
	gchar *g;
	
	
	if((p = getpwuid(geteuid())) != NULL){
	    g=g_strdup_printf("%s@%s",p->pw_name,xffm_details->argv[0]);
	} else {
	    g=g_strdup_printf("%d@%s",geteuid(),xffm_details->argv[0]);
	}
	info = xfce_about_info_new(
		g,
		VERSION,
		_("Xfce fast file manager"),
		XFCE_COPYRIGHT_TEXT("2002-2005", "The Xfce development team"),
		XFCE_LICENSE_LGPL);

	xfce_about_info_set_homepage(info, "http://xffm.xfce.org/");
	xfce_about_info_add_credit(info,
		"Edscott Wilson Garcia and others",
		"xfce4-dev@xfce.org",
		"");

	dialog = xfce_about_dialog_new(NULL, info,pixbuf );
	gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 400);
	xfce_about_info_free(info);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
	if (pixbuf) g_object_unref(G_OBJECT(pixbuf));
	g_free(g);
#else
	show_text(widgets_p);
	print_diagnostics(widgets_p,"xffm/info","Xtra Fast File Manager:",VERSION,
		"\nEdscott Wilson Garcia and others",
		"\nedscott@imp.mx",NULL);
#endif
}


static
void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    record_entry_t *en;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    en=icon_view_p->en;
    gridview_open_with(&(icon_view_p->widgets),en);
    return;
}

static
void on_iconview_activate(GtkMenuItem *w,gpointer user_data){
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);

	record_entry_t *en=copy_entry(icon_view_p->en);
	icon_view_t *icon_view_target=create_iconview(en);	    
	cursor_wait(icon_view_target->widgets.window);
	icon_view_target->preferences = icon_view_p->preferences;
	icon_view_target->sortcolumn = icon_view_p->sortcolumn;
	icon_view_target->module_name=icon_view_p->module_name;
 	reload_iconview(icon_view_target, en, TRUE); 
	return;
}

static 
void gridview_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gchar *path=NULL;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!path && icon_view_p->en && icon_view_p->en->path) 
	path=g_strdup(icon_view_p->en->path);
    xffm_new_terminal_path(&(icon_view_p->widgets),path);
    g_free(path);
    return;
}
   
static
void gridview_differences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    gchar *file1 = NULL, *file2 = NULL;
    
    if (icon_view_p->selection_list) {
	    file1 = ((record_entry_t *)(icon_view_p->selection_list->data))->path;
	    if (g_list_length(icon_view_p->selection_list)>1)
		file2 = ((record_entry_t *)(icon_view_p->selection_list->next->data))->path;
	
    }
    TRACE("xfdiff %s %s",(file1?file1:"null"),(file2?file2:"null"));
    xffm_diff(&(icon_view_p->widgets),file1, file2);
}
static
void gridview_xfmime_edit_activate(GtkMenuItem *w,gpointer data){
    widgets_t *widgets_p=data;
    const gchar *argv[]={"xfmime-edit",NULL};
    xffm_runvwd(widgets_p,NULL,argv);
    xffm_confirm(widgets_p,_("You can make xffm use an alternate icon theme with the XFFM_ICON_THEME environment variable"),NULL,"Ok");
    return;
 
}

static
void on_settings_show(GtkMenuItem *w,gpointer data){   
    void *p;
    GtkDialog *d;
    
    if ((p=function_void("mcs-shm","xffmsettings","module_init"))!=NULL){
	TRACE("module_init=0x%x",(unsigned)p);
	d=(GtkDialog *)function_natural("mcs-shm","xffmsettings",p,"run_xffm_settings_dialog");
	if (d) {
	    gtk_dialog_run(d);
	}
    }	
    else {
	    g_warning("cannot load libxffmsettings");
    }
    return;
 
}

static
void on_newdir_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (icon_view_p) en=icon_view_p->en;
    if(!en) return;
    gridview_show_input(NEW_DIR_INPUT,icon_view_p);
}

static
void on_newfile_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (icon_view_p) en=icon_view_p->en;
    if(!en) return;
    gridview_show_input(NEW_FILE_INPUT,icon_view_p);
}
 
static
void on_open_with_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    en=icon_view_p->en;
    if(!en){
	gridview_show_input(RUN_INPUT,icon_view_p);
    }
    else
    {
	gridview_show_input(RUN_DOUBLE_CLICK,icon_view_p);
	print_status(&(icon_view_p->widgets),"xffm/question", _("Input requested"), NULL);
    }
}
   
static int
autofunction_workdir  (	icon_view_t *icon_view_p,
			record_entry_t *en,
			const gchar *querypath) 
{
    widgets_t *widgets_p;
    widgets_p=&(icon_view_p->widgets);
         
  g_free(widgets_p->workdir);
  widgets_p->workdir=NULL;
  if (querypath){
      widgets_p->workdir=g_strdup(querypath); 
	/* remove any previous gtk loop: */ 
	gridview_cancel_input(NULL,icon_view_p);    
	/* this starts a new gtk loop */
	gridview_show_input(WORKDIR_INPUT,icon_view_p);
      /* on returning from the loop, xffm_details->input == OTHER_INPUT
       * means it was cancelled by button press, or menu selection */
      if (widgets_p->input == OTHER_INPUT) return FALSE;
      widgets_p->input = OTHER_INPUT;
      if (!widgets_p->workdir){
	 print_status(widgets_p,"xffm/warning",strerror(ENOTDIR),NULL);
	 return FALSE;
      }	 
  } else {
  	widgets_p->workdir=g_path_get_dirname (en->path);
  }
  if(!widgets_p->workdir || chdir(widgets_p->workdir)<0){
	 print_status(widgets_p,"xffm/error",strerror(errno), NULL);
	 g_free(widgets_p->workdir);
	 widgets_p->workdir=NULL;
	 chdir(GETWD);
	 return FALSE;
  }
  chdir(g_get_home_dir());
  return TRUE;
}


static
void
gridview_autotype_C                          (GtkMenuItem     *menuitem,
                                        gpointer         data)
{
    const gchar *command;
    const gchar *dirname;
    static gchar *new_command=NULL;
    gboolean *queued;
    const gchar *querypath,*output_arg,*output_ext;
    record_entry_t *en;
    gint argc;
    gchar **argv;
    GError *error=NULL;
    record_entry_t *tmp_en=NULL;
    icon_view_t *icon_view_p=g_object_get_data(G_OBJECT(menuitem),"gui_data");
    widgets_t *widgets_p=&(icon_view_p->widgets);
  
    en=icon_view_p->en;
    if (IS_NETFILE(en->subtype)){
	const gchar *file=XF_SMBget_cache_file(en,widgets_p);
	tmp_en = stat_entry ((gchar *)file, __LOCAL_TYPE);
	en=tmp_en;
    }
    output_arg=g_object_get_data(G_OBJECT(menuitem),"output_arg");
    command=g_object_get_data(G_OBJECT(menuitem),"command");
    dirname=g_object_get_data(G_OBJECT(menuitem),"workdir");
    querypath=g_object_get_data(G_OBJECT(menuitem),"querypath");
    queued=g_object_get_data(G_OBJECT(menuitem),"queued");
    output_ext=g_object_get_data(G_OBJECT(menuitem),"output_ext");
    if (output_arg && !output_ext) g_warning("output_arg && !output_ext not met"); 
    if (querypath && !autofunction_workdir (icon_view_p, en,querypath)) {
	if (tmp_en) destroy_entry(tmp_en);
	return;
    }
    
    if (output_arg) {
	gchar *outputdir=widgets_p->workdir;
	widgets_p->workdir=g_strdup(dirname);
	TRACE("output dir is %s",outputdir);
	g_free(new_command);
	new_command = g_strconcat(command," \"",outputdir,G_DIR_SEPARATOR_S,output_arg,output_ext,"\" \"",output_arg,"\"",NULL);
	command = (const gchar *)new_command;
	g_free(outputdir);
    } else if (!querypath)
    {
	g_free(widgets_p->workdir);
	widgets_p->workdir=g_strdup(dirname);
	TRACE("*****widgets_p->workdir is %s",widgets_p->workdir);
    } else if (!widgets_p->workdir)
    {
	g_warning("widgets_p->workdir==NULL");
	return;
    }
    
    TRACE("output_arg=%s, command=%s, querypath=%s, output_ext=%s, dirname=%s",
	    output_arg, command, querypath, output_ext, dirname);
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics(widgets_p,"xffm/error",msg,": ",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
    }
    
    TRACE("queued=0x%x (%d)",(unsigned)queued,((queued)? *queued : 0));
    if (queued==NULL || *queued == FALSE){
       if (xffm_runvwd(widgets_p,widgets_p->workdir,(const gchar **)argv)){
	    if (en && en->path) RECENT_add2history(widgets_p,en->path);
       }
	g_strfreev (argv);
	if (tmp_en) destroy_entry(tmp_en);
       return;
    } 

    
    gui_autofunction(&(icon_view_p->widgets),en,(const gchar **)argv,(queued && *queued));
    
    chdir(GETWD);
    if (widgets_p->workdir && strcmp(widgets_p->workdir,GETWD)!=0) print_diagnostics(widgets_p,NULL,"$chdir ",GETWD,"\n",NULL);
    g_strfreev (argv);
    if (tmp_en) destroy_entry(tmp_en);

	
}


static
void gridview_up_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p) {
	g_warning("!icon_view_p");
    }
    else {
	if (icon_view_p->population_pp && icon_view_p->population_pp[0]){
	    record_entry_t *en;
	    if (icon_view_p->population_pp[0]->en &&
		    !IS_DUMMY_TYPE(icon_view_p->population_pp[0]->en->type)) 
		return;
	    en=copy_entry(icon_view_p->population_pp[0]->en);
	    push_iconview_go_history(icon_view_p);
	    if (icon_view_p->population_pp[0]->en) icon_view_p->module_name=icon_view_p->population_pp[0]->en->module;
	    else icon_view_p->module_name=NULL;
	    reload_iconview(icon_view_p,en,TRUE);
	}
    }
}
static
void gridview_home_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p) {
	g_warning("!icon_view_p");
    } else {
	record_entry_t *en=stat_entry((gchar *) g_get_home_dir(),__ROOT_TYPE | __LOCAL_TYPE );
	push_iconview_go_history(icon_view_p);
	icon_view_p->module_name=NULL;
	reload_iconview(icon_view_p,en,FALSE);
    }
}

static
void gridview_jump_to_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    gridview_show_input(GOTO_INPUT,icon_view_p);
}



extern
void
mk_text_entry(icon_view_t *icon_view_p, population_t *population_p, int caso);
/*********************** private callbacks ************************************/
#define RENAME_CASO 	0
#define DUPLICATE_CASO 	1
#define SYMLINK_CASO 	2

static 
gboolean
easy_data_test(icon_view_t *icon_view_p){
    if(!icon_view_p->en || !IS_PATH(icon_view_p->en->type) || !icon_view_p->selected_p || !icon_view_p->selected_p->en)
    {
	print_status(&(icon_view_p->widgets),"xffm/error", strerror(EINVAL), NULL);
	return FALSE;
    }
   return TRUE;
}

static
void gridview_rename_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!easy_data_test(icon_view_p)) return;
    mk_text_entry(icon_view_p, icon_view_p->selected_p, RENAME_CASO);
}
 
static
void gridview_duplicate_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!easy_data_test(icon_view_p)) return;
    mk_text_entry(icon_view_p, icon_view_p->selected_p, DUPLICATE_CASO);
}

static
void gridview_symlink_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!easy_data_test(icon_view_p)) return;
    mk_text_entry(icon_view_p, icon_view_p->selected_p, SYMLINK_CASO);
}
   
static
void gridview_unselect_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p) return;
    unselect_all_iconview(icon_view_p);
}

static
void gridview_select_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    int items=0;
    if (!icon_view_p) return;
	
    print_status(&(icon_view_p->widgets),"xffm/info",_("Select all"),"...",NULL);
    cursor_wait(icon_view_p->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    items=select_all_iconview(icon_view_p);
    {
	gchar *g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"%d item selected","%d items selected",items),items);
	print_status(&(icon_view_p->widgets),"xffm/info",g,NULL);
	g_free(g);
    }
    cursor_reset(icon_view_p->widgets.window);
}

void gridview_touch_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
   
    if (icon_view_p && icon_view_p->selection_list && icon_view_p->selection_list->data) {
	 en=(record_entry_t *)icon_view_p->selection_list->data;
    }
 
    if(!en || !IS_PATH(en->type))
    {
	print_status(&(icon_view_p->widgets),"xffm/error", strerror(EINVAL), NULL);
	return;
    }
    xffm_touch(&(icon_view_p->widgets),en->path);
    return;
}

/***   properties_callbacks  ***/


static
void 
gridview_on_prop_activate(GtkMenuItem * menuitem, gpointer user_data) {
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    TRACE("on_prop_activate icon_view_p=0x%x",(unsigned)icon_view_p);
    if (!icon_view_p) return;
    PROP_do_prop(&(icon_view_p->widgets), icon_view_p->selection_list);
#ifndef LINKED_MODULES
    unload_prop_module();
#endif
}


/*********   find callbacks   *********/

static
void 
gridview_glob_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    TRACE("on_find_activate icon_view_p=0x%x",(unsigned)icon_view_p);
    if (!icon_view_p || !icon_view_p->en || !icon_view_p->en->path) {
	TRACE("on_find_activate no path");
	FIND_do_find(&(icon_view_p->widgets));
    } else  {
	TRACE("on_find_activate path=%s",icon_view_p->en->path);
	FIND_do_find_path(&(icon_view_p->widgets),icon_view_p->en->path);
    }
}

static
void 
gridview_host_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    record_entry_t *en=NULL;
    if (!icon_view_p) return;
    push_iconview_go_history(icon_view_p);
    reload_iconview(icon_view_p,en,FALSE);
}


static
void 
gridview_select_by_filter(GtkMenuItem * menuitem, gpointer user_data)
{
    const gchar *filter_s;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p) return;
    filter_s = gui_get_response(&(icon_view_p->widgets),_("Select by filter"),_("File filter : "));

    if (filter_s && strlen(filter_s)) {
	select_byfilter_iconview(icon_view_p, filter_s);
    }
    return;
}
 
static 
void       
gridview_hidden_toggled (GtkToggleButton *togglebutton, gpointer user_data){
    record_entry_t *en;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p;
    if (!user_data) return;
    icon_view_p=(icon_view_t *)(widgets_p->parent);
    ATOMIC_CHECK return;
ATOMIC_ON    
    if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));

    icon_view_p->preferences ^= __SHOW_HIDDEN;

    save_iconview_preferences(icon_view_p);
ATOMIC_OFF    
    en=copy_entry(icon_view_p->en);
    reload_iconview(icon_view_p,en,FALSE);
}

static 
void       
gridview_preview_toggled (GtkToggleButton *togglebutton, gpointer user_data){
    record_entry_t *en;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p;
    if (!user_data) return;
    icon_view_p=(icon_view_t *)(widgets_p->parent);
    ATOMIC_CHECK return;
ATOMIC_ON
    icon_view_p->preferences ^= __SHOW_IMAGES;
    save_iconview_preferences(icon_view_p);
ATOMIC_OFF    
    en=copy_entry(icon_view_p->en);
    reload_iconview(icon_view_p,en,FALSE);
}

/* sort type radio: */
static 
void       
gridview_on_radio (GtkCheckMenuItem *checkmenuitem, gpointer user_data){
    record_entry_t *en;
    icon_view_t *icon_view_p=(icon_view_t *)g_object_get_data(G_OBJECT(checkmenuitem),"gui_data");
    if (!icon_view_p) return;
    ATOMIC_CHECK return;
ATOMIC_ON    
    icon_view_p->sortcolumn = GPOINTER_TO_INT(user_data);
    save_iconview_preferences(icon_view_p);
    en = copy_entry(icon_view_p->en);
ATOMIC_OFF    
    reload_iconview(icon_view_p,en,FALSE);
}

static
void 
on_ascending (GtkMenuItem * menuitem, gpointer user_data){
    record_entry_t *en;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p) return;
    ATOMIC_CHECK return;
ATOMIC_ON
    icon_view_p->preferences |= SORT_ASCENDING;
    save_iconview_preferences(icon_view_p);
    en=copy_entry(icon_view_p->en);
ATOMIC_OFF
    reload_iconview(icon_view_p,en,FALSE);
    return; 
}

static
void 
on_descending (GtkMenuItem * menuitem, gpointer user_data){
    record_entry_t *en;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p) return;
    ATOMIC_CHECK return;
ATOMIC_ON
    en=copy_entry(icon_view_p->en);
    icon_view_p->preferences &= (SORT_ASCENDING^0xffffffff);
    save_iconview_preferences(icon_view_p);
ATOMIC_OFF    
    reload_iconview(icon_view_p,en,FALSE);
    return;
}

static
void on_treeview_activate(GtkMenuItem * menuitem, gpointer user_data) {
    GError *error=NULL;
    gchar *command_line=NULL;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    const gchar *program="xffm-treeview";
    gchar *argument=NULL;
    const gchar *module_name="";
    
    if (icon_view_p && icon_view_p->en && icon_view_p->en->path){
      if (icon_view_p->module_name){
	    argument=g_strdup_printf("\"%s\"",icon_view_p->en->path);
      } else {
	if (g_file_test(icon_view_p->en->path,G_FILE_TEST_IS_DIR)){
	    argument=g_strdup_printf("\"%s\"",icon_view_p->en->path);
	} 
      }
    }
    
    if (!argument) argument=g_strdup("");
    if (icon_view_p->module_name){
	module_name=icon_view_p->module_name;
    }
    command_line = g_strconcat(program, " ", argument," ",module_name,NULL);
    g_free(argument);
    TRACE("command=%s",command_line);
    g_spawn_command_line_async (command_line, &error);

    if (error){
	g_warning(error->message);
	xffm_confirm(&(icon_view_p->widgets),error->message,NULL,NULL);
	g_error_free(error);
    }
    g_free(command_line);
}


static
void
private_mount   (icon_view_t *icon_view_p, int mounted){
    record_entry_t *en=NULL;
    gchar *mount_point;

    if (icon_view_p->selected_p && icon_view_p->selected_p->en) {
	en=icon_view_p->selected_p->en;
    }
    TRACE("<<<<<<<<<<< on mount %d (0x%x)",mounted,(unsigned)icon_view_p);
    if(!en || !en->path) {
	g_warning("no entry to mount");
	return;
    }
    if (mounted) SET_MOUNTED(en->type); else UNSET_MOUNTED(en->type);
    mount_point = (gchar *) FSTAB_fstab_mount(en,&(icon_view_p->widgets));
    if (mount_point && !mounted) {
	icon_view_t *icon_view_target;
	en=stat_entry(mount_point,0);
	icon_view_target=create_iconview(en);	    
	icon_view_target->preferences = icon_view_p->preferences;
	icon_view_target->sortcolumn = icon_view_p->sortcolumn;
	icon_view_target->module_name=NULL;
 	if (reload_iconview(icon_view_target, en, TRUE)){ 
	    if (en && en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)) gui_save_to_go_history(en->path);
	}
	cursor_reset(icon_view_target->widgets.window);
    } 	
		
    
    TRACE("<<<<<<<<<<< on mount done");
}


static
void
gridview_mount   (GtkMenuItem     *menuitem, gpointer         user_data){
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    private_mount(icon_view_p, FALSE);
}
static
void
gridview_unmount   (GtkMenuItem     *menuitem, gpointer         user_data){
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    private_mount(icon_view_p, TRUE);
}



/*   pasteboard callbacks   */

static void private_paste(widgets_t *widgets_p, icon_view_t *icon_view_p, gboolean symlink)
{
    gboolean cut;
    GList *list=NULL;
    record_entry_t *t_en = NULL;
    int i;

    if(!xffm_details->pastepath) return;
    if ((t_en=icon_view_p->en)==NULL) return;
    
    TRACE("TRACE:pastepath=%s\n",xffm_details->pastepath);
    
    if ((i=gui_pasteboard_list(&list))==0) return;
    if (i==1) cut=TRUE; else cut=FALSE;
    i=gui_pasteboard_transfer(widgets_p, t_en,list, icon_view_p,  cut,  symlink);
     
    list = uri_free_list(list);
		
    if (i) {
	record_entry_t *new_en=copy_entry(icon_view_p->en);
        if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));
	reload_iconview(icon_view_p,new_en,FALSE);
	if(cut) XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);
    }
    return;
}


static 
void update_pasteboard_icons(icon_view_t *icon_view_p){
    int i;
    for (i=0; i<icon_view_p->max_elements; i++){
        population_t *population_p=icon_view_p->population_pp[i];
        if (population_p && population_p->en && IS_CUT(population_p->en->type) )
        {
	    gridview_set_icon(icon_view_p, (icon_view_p->population_pp[i])->en);
	}
    }
}

static 
void copy_cut_callback(gboolean cut, gpointer user_data){
    GList *tmp;
    GList *list=NULL;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    for (tmp=icon_view_p->selection_list;tmp;tmp=tmp->next){
        list=g_list_append(list,tmp->data);
    }
    if (!list) return;
    gui_pasteboard_copy_cut(widgets_p,cut,&list);
    update_pasteboard_icons(icon_view_p);
    if (cut) for(tmp = list; tmp; tmp = tmp->next){
        record_entry_t *en=(record_entry_t *)tmp->data;
        gridview_set_icon(icon_view_p, en);
    }
    g_list_free(list);
}

static
void gridview_cut_activate(GtkMenuItem * menuitem, gpointer data)
{
    copy_cut_callback(TRUE, data);
    return;
}



static
void gridview_copy_activate(GtkMenuItem * menuitem, gpointer data)
{
    copy_cut_callback(FALSE, data);
    return;
}

static
void paste_callback(gboolean symlink, gpointer user_data){
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (!icon_view_p->en) return;
    xffm_details->pastepath = icon_view_p->en->path;
    private_paste(widgets_p, icon_view_p, symlink);
}

static
void gridview_paste_activate(GtkMenuItem * menuitem, gpointer data)
{
    paste_callback(FALSE, data);
    return;
}

static
void gridview_pastelink_activate(GtkMenuItem * menuitem, gpointer data)
{
    paste_callback(TRUE, data);
    return;
}



static
void gridview_refresh_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    gridview_refresh(&(icon_view_p->widgets));
    return;
}


