
static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/x-moz-url", 0, TARGET_MOZ_URL},
    {"text/plain", 0, TARGET_PLAIN},
    {"UTF8_STRING", 0, TARGET_UTF8},
    {"STRING", 0, TARGET_STRING}
};

static GtkTreeRowReference *target_ref = NULL;
static int scrolltimer=0;
static scrolltree_t scrolltree_v;
static gint title_offset=0;
#define SCROLL_OFFSET (title_offset)
static gint scrolltree(gpointer data){
     GdkRectangle visible;
     if (!GTK_IS_TREE_VIEW (scrolltree_v.treeview)) return TRUE;
     
     gtk_tree_view_get_visible_rect(scrolltree_v.treeview,&visible); 
            /*printf("CELL: y=(%d,%d), visible=(%d,%d)\n",
			    scrolltree_v.scrolly - scrolltree_v.scrollheight,
			    scrolltree_v.scrolly + scrolltree_v.scrollheight,
			    visible.y,visible.y+visible.height);*/
     if (scrolltree_v.scrolly - scrolltree_v.scrollheight <= visible.y+SCROLL_OFFSET){   
            /*printf("scroll UP \n");*/
	    gtk_tree_view_scroll_to_point (scrolltree_v.treeview,0,scrolltree_v.scrolly - scrolltree_v.scrollheight-SCROLL_OFFSET);
	    if (scrolltree_v.scrolly >= scrolltree_v.scrollheight) 
		    scrolltree_v.scrolly -= scrolltree_v.scrollheight;
     }
     if (scrolltree_v.scrolly + scrolltree_v.scrollheight >= visible.y+visible.height){ 
	    int y=  visible.y;
	    /*printf("scroll DOWN \n");*/
	    /*gtk_tree_view_scroll_to_point (scrolltree_v.treeview,0,scrolltree_v.scrolly + scrolltree_v.scrollheight);*/
	    gtk_tree_view_scroll_to_point (scrolltree_v.treeview,0,visible.y+scrolltree_v.scrollheight);
            gtk_tree_view_get_visible_rect(scrolltree_v.treeview,&visible); 
	    if (y != visible.y){
		    scrolltree_v.scrolly = visible.y + visible.height - scrolltree_v.scrollheight;
	    }
     }
     return TRUE;
}


static
void   treeview_on_drag_begin (GtkWidget *widget,GdkDragContext *drag_context,gpointer user_data){
    	dragging = TRUE;
	/*printf("TRACE: 	on_drag_begin\n");*/
	if (xffm_details->selection_list && g_list_length(xffm_details->selection_list) > 1){
	    gtk_drag_set_icon_stock (drag_context,"gtk-dnd-multiple",-10,-10);
	} else if (xffm_details->selection_list && g_list_length(xffm_details->selection_list) == 1){
	    GdkPixbuf *pixbuf;
	    selection_list_t *sl=(selection_list_t *)xffm_details->selection_list->data;
	    pixbuf=resolve_icon_size(&(xffm_details->arbol->widgets),sl->en,BIG);
	    if (pixbuf) {
	      gtk_drag_set_icon_pixbuf (drag_context,pixbuf,-10,-10);
	      g_object_unref(G_OBJECT(pixbuf));
	    }
	} else {
	    gtk_drag_set_icon_stock (drag_context,"gtk-dnd",-10,-10);
	}


	/* this works better with plain motion-event */
	/*reselect_dnd_list((GtkTreeView *)widget);   */
}

static gboolean valid_drop_site(GtkTreeView * treeview, gint x, gint y, record_entry_t ** en, GtkTreeRowReference ** reference)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    GtkTreePath *treepath=NULL;


    if (gtk_tree_view_get_headers_visible(treeview)){
	/* FIXME:    offset to title button assumed at fontheight+8 but should be
	 *           widget vertical ascent, queried from the gtkcontainer child 
	 *           (how do you do that?)
	 *
	 *           use gtk_tree_view_widget_to_tree_coords () ?
	 *           no good.
	 *           */
  	PangoRectangle logical_rect;
  	PangoLayout *layout = gtk_widget_create_pango_layout((GtkWidget *)treeview,"W");
  	pango_layout_get_pixel_extents(layout, NULL, &logical_rect);
  	title_offset= PANGO_ASCENT(logical_rect) + PANGO_DESCENT(logical_rect);
  	g_object_unref(layout);
	title_offset +=8;
    }
    else title_offset=0;
    

    if(!gtk_tree_view_get_path_at_pos(treeview, x, (xffm_details->preferences & SHOW_TITLES) ? y - title_offset : y, &treepath, NULL, NULL, NULL))
    {
      nodrop:
	    
	gtk_tree_view_set_drag_dest_row (treeview,NULL,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);

	if (treepath) gtk_tree_path_free(treepath);
	return FALSE;
    }

    /* scroll? */
    {
     GdkRectangle rect;
     gtk_tree_view_widget_to_tree_coords (treeview,x,y,&(scrolltree_v.scrollheight),&(scrolltree_v.scrolly));
     scrolltree_v.treeview=treeview;
     gtk_tree_view_get_cell_area  (treeview, treepath, NULL,&rect);
     scrolltree_v.scrollheight=rect.height;
    }
 
    
    if(*reference)
	gtk_tree_row_reference_free(*reference);
    *reference = gtk_tree_row_reference_new(treemodel, treepath);
    gtk_tree_model_get_iter(treemodel, &iter, treepath);

    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, en, -1);

    if(!en) goto nodrop;
    
    if ((*en)->path && g_file_test((*en)->path,G_FILE_TEST_IS_DIR)) goto drop_ok;
    if ((*en)->module){
	if (function_natural("plugins",(*en)->module,*en,"valid_drop_site"))
	    goto drop_ok;
	else goto nodrop;
    }

    /*if(IS_BOOKMARK_TYPE((*en)->type) && IS_ROOT_TYPE((*en)->type))
	    goto drop_ok;*/	
    
   /* if(IS_DIR((*en)->type)||
       IS_NETDIR((*en)->subtype) ||
       IS_XF_NETSHARE((*en)->subtype)
      ) goto drop_ok;
    
    if(IS_TRASH_TYPE((*en)->type)
      )	goto nodrop;
   
     
    if(IS_FIND_TYPE((*en)->type) &&
       (IS_ROOT_TYPE((*en)->type)||IS_XF_FND((*en)->type))
      )  goto nodrop;*/
	
    /* check for parent status */	
    {
	GtkTreeIter parent;
	if(!gtk_tree_model_iter_parent(treemodel, &parent, &iter))
	    goto nodrop;
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, en, -1);
	if(!(*en)) goto nodrop;
	if(!IS_DIR((*en)->type) && 
	   !IS_NETDIR((*en)->subtype) &&
	   !IS_XF_NETSHARE((*en)->subtype)
	  ) goto nodrop;
    }

drop_ok:
    gtk_tree_view_set_drag_dest_row (treeview,treepath,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);

    if (treepath) gtk_tree_path_free(treepath);   
    return TRUE;
}

static
void treeview_on_drag_data (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, gpointer userdata)
{
    GtkTreeView *treeview = (GtkTreeView *) widget;
    GtkTreeIter iter;
    GtkTreePath *treepath;
    GtkTreeModel *treemodel = NULL;
    record_entry_t *en=NULL;
    gboolean will_expand=FALSE;
    gboolean result=FALSE;
    if (!treeview) {
nodrag:
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    treemodel = gtk_tree_view_get_model(treeview);
    if(treeview && !set_load_wait()) goto nodrag;
    if(!valid_drop_site(treeview, x, y, &en, &target_ref) || !en) goto nodrag;
    if(!gtk_tree_row_reference_valid(target_ref))  goto nodrag;
    
    treepath=gtk_tree_row_reference_get_path(target_ref);
    gtk_tree_model_get_iter (treemodel,&iter,treepath);
    gtk_tree_path_free(treepath);
    if (IS_EXPANDED(en->type)) will_expand=TRUE;
    
    cursor_wait(xffm_details->arbol->widgets.window);
    result=gui_drag_data (&(xffm_details->arbol->widgets), en, context, x, y, data, info, time);
    if (result)
    {
		int i;
		GtkTreeSelection *selection;
		GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
		for (i=0; i<TREECOUNT; i++) {
		    selection = gtk_tree_view_get_selection(xffm_details->arbol->treestuff[i].treeview);
		    gtk_tree_selection_unselect_all (selection);
		}
		selection = gtk_tree_view_get_selection(treeview);
		if (gtk_tree_model_iter_has_child(treemodel,&iter)){
		    gtk_tree_selection_select_iter  (selection,&iter);
		} else {
		    GtkTreeIter parent;
		    if (gtk_tree_model_iter_parent(treemodel,&parent,&iter)){
			gtk_tree_selection_select_iter  (selection,&parent);
		    }
		}	    
    } 
    unset_load_wait();
    
    if(result) {
	if (will_expand && (IS_NETDIR(en->subtype) || 
			IS_XF_NETSHARE(en->subtype)||  
			IS_NETFILE(en->subtype)) )
	{
	    GtkTreePath *treepath=gtk_tree_row_reference_get_path(target_ref);
	   gtk_tree_view_expand_row(treeview, treepath, FALSE);  
	   gtk_tree_path_free(treepath);
	}
	if (en->module) {
	    treeview_refresh(&(xffm_details->arbol->widgets));
	}
	else {
	    if (xffm_details->arbol->widgets.window) local_monitor(TRUE);
	} 
    } else {
	print_status(&(xffm_details->arbol->widgets),"xffm/warning",_("Nothing moved"),NULL);
    }
    cursor_reset(xffm_details->arbol->widgets.window);
    return;
}

static
void treeview_on_drag_data_get (GtkWidget * widget, GdkDragContext * context, GtkSelectionData * selection_data, guint info, guint time, gpointer data)
{
    GList *tmp,*drag_entry_list=NULL;
    for (tmp = xffm_details->selection_list; tmp; tmp = tmp->next) {
        selection_list_t *sl;
        sl = (selection_list_t *) tmp->data;
        if (!gtk_tree_row_reference_valid(sl->reference)) return;
	if (sl && sl->en && sl->en->path)
	    drag_entry_list=g_list_append(drag_entry_list,sl->en);
  
    }
    gui_drag_data_get (&(xffm_details->arbol->widgets),drag_entry_list, context, selection_data, info, time);
    g_list_free(drag_entry_list);
}

static
gboolean treeview_on_drag_motion (GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) widget;
    record_entry_t *en;
    GdkDragAction action;

    /*printf("TRACE:  on_drag_motion \n"); */



    /* Insert code to get our default action here. */
    if (getenv("XFFM_DRAG_DOES_COPY") && strlen(getenv("XFFM_DRAG_DOES_COPY")))
	action = GDK_ACTION_COPY;
    else
	action = GDK_ACTION_MOVE;


    if (treeview && !scrolltimer){ 
		scrolltimer = g_timeout_add_full(0, 150, (GtkFunction) scrolltree, (gpointer) treeview, NULL);
		/*printf("TRACE: scrolltimer=%d\n",scrolltimer);*/
    }

    if(treeview && (!valid_drop_site(treeview, x, y, &en, &target_ref) || !en))
    {				/*change icon */
	gdk_drag_status(dc, 0, t);
    }
    else if(dc->actions == GDK_ACTION_MOVE)
	gdk_drag_status(dc, GDK_ACTION_MOVE, t);
    else if(dc->actions == GDK_ACTION_COPY)
	gdk_drag_status(dc, GDK_ACTION_COPY, t);
    else if(dc->actions == GDK_ACTION_LINK)
	gdk_drag_status(dc, GDK_ACTION_LINK, t);
    else if(dc->actions & action)
	gdk_drag_status(dc, action, t);
    else
	gdk_drag_status(dc, 0, t);
    /*fprintf(stderr,"dbg: drag motion done...\n"); */



    return (TRUE);
}


static
void treeview_on_drag_end (GtkWidget * widget, GdkDragContext * context, gpointer data)
{
    gui_drag_end (widget, context, data);
    if (!set_load_wait())
    {
        TRACE("TRACE: cannot set xffm_details->arbol->loading! (on_drag_end())\n");
        return;
    }
    unset_load_wait();
    TRACE("TRACE drag end done\n");
    return;
}


static
void  treeview_on_drag_leave (GtkWidget *widget, GdkDragContext *drag_context, guint time, gpointer user_data){
	TRACE("on_drag_leave*************\n");
   
   if (scrolltimer)g_source_remove(scrolltimer);
   scrolltimer=0;
}


static
void treeview_drag_source_set (GtkTreeView * treeview)
{
    TRACE("TRACE treeview_drag_source_set\n");
	gtk_drag_source_set((GtkWidget *) treeview, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
}




/*********************************************************/

#if 0

static gboolean drop_cancelled = FALSE;

static void update_multistatus_line(record_entry_t *en){
    if (!xffm_details->arbol->widgets.window) return;
    TRACE("update_multistatus_line: selections=%d",g_list_length(xffm_details->selection_list));
    if (xffm_details->selection_list && g_list_length(xffm_details->selection_list) >= 1){
	if (g_list_length(xffm_details->selection_list) == 1 && en) treeview_update_status_line(en);
	else {
	    gchar *g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"%d item selected","%d items selected",g_list_length(xffm_details->selection_list)),g_list_length(xffm_details->selection_list));
    TRACE("update_multistatus_line:%s",g);
	    if (g_list_length(xffm_details->selection_list) == 1) print_status(&(xffm_details->arbol->widgets),"xffm/info",g,NULL);
	    else print_status(&(xffm_details->arbol->widgets),"xffm/warning",g,NULL);
	    g_free(g);
	}
    } else if (en) treeview_update_status_line(en);
}

static
void treeview_single_get_dnd_selection (GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data){
    record_entry_t *en;
    if (!xffm_details->arbol->widgets.window) return;

    treeview_get_dnd_selection (treemodel, path, iter,  data);
    /*if ((xffm_details->preferences & ENABLE_GTK_CLICK)) */
    {
	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
	update_multistatus_line(en);
    }
}

static
gboolean is_in_dnd_selection (GtkTreePath * path){
	GList *tmp;
	if (!path) return TRUE;
	for (tmp=xffm_details->selection_list;tmp;tmp=tmp->next){
		selection_list_t *sl=tmp->data;
           	GtkTreePath *treepath = gtk_tree_row_reference_get_path(sl->reference);
		if (!treepath) continue;
		if(gtk_tree_path_compare (path,treepath)==0){
	           gtk_tree_path_free(treepath);
		   return TRUE;
		}
	        gtk_tree_path_free(treepath);
	}
	return FALSE;
}

static
void cancel_drop (gboolean state)
{
    drop_cancelled = state;
}

static
void treeview_reselect_dnd_list (GtkTreeView *treeview){
    GList *tmp;
    GtkTreeSelection *selection;
    if (!xffm_details->arbol->widgets.window) return;
    selection = gtk_tree_view_get_selection(treeview);
    for (tmp=xffm_details->selection_list;tmp;tmp=tmp->next){
	selection_list_t *sl=tmp->data;
        if(sl && gtk_tree_row_reference_valid(sl->reference)){
           GtkTreePath *treepath = gtk_tree_row_reference_get_path(sl->reference);
	   /*printf("TRACE: reselecting %s\n",sl->en->path);*/
	   gtk_tree_selection_select_path (selection,treepath);
	   gtk_tree_path_free(treepath);
	}
    }
    /* for status line to be updated before release */
    if (!(xffm_details->preferences & ENABLE_GTK_CLICK)){
       /* this is always true here...*/
	if (xffm_details->selection_list && g_list_length(xffm_details->selection_list))
    	    update_multistatus_line(NULL);
    } 
}

static
void treeview_clear_path_from_selection_list (GtkTreeView *treeview,GtkTreePath *treepath)
{
    GtkTreePath *path;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GList *tmp = xffm_details->selection_list;
    if (!treepath || ! treeview) return;
    gtk_tree_selection_unselect_path (selection,treepath);
    for (tmp=xffm_details->selection_list;tmp;tmp=tmp->next)
    {
	selection_list_t *sl;
	sl = (selection_list_t *) tmp->data;
	path=gtk_tree_row_reference_get_path(sl->reference);
	if (!path || gtk_tree_path_compare(path,treepath)==0){
	    xffm_details->selection_list = g_list_remove(xffm_details->selection_list,sl);
	    g_free(sl);
	    if (path) gtk_tree_path_free(path);
	    return;
	}
        gtk_tree_path_free(path);
    }
    return;
}

static
void treeview_drag_source_unset (GtkTreeView * treeview)
{
    TRACE("TRACE drag_source_unset\n");
   gtk_drag_source_unset((GtkWidget *) treeview);
}


#endif
