/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"
#include "treeview.h"
#include "actions_lib.h"


G_MODULE_EXPORT
gboolean go_up_ok (GtkTreeView * treeview)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    record_entry_t *en;
    GtkTreeIter iter;

    if(!gtk_tree_model_get_iter_first(treemodel, &iter))
    	    return FALSE;
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    if (!en|| !en->path) return FALSE;
    while(!IS_LOCAL_TYPE(en->type))
    {
	if(!gtk_tree_model_iter_next(treemodel, &iter))
    	    return FALSE;
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
        if (!en || !en->path) break;
    }

    if (!en || !en->path) return FALSE;
    if(strcmp(en->path, "/") != 0) return TRUE;
    return FALSE;
}

G_MODULE_EXPORT
void pushgo (treestuff_t *treestuff, const gchar *path)
{
    golist  *gogo;

    TRACE("TRACE:hey  pushgo %s\n",path);

    if (!path || !strlen(path)) return;
    
    if (treestuff->gogo){ 
	gogo = treestuff->gogo;
	if (gogo->path && strcmp(gogo->path,path)==0) return;
	gogo = gogo->next;
	while(gogo){
	    golist *lastgo = gogo;
	    gogo = gogo->next;
	    g_free(lastgo->path);
	    g_free(lastgo);
	}
    } else assert_not_reached(); /* malloc'd in treeview.c */
    gogo = (golist *) malloc(sizeof(golist));
    if(!gogo) assert_not_reached();
    if (treestuff->gogo) {
	treestuff->gogo->next = gogo;
	gogo->previous = treestuff->gogo;
    } else {
	gogo->previous = NULL;
    }
	
    treestuff->gogo = gogo;
    gogo->next = NULL;
    gogo->path = g_strdup(path);
    return;
}

/* only for treeview this... */
G_MODULE_EXPORT
int go_to (treestuff_t *treestuff, const gchar *path)
{
    record_entry_t *en, *new_en;
    GtkTreeIter iter;
    GtkTreePath *treepath;
    static gboolean redlight=FALSE;

    
	    
    if (!path) return FALSE;
    
    if(strncmp(path,"//",2)!=0 && access(path, X_OK)!=0)
    {				
	/*printf("TRACE(goto.c): no access (%s)\n",path);*/
	print_status(&(xffm_details->arbol->widgets),"xffm/error",strerror(errno),": ",path,NULL);
	return FALSE;
	/*assert_not_reached(); */
    }
    TRACE("TRACE: going to %s\n",path);
    if (redlight) return TRUE;
    if(!set_load_wait()){
	printf("TRACE(xffm): !set_load_wait\n");
	return FALSE;
    }
    redlight=TRUE;
    

	TRACE("TRACE: doing go_to to %s...\n",path);
    /* a network goto: */
    if (strncmp(path,"//",2)==0){ 
      gchar *fullpath=NULL;
      GtkTreeIter new_iter;
      /* format for mk_net_entry= smd://XXX@YYY: */
      get_module_root(treestuff->treeview, &iter, &en,"xffm_samba");
      if (!en->module) en->module="xffm_samba";
      /* flush treeview */
      gdk_flush();
      treepath = gtk_tree_model_get_path(treestuff->treemodel, &iter);
      if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))){ 
	if (strchr(getenv("SMB_USER"),'%'))
          fullpath=g_strconcat("smb://",getenv("SMB_USER"),"@",path+2,":",NULL);
	else
          fullpath=g_strconcat("smb://",getenv("SMB_USER"),"%%","@",path+2,":",NULL);
      }
      else
        fullpath=g_strconcat("smb://GUEST%%@",path+2,":",NULL);
      new_en=mk_net_entry(fullpath,en->type);
      SET_XF_NETWS(new_en->subtype);
      g_free(fullpath);
      fullpath=NULL;
      
      add_row(treestuff->treemodel, &iter, NULL,&new_iter, new_en, (char *)path+2);
      erase_dummy_row(treestuff->treemodel, &iter,NULL);
      /* FIXME: displayed icon is incorrect */
#if 0
      /* hack... (does not work)*/
      if (function_natural("plugins","xffm_smb_ws",en,"module_icon_id")) {
	 GdkPixbuf *Icon=icon_tell(&(xffm_details->arbol->widgets),
		 MEDIUM,function_natural("plugins","xffm_smb_ws",en,"module_icon_id"));
	if (Icon) {	
	    update_iconcolumn_for_row (treestuff->treemodel, &iter, Icon);
	}
      }
#endif

      insert_dummy_row(treestuff->treemodel, &new_iter,NULL,new_en,NULL,NULL);
      new_en->module="xffm_smb_ws";
      SET_LOADED(en->type);
    } 
    else 
	/* a local goto */
    {	   
      TRACE("TRACE: doing get_local_root\n");
      get_module_root(treestuff->treeview, &iter, &en, NULL);
      treepath = gtk_tree_model_get_path(treestuff->treemodel, &iter);

      if (strcmp(xffm_details->argv[0],"xffm")==0 || strcmp(xffm_details->argv[0],"xffm-treeview")==0){
	  /*printf("TRACE: path is:%s\n",path);*/
	    g_free(xffm_details->argv[1]);
	    xffm_details->argv[1] = g_strdup(path);
      }
	  
      new_en = (stat_entry((char *)path, en->type));
      TRACE("stating %s",path);

      prune_row(treestuff->treemodel, &iter,NULL,en);
      insert_dummy_row(treestuff->treemodel, &iter,NULL,en,NULL,NULL);

      SET_ROOT_TYPE(new_en->type);
      SET_LOCAL_TYPE(new_en->type);
      new_en->count = -1;
      update_text_cell_for_row(NAME_COLUMN,treestuff->treemodel, &iter,FILENAME(new_en));

	/*FIXME: should have function in basic_row:*/
      gtk_tree_store_set((GtkTreeStore *) treestuff->treemodel, &iter, 
		    ENTRY_COLUMN, new_en,
		    -1);
      update_row(treestuff->treemodel, &iter, NULL, new_en);
      /* collapse until the end so iter will not invalidate */
      gtk_tree_view_collapse_row(treestuff->treeview, treepath);
      destroy_entry(en);
      pushgo(treestuff, path);
    }
    unset_load_wait();
    TRACE("TRACE: doing gtk_tree_view_expand_row\n");
    gtk_tree_view_expand_row(treestuff->treeview, treepath, FALSE);  
    gdk_flush();
    treeview_clear_dnd_selection_list();
    gtk_tree_view_scroll_to_cell(treestuff->treeview, treepath, NULL, TRUE, 0.0, 0.0);
    gtk_tree_selection_select_path (treestuff->selection,treepath);
    gtk_tree_view_set_cursor (treestuff->treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    while (gtk_events_pending()) gtk_main_iteration();
    turn_on();
    /*unselect_double_treeview(treeview);*/
#if 0
    gui_save_to_go_history((char *)path);
    TRACE("TRACE: RECENT_add2history(%s)\n",(char *)path);
    if (path) RECENT_add2history(&(xffm_details->arbol->widgets),(char *)path);
#endif

    redlight=FALSE;
    
    TRACE("done goto.....");
    return TRUE;
}

G_MODULE_EXPORT
void go_home (GtkWidget * widget)
{
    GtkTreeIter iter;
    const gchar *home;
    record_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreePath *treepath;
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    treestuff_t *treestuff = (xffm_details->arbol->treestuff)+tree_id;
    
    /*home=get_xffm_home();*/
    home=g_get_home_dir();
    gtk_widget_grab_focus((GtkWidget *) treeview);
    get_module_root(treeview, &iter, &en, NULL);
    
    if(!go_to(treestuff, home)) return;
    
    pushgo(treestuff, home);
    treepath = gtk_tree_model_get_path(treemodel, &iter);
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    turn_on();
}

G_MODULE_EXPORT
void go_up (GtkWidget * widget)
{
    record_entry_t *en, *new_en;
    GtkTreeIter iter;
    GtkTreePath *treepath;
    char *t;
    static gboolean redlight=FALSE;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    treestuff_t *treestuff = (xffm_details->arbol->treestuff)+tree_id;

    if (!go_up_ok(treeview)) return;
    
    gtk_widget_grab_focus((GtkWidget *) treeview);

    if (redlight) return;
    if(!set_load_wait()) {
	printf("TRACE(xffm): !set_load_wait\n");
	return;
    }
    redlight=TRUE;
    
    get_module_root(treeview, &iter, &en, NULL);

    t = strrchr(en->path, '/');
    if (!t) return;
    *t = 0;
    if(strlen(en->path) == 0)
	strcpy(en->path, "/");
    new_en = stat_entry(en->path, en->type);
    SET_ROOT_TYPE(new_en->type);
    new_en->count = -1;


    treepath = gtk_tree_model_get_path(treemodel, &iter);
    prune_row(treemodel, &iter,NULL,en);
    insert_dummy_row(treemodel, &iter,NULL,en,NULL,NULL);
    gtk_tree_view_collapse_row(treeview, treepath);

    update_text_cell_for_row(NAME_COLUMN,treemodel, &iter,FILENAME(new_en));

    gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
		    ENTRY_COLUMN, new_en, 
		    -1);
    destroy_entry(en);
    update_row(treemodel, &iter, NULL, new_en);
    /* open root folder */
    TRACE("TRACE: pushing to go list->%s\n",new_en->path);
    pushgo(treestuff,(const gchar *) new_en->path);
    if (strcmp(xffm_details->argv[0],"xffm")==0 || strcmp(xffm_details->argv[0],"xffm-treeview")==0){
	g_free(xffm_details->argv[1]);
	xffm_details->argv[1] = g_strdup(new_en->path);
    }

    unset_load_wait();
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gdk_flush();
    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    turn_on();
    /*unselect_double_treeview(treeview);*/
    redlight=FALSE;
}

G_MODULE_EXPORT
void go_forward (GtkWidget * widget)
{
    record_entry_t *en;
    GtkTreeIter iter;
    GtkTreePath *treepath;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    treestuff_t *treestuff = (xffm_details->arbol->treestuff)+tree_id;

    if (!go_forward_ok(treestuff)) return;
	
    get_module_root(treeview, &iter, &en, NULL);
    treestuff->gogo = treestuff->gogo->next;
    if(!go_to(treestuff, treestuff->gogo->path)) return;
    treepath = gtk_tree_model_get_path(treemodel, &iter);
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    turn_on();
}

G_MODULE_EXPORT
void go_backward (GtkWidget * widget)
{
    record_entry_t *en;
    GtkTreeIter iter;
    GtkTreePath *treepath;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    treestuff_t *treestuff = (xffm_details->arbol->treestuff)+tree_id;

    if (!go_back_ok(treestuff)) {
	return;
    }

    get_module_root(treeview, &iter, &en, NULL);
    treestuff->gogo = treestuff->gogo->previous;
    if(!go_to(treestuff, treestuff->gogo->path)) return;
    treepath = gtk_tree_model_get_path(treemodel, &iter);
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    turn_on();
}


G_MODULE_EXPORT
void goto_jump (GtkWidget * widget)
{
    treeview_show_input(GOTO_INPUT);
}


/* callbacks */


G_MODULE_EXPORT
void tb_go_up (GtkButton * button, gpointer user_data)
{
    go_up((GtkWidget *) button);
}


G_MODULE_EXPORT
void tb_home (GtkButton * button, gpointer user_data)
{
    go_home((GtkWidget *) button);
}

G_MODULE_EXPORT
void tb_goto (GtkButton * button, gpointer user_data)
{
    goto_jump((GtkWidget *) button);
}

G_MODULE_EXPORT
void on_up2_activate (GtkMenuItem * menuitem, gpointer data)
{
    go_up((GtkWidget *) menuitem);
}

G_MODULE_EXPORT
void on_home3_activate (GtkMenuItem * menuitem, gpointer data)
{
    if (xffm_details->arbol->widgets.window) go_home((GtkWidget *) menuitem);
    else  {
	g_warning("!xffm_details->arbol->widgets.window");
    }
}

G_MODULE_EXPORT
void on_jump_to2_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    treeview_show_input(GOTO_INPUT);
}


G_MODULE_EXPORT
void on_back2_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    go_backward((GtkWidget *) menuitem);
}

G_MODULE_EXPORT
void on_forward2_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    go_forward((GtkWidget *) menuitem);
}

G_MODULE_EXPORT
void tb_go_back (GtkButton * button, gpointer user_data)
{
    go_backward((GtkWidget *) button);
}

G_MODULE_EXPORT
void tb_go_forward (GtkButton * button, gpointer user_data)
{
    go_forward((GtkWidget *) button);
}


