/*
 * Copyright (C) 2002-6 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <unistd.h>



#include <gtk/gtk.h>

#include "types.h"
#include "constants.h"

#include "primary.h"
#include "gui.h"
#include "treeview.h"

extern
xffm_details_t *xffm_details;

G_MODULE_EXPORT
gboolean enable_pane_resize=FALSE;


static
gboolean on_xffm_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    /* treeview only */
    gtk_widget_hide(xffm_details->arbol->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    gui_on_close_activate(NULL,NULL );
    return FALSE;
}

static
gboolean on_xffm_delete_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    /* treeview only */
    gtk_widget_hide(xffm_details->arbol->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    gui_on_close_activate(NULL,NULL );
    return FALSE;
}


G_MODULE_EXPORT
int t_refresh_parent(widgets_t *widgets_p){
    GtkTreeIter iter, parent;
    record_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    en = treeview_get_selected_entry(&iter);
    if (!en) return 0;
    
    if (gtk_tree_model_iter_parent(treemodel,&parent,&iter)) {
	gtk_tree_selection_unselect_all (selection);
	gtk_tree_selection_select_iter  (selection,&parent);
    }
    
    return xffm_refresh(widgets_p);
}

G_MODULE_EXPORT
record_entry_t *t_get_selected_entry(widgets_t *widgets_p){
    GtkTreeIter iter;
    return (treeview_get_selected_entry(&iter));
}


G_MODULE_EXPORT
record_entry_t *t_get_selected_parent_entry(widgets_t *widgets_p){
    GtkTreeIter iter, parent;
    record_entry_t *en, *p_en;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    en = treeview_get_selected_entry(&iter);

    gtk_tree_model_iter_parent(treemodel,&parent,&iter);
    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
    return p_en;
}

static void init_xffm_window(void){
    xffm_details->arbol->widgets.window = create_xffm();
    if (xffm_details->arbol->widgets.window == NULL)
       	g_error("unable to create window");
    xffm_details->arbol->widgets.type = TREEVIEW_TYPE;
    xffm_details->arbol->widgets.stop=FALSE;
    xffm_details->arbol->widgets.tubo_object = NULL;
    xffm_details->arbol->widgets.parent = xffm_details->arbol;
    xffm_details->arbol->widgets.refresh= treeview_refresh;
    xffm_details->arbol->widgets.refresh_parent= t_refresh_parent;
    xffm_details->arbol->widgets.open_with= treeview_open_with;
    xffm_details->arbol->widgets.get_selected_entry= t_get_selected_entry;
    xffm_details->arbol->widgets.get_selected_parent_entry= t_get_selected_parent_entry;

    if(xffm_details->argv[2]) {
	if (!function_void("plugins",xffm_details->argv[2],"is_root_module")) {
	    g_warning("%s is not root module",xffm_details->argv[2]);
	    exit (0);
    }}
 
    xffm_details->arbol->widgets.vpane = lookup_widget(xffm_details->arbol->widgets.window,"vpaned1");
    xffm_details->arbol->widgets.diagnostics = lookup_widget(xffm_details->arbol->widgets.window,"diagnostics");
    xffm_details->arbol->widgets.status = lookup_widget(xffm_details->arbol->widgets.window,"status");
    xffm_details->arbol->widgets.progress = lookup_widget(xffm_details->arbol->widgets.window,"progressbar1");
    parse_colours();
    g_signal_connect(G_OBJECT(xffm_details->arbol->widgets.window), 
		    "destroy_event", G_CALLBACK(on_xffm_destroy_event), (gpointer) xffm_details);
    g_signal_connect(G_OBJECT(xffm_details->arbol->widgets.window), 
		    "delete_event", G_CALLBACK(on_xffm_delete_event), (gpointer) xffm_details);
    hideit(xffm_details->arbol->widgets.window, "item22");
    hide_stop(&(xffm_details->arbol->widgets));
    hide_text(xffm_details->arbol->widgets.diagnostics);
    hideit(xffm_details->arbol->widgets.window, "input_box");
    /* XXX does this "activates-default" do anything??? */
    g_object_set(G_OBJECT (lookup_widget(xffm_details->arbol->widgets.window,"filter_entry")), "activates-default", TRUE, NULL);
    g_object_set(G_OBJECT (lookup_widget(xffm_details->arbol->widgets.window,"input_entry")), "activates-default", TRUE, NULL);
 
    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"show_hidden_menuitem")), "activate", 
			    GTK_SIGNAL_FUNC(toggle_preference),
			    (gpointer) ((long)(SHOW_DOT|INDIVIDUAL_TOGGLE)));
    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"preview_images_menuitem")), "activate", 
			    GTK_SIGNAL_FUNC(toggle_preference),
			    (gpointer) ((long)(IMAGE_PREVIEW|INDIVIDUAL_TOGGLE)));
     /* main window configuration: */
    if (xffm_details->preferences & SHOW_TB1) toolbar_buttons();

    smart_menus();
  

}


G_MODULE_EXPORT
void fireup_treeview(void)
{
    GtkTreeView *treeview;
    int i;
    gchar *exec=g_path_get_basename(xffm_details->argv[0]);
    
    if (strcmp(exec,"xffm") && strcmp(exec,"xffm-treeview") && strcmp(exec,"xffm-find") ){
	GSList *plugin_list = find_root_plugins();
	for(; plugin_list; plugin_list=plugin_list->next)
	{
	    const gchar *exec_name=(const gchar *)function_void("plugins",plugin_list->data,"exec_name");
	    if (exec_name && strcmp(exec_name,exec)==0) {
		if (!xffm_details->argv[1]) xffm_details->argv[1]="/";
		xffm_details->argv[2]=function_void("plugins",plugin_list->data,"module_name");
		TRACE("%s is in module %s",exec_name,(xffm_details->argv[2]?xffm_details->argv[2]:"null"));
		goto load;
	    }
	}
	g_warning("There is no plugin with exec_name = %s",exec);
	exit(0);
    }
load:
    g_free(exec);
    TRACE("arguments= %s %s %s",
	    xffm_details->argv[0],
	    (xffm_details->argv[1]?xffm_details->argv[1]:"null"),
	    (xffm_details->argv[2]?xffm_details->argv[2]:"null"));
  
   init_xffm_window(); /* tree window...*/


    
    init_xffm_treeviews(); /* initialize treeviews */


    if (xffm_details->argv[2]) {
	/* should be a module here... */
	xffm_details->preferences=(SHOW_TITLES | IMAGE_PREVIEW |  TEXT_HEADERS);
	if (function_void("plugins",xffm_details->argv[2],"allow_filter")){
	    TRACE("filter is enabled");
	    xffm_details->preferences |= SHOW_F;
	}	    
	hideit(xffm_details->arbol->widgets.window,"eventbox_sidebar");
    } else {
	xffm_details->preferences=DEFAULT_PREFERENCES;
	
    }
    
    treeview = get_bigger_treeview();
    if (!strstr(xffm_details->argv[0],"xffm-find")) 
        gtk_widget_show((GtkWidget *)(xffm_details->arbol->widgets.window));
    else 
        gtk_widget_realize((GtkWidget *)(xffm_details->arbol->widgets.window));
   
    hide_text(xffm_details->arbol->widgets.diagnostics);

    /* final column settings until here to get around a gtk bug (2.2.4)
     * with the autosize column not rendering... 
     *
     * but by now i'm giving up on the autosize mode since it is 
     * buggy, and moving to grow only (user resize==true) to allow the user
     * to correct the display problem caused by the gtk-native bug
     * 
     * (now will make fixed length for xffm-find and align to right to
     * put full paths in)
     * 
     * */
    for (i=0;i<TREECOUNT;i++){
      treestuff_t *treestuff = (xffm_details->arbol->treestuff)+i;	
      treestuff->ascending = 0;
      treestuff->sort_column = GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
       
      gtk_tree_view_column_set_sizing(treestuff->column[NAME_COLUMN], GTK_TREE_VIEW_COLUMN_FIXED);
      gtk_tree_view_column_set_resizable(treestuff->column[NAME_COLUMN], TRUE);
      TRACE("TRACE:setting width to %d\n",treestuff->name_size);
      gtk_tree_view_column_set_fixed_width(treestuff->column[NAME_COLUMN],treestuff->name_size);

      gtk_tree_view_column_set_sizing(treestuff->column[PIXBUF_COLUMN], GTK_TREE_VIEW_COLUMN_AUTOSIZE);
      gtk_tree_view_column_set_resizable(treestuff->column[PIXBUF_COLUMN], TRUE);
      /*gtk_tree_view_column_set_sizing(treestuff->column[PIXBUF_COLUMN], GTK_TREE_VIEW_COLUMN_AUTOSIZE);
      gtk_tree_view_column_set_resizable(treestuff->column[PIXBUF_COLUMN], FALSE);*/
    }

    hide_bars();
    enable_pane_resize=TRUE;
    
    set_widget_initial_state();
    turn_on_pasteboard();
    
    
  
    {
	GtkWidget *hpaned=lookup_widget(xffm_details->arbol->widgets.window,"hpaned1");
	if (xffm_details->argv[1]) {
	    xffm_details->arbol->hpane=0;
	} 
	else xffm_details->arbol->hpane=1000;
	
	
	TRACE("pane size to %d\n",xffm_details->arbol->hpane);
	gtk_paned_set_position(GTK_PANED(hpaned), xffm_details->arbol->hpane);
	xffm_details->arbol->hpane_ratio = (double)xffm_details->arbol->hpane / (double)hpaned->allocation.width;
    } 

    
    treeview_clear_dnd_selection_list();
    /* program name other than xffm-find will trigger an expand */
    if (!strstr(xffm_details->argv[0],"xffm-find")) {
      GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
      /*GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);*/
      GtkTreePath *treepath=gtk_tree_path_new_first();
      if (treepath) {
	gtk_tree_selection_select_path (selection,treepath);
	/*get_dnd_selection(treemodel, treepath, &iter, (gpointer) treeview);*/
	gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
	if (xffm_details->argv[1]) {	
	    gtk_tree_view_expand_row(treeview, treepath, FALSE);  
	    gdk_flush();
	    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
	}
	
	set_path_reference(treeview,treepath);
	gtk_tree_path_free(treepath); 
      }
      else TRACE("Cannot find root element for %s", xffm_details->argv[0]); 
    }
    


   for (i=0;i<TREECOUNT;i++){
     GtkTreeSortable *sortable=GTK_TREE_SORTABLE(xffm_details->arbol->treestuff[i].treemodel);
     xffm_details->arbol->treestuff[i].sort_column =GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
     gtk_tree_sortable_set_sort_column_id (sortable,xffm_details->arbol->treestuff[i].sort_column,GTK_SORT_ASCENDING);
   }

   turn_on();
   enable_write_config();
    
   write_xffm_config();

   gtk_widget_grab_focus((GtkWidget *) treeview);
      
   xffm_details->comm=0;

    if (strstr(xffm_details->argv[0],"xffm"))
	gtk_window_set_title (GTK_WINDOW (xffm_details->arbol->widgets.window), 		g_strdup(OUR_HOST_NAME(&(xffm_details->arbol->widgets))));
	
    if (strstr(xffm_details->argv[0],"xffm-find")) {
	if (xffm_details->argv[1]) FIND_do_find_path(&(xffm_details->arbol->widgets),xffm_details->argv[1]);
	else FIND_do_find(&(xffm_details->arbol->widgets));

	hideit(xffm_details->arbol->widgets.window,"hbox27");
	hideit(xffm_details->arbol->widgets.window,"box_tb1");
	hideit(xffm_details->arbol->widgets.window,"eventbox_sidebar");
	gtk_tree_view_set_headers_visible(treeview,TRUE);
	showit(xffm_details->arbol->widgets.window,"show_titles");

    }

    return ;
}


