/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/

/* basic callback functions used to set up the iconview 
 *
 * */


static GdkDragAction drag_action=GDK_ACTION_MOVE;
static GtkTargetList* target_list=NULL;
static gboolean skip_second_release = FALSE;



static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/x-moz-url", 0, TARGET_MOZ_URL},
    {"text/plain", 0, TARGET_PLAIN},
    {"UTF8_STRING", 0, TARGET_UTF8},
    {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))


/* mouse callbacks *******************************************************/


static 
gboolean  
on_button_press (	GtkWidget *widget, 
			GdkEventButton *event, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    population_t *population_p;
    int double_click=0;
    int single_click_button;
    int double_click_button;
    gboolean reverse_control;
   
    /* cancel any pending tip :*/
    icon_view_p->tip_timer=0;
    if (icon_view_p->redlight) return TRUE;
    icon_view_p->mouseX=event->x;
    icon_view_p->mouseY=event->y;
    TRACE("on_button_press");
    /* ignore size events until button released... */
    icon_view_p->redlight2=TRUE;
    xffm_details->eventtime = event->time;
    if (icon_view_p->rename) {
	done_with_rename((gpointer)icon_view_p);
	print_status(&(icon_view_p->widgets),NULL,_("Omitting"),NULL);
    }
   
    population_p=find_in_population(icon_view_p,event->x,event->y);
    skip_second_release = FALSE;
    
    icon_view_p->dragstate=FALSE;

    /* update status line */
    if (population_p && population_p->en) {
 	   if (icon_view_p->module_name) {
	     if (population_p->en->path){
		gchar *g=g_path_get_basename(population_p->en->path);
		print_status_pixbuf(&(icon_view_p->widgets),resolve_icon_small(&(icon_view_p->widgets),population_p->en),g,NULL);
		g_free(g);
	     }
	   } else { 
	     if (population_p->en->path){
		gchar *g=g_path_get_basename(population_p->en->path);
		print_status_pixbuf(&(icon_view_p->widgets),resolve_icon_small(&(icon_view_p->widgets),population_p->en),g,NULL);
		g_free(g);
	     }
	     else if (population_p->en->tag){  
	       print_status(&(icon_view_p->widgets),NULL,population_p->en->tag,NULL);
	     }
	   }
	   if (diagnostics_is_visible(icon_view_p->widgets.diagnostics)) print_path_info(&(icon_view_p->widgets),population_p->en);	   
    }
   
    if (event->button == 3){
	TRACE("uh-huh. a popup now.");
	if (population_p){
	    if (!population_p->selected) {
	      if (!(event->state&GDK_CONTROL_MASK)){
		unselect_all_pixbuf(icon_view_p);	
		unsaturate_pixbuf(icon_view_p);
	      } 
	    }
	    saturate_pixbuf(icon_view_p,population_p);
	    select_pixbuf(icon_view_p,population_p);
	}
	do_iconview_popup(icon_view_p, population_p, event);
	return TRUE;
    } 
   
    if (getenv("XFFM_SINGLE_CLICK_NAVIGATION") && strlen(getenv("XFFM_SINGLE_CLICK_NAVIGATION"))) {
	TRACE("XFFM_SINGLE_CLICK_NAVIGATION");
	single_click_button=1;
	double_click_button=2;
	reverse_control=TRUE;
    } else {
	single_click_button=2;
	double_click_button=1;
	reverse_control=FALSE;
    }
    
    if((event->type == GDK_2BUTTON_PRESS)|| (event->button == single_click_button)){ 
	/*gdouble h=(event->x - icon_view_p->mouseX)*(event->x - icon_view_p->mouseX)+(event->y - icon_view_p->mouseY)*(event->y - icon_view_p->mouseY);
	TRACE("h=%f",h);*/
	if(event->button == single_click_button){
		if (reverse_control)
		    double_click=((event->state&GDK_CONTROL_MASK)?2:1);
		else 
		    double_click=((event->state&GDK_CONTROL_MASK)?1:2);
	}
	if (event->button == double_click_button) {
		if (reverse_control)
		    double_click=((event->state&GDK_CONTROL_MASK)?1:2);
		else 
		    double_click=((event->state&GDK_CONTROL_MASK)?2:1);
	}
    }
    TRACE("population=0x%x, double_click=%d",
	    (unsigned)population_p,double_click);	
    
    if (!population_p)icon_view_p->selected_p=NULL;
    
    if (population_p && double_click) {
	icon_view_p->doing_drag_p=NULL;
	icon_view_p->dragstate=FALSE;	
	icon_view_p->old_X=icon_view_p->old_Y=
	icon_view_p->down_X=icon_view_p->down_Y=-1;
        process_double_click(icon_view_p,population_p,(double_click==1));
	return TRUE;
    }
    else if (population_p) {
	int hotX,hotY;
	if (!population_p->en) {
	   TRACE("found with null entry");
	} else {
	   TRACE("found population 0x%xs",(unsigned)population_p);
	   TRACE("found population->en 0x%xs",(unsigned)population_p->en);
	   TRACE("found population->en->path %s",population_p->en->path);
	   TRACE("found %s, type=0x%x",
		population_p->en->path,population_p->en->type);

	    /*if (!IS_ROOT_TYPE(population_p->en->type) && !IS_DUMMY_TYPE(population_p->en->type) && population_p->en->path) icon_view_p->selected_p=population_p;*/
	    if (!IS_DUMMY_TYPE(population_p->en->type) ) 
	    {
		if (!IS_ROOT_TYPE(population_p->en->type) && population_p->en->path )
		{
		    icon_view_p->selected_p=population_p;
		} 
		else if (population_p->en->module && function_natural("plugins",population_p->en->module,population_p->en,"get_dnd_path"))
		{
		    icon_view_p->selected_p=population_p;		    
		}
	    }

	   
	}
	icon_view_p->doing_drag_p=population_p;
	/* this is more natural: and congruent with popup above */
	TRACE("--found population 0x%xs",(unsigned)population_p);
	if (!population_p->selected) {
	    if (!(event->state&GDK_CONTROL_MASK)){
		unselect_all_pixbuf(icon_view_p);	
		unsaturate_pixbuf(icon_view_p);
	      } 
	}
	if (population_p->en){
	    if (!g_list_find(icon_view_p->selection_list,population_p->en)) {
		saturate_pixbuf(icon_view_p,population_p);
		select_pixbuf(icon_view_p,population_p);
	    } else if (event->state&GDK_CONTROL_MASK) {
		unselect_pixbuf(icon_view_p,population_p);
	    }
	}
#if 0
	/* this is more conventional, but less natural */
	if (population_p->selected && event->state&GDK_CONTROL_MASK){
	    unselect_pixbuf(icon_view_p,population_p);
	    saturate_pixbuf(icon_view_p,population_p);
	    graphics_expose_all(icon_view_p);
	} else {
	    unsaturate_pixbuf(icon_view_p);
	    select_pixbuf(icon_view_p,population_p);
	}
	if (!(event->state&GDK_CONTROL_MASK)){
	    unselect_all_pixbuf(icon_view_p);
	    graphics_expose_all(icon_view_p);
	}
	    
#endif	    
	hotX = (int)event->x % CELLSIZE - CELLSPACING;
	hotY = (int)event->y % CELLSIZE;	
	TRACE("doing_drag_p=0x%x",(unsigned)icon_view_p->doing_drag_p);
	setup_drag_state(icon_view_p,event,hotX,hotY,event->button);
	icon_view_p->old_X=icon_view_p->old_Y=icon_view_p->down_X=icon_view_p->down_Y=-1;
    }
    else
    {
	if (double_click) {
	    int caso=0;
	    if (event->state&GDK_CONTROL_MASK) caso=1;
	    if (event->state&GDK_SHIFT_MASK && event->state&GDK_CONTROL_MASK) caso=2;
	    icon_view_p->doing_drag_p=NULL;
	    draw_window(icon_view_p,event->x,event->y,FALSE);
	    icon_view_p->old_X=icon_view_p->old_Y=
	       icon_view_p->down_X=icon_view_p->down_Y=-1;
	    population_p=find_in_labels(icon_view_p,event->x,event->y);
	    if (population_p && population_p->en && !IS_ROOT_TYPE(population_p->en->type) && !IS_DUMMY_TYPE(population_p->en->type) && population_p->en->path){
		icon_view_p->selected_p=population_p;
		if (g_file_test(population_p->en->path,G_FILE_TEST_EXISTS)){
		    mk_text_entry(icon_view_p, population_p, caso);
		}
		else if (icon_view_p->module_name) {
		    TRACE("FIXME: ask module");
		}
	    }
	    return TRUE;
	} else {
    
	    TRACE("nothing found at %f %f",event->x,event->y);
	    gridview_cancel_input(NULL,icon_view_p);
	    if (!(event->state&GDK_CONTROL_MASK)){
		unselect_all_pixbuf(icon_view_p);
		unsaturate_pixbuf(icon_view_p);
	    }
	    icon_view_p->down_X=event->x;
	    icon_view_p->down_Y=event->y;
	}
    }
    return TRUE;
}

static 
gboolean  
on_button_release (	GtkWidget *widget, 
			GdkEventButton *event, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data; 
    population_t *population_p;
    /*icon_view_p->mouseX=event->x;
    icon_view_p->mouseY=event->y;*/
    if (icon_view_p->redlight) return TRUE;
    TRACE("button release...");
    /* reenable size event callback */
    icon_view_p->redlight2=FALSE;

    population_p=find_in_population(icon_view_p,(gdouble)event->x, (gdouble)event->x);   
    icon_view_p->doing_drag_p=NULL;
    draw_window(icon_view_p,event->x,event->y,FALSE);
    /* known issue: 
     * this pixel is left behind upon erasing the
     * selection box... icon_view_p->down_X,icon_view_p->down_Y*/
    select_population_area(icon_view_p);

    icon_view_p->old_X=icon_view_p->old_Y=icon_view_p->down_X=icon_view_p->down_Y=-1;
    if (icon_view_p->selection_count > 1) {
	gchar *g=g_strdup_printf(_("%d item(s) selected"),icon_view_p->selection_count);
	print_status(&(icon_view_p->widgets),"xfce/warning",g,NULL);
	g_free(g);
    }

    return TRUE;
}

static 
gboolean 
on_motion (		GtkWidget *widget, 
			GdkEventMotion *event, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data; 
    population_t *population_p=find_in_population(icon_view_p,event->x,event->y);
    
    if (icon_view_p->redlight) return TRUE;
    TRACE("on motion");
    /* if we are window selecting, don't do individual saturation*/
    if (icon_view_p->down_X != -1 && icon_view_p->down_Y != -1){
	draw_window(icon_view_p,event->x, event->y,TRUE);
	/* reselect */
	/* here you could select_population_area() on the fly.
	 * the only difficulty is unselecting on the fly
	 * as the user changes her mind */	
	/*select_population_area(icon_view_p);*/
    }
    else {
	/*TRACE("x=%f,y=%f (%f,%f)",
		event->x,event->y,icon_view_p->mouseX,icon_view_p->mouseY);*/
	graphics_saturation_event(icon_view_p,population_p,event->x, event->y);
	population_p=find_in_labels(icon_view_p,event->x,event->y);
	graphics_label_event(icon_view_p,population_p);
    }
 
    return TRUE;
}

static 
gboolean 
on_enter (		GtkWidget *widget, 
			GdkEventCrossing *event, 
			gpointer data)
{
   //icon_view_t *icon_view_p = (icon_view_t *)data;   
  TRACE("on enter");
    return TRUE;
}
static 
gboolean 
on_leave (		GtkWidget *widget, 
			GdkEventCrossing *event, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    TRACE("on leave");
    if (icon_view_p->redlight) return TRUE;
    if (icon_view_p->saturated_p) unsaturate_pixbuf(icon_view_p);
    graphics_set_default_tooltip(icon_view_p,NULL);
    return TRUE;
}

/**  drag events **********************************************/

static
void
enter_drag_state(icon_view_t *icon_view_p)
{
	    GdkPixmap *pixmap;
            GdkBitmap *mask;
		TRACE("enter dragstate ");

	    if (icon_view_p->dragstate) {
		TRACE("dragstate true");
		return;
	    }
		TRACE("now entering dragstate ");

		
	    icon_view_p->drag_event.context = gtk_drag_begin   (icon_view_p->paper,   
			   target_list,
			   GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK, 
			    icon_view_p->drag_button,
			    (GdkEvent *)(&(icon_view_p->drag_event)));

	    if (!icon_view_p->drag_event.context) return;
	    gdk_drag_status(icon_view_p->drag_event.context, drag_action, icon_view_p->drag_event.time);

	    TRACE("selection count=%d",icon_view_p->selection_count);

	    {
		gchar *g=g_strdup_printf(_("%d item(s) selected"),icon_view_p->selection_count);
		print_status(&(icon_view_p->widgets),"xfce/warning",g,NULL);
		g_free(g);
	    }
	    if (icon_view_p->selection_count > 1){
		/*g_warning("fixme: I need a better multiple selection drag icon...");
		 *  probably by construction a icon with the first two icons
		 *  in the selection list...*/
		gtk_drag_set_icon_stock (icon_view_p->drag_event.context,
			GTK_STOCK_DND_MULTIPLE,
			icon_view_p->hot_x,icon_view_p->hot_y);
	    }
	    else 
	    {
	      gdk_pixbuf_render_pixmap_and_mask(icon_view_p->doing_drag_p->pixbuf,&pixmap,&mask,1);
	      gtk_drag_set_icon_pixmap (icon_view_p->drag_event.context,
		    icon_view_p->cmap, 
		    pixmap, mask,
		    icon_view_p->hot_x,icon_view_p->hot_y);
	    }
	    icon_view_p->dragstate=TRUE;
	    
}
static
void
setup_drag_state(icon_view_t *icon_view_p,GdkEventButton *event,int x,int y,int button)
{
	    icon_view_p->drag_button=button;
	    icon_view_p->hot_x=x;
	    icon_view_p->hot_y=y;
	    icon_view_p->drag_event.type=GDK_DRAG_ENTER;
	    icon_view_p->drag_event.x_root=event->x;
	    icon_view_p->drag_event.y_root=event->y;
	    icon_view_p->drag_event.time=event->time+2;
	    icon_view_p->drag_event.window=event->window;
	    icon_view_p->drag_event.send_event=event->send_event;
	    TRACE("event time=0x%x",event->time);
}



static 
void 
gridview_drag_data (		GtkWidget * widget, 
			GdkDragContext * context, 
			gint x, gint y, 
			GtkSelectionData * selection_data, 
			guint info, 
			guint time, 
			gpointer data)
{
    population_t *population_p;
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    record_entry_t *target_en;
    TRACE("gridview_drag_data: drag_data...");
    /*icon_view_p = (icon_view_t *)g_object_get_data(G_OBJECT(widget),"icon_view_p");*/
    if (!icon_view_p) {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    if (icon_view_p->redlight) {
	TRACE("gridview_drag_data: icon_view_p->redlight");
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    cursor_wait(icon_view_p->widgets.window);
    target_en=icon_view_p->en;
    
    population_p=find_in_population(icon_view_p,x,y);
    if (population_p && population_p->en && population_p->en->path){
	if (g_file_test(population_p->en->path, G_FILE_TEST_IS_DIR))
	    target_en=population_p->en;
	else if (IS_NETDIR(population_p->en->subtype) || 
		 IS_XF_NETSHARE(population_p->en->subtype)) {
	    target_en=population_p->en;
	} 
    }

    TRACE("drag_data...core_drag_data");
    if (core_drag_data (&(icon_view_p->widgets),target_en, context, x, y, selection_data, info, time))
    TRACE("drag_data...reload 0x%x->0x%x",(unsigned)icon_view_p, (unsigned)icon_view_p->en);
    {
	record_entry_t *en=copy_entry(icon_view_p->en);
	if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));
	reload_iconview(icon_view_p,en,FALSE);
    }
    TRACE("drag_data...all done");
    cursor_reset(icon_view_p->widgets.window);
}
static 
void  
gridview_drag_leave (		GtkWidget *widget, 
			GdkDragContext *drag_context, 
			guint time, 
			gpointer data)
{
    TRACE("drag_leave...");
}
static 
void 
gridview_drag_delete (		GtkWidget * widget, 
			GdkDragContext * context, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data;
    record_entry_t *en=copy_entry(icon_view_p->en);
    reload_iconview(icon_view_p,en,FALSE);
}

static 
void 
gridview_drag_end (		GtkWidget * widget, 
			GdkDragContext * context, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data;
    TRACE("drag_end...core_drag_end");
    core_drag_end(widget,context,data);
    cursor_wait(icon_view_p->widgets.window);
    /*TRACE("drag_end... reload 0x%x->0x%x",(unsigned)icon_view_p, (unsigned)icon_view_p->en);*/
    cursor_reset(icon_view_p->widgets.window);
    TRACE("drag_end... alldone");
}
static 
gboolean 
gridview_drag_motion (		GtkWidget * widget, 
			GdkDragContext * dc, 
			gint x, 
			gint y, 
			guint t, 
			gpointer data)
{
    gboolean target_ok=FALSE;
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    if (icon_view_p->redlight) return TRUE;
    population_t *population_p=find_in_population(icon_view_p,x,y);

    if (getenv("XFFM_DRAG_DOES_COPY") && strlen(getenv("XFFM_DRAG_DOES_COPY")))
	drag_action = GDK_ACTION_COPY;
    else
	drag_action = GDK_ACTION_MOVE;
    
    if (dc->actions == GDK_ACTION_MOVE) 
	gdk_drag_status(dc, GDK_ACTION_MOVE, t);
    else if(dc->actions == GDK_ACTION_COPY) 
	gdk_drag_status(dc, GDK_ACTION_COPY, t);
    else if(dc->actions == GDK_ACTION_LINK) 
	gdk_drag_status(dc, GDK_ACTION_LINK, t);
    else if(dc->actions &  drag_action) 
	gdk_drag_status(dc,  drag_action, t);
    else gdk_drag_status(dc, 0, t);
    TRACE("on_drag_motion...x=%d, y= %d, population_p=0x%x",
	    x,y,(unsigned)population_p);

    if (population_p) {
	/* if not valid drop target, return */
	if (icon_view_p->module_name){
	    if (function_natural("plugins",icon_view_p->module_name,population_p->en,"valid_drop_site")) target_ok=TRUE;
	} else { /* local */
	    if (population_p->en && IS_DIR(population_p->en->type)) target_ok=TRUE;
	}
    }

    if (target_ok || !population_p) 
	graphics_saturation_event(icon_view_p,population_p, -1, -1);
    
     if (icon_view_p->doing_drag_p){
	TRACE("widget ok");
	//icon_view_p->restore_pixbuf=FALSE;
    }
   // gtk_widget_queue_draw (icon_view_p->paper);
    /*gtk_widget_queue_draw_area (icon_view_p->paper, 
		x,y,
		CELLSIZE,CELLSIZE);*/	 
   
    return (TRUE);
}
static 
void 
gridview_drag_data_get (		GtkWidget * widget, 
			GdkDragContext * context, 
			GtkSelectionData * selection_data, 
			guint info, 
			guint time, 
			gpointer data)
{
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    TRACE("drag_data_get: jumping to on_drag_data_get");
    core_drag_data_get(&(icon_view_p->widgets),icon_view_p->selection_list,context,selection_data,info,time);
    TRACE("drag_data_get: all done");
}
static 
void   
gridview_drag_begin (		GtkWidget *widget,
			GdkDragContext *drag_context,
			gpointer data)
{
    //icon_view_t *icon_view_p = (icon_view_t *)data;   
    TRACE("on_drag_begin...");
}

/* Widget callbacks *****************************************************/
static
gboolean 
destroy_event	(	GtkWidget *widget,
			GdkEvent *event,
			gpointer data){
    if (!data) return TRUE;
    graphics_destroy_event((icon_view_t *)data);
    return TRUE;
}


static
gboolean    on_configure_paper (GtkWidget *widget, GdkEventConfigure *event, gpointer data){
    /*icon_view_t *icon_view_p = (icon_view_t *)data;   */
    TRACE("configure event paper");
    return TRUE;
}
static
gboolean    on_configure_window (GtkWidget *widget, GdkEventConfigure *event, gpointer data){
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    TRACE("configure event window, redlight_size_envent=%d",icon_view_p->redlight);
     TRACE("********  w: %d, H:%d",
		  icon_view_p->widgets.window->allocation.width,
		  icon_view_p->widgets.window->allocation.height);
    if (icon_view_p->rename) {
	done_with_rename((gpointer)icon_view_p);
	print_status(&(icon_view_p->widgets),NULL,_("Omitting"),NULL);
    }
    gtk_paned_set_position(GTK_PANED(icon_view_p->widgets.vpane), 10000);
    return FALSE;
}

static
gboolean    on_size_paper (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    icon_view_t *icon_view_p = (icon_view_t *)user_data;   
    TRACE("size allocation event for paper...\n");
    if (icon_view_p->redlight) return TRUE;
    graphics_on_size(icon_view_p,widget->allocation.width,widget->allocation.height);
     return TRUE;
}
static
gboolean    on_size_window (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    icon_view_t *icon_view_p = (icon_view_t *)user_data;   
    TRACE("size allocation event for window... redlight_size_event=%d\n",icon_view_p->redlight2);
    if (icon_view_p->redlight) return TRUE;
    if (!icon_view_p->redlight2 && !icon_view_p->en) 
    {
	iconview_geometry_t *iconview_geometry_p=get_iconview_geometry_p(icon_view_p);
	if (!iconview_geometry_p ||
	    (icon_view_p->widgets.window->allocation.width != iconview_geometry_p->w ||
	    icon_view_p->widgets.window->allocation.height != iconview_geometry_p->h))
	{
	  /*graphics_on_size(icon_view_p,widget->allocation.width,widget->allocation.height);*/
	  TRACE("now saving geometry...w: %d, H:%d",
		  icon_view_p->widgets.window->allocation.width,
		  icon_view_p->widgets.window->allocation.height);
#ifdef THIS_IS_DISABLED_BECAUSE_ITS_BUGGY
	  gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	  gchar *f=g_build_filename(xdg_dir,GRIDVIEW_GEOMETRY_DBH_FILE,NULL);
	  g_free(xdg_dir);
	  if (!icon_view_p->en && g_file_test(f,G_FILE_TEST_EXISTS)) {
	    static GtkWidget *dialog=NULL;
	    if (!dialog) {
		GList *tmp;
		gchar *m=g_strdup_printf(_("Reset all windows to this size?"));
		int response = GTK_RESPONSE_NONE;
		dialog = xffm_confirm_dialog (&(icon_view_p->widgets),
				     (const gchar *)m,
				     _("No"),
				     _("Yes"));
		response = gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_hide (dialog);
		gtk_widget_destroy (dialog);
		dialog=NULL;
		if (response == GTK_RESPONSE_YES){
		    unlink(f);
		    icon_view_p->redlight2=TRUE;
		    for (tmp=iconview_list; tmp; tmp=tmp->next){
			icon_view_t *icon_view_pp=(icon_view_t *)tmp->data;
			gtk_window_resize (
			    (GtkWindow *)icon_view_pp->widgets.window, 	
			    icon_view_p->widgets.window->allocation.width, 
			    icon_view_p->widgets.window->allocation.height);
		    }
		    TRACE("all views reset to default (geometry only)");
		    while (gtk_events_pending()) gtk_main_iteration();
		    gdk_flush();
		    icon_view_p->redlight2=FALSE;
		}	
		g_free(m);
	    } else {
		place_dialog(icon_view_p->widgets.window,dialog);
		g_free(f);
		return TRUE;
	    }
	  }
	  g_free(f);
#endif
	  TRACE("1-redlight_size_event=%d, now saving...",icon_view_p->redlight2);	
	  save_iconview_geometry_p(icon_view_p);
	}
    }
    else if (!icon_view_p->redlight2 && icon_view_p->en->path && get_iconview_geometry_p(icon_view_p)) 
    {
	  /*graphics_on_size(icon_view_p,widget->allocation.width,widget->allocation.height);*/
	  TRACE("2-redlight_size_event=%d, now saving...",icon_view_p->redlight2);	
	  save_iconview_geometry_p(icon_view_p);
    }
  
    return TRUE;
}


static 
void 
on_expose (		GtkWidget * widget, 
			GdkEventExpose *event,
			gpointer data)
{
    int bottom_row,bottom_column,top_row,top_column;
    icon_view_t *icon_view_p = (icon_view_t *)data;   
    /*if (icon_view_p->redlight) return;*/
    
    TRACE("on_expose for %d,%d,%d,%d",
	    event->area.x, event->area.y,event->area.width, event->area.height);
    bottom_row=event->area.y/CELLSIZE;
    bottom_column=event->area.x/CELLSIZE;
    top_row=(event->area.y+event->area.height)/CELLSIZE;
    if ((event->area.y+event->area.height)%CELLSIZE) top_row++;
    top_column=(event->area.x+event->area.width)/CELLSIZE;
    if ((event->area.x+event->area.width)%CELLSIZE) top_column++;
    
    graphics_expose(icon_view_p,bottom_row,bottom_column,top_row,top_column);
}


static
void 
adjustment_changed(GtkAdjustment *adjustment, gpointer data){
    icon_view_t *icon_view_p = (icon_view_t *)data; 
    TRACE("adjustment_changed, redlight_size_event=%d", icon_view_p->redlight2);
    if (!icon_view_p->redlight2) save_iconview_geometry_p(icon_view_p);
    unsaturate_pixbuf(icon_view_p);
    graphics_label_event(icon_view_p,NULL);

    /* gtk bug to work around: with big drawing areas, the 
     * expose event generated by the drawing area widget is
     * incorrect (due to smooth scrolling using a short int somewhere). 
     * Since we're trapping
     * adjustment changes anyway, let's do the arithmetic ourselves.
     * This workaround may no longer be necessary in future gtk
     * versions. */
    {
#define BUG_NUMBER ((0x01 << 14) - 256)
      int scroll_pos= gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window)); 
      if (scroll_pos > BUG_NUMBER) {
	GList *children=gtk_container_get_children ((GtkContainer *)icon_view_p->scrolled_window);
	int height=((GtkWidget *)(children->data))->allocation.height;
	int extra=((scroll_pos%CELLSIZE)?1:0);
	int visible_rows=height/CELLSIZE+1+extra;
	int bottom_row=scroll_pos/CELLSIZE;
	int top_row=scroll_pos/CELLSIZE + visible_rows-1;
	g_list_free(children);
	TRACE("bug number= %d, window height=%d, cellsize=%d, visible rows=%d",
		BUG_NUMBER,height,CELLSIZE, visible_rows);
	TRACE("adjustment value: %d, rows=%d, cols=%d, ^row=%d _row=%d\n",
	    scroll_pos,icon_view_p->grid_rows,icon_view_p->grid_columns,
	    bottom_row,top_row);
	graphics_expose(icon_view_p, bottom_row, 0,top_row,icon_view_p->grid_columns);
      }
    }
    
}

static gboolean invisible_bottom(icon_view_t *icon_view_p){
	int totally_invisible_items;
	int partially_invisible_items;
	int invisible_items;	
	gdouble sp=gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));

	totally_invisible_items = ((int)(sp)/CELLSIZE) * icon_view_p->grid_columns;
	partially_invisible_items = (((int)(sp)%CELLSIZE)/ICON_SIZE) * icon_view_p->grid_columns;

	TRACE("partially=%d, totally=%d, invisible=%d",
		partially_invisible_items,totally_invisible_items,invisible_items);
	
	invisible_items=totally_invisible_items+partially_invisible_items;
	return invisible_items;
}

static gboolean invisible_top(icon_view_t *icon_view_p){
	int invisible_items;	
	gdouble sp=gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));

	invisible_items = ((int)(sp+icon_view_p->widgets.window->allocation.height)/CELLSIZE) * icon_view_p->grid_columns;
	
	return invisible_items;
}

    
static
gboolean keyboard_event(GtkWidget *widget,GdkEventKey *event, gpointer data){
    icon_view_t *icon_view_p = (icon_view_t *)data; 
    int selected_row;
    int selected_column;
    int selection_id;
    int last_id;
    int scroll_pos=-1;
    widgets_t *widgets_p=&(icon_view_p->widgets);
    gboolean initial=FALSE;
    TRACE("keyboard_event");

    /* keybindings are generated with the popup menu: */
    if (!icon_view_p->popup){
	icon_view_p->popup = gridview_mk_popup_menu(NULL,NULL,icon_view_p);
    }

   /* asian input methods */
    if (event->keyval == GDK_space &&(event->state&(GDK_MOD1_MASK|GDK_SHIFT_MASK))){
	return FALSE;
    }
    if (widgets_p->input != OTHER_INPUT) return FALSE;
    if (event->state&(GDK_SHIFT_MASK | GDK_CONTROL_MASK | GDK_MOD1_MASK)) {
	if (gui_common_mask_key(event,icon_view_p)) return TRUE;
    }
    if (icon_view_p->selection_list && g_list_length(icon_view_p->selection_list)) {
      if (event->keyval == GDK_Delete) {
	gridview_remove_activate((GtkMenuItem *)icon_view_p->widgets.window, icon_view_p);
	return TRUE;
      }
      if (event->keyval == GDK_Print) {
        gridview_print_activate(NULL,icon_view_p);
	return TRUE;
      }
      if (event->keyval == GDK_Execute) {
	gridview_run_activate((GtkMenuItem *)icon_view_p->widgets.window, icon_view_p);
	return TRUE;
      }
   
      /* return */
      if(event->keyval == GDK_Return){
	if (!icon_view_p->selected_p) {
	    TRACE("!icon_view_p->selected_p");
	    return TRUE;
	}
	process_double_click(icon_view_p,icon_view_p->selected_p, !(event->state&GDK_CONTROL_MASK));
	return TRUE;	
      }
    }
    if (event->keyval == GDK_Control_L || event->keyval == GDK_Control_R) {
	return TRUE;
    }
    if (!icon_view_p->population_pp || !icon_view_p->population_pp[0]) return FALSE; 
    unselect_all_pixbuf(icon_view_p);	
    unsaturate_pixbuf(icon_view_p);
    
    switch (event->keyval) {
	case GDK_Page_Up:
	case GDK_Page_Down:
	    {
		int factor=3*CELLSIZE;
		if (event->keyval == GDK_Page_Up) factor *= -1;
		scroll_pos = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window)) +factor;     
		if (scroll_pos < 0)  scroll_pos=0;
		if (scroll_pos > icon_view_p->grid_rows*CELLSIZE) scroll_pos = icon_view_p->grid_rows*CELLSIZE;
		gtk_adjustment_set_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window),scroll_pos);
		gtk_adjustment_changed (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
		return TRUE;
	    }
    }

    for (selection_id=0; icon_view_p->population_pp[selection_id] && icon_view_p->population_pp[selection_id] != icon_view_p->selected_p; selection_id++);
    
    if (!icon_view_p->population_pp[selection_id]){
	if (event->keyval != GDK_End) selection_id=0;
	else selection_id=g_list_length(icon_view_p->population_list)-1;
	initial=TRUE;
    } 

    /* is selection id visible? */
    {
	int invisible_items=invisible_bottom(icon_view_p);
	
	if (selection_id < invisible_items) {
	    selection_id = invisible_items;
	    initial=TRUE;
	}
	TRACE("selection_id=%d, invisibleitems=%d, listlength=%d",
		selection_id,invisible_items,
		g_list_length(icon_view_p->population_list));
	
	if (selection_id >= g_list_length(icon_view_p->population_list)){
	    selection_id = g_list_length(icon_view_p->population_list)-1;
	    initial=TRUE;
	    scroll_pos=(selection_id/icon_view_p->grid_columns)*CELLSIZE;
	    TRACE("scrollback, scrollpos at %d",scroll_pos);
	}
	TRACE("at %s",icon_view_p->population_pp[selection_id]->en->path);
    }
    
    last_id=selection_id;
    
    if (!initial) switch (event->keyval) {
	case GDK_Home:
	    selection_id=0;
	    scroll_pos=0;
	    break;
	case GDK_Left:
	    if (selection_id-1 >= 0) {
		selection_id--;
		if (selection_id/icon_view_p->grid_columns 
			!= last_id/icon_view_p->grid_columns &&
			selection_id < invisible_bottom(icon_view_p))
		{
		    scroll_pos = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window))-CELLSIZE;   
		    if (scroll_pos < 0) scroll_pos =0;
		}
	    }
	    break;
	case GDK_Right:
	    if (icon_view_p->population_pp[selection_id+1]) {
		selection_id++;
		if (selection_id/icon_view_p->grid_columns 
			!= last_id/icon_view_p->grid_columns &&
			selection_id >= invisible_top(icon_view_p))
		{
		    scroll_pos = CELLSIZE + gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));   
		}
	    }
	    break;
	    
	case GDK_End:
	    selection_id=g_list_length(icon_view_p->population_list)-1;
	    scroll_pos=(selection_id/icon_view_p->grid_columns)*CELLSIZE;
	    break;
	case GDK_Down:
	    if (selection_id+icon_view_p->grid_columns < g_list_length(icon_view_p->population_list)){
		selection_id+=icon_view_p->grid_columns;
		    TRACE("invisible top=%d selection_id=%d",invisible_top(icon_view_p),selection_id);
		if (selection_id >= invisible_top(icon_view_p)){
		    scroll_pos = CELLSIZE + gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
		}
	    }
	    break;
	case GDK_Up:
	    if (selection_id-icon_view_p->grid_columns >= 0)
		selection_id-=icon_view_p->grid_columns;
		    TRACE("invisible bottom=%d selection_id=%d",invisible_bottom(icon_view_p),selection_id);
		if (selection_id < invisible_bottom(icon_view_p)){
		    scroll_pos = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window)) - CELLSIZE;
		    if (scroll_pos < 0) scroll_pos =0;
		}
	    break;

	    break;
	default:
	    return FALSE;
    }
    selected_column=selection_id%icon_view_p->grid_columns;
    selected_row=selection_id/icon_view_p->grid_columns;
    saturate_pixbuf(icon_view_p,icon_view_p->population_pp[selection_id]);
    select_pixbuf(icon_view_p,icon_view_p->population_pp[selection_id]);
    if (scroll_pos >=0) {
	gtk_adjustment_set_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window),scroll_pos);
	gtk_adjustment_changed (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
    }
    TRACE("item %d selected row and column=%d,%d (%d,%d)",selection_id,
	    selected_row,selected_column,icon_view_p->grid_rows,icon_view_p->grid_columns);
    /* this expose is necessary because the gtk expose event is returning
     * weird expose areas, probably because the paper has been resized... */
    graphics_expose_item(icon_view_p,selected_row,selected_column);
    graphics_expose_item(icon_view_p,last_id/icon_view_p->grid_columns,last_id%icon_view_p->grid_columns);
    icon_view_p->selected_p=icon_view_p->population_pp[selection_id];
    
    
    /* cursor arrows */
    /* quick scrolling */
    /* control keys */
    return TRUE;
}


