static 
void
mount_item(		icon_view_t *icon_view_p, 
			population_t *population_p){
    if (g_list_length(icon_view_p->selection_list)!=1) return;
    if (IS_XF_NETSHARE(population_p->en->subtype)){
	showit(icon_view_p->widgets.window, "mountP");
	return;
    }
    if (function_void("plugins","xffm_fstab","is_root_module")) {
	 int mounted=GPOINTER_TO_INT(FSTAB_is_mounted(population_p->en->path));
	 TRACE("%s is mounted=%d",population_p->en->path,mounted);
	 if (IS_DIR(population_p->en->type) && FSTAB_is_in_fstab(population_p->en->path))
	 {
	  if (mounted>=0){
	      if (mounted) showit(icon_view_p->widgets.window, "unmountP");
	      else showit(icon_view_p->widgets.window, "mountP");
	  } else {
	      if (IS_MOUNTED(population_p->en->type)) showit(icon_view_p->widgets.window, "unmountP");
	      else showit(icon_view_p->widgets.window, "mountP");
	  }
	 }
	 else if (mounted){
	    showit(icon_view_p->widgets.window, "unmountP");
	 }
    }
}

static 
void
remove_item(		icon_view_t *icon_view_p, 
			population_t *population_p)
{
    if (!icon_view_p || !population_p || !population_p->en || !population_p->en->path) return;
    /* for local remove: */
    if (g_file_test(population_p->en->path,G_FILE_TEST_EXISTS) ||
        IS_NETFILE(population_p->en->subtype) ||
        IS_NETDIR(population_p->en->subtype))	
    {
	showit(icon_view_p->widgets.window, "remove_menuitem");
    }
}

static 
void
properties_item(		icon_view_t *icon_view_p, 
			population_t *population_p)
{
    if (!icon_view_p || !population_p || !population_p->en || !population_p->en->path) return;
    /* for local remove: */
    if (g_file_test(population_p->en->path,G_FILE_TEST_EXISTS) )	
    {
	showit(icon_view_p->widgets.window, "properties2");
    }
}

static 
void
print_item(		icon_view_t *icon_view_p, 
			population_t *population_p)
{
    if (!icon_view_p || !population_p || !population_p->en || !population_p->en->path) return;
    /* for local remove: */
    if (g_file_test(population_p->en->path,G_FILE_TEST_EXISTS)&&
        !g_file_test(population_p->en->path,G_FILE_TEST_IS_DIR)&&
	g_list_length(icon_view_p->selection_list)==1)	
    {
	showit(icon_view_p->widgets.window, "print_menuitem");
    }
}


static 
void
refresh_item(		icon_view_t *icon_view_p, 
			population_t *population_p)
{
    gchar **w,*widget_name[]={"show_hidden_menuitem","preview_images_menuitem","newfile_menuitem","newdirectory_menuitem",NULL};
    showit(icon_view_p->widgets.window, "refresh3");
    for (w=widget_name;*w;w++){
     if (icon_view_p->en && icon_view_p->en->path){
	if (g_file_test(icon_view_p->en->path,G_FILE_TEST_IS_DIR)) {
	    showit(icon_view_p->widgets.window, *w);
	} 
	if (icon_view_p->module_name){
	    if (function_void("plugins",icon_view_p->module_name,*w)) showit(icon_view_p->widgets.window, *w);
	}
      }
    }
    if (icon_view_p->go_list) showit(icon_view_p->widgets.window, "go_back_menuitem");
    showit(icon_view_p->widgets.window, "goto2");
    showit(icon_view_p->widgets.window, "sort1");
    if (icon_view_p->preferences & SORT_ASCENDING) hideit(icon_view_p->widgets.window,"ascending1");
    else hideit(icon_view_p->widgets.window,"descending1");

    showit(icon_view_p->widgets.window, "run2");
    if (valid_pasteboard() && icon_view_p->en && icon_view_p->en->path) {
	showit(icon_view_p->widgets.window, "paste_menuitem");	
	showit(icon_view_p->widgets.window, "pastelink_menuitem");	
    }
    showit(icon_view_p->widgets.window, "host2");
    showit(icon_view_p->widgets.window, "home2");
    showit(icon_view_p->widgets.window, "opentreeview");
    showit(icon_view_p->widgets.window, "openiconview");
    showit(icon_view_p->widgets.window, "iv_separator00");
    
    showit(icon_view_p->widgets.window, "iv_separator0");
    showit(icon_view_p->widgets.window, "terminal2");
    showit(icon_view_p->widgets.window, "find2");
    showit(icon_view_p->widgets.window, "differences2");
    showit(icon_view_p->widgets.window, "iv_separator1");
    if (icon_view_p->en) {
	showit(icon_view_p->widgets.window, "select_all_menuitem");
	showit(icon_view_p->widgets.window, "select_byfilter_menuitem");
	showit(icon_view_p->widgets.window, "unselect_all_menuitem");
	showit(icon_view_p->widgets.window, "iv_separator2");
    }
#ifdef HAVE_LIBXFCE4MCS_CLIENT
    showit(icon_view_p->widgets.window, "settings2");
#endif
    showit(icon_view_p->widgets.window, "about2");
    showit(icon_view_p->widgets.window, "exit2");
    
}

#define MENU_IN_MODULE(x) (icon_view_p->module_name && function_void("plugins",icon_view_p->module_name,(x)))

static 
void
open_item(		icon_view_t *icon_view_p, 
			population_t *population_p)
{
    gchar *symbols[]={"open_with_menuitem","copy_menuitem","cut_menuitem",
	"rename_menuitem","duplicate_menuitem","touch_menuitem",
	"symlink_menuitem",
	NULL};
    gboolean multiple_select[]={FALSE,TRUE,TRUE,FALSE,FALSE,FALSE,FALSE,0};
    int i;
    
    if (!icon_view_p || !population_p || !population_p->en || !population_p->en->path) return;
    
    for (i=0; symbols[i]; i++){
	hideit(icon_view_p->widgets.window, symbols[i]);
	if (g_file_test(population_p->en->path,G_FILE_TEST_EXISTS) 
	|| MENU_IN_MODULE(symbols[i])) 
	{
	    if (icon_view_p->selection_count > 1 && !multiple_select[i]) continue;
	    if (i>2) showit(icon_view_p->widgets.window, "iv_separator_single_selections");
	    showit(icon_view_p->widgets.window, symbols[i]);
	}
    }
    
 
   if (g_file_test(population_p->en->path,G_FILE_TEST_IS_DIR) 
    || MENU_IN_MODULE("paste_menuitem"))	
    {
	if (valid_pasteboard() && icon_view_p->en && icon_view_p->en->path) {
	    showit(icon_view_p->widgets.window, "paste_menuitem");
	}
    }
    
    if (g_list_length(icon_view_p->selection_list)>0 && 
	g_list_length(icon_view_p->selection_list)<3 &&
	g_file_test(icon_view_p->en->path,G_FILE_TEST_IS_DIR))
	showit(icon_view_p->widgets.window, "differences2");
}
static
void 
set_menu_toggles(icon_view_t *icon_view_p){
    icon_view_p->redlight=TRUE;
    {
	if (icon_view_p->sortcolumn == GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID)
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "unsorted6"),TRUE);
	else if (icon_view_p->sortcolumn == NAME_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "name6"),TRUE);
	else if (icon_view_p->sortcolumn == SIZE_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "size6"),TRUE);
	else if (icon_view_p->sortcolumn == DATE_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "date6"),TRUE);
	else if (icon_view_p->sortcolumn == OWNER_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "owner6"),TRUE);
	else if (icon_view_p->sortcolumn == GROUP_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "group6"),TRUE);
	else if (icon_view_p->sortcolumn == MODE_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "mode6"),TRUE);
	      
	gtk_check_menu_item_set_active((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "preview_images_menuitem"),icon_view_p->preferences & __SHOW_IMAGES);
	
	gtk_check_menu_item_set_active((GtkCheckMenuItem *)lookup_widget(icon_view_p->widgets.window, "show_hidden_menuitem"),icon_view_p->preferences & __SHOW_HIDDEN);
      

    }
    icon_view_p->redlight=FALSE;
}
static
void 
do_iconview_popup(	icon_view_t *icon_view_p, 
			population_t *population_p, 
			GdkEventButton *event)
{
    if (!icon_view_p) return;
    /* only need to destroy and recreate if module fiddles around with it */
    if (!icon_view_p->popup){
	icon_view_p->popup = gridview_mk_popup_menu(NULL,NULL,icon_view_p);
    }    
    gtk_widget_hide_all(icon_view_p->popup);
	TRACE("do_iconview_popup");

    if (population_p && population_p->en && population_p->en->module && 
	function_rational("plugins",population_p->en->module,(void *)(population_p->en),&(icon_view_p->widgets),"private_popup"))
    {
	TRACE("private module popup menu here.");
	return;
    }

    {
	///hmmm works when menu is created, but not here.....
	GtkWidget *w,*inner_label=lookup_widget(icon_view_p->widgets.window,"sort1");
	GdkPixbuf *pb;
	if (icon_view_p->preferences & SORT_ASCENDING) pb=icon_tell(&(icon_view_p->widgets),SMALL,"xfce/stock_sort-ascending");
	else pb=icon_tell(&(icon_view_p->widgets),SMALL,"xfce/stock_sort-descending");
	w=gtk_image_new_from_pixbuf (pb);
	g_object_unref(pb);
	gtk_widget_show (w);
	TRACE("now setting image for sort order menu item...");
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (inner_label), w);
    }

      
    if (!population_p || 
        !population_p->en || 
        !population_p->en->path || 
	IS_DUMMY_TYPE(population_p->en->type) ||
	IS_ROOT_TYPE(population_p->en->type) 
	 )
    {
	TRACE("main menu here");
	refresh_item(icon_view_p,population_p);
	set_menu_toggles(icon_view_p);
	gtk_menu_popup(GTK_MENU(icon_view_p->popup), NULL, NULL, NULL, NULL, 3, event->time);
	return;
    }
    

    gui_autostuff(&(icon_view_p->widgets),icon_view_p, icon_view_p->popup,population_p->en,gridview_autotype_C, gridview_mount, gridview_unmount);
    
    mount_item(icon_view_p,population_p);
    remove_item(icon_view_p,population_p);
    open_item(icon_view_p,population_p);    
    properties_item(icon_view_p,population_p);    
    print_item(icon_view_p,population_p); 

    TRACE("icon_view_p->module_name=%s,icon_view_p->submodule_name=%s",
	    icon_view_p->module_name,icon_view_p->submodule_name);
    gridview_mk_module_popup_menu(icon_view_p->module_name,icon_view_p,icon_view_p->en);

    
    set_menu_toggles(icon_view_p);
    gtk_menu_popup(GTK_MENU(icon_view_p->popup), NULL, NULL, NULL, NULL, 3, event->time);
}


