#define TIMERVAL 2500
#define MAX_LOAD_TIME 2

    
static
gint gridview_monitor(gpointer data)
{
   GList *tmp;
   if (!xffm_details->icon_view_p) return FALSE;
    if(!xffm_details->timer)
    {
	xffm_details->timer = g_timeout_add (TIMERVAL,gridview_monitor, NULL);
	return TRUE;
    }
    if(getenv("XFFM_DISABLE_MONITOR") && strlen(getenv("XFFM_DISABLE_MONITOR"))) 
    {
	return TRUE;
    }
    
    for (tmp=iconview_list;tmp;tmp=tmp->next){
	long v1,v2;
	struct stat st;
	icon_view_t *icon_view_p=(icon_view_t *)tmp->data;
	record_entry_t *new_en;
	if (icon_view_p->redlight) continue;
	/* button down? */
	if (icon_view_p->down_X != -1 && icon_view_p->down_Y != -1) continue;
	if (!icon_view_p || !icon_view_p->en || !icon_view_p->en->path || !icon_view_p->en->st) continue;
	if (!g_file_test(icon_view_p->en->path,G_FILE_TEST_EXISTS)) continue;
	if (stat(icon_view_p->en->path,&st)<0) continue;
	v1=icon_view_p->en->st->st_mtime + icon_view_p->en->st->st_ctime + icon_view_p->en->st->st_dev;
	v2=st.st_mtime + st.st_ctime + st.st_dev;
	if (v1 == v2) continue;

	TRACE("update necessary for %s iconview=0x%x (%ld == %ld",icon_view_p->en->path,(unsigned)icon_view_p,v1,v2);
	/* takes too long? */
	TRACE("load_time for %s=%ld",icon_view_p->en->path,(long)icon_view_p->en->load_time );
	if (icon_view_p->en->load_time > MAX_LOAD_TIME) {
	    print_status(&(icon_view_p->widgets),"xfce/warning",_("Directory is modified"),NULL);
	    DBG("load_time (%ld) for %s takes too long for automatic monitor...",
		    (long)icon_view_p->en->load_time,icon_view_p->en->path);
	    continue;
	}
	
	new_en=copy_entry(icon_view_p->en);
	if (!reload_iconview(icon_view_p,new_en,FALSE)){
	    destroy_entry(new_en);
	} else {
	    memcpy(icon_view_p->en->st,&st,sizeof(struct stat));
	}
    }
    return TRUE;
}
