/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <ctype.h>

#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "treeview.h"

#include "actions_lib.h"



#define PRINT_STATUS_INPUT print_status(&(xffm_details->arbol->widgets),"xfce/question", _("Input requested"), NULL)
#define PRINT_STATUS_DONE print_status(&(xffm_details->arbol->widgets),"xfce/info", _("Command done"), NULL)
	


extern
gchar *workdir;



/* **********************private*********************** */
static void check1_toggle (GtkToggleButton *togglebutton, gpointer data){
    widgets_t *widgets_p=(widgets_t *)data;
    GtkWidget *check = lookup_widget(widgets_p->window,"checkbutton3");
    if (widgets_p->input != RUN_INPUT && widgets_p->input !=  RUN_DOUBLE_CLICK) return;
    gtk_button_set_label((GtkButton *) check, _("Hold"));
    if (!gtk_toggle_button_get_active (togglebutton)) gtk_widget_hide(check); 
    else gtk_widget_show(check);
}


static
void set_new_combo(void)
{
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);
    GtkWidget *w = lookup_widget(widgets_p->window,"input_combo");
    GList *new_list = NULL;
    GtkTreeIter iter;
    record_entry_t *en;
    char *path;


    en = treeview_get_selected_entry(&iter);
    path = g_strdup(en->path);
    if(!IS_DIR(en->type)) *(strrchr(path, '/')) = 0;
    if (IS_NETTHING(en->subtype)) new_list = g_list_append(new_list,  _("New"));
    else new_list = g_list_append(new_list, (gchar *)xffm_new_name(path, _("New")));
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    g_list_free(new_list);
    g_free(path);
    path=NULL;
}


static gchar *fix_relative_path(GtkTreeView *treeview,gchar *choice){
    GtkTreeIter iter;
    record_entry_t *en;
    gchar *g=NULL;
    /* invalid stuff */
    if (!choice) return NULL; 
    if (!strlen(choice)) return g_strdup(choice); 
    /* network stuff */
    if (strncmp(choice,"//",2)==0) return g_strdup(choice); 
    /* absolute path */
    if (*choice == G_DIR_SEPARATOR && g_file_test((const gchar *)choice,G_FILE_TEST_IS_DIR)) return g_strdup(choice); 
	/* relative to xffm-root-folder, maybe */
	get_module_root(treeview, &iter, &en, NULL);
	g=g_strconcat(en->path,G_DIR_SEPARATOR_S,choice,NULL);
    if (g && g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
        return g;
    }
    /* relative to homedir, maybe */
    g=g_strconcat(GETWD,G_DIR_SEPARATOR_S,choice,NULL);
    if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
        return g;
    }
    g_free(g);
    return g_strdup(choice);
}



static
const gchar *
get_selection_list_path(void){
    GList *tmp,*selection_list;
    int list_path_length=0;
    static gchar *list_path=NULL;
    g_free(list_path);
    list_path=NULL;

    selection_list=xffm_details->selection_list;
    
    for (tmp = selection_list; tmp; tmp=tmp->next)
    {
	record_entry_t *en;
	en = ((selection_list_t *) tmp->data)->en;
    
	list_path_length += (strlen(en->path)+3);
    }
    list_path =(gchar *)malloc(list_path_length+1);
    memset(list_path,0,list_path_length+1);

    if (!list_path) return NULL;
    strcpy(list_path,"");
    for (tmp = selection_list; tmp; tmp=tmp->next)
    {
	record_entry_t *en;
	en = ((selection_list_t *) tmp->data)->en;

	strcat(list_path,"\"");
	strcat(list_path,en->path);
	strcat(list_path,"\"");
	if (tmp->next) strcat(list_path," ");
    }
    return (const gchar *) list_path;
}

static
void private_ok_input (GtkTreeView * treeview)
{
    gboolean result;
    gchar *choice;
    GtkTreeIter iter;
    GtkEntry *entry;
    record_entry_t *en;
    gchar *nfile=NULL;
    GtkTreePath *treepath;
    GtkTreeRowReference *reference;
    GtkTreeModel *treemodel;
    treestuff_t *treestuff;
    xfc_combo_info_t **combo_info;
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);


    combo_info=(xfc_combo_info_t **)(&(widgets_p->combo_info));

    TRACE("-*************at input ok,xffm_details->input=%d (%d,%d,%d)",widgets_p->input,NEW_FILE_INPUT, NEW_DIR_INPUT,NEW_INPUT);
	treemodel = gtk_tree_view_get_model(treeview);
	treestuff=get_treestuff(treeview);

    print_status(&(xffm_details->arbol->widgets),NULL," ",NULL);
    entry = (GtkEntry *) lookup_widget(widgets_p->window,"input_entry");

    
    choice = g_strdup(XFC_get_entry(*combo_info));

    
    gtk_widget_hide(lookup_widget(widgets_p->window,"input_box"));
    if(treeview && xffm_details->preferences & SHOW_TB1)
	gtk_widget_show_all(lookup_widget(widgets_p->window,"box_tb1"));
#if 0    
#ifdef USE_FILTER_BAR
    if(xffm_details->preferences & SHOW_F)
	showit(NULL, "filter_box");
#endif
#endif
   
    if(treeview) gtk_widget_grab_focus((GtkWidget *) treeview);

    if (!choice && widgets_p->input==NEW_WIN_INPUT){
	choice=g_strdup(g_get_home_dir());
    }
    if (!choice) {
	TRACE("!choice\n");
	return;
    }
    g_strstrip(choice);
    if (!strlen(choice)) {
	g_free(choice); 
	TRACE("!strlen(choice)\n");
	return;
    }


    TRACE("*************at input ok,xffm_details->input=%d (%d,%d,%d)",widgets_p->input,NEW_FILE_INPUT, NEW_DIR_INPUT,NEW_INPUT);
    switch (widgets_p->input)
    {
	default:
	    break;
	case NEW_TERM_INPUT:
	case NEW_WIN_INPUT:
	{
	    gchar *g = fix_relative_path(treeview,choice);
	    if (!g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)){
		print_status(&(xffm_details->arbol->widgets),"xfce/error",
			       strerror(ENOENT), " : ", 
			       choice, NULL);
	    } else {
	      if (widgets_p->input == NEW_WIN_INPUT){
	        char *argv[3];
		argv[0] = "xftree4";
		argv[1] = (char *)g;
		argv[2] = 0;
		xffm_runvwd(widgets_p,NULL,argv);
	      } else if (widgets_p->input == NEW_TERM_INPUT){
		xffm_new_terminal_path(NULL,g);
	      }
	      /* save both relative and absolute paths for autocompletion */
	      if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
		save_to_go_history(choice);
		save_to_go_history(g);
	      }
	    }
	    g_free(g);
	    break;
	}
	case WORKDIR_INPUT:
	    g_free(workdir);
	    workdir=g_strdup(choice);
	    if (g_file_test((const gchar *)workdir,G_FILE_TEST_IS_DIR)){
		save_workdir_history(workdir);
	    }
    	    g_free(choice);
	    choice=NULL;
	    /* OTHER_INPUT should cancel whatever is waiting on gtk loop */
    	    /*widgets_p->input = OTHER_INPUT;*/
	    gtk_main_quit();
	    return;
	case RENAME_INPUT:
	case PRINT_INPUT:
	case SYMLINK_INPUT:
	case DUPLICATE_INPUT:
	    if(!set_load_wait()) {
		g_warning("!set_load_wait()");
		return;
	    }
	    
	    if (!xffm_details->arbol->widgets.window) g_assert_not_reached();	    
	    en = treeview_get_selected_entry(&iter);
	    if(!en || !IS_PATH(en->type))
		assert_not_reached();
	    treepath = gtk_tree_model_get_path(treemodel, &iter);
	    gtk_tree_path_up(treepath);
	    reference = gtk_tree_row_reference_new(treemodel, treepath);
	    gtk_tree_path_free(treepath);
	    
	    {

		char *path = g_strdup(en->path);
		*(strrchr(path, '/')) = 0;
		switch (widgets_p->input)
		{
		    default:
			break;
		    case RENAME_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			result=xffm_rename(&(xffm_details->arbol->widgets), nfile, en->path);
			break;
		    case PRINT_INPUT: 
			xffm_print(&(xffm_details->arbol->widgets), choice, en->path);
			break;
		    case SYMLINK_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			result=xffm_symlink(&(xffm_details->arbol->widgets), nfile, en->path);
			break;
		    case DUPLICATE_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			result=xffm_duplicate(&(xffm_details->arbol->widgets), nfile, en->path);
			break;
		}
	    }
   
	    if (result) {
		gboolean duplicate=FALSE;
		record_entry_t *c_en;
		GtkTreeIter parent,child;
		
		/* to eliminate duplicate entries */
		if(gtk_tree_model_iter_parent(treemodel, &parent, &iter))
		{
		  if(gtk_tree_model_iter_children(treemodel, &child, &parent)){
		    do {
		      gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
		      if (c_en==en) continue;
		      /*printf("TRACE:%s -- %s\n",nfile,c_en->path);*/
		      if (c_en && c_en->path && nfile && strcmp(nfile,c_en->path)==0){
			duplicate=TRUE;
			break;	
		      }  
		    } while (gtk_tree_model_iter_next(treemodel, &child));
		  }
		}
		if (nfile) {
		    g_free(en->path);
		    en->path=g_strdup(nfile);
		}
		update_text_cell_for_row(NAME_COLUMN,treemodel, &iter, (FILENAME(en)));
		if (duplicate) remove_row(treemodel, &child,NULL,c_en);
		
		update_dir(treeview, reference);
		unset_load_wait();	   
		local_monitor(TRUE);
		gtk_tree_row_reference_free(reference);
	    } else {
		unset_load_wait();	   
	    }
		

	    break;
	case RUN_DOUBLE_CLICK:
	case RUN_INPUT:
	    {
		gboolean in_terminal, remember, hold;
		GtkWidget *check;
		gchar *in_cmd;
		GList *selection_list;

		selection_list = xffm_details->selection_list;
		TRACE("at RUN_INPUT");
		check = lookup_widget(widgets_p->window,"checkbutton1");
		in_terminal = gtk_toggle_button_get_active((GtkToggleButton *) check);
		check = lookup_widget(widgets_p->window,"checkbutton3");
		hold = gtk_toggle_button_get_active((GtkToggleButton *) check);

		if (g_file_test(choice,G_FILE_TEST_IS_DIR)){
		    if (in_terminal) {
			xffm_new_terminal_path(NULL,choice);
			{
			    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
			    gchar *f=g_strconcat(xdg_dir,RUN_DBH_FILE,NULL);

			    g_free(xdg_dir);
			    XFC_save_to_history(f,choice);
			    xffm_save_flags(choice,in_terminal,hold);
			    g_free(f);
			}
			break;
		    }
		    else in_cmd = g_strdup_printf("xffm %s",choice);
		} else {
		    in_cmd = g_strdup(choice);
		}
		
		if(widgets_p->input == RUN_INPUT)
		{
		    gchar *dir=NULL;
		    remember = FALSE;
		    en = treeview_get_selected_entry(&iter);
		    if (en) dir=g_path_get_dirname(en->path);
		    chdir(dir);
		    g_free(en);
		    en = NULL;
		}
		else
		{		/*RUN_DOUBLE_CLICK */
		    check = lookup_widget(widgets_p->window,"checkbutton2");
		    remember = gtk_toggle_button_get_active((GtkToggleButton *) check);
		    en = treeview_get_selected_entry(&iter);
		}
		TRACE("at input ok xffm_on_run %s en=0x%x",in_cmd,(unsigned)en);
		if (widgets_p->input == RUN_DOUBLE_CLICK && g_list_length(selection_list)==1){
		    if(xffm_on_run_path(widgets_p,in_cmd, get_selection_list_path(), in_terminal, remember, TRUE, hold)) {
			gchar *g=g_strdup_printf(_("Executing %s"),in_cmd);
			print_status(&(xffm_details->arbol->widgets),"xfce/info", g, NULL);
			g_free(g);
		    }

		}
		else { 
		    if(xffm_on_run(widgets_p,in_cmd, en, in_terminal, remember, TRUE, hold));
		}
		chdir(GETWD);
		
		{
			gchar *g;
			if (g_file_test(in_cmd,G_FILE_TEST_EXISTS)) {
			    gchar *f;
			    f=g_path_get_basename(in_cmd);
			    g=g_strdup_printf(_("Executing %s"),f);
			    g_free(f);
			} else {
			    g=g_strdup_printf(_("Executing %s"),in_cmd);
			}
			print_status(&(xffm_details->arbol->widgets),"xfce/info", g, NULL);
			g_free(g);
		}
		g_free(in_cmd);
		in_cmd=NULL;
	    }
	    break;
	case GOTO_INPUT:
	    {
	      gchar *g=fix_relative_path(treeview,choice);
	      if (strncmp(g,"//",2) != 0 && !g_file_test(g,G_FILE_TEST_IS_DIR)){
		  /* try utf8...*/
		  /*gchar *gg=g;
		  g=g_strdup(my_valid_utf_pathstring(g));
		  g_free(gg);*/
		  if (!g_file_test(g,G_FILE_TEST_IS_DIR)){
		    print_diagnostics(&(xffm_details->arbol->widgets), "xfce/error","g is ", " : ", g, "\n", NULL);
		    print_diagnostics(&(xffm_details->arbol->widgets), "xfce/error", strerror(ENOENT), " : ", choice, "\n", NULL);
		    print_status(&(xffm_details->arbol->widgets), "xfce/error", strerror(ENOENT), NULL);
		    goto over;
		  }
	      }
	      if (strncmp(g,"//",2)==0) {
		  get_module_root(treeview, &iter, &en,"xffm_nmb");
	      }
	      else  get_module_root(treeview, &iter, &en, NULL);
	      /*pushgo(treestuff, g);*/
	      go_to(treestuff, g);
	      
	      /* save relative path for autocompletion */
	      if (g && g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)){
	        save_to_go_history(g);
	        TRACE("TRACE: RECENT_add2history(%s)\n",(char *)g);
	        RECENT_add2history(&(xffm_details->arbol->widgets),(char *)g);
	      }
	      g_free(g);
	    }
	    break;
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	case NEW_INPUT:
	    {
		GtkWidget *w = lookup_widget(widgets_p->window,"checkbutton1");

		    en = treeview_get_selected_entry(&iter);
		    /* if no children, get parent */
		    if (!gtk_tree_model_iter_has_child (treemodel,&iter)){
			GtkTreeIter parent;
			if (!gtk_tree_model_iter_parent (treemodel,&parent,&iter)) break;
			iter=parent;
			gtk_tree_model_get(GTK_TREE_MODEL(treemodel), &iter, ENTRY_COLUMN, &en, -1);
			if (!en) break;
		    }

		TRACE("newinput, en=0x%x\n",(unsigned)en);
    		if(!en) break;
		TRACE("newinput en->module0x%x",(unsigned)en->module);
		if (en->module) {
		    const gchar *function_name="on_new";
		    switch (widgets_p->input) {
			case NEW_FILE_INPUT: function_name="on_new_file"; break;
			case NEW_DIR_INPUT:  function_name="on_new_dir"; break;
			case NEW_INPUT:
			    if (gtk_toggle_button_get_active((GtkToggleButton *) w)) {
				function_name="on_new_dir"; break;
			    } else {
				function_name="on_new_file"; break;
			    }
		    }
		    function_rational("plugins",en->module,en,&(xffm_details->arbol->widgets),function_name);
		    break;
		}
		else if(!IS_PATH(en->type))break;
		
		if (xffm_details->arbol->widgets.window) {
		    treepath = gtk_tree_model_get_path(treemodel, &iter);
		    reference = gtk_tree_row_reference_new(treemodel, treepath);
		    gtk_tree_path_free(treepath);
		}

		if (!en->module) {
		    char *path = g_strdup(en->path);
		    char *name = g_strdup(choice);
		    if(!IS_DIR(en->type)) *(strrchr(path, '/')) = 0;
		    xffm_new(&(xffm_details->arbol->widgets), path, name, gtk_toggle_button_get_active((GtkToggleButton *) w));
		    g_free(path);
		    path=NULL;
		    g_free(name);
		    name=NULL;
		}

		    if(set_load_wait())
		    {
			update_dir(treeview, reference);
			unset_load_wait();
		    }
		    gtk_tree_row_reference_free(reference);
	    }
	    local_monitor(FALSE);
	    break;
    }
over:
    g_free(nfile);
    nfile=NULL;
    g_free(choice);
    choice=NULL;
    widgets_p->input = OTHER_INPUT;
}

G_MODULE_EXPORT
void treeview_cancel_input (GtkEntry *entry,gpointer data)
{
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);
    if (widgets_p->input == OTHER_INPUT) return;
    
    gtk_widget_hide(lookup_widget(widgets_p->window,"input_box"));
    print_status(&(xffm_details->arbol->widgets),NULL,_("Omitting"),NULL);
    if (xffm_details->arbol->widgets.window){
        if(xffm_details->preferences & SHOW_TB1) gtk_widget_show_all(lookup_widget(widgets_p->window,"box_tb1"));
    }
    
    if (widgets_p->input==WORKDIR_INPUT){
	    g_free(workdir);
	    workdir=NULL;
	    widgets_p->input = OTHER_INPUT;
	    gtk_main_quit(); /* this lets on_autotype_C continue */
    } else {
	    widgets_p->input = OTHER_INPUT;
    }
}
/************************************************************************/

G_MODULE_EXPORT
void treeview_show_input (int which)
{
    GtkTreeView *treeview=NULL;
    GtkCheckButton *check_button1, *check_button2;
    GtkLabel *label;
    GtkEntry *entry;
    GtkCombo *combo;
    /*GtkToggleButton *w; */
    GtkTreeIter iter;
    char *path, *name=NULL;
    record_entry_t *en;
    gchar *sname;
    xfc_combo_info_t **combo_info;
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);

    combo_info=(xfc_combo_info_t **)(&(widgets_p->combo_info));

	gint tree_id = get_active_tree_id();
	treeview = xffm_details->arbol->treestuff[tree_id].treeview;


    TRACE("at show input");

    if(xffm_details->arbol->widgets.tubo_object){
	g_warning("should not happen2 at input.c");
	return;
    }
	
    treeview_cancel_input(NULL,NULL);
    

    label = (GtkLabel *) lookup_widget(widgets_p->window,"input_label");
    entry = (GtkEntry *) lookup_widget(widgets_p->window,"input_entry");

    /* combo setting up: */
    combo=(GtkCombo *)lookup_widget(widgets_p->window,"input_combo");
    check_button1 = (GtkCheckButton *) lookup_widget(widgets_p->window,"checkbutton1");
    if (*combo_info==NULL){
	g_signal_connect((gpointer)check_button1,"toggled",G_CALLBACK (check1_toggle),&(xffm_details->arbol->widgets));
	*combo_info = XFC_init_combo(combo);
    } else {
	XFC_clear_history(*combo_info);
    }

    (*combo_info)->activate_func = treeview_input_activate;
    (*combo_info)->activate_user_data=NULL;
    /*(*combo_info)->activate_user_data=*combo_info;*/
    (*combo_info)->cancel_func = treeview_cancel_input;
    (*combo_info)->cancel_user_data=NULL;
    
#ifndef LINKED_MODULES 
    /* not available in debug mode... */
    {
      xfc_combo_functions *xfc;
      xfc=load_xfc();
      if (xfc) switch (which) {
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	xfc->extra_key_completion = extra_key_completion;
	xfc->extra_key_data = &(xffm_details->arbol->widgets);
	break;
	default:
	xfc->extra_key_completion = NULL;
	xfc->extra_key_data = NULL;
	break;
      } 
      else g_warning("xfc==NULL");
    }
#endif
    
    gtk_widget_show_all(lookup_widget(widgets_p->window,"input_box"));
    gtk_widget_show_all(lookup_widget(widgets_p->window,"input_combo"));
    XFC_set_combo(*combo_info,NULL);

    
    /* toolbar is only available in the treeview version for now: */
    if (xffm_details->arbol->widgets.window) hideit(xffm_details->arbol->widgets.window, "box_tb1");
    /*hideit(xffm_details->arbol->widgets.window, "filter_box");*/
    
    /* check button initializations: */
    
    gtk_widget_hide(lookup_widget(widgets_p->window,"checkbutton1"));
    gtk_widget_hide(lookup_widget(widgets_p->window,"checkbutton2"));
    gtk_widget_hide(lookup_widget(widgets_p->window,"checkbutton3"));

    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button1))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, FALSE);
    if (which==NEW_INPUT || which==NEW_DIR_INPUT)
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, TRUE);

    check_button2 = (GtkCheckButton *) lookup_widget(widgets_p->window,"checkbutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button2))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button2, FALSE);

    widgets_p->input = which;

    en = treeview_get_selected_entry(&iter);
    if (en) TRACE("input.c, en->module is %s",((en->module)?en->module:"null"));
    else TRACE("input.c, entry is null");
        
    if(!en || !en->path)	    
    {
	path = g_strdup(GETWD);
	name = g_strdup(_("New"));
    }
    else
    {
	path = g_strdup(en->path);
	if(IS_PATH(en->type))
	{
	    if (!strrchr(path, '/')) {
		g_warning("show_input(): en->path is not absolute!\n");
		name=g_strdup(my_utf_string(path));
	    } else {
		name=g_path_get_basename(my_utf_string(path));
	    }
	}
	else
	{
	    name = g_strdup(_("New"));
	}
    }

    switch (which)
    {

	case RENAME_INPUT:
	case DUPLICATE_INPUT:
	{
	    gchar *t1,*t2;
	    gtk_entry_set_text(entry, "");
	    if (which==RENAME_INPUT || which==DUPLICATE_INPUT) 
		t1=g_strdup(xffm_new_name(path, name)),t2=_("Name");
	    else t1=g_strdup(""), t2="";
	    gtk_entry_set_text(entry, my_valid_utf_pathstring(t1));
	    gtk_label_set_text(label, t2);
	    g_free(t1);
	    PRINT_STATUS_INPUT;
	    break;
	}
	case SYMLINK_INPUT:
	    sname=g_strconcat(name,"-lnk",NULL);
	    gtk_entry_set_text(entry, my_valid_utf_pathstring(sname));
	    g_free(sname);
	    sname=NULL;
	    gtk_label_set_text(label, _("Name"));
	    PRINT_STATUS_INPUT;
	    break;
	case PRINT_INPUT:
	{
	    gchar *pc=g_find_program_in_path("xfprint4");
	    gtk_label_set_text(label, _("Print command"));
	    if (pc) {
		gtk_entry_set_text(entry, "xfprint4");
		print_status(&(xffm_details->arbol->widgets),"xfce/question","xfprint4 ",FILENAME(en), NULL);
	    }
	    else {
		gtk_entry_set_text(entry, "lpr");
		print_status(&(xffm_details->arbol->widgets),"xfce/question","lpr ",FILENAME(en), NULL);
	    }
	    g_free(pc);
	    break;
	}
	case NEW_INPUT:
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	    set_new_combo();
	    gtk_label_set_text(label, _("Name"));
	    print_status(&(xffm_details->arbol->widgets),"xfce/question", _("Name"), NULL);
	    if (which == NEW_INPUT){
	      gtk_button_set_label((GtkButton *) check_button1, _("Directory"));
	      showit(NULL,"checkbutton1");
	    }
	    break; 
	case WORKDIR_INPUT: 
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,WORKDIR_DBH_FILE,NULL);
	      gchar *dir=NULL;

	      if (en && en->path) dir = g_path_get_dirname(en->path);

	      g_free(xdg_dir);
	      XFC_read_history(*combo_info,f);
    	      XFC_set_combo(*combo_info,NULL);
	      
	      /* only suggest a valid utf8 path initially */
	      if (dir && g_utf8_validate (dir,-1,NULL)) {
		  XFC_set_entry(*combo_info,dir);
	      }
   	      g_free (f);
   	      g_free (dir);
	    }
	    gtk_label_set_text(label,workdir?_(workdir):_("Output dir"));
	    PRINT_STATUS_INPUT;
	    break;
	case NEW_WIN_INPUT: 
	case NEW_TERM_INPUT: 
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,GOTO_DBH_FILE,NULL);
	      const gchar *p = g_get_home_dir();

	      p=treeview_get_selected_chdir();

	      g_free(xdg_dir);
	      XFC_read_history(*combo_info,f);
    	      XFC_set_combo(*combo_info,NULL);
   	      g_free (f);
	      /* only suggest current dir initially if it is a
	       * a valid utf8 path (because the combo list must
	       * be hashtable by the combo module, to solve
	       * euc-jp conflicts)*/
	      if (p && g_utf8_validate (p,-1,NULL)) {
		XFC_set_entry(*combo_info,(gchar *)p);
	      } 
	    }
	    gtk_label_set_text(label,_("Directory"));
	    PRINT_STATUS_INPUT;
	    break;  
	case GOTO_INPUT:
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,GOTO_DBH_FILE,NULL);
	      
	      g_free(xdg_dir);
	      XFC_read_history(*combo_info,f);
    	      /* implied by XFC_set_entry: XFC_set_combo(*combo_info,NULL);*/
	      XFC_set_blank(*combo_info);
   	      g_free (f);
	    }
	    /*set_goto_combo(*combo_info);*/
	    gtk_label_set_text(label, _("Go to"));
	    PRINT_STATUS_INPUT;
	    break;
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	    switch (which)
	    {
		case RUN_INPUT:
	    	    xffm_set_run_combo(&(xffm_details->arbol->widgets),en,*combo_info);
		    gtk_label_set_text(label, _("Run"));
		    PRINT_STATUS_INPUT;
		    break;
		case RUN_DOUBLE_CLICK:
	    	    xffm_set_run_combo(&(xffm_details->arbol->widgets),en,*combo_info);
		    gtk_label_set_text(label, _("Open with"));
		    gtk_button_set_label((GtkButton *) check_button2, 
				    _("Remember"));
		    gtk_widget_show_all(lookup_widget(widgets_p->window,"checkbutton2"));
		    if(en && en->path)
		    {
		      int in_term;
		      gchar **text_editors;
		      const gchar *p=xffm_get_from_open_history(en->path, &in_term);
		      if (p) {
			  /* XXX: this value is not in association hash...
			   * So if it is not a valid utf8, forget about it...*/
			  if ( g_utf8_validate (p,-1,NULL)) {
			    XFC_set_entry(*combo_info,(gchar *)(p));
			    gtk_toggle_button_set_active((GtkToggleButton *) check_button2, (gboolean)in_term);	
			  }
		      }
		      else if ((text_editors=text_type_OK(en->path))!=NULL){  
			  /* OK to apply an editor */
			int k;
			for (k=0;text_editors[k];k++){
			    gchar *c=g_find_program_in_path(text_editors[k]);
			    if (c){
				g_free(c);
				XFC_set_entry(*combo_info,(gchar *)text_editors[k]);
				break;
			    }
			}	
		      }
		      else {
			const gchar *p=MIME_command(en->path);
			/*printf("TRACE:no history to set for %s\n",en->path);*/
			if (p) XFC_set_entry(*combo_info,(gchar *)my_valid_utf_pathstring(p));
			else XFC_set_blank(*combo_info);
		      }
		    }
		    PRINT_STATUS_INPUT;
		    break;

	    }

	    gtk_button_set_label((GtkButton *) check_button1, _("In terminal"));
	    gtk_widget_show_all(lookup_widget(widgets_p->window,"checkbutton1"));
	    break;

	default:
	    break;
    }
    g_free(path);
    path=NULL;
    gtk_widget_grab_focus((GtkWidget *) entry);
    /* these will preselect */
    
    if (which == NEW_INPUT || which == SYMLINK_INPUT ||
	which == NEW_FILE_INPUT || which == NEW_DIR_INPUT ||
	which ==  RUN_INPUT || which == RUN_DOUBLE_CLICK ||
	which == NEW_WIN_INPUT || which == NEW_TERM_INPUT ){
      gtk_editable_set_position(GTK_EDITABLE (entry),0);
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
    } else {
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, 0);
      gtk_editable_set_position(GTK_EDITABLE (entry),-1);
    }
    if (which==WORKDIR_INPUT) gtk_main();
    g_free(name);
}


/* callbacks */


/*
G_MODULE_EXPORT
void on_input_cancel (GtkButton * button, gpointer user_data)
{
    cancel_input(NULL,user_data);
}*/


G_MODULE_EXPORT
void treeview_input_ok (GtkButton * button, gpointer user_data)
{ 
	gint tree_id = get_active_tree_id();
	GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    TRACE("--on inputok, iconview_p is 0x%x\n",(unsigned)user_data);
	private_ok_input(treeview);
}


G_MODULE_EXPORT
void treeview_input_activate (GtkEntry * entry, gpointer user_data)
{
	gint tree_id = get_active_tree_id();
	GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
	private_ok_input(treeview);
}
