/*#define DISABLE_MONITOR*/
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * monitors:
 * 1- all elements in open folders
 *   a) stat information
 *   b) files no longer present
 *   c) files which appeared after last refresh
 *
 *   */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


#include <errno.h>
#include <regex.h>
#include <dirent.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"

#include "treeview.h"


/*#define TIMERVAL 1000*/
#define TIMERVAL 5000

extern gboolean easy_mode;


/*static gboolean monitor_running;*/
static GList *cut_list = NULL;
static GList *update_list = NULL;
static long long pasteboard_checksum = -1;



static GList *zap_list(GList * list)
{
    GList *tmp;
    if(!list)
	return NULL;
    for(tmp = list; tmp; tmp = tmp->next)
    {
	if(tmp->data)
	{
	    GtkTreeRowReference *reference;
	    reference = (GtkTreeRowReference *) tmp->data;
	    gtk_tree_row_reference_free(reference);
	}
    }
    g_list_free(list);
    return NULL;
}


/* OjO: should be same algorithm as in add_folder.c, read_files_d_type() */
static 
int 
read_and_add(			GtkTreeView * treeview, 
				GtkTreeRowReference * reference, 
#ifdef USE_FILTER_BAR
				const regex_t * preg, 
#endif
				GList ** list)
{
    DIR *directory;
    struct dirent *d;
    char *fullpath;
    struct stat st;
    GList *tmp;
    gboolean found;
    record_entry_t *c_en, *en;
    GtkTreeIter target;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    TRACE("read and add1\n");
    if(!gtk_tree_row_reference_valid(reference))
	return TRUE;
    TRACE("read and add2\n");
    if(!get_entry_from_reference(treeview, reference, &target, &en))
	return TRUE;
    TRACE("read and add3\n");

    directory = opendir(en->path);
    if(!directory)
	return FALSE;
    TRACE("read and add4\n");
    while((d = readdir(directory)) != NULL)
    {
	found = FALSE;
	if(!strcmp(d->d_name, ".") || !strcmp(d->d_name, ".."))
	    continue;
	/* double dot files are not considered hidden in xffm */
	if(d->d_name[0] == '.' && d->d_name[1] != '.' && !SHOWS_HIDDEN(en->type))
	    continue;

	fullpath = g_build_filename(en->path, d->d_name,NULL);
	TRACE("fullpath=%s ...\n",fullpath);
	/* must check result of stat, because file may have dissappeared! */
	if (stat(fullpath, &st)<0 
#ifdef USE_FILTER_BAR
		|| (!S_ISDIR(st.st_mode) && preg && regexec(preg, d->d_name, 0, NULL, 0))
#endif
	){
	    TRACE("stat(fullpath, &st)<0\n");
	    g_free(fullpath);
	    continue;
	}
	tmp = *list;
	while(tmp)
	{
	    char *fullname;
	    fullname = (char *)tmp->data;
	    TRACE("checking %s==%s\n",fullname,fullpath);
	    if(strcmp(fullname, fullpath) == 0)
	    {
		found = TRUE;
		break;
	    }

	    tmp = tmp->next;
	}
	if(!found)
	{
	    TRACE("adding row for %s\n",fullpath);
	    c_en = stat_entry(fullpath, en->type);
	    add_row(treemodel, &target, NULL, NULL,c_en, d->d_name);
	}
	g_free(fullpath);
    }
    closedir(directory);
    TRACE("read and add done\n");
    return (FALSE);
}

static void update_cells(GtkTreeView * treeview, GtkTreeIter * target, record_entry_t ** en)
{
    record_entry_t *new_en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (!(*en) || !((*en)->path)) return;
    new_en = stat_entry((*en)->path, (*en)->type);

    /*XXX has hidden flag is not inheritable, so we must reset
     * here (what other flags are not inheritable and must be
     * reset?) (Monitor should also be able to unset the flag
     * when no longer required) */
    if (HAS_HIDDEN((*en)->type)) SET_HAS_HIDDEN(new_en->type);
    
    if (!new_en) return;
    
    if(IS_ROOT_TYPE((*en)->type)) SET_ROOT_TYPE(new_en->type);
    if(IS_FSTAB_TYPE((*en)->type)) SET_FSTAB_TYPE(new_en->type);
    if(IS_LOCAL_TYPE((*en)->type)) SET_LOCAL_TYPE(new_en->type);
    if(IS_LOADED((*en)->type)) SET_LOADED(new_en->type);
    if(IS_INCOMPLETE((*en)->type)) SET_INCOMPLETE(new_en->type);
    if(IS_EXPANDED((*en)->type)) SET_EXPANDED(new_en->type);
    if(IS_LOADED((*en)->type)) SET_LOADED(new_en->type);

    /* changes from dir<-->file */

    if(IS_FILE((*en)->type) && IS_DIR(new_en->type)) {
	insert_dummy_row(treemodel, target,NULL,new_en,NULL,NULL);
    }
    else if(IS_FILE(new_en->type) && IS_DIR((*en)->type)) {
	prune_row(treemodel, target, NULL, new_en);
    }

    memcpy((*en)->st, new_en->st, sizeof(struct stat));
    (*en)->type = new_en->type;
    destroy_entry(new_en);
    update_row(treemodel, target, NULL, (*en));
}

/* this removes it from the treeview only */
static void a_remove_it(GtkTreeView * treeview, GtkTreeRowReference * reference)
{
    record_entry_t *en, *p_en;
    GtkTreeIter iter, parent;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath = gtk_tree_row_reference_get_path(reference);

    if(!gtk_tree_row_reference_valid(reference))
	goto endfor;
    if(!gtk_tree_model_get_iter(treemodel, &iter, treepath))
	goto endfor;

    /* this takes care of ignoring ROOT_TYPE: */
    if(!gtk_tree_model_iter_parent(treemodel, &parent, &iter))
	goto endfor;


    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    if (en && IS_PATH(en->type) && en->path && g_file_test(en->path,G_FILE_TEST_EXISTS)) 
	goto endfor;


    /*check if last item in folder, if so, turn to dummy */
    if(gtk_tree_model_iter_n_children(treemodel, &parent) == 1){
	prune_row(treemodel, &iter, NULL, en);
	clear_row(treemodel, &iter, NULL, en);
	SET_DUMMY_TYPE(en->type);
	gtk_tree_model_row_changed(treemodel, treepath, &iter);
	
    } else {
	remove_row(treemodel, &iter, NULL, en);
    }
    p_en->count--;

  endfor:
    if(treepath)
	gtk_tree_path_free(treepath);
    return;
}

G_MODULE_EXPORT
void remove_it(GtkTreeView * treeview, GtkTreeRowReference * reference)
{
    a_remove_it(treeview, reference);
}

/* must be called with wait enabled */
G_MODULE_EXPORT
gboolean update_dir(GtkTreeView * treeview, GtkTreeRowReference * reference)
{
    record_entry_t *en, *c_en;
    GList *list = NULL, *tmp;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter, child;
    struct stat st;
#ifdef USE_FILTER_BAR
   const regex_t *preg;
#endif
    int i;

    if(!xffm_details->arbol->loading)
    {
	TRACE("xffm_details->arbol->loading not set! (update_dir())\n");
	return FALSE;
    }
    if(!gtk_tree_row_reference_valid(reference))
	return FALSE;
    if(!get_entry_from_reference(treeview, reference, &iter, &en))
	return FALSE;

    if (IS_NETWORK_TYPE(en->type)) return FALSE;
    if (IS_NETTHING(en->subtype)) return FALSE;
    if (IS_FSTAB_TYPE(en->type)&&IS_ROOT_TYPE(en->type)) 
	    return FALSE;
    if (IS_BOOKMARK_TYPE(en->type)&&IS_ROOT_TYPE(en->type)) 
	    return FALSE;
    if (IS_FIND_TYPE(en->type)&&IS_ROOT_TYPE(en->type)) 
	    return FALSE;

    /* modify changed stat information */
    
    if (!IS_XF_FND(en->type)) {
    
     if(lstat(en->path, &st) < 0)
     {
	/* printf("TRACE:removing %s\n",en->path); */
	if (gtk_tree_row_reference_valid(reference)) remove_it(treeview, reference);
	return TRUE;
     }

     if (!en->st) return TRUE;
    
     if (S_ISLNK(st.st_mode)) {
	    if (stat(en->path, &st)<0) {
			      SET_BROKEN_LNK(c_en->type);
			      return TRUE;
		      }
     } 
     if (!en->st) return TRUE;
     if(en->st->st_mtime != st.st_mtime || en->st->st_ctime != st.st_ctime)
     {
	update_cells(treeview, &iter, &en);
	set_icon(treemodel, &iter);
        TRACE("///////////////TRACE:updating cell st!=st %s\n",en->path);
     }
 
     if(!IS_DIR(en->type) || (IS_DIR(en->type) && (!IS_LOADED(en->type) || IS_INCOMPLETE(en->type))))
     {
	return TRUE;
     }
    }
 
    /* remove stuff that is gone */

    if(gtk_tree_model_iter_children(treemodel, &child, &iter))
    {
	if(!xffm_details->arbol->widgets.window)
	    return FALSE;
	do
	{
	    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	    if(IS_DUMMY_TYPE(c_en->type))
		continue;
	    if(lstat(c_en->path, &st) < 0)
	    {
		GtkTreePath *tpath;
		GtkTreeRowReference *ref;
		if(!xffm_details->arbol->widgets.window)
		    return FALSE;
		tpath = gtk_tree_model_get_path(treemodel, &child);
		ref = gtk_tree_row_reference_new(treemodel, tpath);
		list = g_list_append(list, ref);
		gtk_tree_path_free(tpath);
	    }
	    else {
              if (S_ISLNK(st.st_mode)) {
		      if (stat(c_en->path, &st)<0) {
			      SET_BROKEN_LNK(c_en->type);
			      continue;
		      }
	      }
	      if(c_en->st->st_mtime != st.st_mtime || c_en->st->st_ctime != st.st_ctime)
	      {
		{
		        update_cells(treeview, &child, &c_en);
			set_icon(treemodel, &child);
        TRACE("TRACE:updating cell c_en->st!=st %s\n",c_en->path); 
		}
	      }
	    }
	}
	while(gtk_tree_model_iter_next(treemodel, &child));
	/* remove erase list */
	for(tmp = list; tmp; tmp = tmp->next)
	{
	    GtkTreeRowReference *ref = (GtkTreeRowReference *) tmp->data;
	    if (gtk_tree_row_reference_valid(ref)) remove_it(treeview, ref);
	    if(ref) gtk_tree_row_reference_free(ref);
	}
	g_list_free(list);
	list = NULL;
    }

    /* add new stuff */
        TRACE("/////////////// add new stuff  %s\n",en->path);
      
    if (!IS_XF_FND(en->type)) {
     if(gtk_tree_model_iter_children(treemodel, &child, &iter))
     {
	do
	{
	    if(!xffm_details->arbol->widgets.window)
		return FALSE;
	    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	    if(c_en && !IS_DUMMY_TYPE(c_en->type))
	    {
		list = g_list_append(list, c_en->path);
		TRACE("appending %s\n",c_en->path);
	    }
	}
	while(gtk_tree_model_iter_next(treemodel, &child));
     }
#ifdef USE_FILTER_BAR
     if (!en) preg = NULL;
     else preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
     read_and_add(treeview, reference, preg, &list);
#else
     read_and_add(treeview, reference,  &list);
#endif
     g_list_free(list);
     list = NULL;

     /* reload iter in case it became invalid */
     if(!get_entry_from_reference(treeview, reference, &iter, &en))
	return FALSE;

     /* update the filecount (this includes hidden files) */
     i=count_files(en->path);
     if (i != en->count) {
      const gchar *tag; 
      en->count=i;
      tag = sizetag((off_t)-1, en->count);
      update_text_cell_for_row(SIZE_COLUMN,treemodel,&iter,tag);
     }
    }
    
    
    /* check if is dummy still necessary */
    if(gtk_tree_model_iter_n_children(treemodel,&iter) > 1){
        if (!gtk_tree_model_iter_children (treemodel,&child,&iter))
		assert_not_reached();

	do
	{
	    if(!xffm_details->arbol->widgets.window) return FALSE;
	    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	    if (!c_en) return FALSE;
	    if(IS_DUMMY_TYPE(c_en->type))
	    {
	       if (c_en->path && strcmp(c_en->path,"..")==0) break;/*FIXME: remove this line?*/
	       remove_row(treemodel, &child,NULL,c_en);
	       break;
	    }
	}
	while(gtk_tree_model_iter_next(treemodel, &child));
    }
   
    return TRUE;

}


static void doall_update_list(GtkTreeView * treeview)
{
    GList *tmp;
    for(tmp = update_list; tmp; tmp = tmp->next)
    {
	GtkTreeRowReference *reference = (GtkTreeRowReference *) tmp->data;
	update_dir(treeview, reference);
    }
}


/* get a g_list AFAP */

static gboolean find_cut_icons(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    record_entry_t *en;
    struct stat st;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(en && en->path && IS_CUT(en->type) && !IS_NETWORK_TYPE(en->type) 
		    && lstat(en->path, &st) < 0)
    {
	GtkTreeRowReference *reference;
	reference = gtk_tree_row_reference_new(treemodel, treepath);
	if(gtk_tree_row_reference_valid(reference))
	{
	    cut_list = g_list_prepend(cut_list, reference);
	}

    }
    /* this interferes with cell-edit, but only when the Xpasteboard changes */
    update_icon(treemodel, iter);
    return FALSE;
}

/* get a g_list AFAP */


static gboolean find_update_list(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    /*GtkTreeView *treeview=(GtkTreeView *)data; */
    record_entry_t *en;
    GtkTreeRowReference *reference;

    if(!gtk_tree_model_iter_has_child(treemodel, iter)){
	TRACE("!gtk_tree_model_iter_has_child\n");
	return FALSE;
    }
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en ){
	TRACE("!en");
	return FALSE;
    }
    if(!IS_DIR(en->type) || !IS_LOADED(en->type) || IS_INCOMPLETE(en->type)){
	TRACE("%s: !IS_DIR || !IS_LOADED || IS_INCOMPLETE\n", en->path);
	return FALSE;
    }
    /* if NFS, return false. How to tell?*/
    if (IS_NETWORK_TYPE(en->type)) {
	TRACE("IS_NETWORK_TYPE\n");
	return FALSE;
    }
    if (IS_ROOT_TYPE(en->type) && !IS_LOCAL_TYPE(en->type)) {
	TRACE("IS_ROOT_TYPE && !IS_LOCAL_TYPE\n");
	return FALSE;
    }
    if(en->load_time >= 2){
	TRACE("en->load_time >= 2\n");
	return FALSE;
    }
  
    if(!en->path || strcmp(en->path, "/dev") == 0){
	TRACE("!en->path || strcmp(en->path, \"/dev\") == 0\n");
	return FALSE;
    }

    reference = gtk_tree_row_reference_new(treemodel, treepath);
    update_list = g_list_append(update_list, reference);

    TRACE("adding %s to update list\n",en->path);
    

    return FALSE;
}

G_MODULE_EXPORT
gint timeout_monitor(GtkTreeView * treeview){
   local_monitor(FALSE);
   return TRUE;
}

static void monitor_modules(GtkTreeView * treeview){
    GtkTreeIter iter;    
    GtkTreeModel *treemodel=gtk_tree_view_get_model(treeview);
    record_entry_t *en;
    if(gtk_tree_model_get_iter_first(treemodel, &iter)) {
	do {
	    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	    if (en->module) {
		function_natural("plugins",en->module,(void *) treeview,"module_monitor");
	    }
	} while (gtk_tree_model_iter_next(treemodel, &iter));
	
    }
}

G_MODULE_EXPORT
gint local_monitor(gboolean force)
{
    /*gboolean erased; */
    /*static int count=0; */
    record_entry_t *en;
    GtkTreeIter iter;
    GList *tmp;
    char *b;
    int len = -1;
    long long new_pasteboard_checksum = 0;
    gint tree_id;
    GtkTreeModel *treemodel;
    GtkTreeView *treeview;
    widgets_t *widgets_p;

    widgets_p=&(xffm_details->arbol->widgets);
    if (!widgets_p->window){
	return TRUE;
    }
   
    if(!xffm_details->timer)
    {

	xffm_details->timer = g_timeout_add_full(0, TIMERVAL, 
			(GtkFunction) timeout_monitor, NULL, NULL);
	return TRUE;
    }
    
  
    /* abort monitor when click received on selected item
     * (assume easy edit) resume monitor when something else clicked
     * or keyboard press*/  
    if (easy_mode && !force) return FALSE;
    if (processing_pending()) return FALSE;
    if(!xffm_details || !widgets_p->window)
	return FALSE;

    if (widgets_p->input != OTHER_INPUT) return FALSE;

    set_processing_pending();

    /* check whether pasteboard has changed to change icons
     * accordingly */
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    if(b && strlen(b)) {
	char *c;
	for(c = b; *c; c++)
	    new_pasteboard_checksum += (long long)(*c);
    }
    if(b) XFree(b);
    /* skip first time around... */
    if (pasteboard_checksum < 0) pasteboard_checksum = new_pasteboard_checksum;


    if(new_pasteboard_checksum != pasteboard_checksum)
    {
      pasteboard_checksum = new_pasteboard_checksum;

      for (tree_id=0;tree_id<TREECOUNT;tree_id++) {
	treeview = xffm_details->arbol->treestuff[tree_id].treeview;
	treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
	if(!gtk_tree_model_get_iter_first(treemodel, &iter)) continue;
	gtk_tree_model_foreach(treemodel,find_cut_icons, treeview);

	for(tmp = cut_list; tmp; tmp = tmp->next)
	{
	    if(tmp->data)
	    {
		GtkTreeRowReference *reference;
		reference = (GtkTreeRowReference *) tmp->data;
		if (gtk_tree_row_reference_valid(reference)) 
		    remove_it(treeview, reference);
		gtk_tree_row_reference_free(reference);
	    }
	}
	g_list_free(cut_list);
	cut_list = NULL;
      }
    }

    if(force || !(getenv("XFFM_DISABLE_MONITOR") && strlen(getenv("XFFM_DISABLE_MONITOR"))))
    {
      for (tree_id=0;tree_id<TREECOUNT;tree_id++){
	treeview = xffm_details->arbol->treestuff[tree_id].treeview;
	treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
	TRACE("%d\n",tree_id);fflush(NULL);
    
	if(!gtk_tree_model_get_iter_first(treemodel, &iter)) continue;
	monitor_modules(treeview);
	    
	if(!set_load_wait()) goto end;
	    
	/* check for existance of local root path: */
	do {
	    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	    if(IS_LOCAL_TYPE(en->type) && access(en->path, F_OK) != 0)
	    {
	       /*const gchar *home=get_xffm_home();*/
	       print_diagnostics(&(xffm_details->arbol->widgets),"xfce/error",
		       strerror(errno),":\n",en->path,"\n",NULL);
	       unset_load_wait();
	       if (go_up_ok(treeview)) go_up((GtkWidget *)treeview);
	       else go_home((GtkWidget *)treeview);
		   
	       goto end;
	    }
	} while(gtk_tree_model_iter_next(treemodel, &iter));
	
	gtk_widget_freeze_child_notify((GtkWidget *) treeview);
	gtk_tree_model_foreach(treemodel, find_update_list, treeview);
	doall_update_list(treeview);
	update_list = zap_list(update_list);
	gtk_widget_thaw_child_notify((GtkWidget *) treeview);
	unset_load_wait();
	/*D(printf("o\n");fflush(NULL);)*/
      }
    }
end:
    unset_processing_pending();
    return TRUE;
}
