#ifndef XFFM_ACTIONS_LIB_H
#define XFFM_ACTIONS_LIB_H
#include "run.h"
#include "remove.h"
#include "cpy.h"
#include "rcp.h"
#include "countfiles.h"
#include "password_dialog.h"

const gchar *xffm_new_name(const gchar *in_path, const gchar *base);

int xffm_print(widgets_t *widgets_p, const gchar *cmd, const gchar *file);
int xffm_touch(widgets_t *widgets_p, const gchar *path);
int xffm_rename(widgets_t *widgets_p, const gchar *nfile, const gchar *ofile);
int xffm_duplicate (widgets_t *widgets_p, const gchar *nfile, const gchar *ofile);
int xffm_symlink(widgets_t *widgets_p, const gchar *nfile, const gchar *ofile);
int xffm_new(widgets_t *widgets_p, const char *path, const gchar *in_name, gboolean directory);
int xffm_diff(widgets_t *widgets_p, const gchar *file1, const gchar *file2);
int xffm_scramble(widgets_t *widgets_p, const gchar *file, gboolean cypher);

GtkWidget* xffm_create_remove (widgets_t *widgets_p);



void
on_save_preferences_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_about2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void
on_autotype_D                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
void
on_refresh                             (GtkButton       *button,
                                        gpointer         user_data);
#endif
