static GList *key_list=NULL;

static pid_t parent_pid;
static widgets_t *autotype_widgets_p;
static void *autotype_fork_obj=NULL;
static int childFD;
/* autotype entries will appear in file-menu and popup depending on
 * extension of selected item (if any). Notes:
 * -leave a blank at end of command if using arguments (to be safe) 
 * -keep entries with same extension together (so they all will appear)
 * -using NULL for input_query_text means that no input will be required
 * -using TRUE in the queued field will place it into the single queued, 
 *        where processes are run one at a time, sequentially.
 * 
 *  {char *extension,char *command,
 *  char *menu_label,char *input_query_text, gboolean queued} 
 * */
/* here the extension is appendend to "$command $filename$extension $filename". if NULL, 
 * then  "$command $filename" is used */
static
autotype_t autotype_dir []= {/* all directory commands which query for directory 
	must have output specified on command line...*/
	/* archive file extractions (queued) */
	/*{".tar","tar -cf ",N_("Create tarball %s"),N_("Output dir"),1},*/
	{".tar.gz","tar -czf ",N_("Create gzip tarball %s"),N_("Output dir"),1},
	{".tar.bz2","tar -cjf ",N_("Create bzip2 tarball %s"),N_("Output dir"),1},
	{".iso","mkisofs -dDlLNRTUP Created_by_XFce4_desktop -o ",N_("Create isofs %s"),N_("Output dir"),1},
	{NULL,NULL}
};

static
autotype_t autotype []= {
	/* assorted packages (not queued) */
	{".jpg","xffm-root",N_("Set %s as desktop background"),NULL,0},
	{".png","xffm-root",N_("Set %s as desktop background"),NULL,0},
	{".gif","xffm-root",N_("Set %s as desktop background"),NULL,0},
	/* archive file extractions (queued) */
	{".gz","gunzip","gunzip",NULL,1},
	{".bz2","bunzip2","bunzip2 %s",NULL,1},
	{".Z","uncompress","uncompress %s",NULL,1},
	{".ZIP","unzip","unzip %s",N_("Extract into"),1},
	{".zip","unzip","unzip %s",N_("Extract into"),1},
	/* tar stuff, non-compressed: */
	{".tar","xterm -hold -e tar -tf ",N_("Package contents %s"),NULL,0},
	{".tar","tar -xf ",N_("Extract files from %s"),N_("Extract into"),1},
	/* tar stuff, compressed short: */
	{".tgz","tar -xzf ",N_("Extract files from %s"),N_("Extract into"),1},
	{".tgz","tar -tzf ",N_("Package contents %s"),NULL,1}, 					    {".tbz","tar --use-compress-program bunzip2 -xf %s",N_("Extract files from %s"),N_("Extract into"),1},
	{".tbz","xterm -hold -e tar --use-compress-program bunzip2 -tf %s",N_("Package contents %s"),NULL,0},
	/* tar stuff, compressed long: */
	{".tar.gz","tar -xzf ",N_("Extract files from %s"),N_("Extract into"),1},
	{".tar.gz","xterm -hold -e tar -tzf ",N_("Package contents %s"),NULL,0}, 
	{".tar.bz2","tar --use-compress-program bunzip2 -xf %s",N_("Extract files from %s"),N_("Extract into"),1},
	{".tar.bz2","xterm -hold -e tar --use-compress-program bunzip2 -tf %s",N_("Package contents %s"),NULL,0},
	/* cd rom burning */   
	{".iso","burncd -f /dev/acd0 -s max data %s fixate","burncd",NULL,1},
	{".iso","sudo burncd -f /dev/acd0 -s max data %s fixate","sudo burncd",NULL,1},
	{".iso","cdrecord -v dev=ATAPI:0,0,0 ","cdrecord %s",NULL,1},
	{".iso","sudo cdrecord -v dev=ATAPI:0,0,0 ","sudo cdrecord %s",NULL,1},

	/* FreeBSD package management (queued) */
#ifndef __linux__
	{".tgz","pkg_info -d ",N_("Package information %s"),NULL,1},
	{".tbz","pkg_info -d ",N_("Package information %s"),NULL,1},
	
	{".tgz","pkg_info -r ",N_("Package requirements %s"),NULL,1},
	{".tgz","pkg_info -L ","pkg_info -L %s",NULL,1},
	{".tgz","pkg_update ","pkg_update %s",NULL,1},
	{".tgz","sudo pkg_update ","sudo pkg_update %s",NULL,1},
	{".tgz","pkg_add ","pkg_add %s",NULL,1},
	{".tgz","sudo pkg_add ","sudo pkg_add %s",NULL,1},
	{".tgz","pkg_add -f ","pkg_add -f %s",NULL,1},
	{".tgz","sudo pkg_add -f ","sudo pkg_add -f %s",NULL,1},

	{".tbz","pkg_info -r ",N_("Package requirements %s"),NULL,1},
	{".tbz","pkg_info -L ","pkg_info -L %s",NULL,1},
	{".tbz","pkg_update ","pkg_update %s",NULL,1},
	{".tbz","sudo pkg_update ","sudo pkg_update %s",NULL,1},
	{".tbz","pkg_add ","pkg_add %s",NULL,1},
	{".tbz","sudo pkg_add ","sudo pkg_add %s",NULL,1},
	{".tbz","pkg_add -f ","pkg_add -f %s",NULL,1},
	{".tbz","sudo pkg_add -f ","sudo pkg_add -f %s",NULL,1},


	
#endif
#ifdef __linux__
	/* RedHat package management (queued) */
	{".rpm","rpm -q -i -p ",N_("Package information %s"),NULL,1},
	{".rpm","rpm -qR -p ",N_("Package requirements %s"),NULL,1},
	{".rpm","rpm -ql -p ",N_("Package contents %s"),NULL,1},
	{".rpm","rpm -U --percent ","rpm -U %s",NULL,1},
	{".rpm","sudo rpm -U --percent ","sudo rpm -U %s",NULL,1},
	{".rpm","rpm -U --percent --nodeps ","rpm -U --nodeps %s",NULL,1},
	{".rpm","sudo rpm -U --percent --nodeps ","sudo rpm -U --nodeps %s",NULL,1},
	{".rpm","rpm -U --percent --force ","rpm -U --force %s",NULL,1},
	{".rpm","sudo rpm -U --percent --force ","sudo rpm -U --force %s",NULL,1},
	{".rpm","rpm -i --percent ","rpm -i %s",NULL,1},
	{".rpm","sudo rpm -i --percent ","sudo rpm -i  %s ",NULL,1},
	{".rpm","rpm -i --percent --nodeps ","rpm -i --nodeps %s",NULL,1},
	{".rpm","sudo rpm -i --percent --nodeps ","sudo rpm -i --nodeps %s",NULL,1},
	{".rpm","rpm -i --percent --force ","rpm -i --percent --force %s",NULL,1},
	{".rpm","sudo rpm -i --percent --force ","sudo rpm -i --percent --force %s",NULL,1},
	
	/* Debian package management (queued) */
	{".deb","dpkg -i ","dpkg -i %s",NULL,1},
	{".deb","sudo dpkg -i ","sudo dpkg -i %s",NULL,1},
#endif
	/* assorted packages (not queued) */
	/*{"","","",NULL},*/
	{NULL,NULL}
};

/* Use as many different names for as many different
 * autotype menu entries for one file extension type. */
static
char *auto_C_name []={
   "ejecutar1",
   "ejecutar2",
   "ejecutar3",
   "ejecutar4",
   "ejecutar5",
   "ejecutar6",
   "ejecutar7",
   "ejecutar8",
   "ejecutar9",
   "ejecutar10",
   NULL
};

static int auto_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    if (childFD >= 0 && strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics(autotype_widgets_p,"xfce/warning",_("Sudo password requested"),"\n", NULL);
	p=xffm_get_password(autotype_widgets_p,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    if (line[0] != '\n') print_diagnostics(autotype_widgets_p,"xfce/error", line, NULL);
    return TRUE;
}

static int rwStdout (int n, void *data){
  char *line;
  static int count=0;
  if (n) return TRUE; 
  else{
	  line = (char *) data;
	  if (line[0]=='%') {
		  print_diagnostics(autotype_widgets_p,NULL,".",NULL);
		  if (++count == 80) {
		     print_diagnostics(autotype_widgets_p,NULL,"\n",NULL);
		     count=0;
		  }
	  }
	  else {
		  print_diagnostics(autotype_widgets_p,"nonverbose",line,NULL);
		  count=0;
	  }
  }
  return TRUE;
}

/* function called when child is dead */
static void rwForkOver (pid_t pid)
{
  autotype_fork_obj=NULL;
  /* this hack should no longer be necessary, since tubo signals
   * the child with SIGCONT before waiting... */
  /* another wait just in case the one in tubo misses 
   * (shouldn't happen, but it does)*/
  /*waitpid(pid, &status, WNOHANG);*/

  print_diagnostics(autotype_widgets_p,NULL,_("Command done"),"\n",NULL);
  print_status(autotype_widgets_p,"xfce/info",_("Command done"),NULL);
}

static void tubo_cmd(void *data){
	char **argv=(char **)data;
	int i=0;
	int status;
	usleep(5000);
	/*argv[i++]="sh";	argv[i++]="-c";*/
	/*for (i=0;argv[i]!=NULL;i++) fprintf(stdout,"--arg[%d]=%s\n",i,argv[i]);
	  fflush(NULL);sleep(2);*/ 
	i=fork();
	if (i<0){
		fprintf(stderr,"unable to fork\n");
	       	_exit(123);
	}
	if (!i){
           if (execvp (argv[0], argv) == -1) {
	     fprintf(stdout,"%s: %s\n",strerror(errno),argv[0]);
	     /*fprintf(stdout,"parentpid=%d\n",parent_pid);*/
	   }
	   fflush(NULL);
	   sleep(1);
	   _exit(123);
	} else usleep(5000);
	wait(&status);
	fflush(NULL);
	sleep(1);
	_exit(123);
}



static
void remove_menu_item (GtkWidget *widget, gpointer data){
    TRACE("removing 0x%x",(unsigned)widget);
    gtk_widget_destroy(widget);
}

static 
GtkWidget * 
create_menu_entry(		widgets_t *widgets_p,
				char *name,
				char *label,
				GtkWidget *parent,
				void *callback,
				void *data,
				int offset){
  GtkWidget *w,*image;
  w = gtk_image_menu_item_new_with_label (label);
  if (offset <0) gtk_container_add (GTK_CONTAINER (parent), w);
  else {
	gtk_menu_shell_insert(GTK_MENU_SHELL(parent), w, offset);
  }
  
  /* get the application icon would look nice */
  {
      /*GdkPixbuf *p=load_stock_icon("gtk-execute",GTK_ICON_SIZE_MENU);*/
      GdkPixbuf *p=icon_tell(widgets_p, GTK_ICON_SIZE_MENU,"xfce/stock_run");
      if (p) {
	image = gtk_image_new_from_pixbuf (p);
	g_object_unref(p);
      } else image=NULL;
  }
  /*image = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_MENU);*/
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (w), image);
  g_signal_connect ((gpointer) w, "activate", G_CALLBACK (callback), data);
  TRACE("created %s at 0x%x window",name,(unsigned)widgets_p->window);
  /*gtk_widget_show(w);*/
  GLADE_HOOKUP_OBJECT (widgets_p->window, w, name);
  return w;
}

static
int 
set_auto_command(			widgets_t *widgets_p,
					int j,
					GtkWidget *popup,
					const gchar *name,
					const gchar *alt_label,
					const gchar *app, 
					const gchar *path,
					const gchar *querypath,
					const gboolean *queued,
					const gchar *output_arg,
					const gchar *output_ext)
{
    int jj;

    gchar *dirname=g_path_get_dirname(path);
    gchar *basename=g_path_get_basename(path);
    
    TRACE("set_auto_command() now... %s",app);
     if (MIME_is_valid_command(app)){
	      GtkWidget *label;
	      gchar *old_text, *command ;
	      GtkWidget *a=lookup_widget(widgets_p->window,name);
	      if (strncmp(app,"sudo ",strlen("sudo "))==0){
		    if (getuid()==0) return j; /* don't sudoize root */
		    if (!strlen(app+strlen("sudo ")) || !MIME_is_valid_command(app+strlen("sudo "))) return j;
	      }
	      
	      label = gtk_bin_get_child(GTK_BIN(a));
	      if (alt_label){
		 gtk_label_set_text((GtkLabel *)label,my_utf_string(alt_label));
	      } else {
		  /* allow mixed utf8-eucjp  paths */
		  gchar *new_label;
		  gchar *fname=g_strdup(my_utf_string(basename));
		  if (queued && *queued && output_arg) new_label=g_strdup(my_utf_string(app));
		  else new_label=g_strdup(MIME_mk_command_line(app,fname,FALSE,FALSE));
		  gtk_label_set_text((GtkLabel *)label,my_utf_string(new_label));
		  g_free(new_label);
		  g_free(fname);
	      }

	      

	      if (queued && *queued && output_arg) command=g_strdup(app);
	      else {
		  if (strncmp(path,"//",strlen("//"))==0){
		      gchar *netpath=g_build_filename(XF_SMBget_netfile_cache_dir(),strrchr(path,'/')+1,NULL);
		      command=g_strdup(MIME_mk_command_line(app,netpath,FALSE,FALSE));
		      g_free(netpath);
		  }
		  else {
		      /* this is to use relative paths for arguments for all
		       * commands except those where the output directory (or
		       * workdir) is requested from the user.
		       * */
		      if (querypath) 
			  command=g_strdup(MIME_mk_command_line(app,path,FALSE,FALSE));
		      else
			  command=g_strdup(MIME_mk_command_line(app,basename,FALSE,FALSE));
		  }
	      }
	      
	      /* check for duplicates */
	      {
		gint argcp1;
		gchar **argvp1;
		GError *error=NULL;
		 if (!g_shell_parse_argv ((const gchar *)command,&argcp1,&argvp1,&error)){
		    g_free(command);
		    g_error_free(error);
		    g_strfreev(argvp1);
		    TRACE("!g_shell_parse_argv at gui_autostuff");
		    return j;
		 }
	         for (jj=0;jj<j;jj++){
		   gboolean is_duplicate=TRUE;
		   gint ac,argcp2;
		   gchar **argvp2;
		   gchar *set_command=g_object_get_data(G_OBJECT(lookup_widget(widgets_p->window,auto_C_name[jj])), "command");
		   TRACE("j=%d: %s == %s\n",jj,set_command,command);
		   if (!g_shell_parse_argv ((const gchar *)set_command,&argcp2,&argvp2,&error)){
		    g_free(basename);
		    g_free(command);
		    g_error_free(error);
		    g_strfreev(argvp2);
		    TRACE("!g_shell_parse_argv at gui_autostuff");
		    return j;
		   }
		   if (argcp2 != argcp1) {
		    is_duplicate=FALSE;
		   } else for (ac=0; ac<argcp2; ac++){
		    if (strcmp(argvp2[ac],argvp1[ac])){
			is_duplicate=FALSE;
			break;
		    }
		   }
		   TRACE("0x%x, 0x%x\n",(unsigned)argvp1,(unsigned)argvp2);
		
		   g_strfreev(argvp2);
		   argvp2=NULL;
		   /*if (strcmp(set_command,command)==0)*/
		   if (is_duplicate) {
		      g_free(basename);
		      g_free(command);
		    TRACE("is_duplicate at gui_autostuff");
		      return j;
		   }
		 } /* end for */
		 g_strfreev(argvp1);
		 argvp1=NULL;
	      }
	      /* OK, by now we know the command is not duplicated...*/
	      /* now let's free up any left over data from previous
	       * generated menus... */
	      
	      if ((old_text=g_object_get_data(G_OBJECT(a),"command")) != NULL) {
		  g_object_set_data(G_OBJECT(a),"command",NULL);
		  g_free(old_text);
	      }
	      if ((old_text=g_object_get_data(G_OBJECT(a),"workdir")) != NULL) {
		  g_object_set_data(G_OBJECT(a),"workdir",NULL);
		  g_free(old_text);
	      }
	      if ((old_text=g_object_get_data(G_OBJECT(a),"output_arg")) != NULL) {
		  g_object_set_data(G_OBJECT(a),"output_arg",NULL);
		  g_free(old_text);
	      }
	      g_object_set_data(G_OBJECT(a),"command",(gpointer)command);
	      g_object_set_data(G_OBJECT(a),"workdir",(gpointer)dirname);
	      g_object_set_data(G_OBJECT(a),"querypath",(gpointer)querypath);
	      g_object_set_data(G_OBJECT(a),"queued",(gpointer)queued);
	      if (output_arg) {
		  g_object_set_data(G_OBJECT(a),"output_arg",g_strdup(output_arg));
	      }
	      TRACE("command=%s, output_arg=%s",command,output_arg);
	      g_object_set_data(G_OBJECT(a),"output_ext",(gpointer)output_ext);
	      TRACE("now showing %s, active widget=0x%x",
		      name,(unsigned)widgets_p->window);
	      showit(widgets_p->window, name);
	      j++;
     }
     g_free(basename);
     /*else g_warning("%s is not valid command",app);*/
     return j;
}

static
gchar *
alt_menu_label(			const gchar *label, const gchar *path,const gchar *extension)
{/* chinese friendly translations: */
    gchar *alt_label=NULL;
    if (label) 
    { 
	gchar *fffname=g_path_get_basename(path);
	gchar *fname=g_strdup(my_utf_string(fffname));
	gchar *ffname=g_strconcat(fname,extension,NULL);
	g_free(fffname);
	if (strstr(label,"%s")) {
	    alt_label=g_strdup_printf(my_utf_string(label),ffname);
	} else {
	    alt_label=g_strdup_printf("%s %s",my_utf_string(label),ffname);
	}
	g_free(fname);
	g_free(ffname);   
    }
    return alt_label;
}


