
/*
 * 
 * copywrite 2003-4 under GNU/GPL which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>
#include <signal.h>

#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "actions_lib.h"


#include "tubo.h"

G_MODULE_EXPORT
char *src_host = NULL;


#include "rcp.i"

G_MODULE_EXPORT
int xffm_scp(widgets_t *widgets_p, const gchar **srcs, const gchar *tgt){
    static char *argument[1024];
    gchar *arg1=NULL;
    int i=0,j,k;
    gchar *g_tgt;
    struct stat st;
   
    WIDGET_P_CHECK;

    rcp_widgets_p = widgets_p;

    if (rcp_widgets_p->tubo_object){
	print_diagnostics(rcp_widgets_p,"xfce/error",strerror(EBUSY),NULL);
	return FALSE;
    }
    exit_status=FALSE;
    /*if (!src_host) return FALSE;*/
    if (!tgt) return FALSE;

    if (stat(tgt,&st) < 0){
	    printf("invalid target!\n");
	    return FALSE;
    }
    if (S_ISDIR(st.st_mode)) g_tgt = g_strdup(tgt);
    else g_tgt=g_path_get_dirname(tgt);
    if (!g_tgt) return FALSE;

    if (!srcs[0]) return FALSE;

    argument[i++]="scp";
    argument[i++]="-v";
    argument[i++]="-r";
    argument[i++]="-p";
    argument[i++]="-C";
    argument[i++]="-B";
    
    show_text(rcp_widgets_p->diagnostics);
    print_diagnostics(rcp_widgets_p,NULL,"scp -v -r -p -C -B ",srcs[0],"....\n",NULL);
    
    k=i;
    force_override=FALSE;

    for (j=0;srcs[j] && j < 1023;j++){
	    if (strchr(srcs[j],' ')!=NULL){
		    print_diagnostics(rcp_widgets_p,"xfce/error",_("Cannot scp files with embedded spaces"),":\n",srcs[j],"\n",NULL);
		    continue;
	    }
	    if (!arg1){
		    argument[i++] = arg1 = g_strdup(srcs[j]);
		    //if (src_host) from cutnpaste
		    //argument[i++] = arg1 = g_strconcat(src_host,":",srcs[j],NULL);
	    } else {
		    argument[i++] = g_strdup(srcs[j]);
		    //if (src_host) from cutnpaste
		    //argument[i++] = g_strconcat(src_host,":",srcs[j],NULL);
	    }
	    argument[i]=NULL;
	    {
		gchar *b=g_path_get_basename(srcs[j]);
		gchar *f=g_strconcat(g_tgt,"/",b);
		g_free(b);
		if (access(f,F_OK)==0){
		   /* externs from cpy.c: */	
		   int r= xffm_warn_target_exists(rcp_widgets_p, f, NULL);
		   if (r==DLG_CANCEL) {
			DBG("scp cancelled..");
		       goto w_cancel;
		   }
		   if(r == DLG_WASTE)
		   {
			if(!xffm_waste(rcp_widgets_p, f))
			{
			    g_warning("Move to wastebasket failed");
w_cancel:
			    g_free(f);f=NULL;
			    goto cancel_it;
			}
		   }
		   g_free(f);f=NULL;
		}
	    }
    }
    argument[i++]=g_tgt;
    
    argument[i++]=NULL;

#ifdef DEBUG
    printf("Tubo: ");
    for (j=0;argument[j];j++){
	    printf("%s ",argument[j]);
    }
    printf("\n");
#endif
	
    show_stop(rcp_widgets_p);
	

    rcp_widgets_p->tubo_object = 
		Tubo(fork_function, 
				(void *)argument, 
				fork_finished_function, 
				&childFD, 
				operate_stdout, 
				operate_stderr,0,TRUE);
    	
    g_timeout_add_full(0,260, (GtkFunction) watch_stop,NULL, NULL);
    	
    Gpid = TuboPID(rcp_widgets_p->tubo_object);
    while (rcp_widgets_p->tubo_object) {
	while (gtk_events_pending()) gtk_main_iteration();
	usleep(150);
    }
cancel_it:
    chdir(GETWD);
    for (j=k;argument[j];j++) g_free(argument[j]);
    return(1);
}


