
static GList *remove_list = NULL;
/*static GList *remote_remove_list = NULL;*/
static gboolean waste = TRUE;
static gboolean unlink_mode = FALSE;
static gboolean all;
static gboolean cancel_remove;
static gchar *remote_module=NULL;
static gboolean invalid_input = FALSE;
static gboolean on_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer data);
static void on_remove_no_activate(GtkButton * button, gpointer data);
static void on_remove_yes_activate(GtkButton * button, gpointer data);
static void on_waste_yes_activate(GtkButton * button, gpointer data);


static int subcheck_select(record_entry_t *en){
    if(!IS_PATH(en->type)&&!en->module)	return FALSE;
    if(strstr(en->path, "/..Wastebasket")||IS_TRASH_TYPE(en->type)|| en->module){
	unlink_mode = TRUE;
	if (en->module) remote_module=g_strdup(en->module);
    }
    if (IS_PATH(en->type)&&remote_module) invalid_input=TRUE;
    return TRUE;

}

#if 0
static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    record_entry_t *en;
    GtkTreeRowReference *reference;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en || invalid_input) return;
    if (!subcheck_select(en)) return;
    reference = gtk_tree_row_reference_new(treemodel, path);
    remove_list = g_list_append(remove_list, reference);    
    return;
}
#endif

static void make_dialog(widgets_t *widgets_p, gboolean question)
{
    record_entry_t *en;
    gchar *mess=NULL;
    gchar *mess1=NULL;

    WIDGET_P_CHECK;

    if(!remove_list) return;
    if(widgets_p->remove) {
	g_warning("widgets_p->remove != NULL");
	return;
    }

    widgets_p->stop = FALSE;
    hide_stop(widgets_p);
    
    widgets_p->remove = xffm_create_remove(widgets_p);
    place_dialog(widgets_p->window, widgets_p->remove);

    g_signal_connect(lookup_widget(widgets_p->remove, "cancelbutton"), "clicked", G_CALLBACK(on_remove_no_activate), widgets_p);
    g_signal_connect(lookup_widget(widgets_p->remove, "wastebutton"), "clicked", G_CALLBACK(on_waste_yes_activate), widgets_p);
    g_signal_connect(lookup_widget(widgets_p->remove, "removebutton"), "clicked", G_CALLBACK(on_remove_yes_activate), widgets_p);

    
    g_signal_connect(widgets_p->remove, "delete-event", G_CALLBACK(on_destroy_event), widgets_p);
    g_signal_connect(widgets_p->remove, "destroy-event", G_CALLBACK(on_destroy_event), widgets_p);

    /* dialog specifics */
 
    /* deleting from a wastebasket forces unlink */
    if(unlink_mode) hideit(widgets_p->remove, "wastebutton");
 
    if(g_list_length(remove_list) < 2)
    {
	hideit(widgets_p->remove, "togglebutton1");
    }
    if(question)
    {
	mess1=g_strdup(" ");
	hideit(widgets_p->remove, "warning");
    }
    else
    {
	mess1=g_strconcat(" ",_("Try again?"),"\n",NULL);
	hideit(widgets_p->remove, "question");
    }

    en = (record_entry_t *)remove_list->data;
    
    if (!en){
	g_warning("critical: en==NULL");
    }

    
    
    {
	gchar *b=g_path_get_basename(en->path);
        mess=g_strconcat(mess1,b,"\n",
			    "(",time_to_string(en->st->st_mtime)," ",
			    sizetag((off_t)en->st->st_size, -1),")",
			    NULL); 
	g_free(b);
    }

    {
      GdkPixbuf	*pb;
      GtkImage *image=(GtkImage *)lookup_widget (widgets_p->remove, "adicon");
      pb = icon_tell(widgets_p, MEDIUM, "xfce/waste_basket_full");
      if (pb) {
	gtk_image_set_from_pixbuf (image, pb);
	g_object_unref (G_OBJECT (pb));
      }
    }
    gtk_label_set_text((GtkLabel *) 
		    lookup_widget(widgets_p->remove,"label16"), 
		    _("Remove"));
   gtk_label_set_text((GtkLabel *) 
		    lookup_widget(widgets_p->remove, "label20"), 
		    my_utf_string(mess));
    g_free(mess);mess=NULL;
    g_free(mess1);mess1=NULL;
    gtk_widget_realize(widgets_p->remove);
    if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	  gtk_widget_grab_focus (lookup_widget(widgets_p->remove,"removebutton"));	    
    }
    else if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"waste")==0){
	  gtk_widget_grab_focus (lookup_widget(widgets_p->remove,"wastebutton"));	    
    }
    if (widgets_p->type != DESKVIEW_TYPE){
        gtk_window_set_transient_for(GTK_WINDOW(widgets_p->remove), GTK_WINDOW(widgets_p->window));
    } 
    gdk_window_set_keep_above (widgets_p->remove->window,TRUE);


    gtk_widget_show(widgets_p->remove);
    gtk_main();

}

static void close_it(widgets_t *widgets_p)
{
    WIDGET_P_CHECK;
    gtk_main_quit();
    gtk_widget_destroy(widgets_p->remove);
    widgets_p->remove = NULL;
}

/*****    dialog callbacks   *****/

static
gboolean on_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer data)
{
    widgets_t *widgets_p = (widgets_t *) data;
    WIDGET_P_CHECK;

    close_it(widgets_p);
    return TRUE;
}


static void on_remove_no_activate(GtkButton * button, gpointer data)
{
    GtkWidget *check;
    widgets_t *widgets_p = (widgets_t *) data;

    WIDGET_P_CHECK;
    /*printf("TRACE:remove no\n"); */
    check = lookup_widget(widgets_p->remove, "togglebutton1");
    all = gtk_toggle_button_get_active((GtkToggleButton *) check);
    close_it(widgets_p);

  loop:

    remove_list = g_list_remove(remove_list, remove_list->data);

    if(all && remove_list) goto loop;
    if(remove_list) make_dialog(widgets_p, TRUE);

}


static void do_the_remove(GtkButton * button, gpointer data, gboolean unlink_mode)
{
    GtkWidget *check;
    int method = WASTE;
    record_entry_t *en;
    gboolean result = FALSE;
    widgets_t *widgets_p = (widgets_t *) data;
    
    WIDGET_P_CHECK;
    
    cancel_remove = FALSE;
    check = lookup_widget(widgets_p->remove, "togglebutton1");
    all = gtk_toggle_button_get_active((GtkToggleButton *) check);

    close_it(widgets_p);
    if (unlink_mode) {
        print_status(widgets_p,"xfce/warning", _("Removing"),"...", NULL);
	method = UNLINK;
    }
    else {
	method = WASTE;
    }



  loop:
    en=(record_entry_t *)remove_list->data;
    
    switch (method)
    {
	case WASTE:
	    TRACE("TRACE:remove WASTE %s\n",en->path);
	    if(strstr(en->path, "..Wastebasket"))
	    {
#ifdef ENOTSUP
		errno = ENOTSUP;	/* Not supported message */
#else 
#ifdef EOPNOTSUPP
		errno = EOPNOTSUPP;
#else
		errno = ENODEV;
#endif
#endif
		result = FALSE;
	    }
	    else
		result = xffm_waste(widgets_p, en->path);
	    break;
	case UNLINK:
	    if (remote_module){
	      TRACE("TRACE: schedule rm %s\n",en->path);
	      result=TRUE; /* schedule ok */	  
	    }
	    else /* local path */
	    {
	      TRACE("TRACE:remove UNLINK %s\n",en->path);
	      show_stop(widgets_p);
	      result = xffm_unlink(widgets_p, en->path);
	    }
	    break;
	default:
	    g_warning("!UNLINK && !WASTE");
	    return;
    }
    if(cancel_remove)
    {
	print_status(widgets_p,"xfce/error",	strerror(ECANCELLED),NULL);	
	remove_list = g_list_remove(remove_list, remove_list->data);
	hide_stop(widgets_p);
	return;
    }

    if(!result && errno == ENOENT) result = TRUE;
    if(!result && !all)
    {
	make_dialog(widgets_p, FALSE);
	return;
    }
    
    TRACE("wof");
    if (remote_module){
	TRACE("wof:function_rational on_remove");
	function_rational("plugins",remote_module,remove_list,widgets_p,"on_remove");
    }

    
    remove_list = g_list_remove(remove_list, remove_list->data);
    
    if(all && remove_list) goto loop;
    if(remove_list) make_dialog(widgets_p, TRUE);
    hide_stop(widgets_p);
   

    print_status(widgets_p,"xfce/info", _("Command done"), NULL);
    return;
}

static void on_remove_yes_activate(GtkButton * button, gpointer data)
{
    do_the_remove(button,data,TRUE);
    return;
}

static void on_waste_yes_activate(GtkButton * button, gpointer data)
{
    do_the_remove(button,data,FALSE);
    return;
}

/**************/

static char dlg_result;


static void on_single_rm_no_activate(GtkButton * button, gpointer data)
{
    widgets_t *widgets_p=(widgets_t *)data;
    WIDGET_P_CHECK;
    dlg_result = DLG_NO;
    close_it(widgets_p);
}


static void on_single_rm_yes_activate(GtkButton * button, gpointer data)
{
    widgets_t *widgets_p=(widgets_t *)data;
    WIDGET_P_CHECK;
    dlg_result = DLG_YES;
    waste = FALSE;
    close_it(widgets_p);
}

static void on_single_waste_yes_activate(GtkButton * button, gpointer data)
{
    widgets_t *widgets_p=(widgets_t *)data;
    WIDGET_P_CHECK;
    dlg_result = DLG_YES;
    waste = TRUE;
    close_it(widgets_p);
}

static void make_single_rm_dialog(widgets_t *widgets_p, const gchar *nfile, const gchar *ofile, gboolean err)
{
    gchar *mess=NULL,*mess1=NULL;
    struct stat st;
    if(widgets_p->remove) assert_not_reached();
    if (!nfile) assert_not_reached();

    waste = TRUE;
    widgets_p->remove = xffm_create_remove(widgets_p);
    place_dialog(widgets_p->window, widgets_p->remove);

    g_signal_connect(lookup_widget(widgets_p->remove, "cancelbutton"), 
		    "clicked", G_CALLBACK(on_single_rm_no_activate), 
		    widgets_p);
    g_signal_connect(lookup_widget(widgets_p->remove, "removebutton"), 
		    "clicked", G_CALLBACK(on_single_rm_yes_activate), 
		    widgets_p);
    g_signal_connect(lookup_widget(widgets_p->remove, "wastebutton"), 
		    "clicked", G_CALLBACK(on_single_waste_yes_activate), 
		    widgets_p);

    g_signal_connect(widgets_p->remove, "delete-event", 
		    G_CALLBACK(on_destroy_event),  
		    widgets_p);
    g_signal_connect(widgets_p->remove, "destroy-event", 
		    G_CALLBACK(on_destroy_event),  
		    widgets_p);

    /* dialog specifics */

    if(err)
    {
	hideit(widgets_p->remove, "question");	
	mess1=g_strconcat(" ",_("Try again?"),"\n",NULL);
	hideit(widgets_p->remove, "question");
    } else {
	hideit(widgets_p->remove, "warning");
	mess1=g_strdup(" ");
    }


    /* working in a wastebasket forces unlink */
    if(ofile && strstr(ofile,"../Wastebasket"))
    {
	hideit(widgets_p->remove, "wastebutton");
    }
   
    {
      GdkPixbuf	*pb;
      GtkImage *image=(GtkImage *)lookup_widget (widgets_p->remove, "adicon");
      pb = icon_tell(widgets_p, MEDIUM, "xfce/waste_basket_full");
      if (pb) {
	gtk_image_set_from_pixbuf (image, pb);
	g_object_unref (G_OBJECT (pb));
      }
    }

    
    lstat(nfile,&st);
   
    if (ofile){
       gtk_label_set_text((GtkLabel *) 
		    lookup_widget(widgets_p->remove,"label22"), 
		    _("Overwrite"));
    } else {
       gtk_label_set_text((GtkLabel *) 
		    lookup_widget(widgets_p->remove,"label22"), 
		    _("Remove"));
   
    }
    
       gtk_label_set_text((GtkLabel *) 
		    lookup_widget(widgets_p->remove,"label16"), 
		    _("Remove"));
   
    {
	gchar *b=g_path_get_basename(nfile);
	mess=g_strconcat(mess1, b,"\n",
			    "(",time_to_string(st.st_mtime)," ",
			    sizetag((off_t)st.st_size, -1),")",
			    NULL); 
	g_free(b);
    }

    gtk_label_set_text((GtkLabel *) 
		    lookup_widget(widgets_p->remove,"label20"), 
		    mess);
    
    g_free(mess);mess=NULL;
    g_free(mess1);mess1=NULL;
    gtk_widget_realize(widgets_p->remove);

    if (widgets_p->type != DESKVIEW_TYPE){
	gtk_window_set_transient_for(GTK_WINDOW(widgets_p->remove), 
		    GTK_WINDOW(widgets_p->window));
    }
    gdk_window_set_keep_above (widgets_p->remove->window,TRUE);
    hideit(widgets_p->remove, "togglebutton1");
    if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	  gtk_widget_grab_focus (lookup_widget(widgets_p->remove,"removebutton"));	    
    }
    else if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"waste")==0){
	  gtk_widget_grab_focus (lookup_widget(widgets_p->remove,"wastebutton"));	    
    }
    gtk_widget_show(widgets_p->remove);
    gtk_main();
    return ;

}



