/*
 * Copyright (C) 2005 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"


G_MODULE_EXPORT
void save_to_go_history (char *p)
{				
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *f=g_build_filename(xdg_dir,GOTO_DBH_FILE,NULL);

    g_free(xdg_dir);
    XFC_save_to_history(f,p);
    g_free(f);
}

G_MODULE_EXPORT
void save_workdir_history(char *p){
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *f=g_build_filename(xdg_dir,WORKDIR_DBH_FILE,NULL);

    g_free(xdg_dir);
    XFC_save_to_history(f,p);
    g_free(f);
}

G_MODULE_EXPORT
int extra_key_completion (gpointer data)
{
    	GtkEntry *entry;
	gboolean interm;
	gboolean hold;
      	GtkWidget *check;
      	gchar *choice ;
	widgets_t *widgets_p=(widgets_t *)data;
	
	if (!widgets_p){
	    g_warning("!widgets_p");
	    return FALSE;
	}
    	if (widgets_p->input != RUN_INPUT && widgets_p->input !=  RUN_DOUBLE_CLICK) return FALSE;
	    
	
	entry=(GtkEntry *)lookup_widget(widgets_p->window,"input_entry");
      	check = lookup_widget(widgets_p->window,"checkbutton3");
      	choice = g_strdup((gchar *)gtk_entry_get_text((GtkEntry *)entry));

	xffm_recover_flags(choice, &interm, &hold);
        gtk_toggle_button_set_active ((GtkToggleButton *)check,hold);
	gtk_button_set_label((GtkButton *) check, _("Hold"));
      	check = lookup_widget(widgets_p->window,"checkbutton1");
        gtk_toggle_button_set_active ((GtkToggleButton *)check,interm);	
	TRACE("at extra_key_completion!\n");
	return FALSE;
}

G_MODULE_EXPORT
int 
get_entry_from_reference (	GtkTreeView * treeview, 
				GtkTreeRowReference * reference, 
				GtkTreeIter * iter, 
				record_entry_t ** en_p)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath = gtk_tree_row_reference_get_path(reference);
    if(!treepath || !treemodel)	return FALSE;
    if(!gtk_tree_model_get_iter(treemodel, iter, treepath))
	return FALSE;
    gtk_tree_path_free(treepath);
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, en_p, -1);
    return TRUE;
}

