/*
 * gtk_prop.c
 *
 * Copyright (C) 1999 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
 * Heavily modified as part of the Xfce project (http://www.xfce.org)
 *
 * Edscott Wilson Garcia Copyright 2001-2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define noRECURSIVE_BUTTON
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <limits.h>
#include <grp.h>
#include <pwd.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "types.h"
#include "constants.h"

#include "primary.h"
#include "actions_lib.h"

#include "properties-module.h"

#define box_pack_start(box,w) \
	gtk_box_pack_start(GTK_BOX(box),w,TRUE,FALSE,0)
#define box_pack_end(box,w) \
	gtk_box_pack_end(GTK_BOX(box),w,TRUE,FALSE,0)

#define X_PAD 8
#define Y_PAD 1
#define TBL_XOPT GTK_EXPAND
/* flags
 */
#define IS_MULTI		1
#define IS_STALE_LINK	2
/* question dialogs: */
#define DLG_OK			0x11
#define DLG_CLOSE		0x120
#define DLG_ALL			0x140
#define DLG_SKIP		0x180

#define DLG_RC_CANCEL		0
#define DLG_RC_OK		1
#define DLG_RC_ALL		2
#define DLG_RC_CONTINUE		3
#define DLG_RC_SKIP		4
#define DLG_RC_DESTROY		5
#define DLG_RC_RECURSIVE	6

/* */
#define DLG_OK_CANCEL	(DLG_OK|DLG_CANCEL)
#define DLG_YES_NO	(DLG_YES|DLG_NO)
/* */

typedef struct
{
    GtkWidget *top;
    GtkWidget *user;
    GtkWidget *group;
    struct stat *st;
    int result;
    int type;
}
dlg;
typedef struct row_t{
	GtkWidget *w[5];
	gboolean flag;
}row_t;



#include "properties-module.i"

G_MODULE_EXPORT
void do_prop(widgets_t *widgets_p, GList *selection_list)
{
    record_entry_t *en=NULL;
    struct stat st,*sp;
    int select_count;
    /*const gchar *working_directory=g_get_home_dir();*/
    
 
    if (!selection_list) return;
    {
	GList *tmp;
	sp=NULL;
	for(tmp=selection_list; tmp; tmp=tmp->next) {
	    select_list = g_list_append(select_list,tmp->data);
	}
    }
    select_count=g_list_length(select_list);
    
    if(!select_count)
    {
	if (widgets_p) print_diagnostics(widgets_p,"xfce/error", strerror(EINVAL), NULL);
	return;
    }
    
    if (select_count == 1) {
	en = (record_entry_t *)selection_list->data;
       
       if(!en || !IS_PATH(en->type))
       {
	if (widgets_p) print_diagnostics(widgets_p,"xfce/error", strerror(EINVAL), NULL);
	g_list_free(select_list);select_list=NULL;
	return;
       }	    
       memcpy(&st, en->st, sizeof(struct stat));
       sp=&st;
    }     
    switch (xf_dlg_prop(widgets_p, en, sp))
    {
	case DLG_RC_OK:
	  if (en){
	    /*en->st->st_mtime=0;*/
	    /* argument variable must be thread safe */  
	    char argument_s[64];	  
	    if(en->st->st_mode != st.st_mode && !IS_BROKEN_LNK(en->type))
	    {
		/* chmod() on a symlink itself isn't possible */
		if(chmod(en->path, st.st_mode) == -1)
		{
		    sprintf(argument_s,"0%o",st.st_mode & 0777);
		    if (!xffm_try_sudo(widgets_p,"chmod",argument_s,en->path)){
		    }
		    else
		    {
			en->st->st_mode = st.st_mode;
		    }
		}
		else
		{
		    en->st->st_mode = st.st_mode;
		}
	    }
	    if((en->st->st_uid != st.st_uid) || (en->st->st_gid != st.st_gid))
	    {
		if(chown(en->path, new_owner, new_group) == -1)
		{
		    sprintf(argument_s,"%d:%d",st.st_uid,st.st_gid);
		    if (!xffm_try_sudo(widgets_p,"chown",argument_s,en->path)){
		    }
		    else
		    {
			en->st->st_uid = st.st_uid;
			en->st->st_gid = st.st_gid;
		    }
		}
		else
		{
		    en->st->st_uid = st.st_uid;
		    en->st->st_gid = st.st_gid;
		}
	    }
	  } else if (!sp) {
		char argument_s[64];	  
		GList *tmp;
		struct stat st;
	        for (tmp=select_list;tmp; tmp=tmp->next){
			record_entry_t *en=(record_entry_t *)tmp->data;
			/*en->st->st_mtime=0;*/
			if (row_chown.flag) {
				if (chown(en->path,new_owner,-1)==-1) {
				    sprintf(argument_s,"%d",new_owner);
				    xffm_try_sudo(widgets_p,"chown",argument_s,en->path);
				}
			}
			if (row_chgrp.flag) {
				if (chown(en->path,-1,new_group)==-1){
				    sprintf(argument_s,"%d",new_group);
				    xffm_try_sudo(widgets_p,"chgrp",argument_s,en->path);
				}
			}
			if (u_row.flag && stat(en->path,&st)>=0) {
				st.st_mode &= (S_IRWXO | S_IRWXG);
				st.st_mode |= new_u_m;
				if(chmod(en->path, st.st_mode) == -1)	{
				    sprintf(argument_s,"0%o",st.st_mode & 0777);
		    		    xffm_try_sudo(widgets_p,"chmod",argument_s,en->path);
				}
			}
			if (g_row.flag &&  stat(en->path,&st)>=0) {
				st.st_mode &= (S_IRWXU | S_IRWXO);
				st.st_mode |= new_g_m;
				if(chmod(en->path, st.st_mode) == -1)	{
				    sprintf(argument_s,"0%o",st.st_mode & 0777);
		    		    xffm_try_sudo(widgets_p,"chmod",argument_s,en->path);
				}
			}
			if (o_row.flag &&  stat(en->path,&st)>=0) {
				st.st_mode &= (S_IRWXU | S_IRWXG);
				st.st_mode |= new_o_m;
				if(chmod(en->path, st.st_mode) == -1)	{
				    sprintf(argument_s,"0%o",st.st_mode & 0777);
		    		    xffm_try_sudo(widgets_p,"chmod",argument_s,en->path);
				}
			}
		}	
	  }		  

	  break;
	case DLG_RC_CANCEL:
	default:
	    break;
    }
    g_list_free(select_list);select_list=NULL;

    if (widgets_p && widgets_p->type == TREEVIEW_TYPE){
	(*xffm_details->arbol->local_monitor)(TRUE);
    }
    return;

}

G_MODULE_EXPORT
xfprop_functions *module_init(void){
    /*if (xfprop_fun) return xfprop_fun; (deallocate at main)*/
#ifdef ENABLE_NLS
    /* This is required for UTF-8 at least - Please don't remove it */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif
    xfprop_fun = g_new0 (xfprop_functions,1);
    if (!xfprop_fun) g_assert_not_reached();
    xfprop_fun->do_prop = do_prop;
    
    return xfprop_fun;
}

