static xfdir_t bookshelf_xfdir;

static
xfdir_t *
private_get_xfdir(	record_entry_t *en){
  	glob_t dirlist;
	int i;
    	gchar *bm_dir;
	gchar *globstring;
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);

	bm_dir = g_build_filename(xdg_dir,BOOKMARK_DIR,NULL);
	g_free(xdg_dir);
	
	globstring = g_strconcat(bm_dir,G_DIR_SEPARATOR_S,"*.bm.dbh",NULL);

	if (glob (globstring, GLOB_ERR, NULL, &dirlist) != 0) {
	   TRACE("%s: no match", globstring);
	   return NULL;
	} else {
	    int j,count=0;
	   TRACE("Files found=%d",dirlist.gl_pathc);
	   if (!dirlist.gl_pathc) return NULL;
	   
	   for (i = 0; i < dirlist.gl_pathc; i++){
	      gchar *p,*g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if(!strstr(g,".bm.dbh")) {
		  g_free(g);
		  continue;
	      }
	      p=strstr(g,".bm.dbh");
	      *p=0;
	      g_free(g);g=NULL;
	      count++;
	   }
	   /* add default bookmark file */
	   count++;
	   bookshelf_xfdir.gl = (dir_t *) malloc(count * sizeof(dir_t));
	   bookshelf_xfdir.pathc=count;
	   for (i = 0,j=0; i < dirlist.gl_pathc; i++){
	      gchar *p,*g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if(!strstr(g,".bm.dbh")){
		  g_free(g);
		  continue;
	      }
	      p=strstr(g,".bm.dbh");
	      *p=0;
              TRACE ("glob match: %s", g);
	      bookshelf_xfdir.gl[j].pathv=g;
	      bookshelf_xfdir.gl[j].en = mk_entry(0);
	      bookshelf_xfdir.gl[j].en->path = g_strdup(g);
	      bookshelf_xfdir.gl[j].en->tag = g_strdup(my_utf_string(g));
	      SET_ROOT_TYPE(bookshelf_xfdir.gl[j].en->type);
	      SET_BOOKMARK_TYPE(bookshelf_xfdir.gl[j].en->type);	
	      SET_XF_NODE(bookshelf_xfdir.gl[j].en->type);
	      if (xffm_details->preferences & IMAGE_PREVIEW) 
		  SET_SHOWS_IMAGES(bookshelf_xfdir.gl[j].en->type);
	      if (xffm_details->preferences & SHOW_DOT) 
		  SET_SHOWS_HIDDEN(bookshelf_xfdir.gl[j].en->type);
	      
	      j++;
	   }
	   /* default bookmark file: */
	   {
	      gchar *g=g_build_filename(bm_dir,"bookmarks.dbh",NULL);
	      bookshelf_xfdir.gl[j].pathv=g_strdup(_("Default book"));
	      bookshelf_xfdir.gl[j].en = mk_entry(0);
	      bookshelf_xfdir.gl[j].en->path = g_strdup(g);
	      bookshelf_xfdir.gl[j].en->tag = g_strdup(g);
	      SET_ROOT_TYPE(bookshelf_xfdir.gl[j].en->type);	
	      SET_BOOKMARK_TYPE(bookshelf_xfdir.gl[j].en->type);	
	      SET_XF_NODE(bookshelf_xfdir.gl[j].en->type);
	      if (xffm_details->preferences & IMAGE_PREVIEW) 
		  SET_SHOWS_IMAGES(bookshelf_xfdir.gl[j].en->type);
	      if (xffm_details->preferences & SHOW_DOT) 
		  SET_SHOWS_HIDDEN(bookshelf_xfdir.gl[j].en->type);
	      g_free(g);
	   }
	   
	   
	}
  	globfree (&dirlist);
	g_free(bm_dir);
	g_free(globstring);
	return &bookshelf_xfdir;

}


