/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Copyright (c) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_SYS_UCRED_H
#include <sys/ucred.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif

#include <stdio.h>
#include <errno.h>
#ifdef HAVE_FSTAB_H
#include <fstab.h>
#endif
#include <limits.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_MNTENT_H
#include <mntent.h>
#endif
#ifdef HAVE_PATHS_H
#include <paths.h>
#endif
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_SYS_FS_TYPES_H
#include <sys/fs_types.h>
#endif

#ifdef HAVE_SYS_MNTTAB_H
#include <sys/mnttab.h>
#endif

#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif

#ifdef HAVE_SYS_VFSTAB_H
#include <sys/vfstab.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"

#include "fstab-module.h"

#include "tubo.h"

/* exported prototypes */
void *is_mounted(void *p);
void *is_in_fstab(void *p);

#include "fstab-module.i"

/****************   void  functions  ***********************/

G_MODULE_EXPORT
const gchar *
module_name(void){
    return "xffm_fstab";
}
G_MODULE_EXPORT
const gchar *
submodule_dir(void){
    return "plugins";
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xffstab";
}

/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xffstab.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
void *
module_icon_id(void * p){
    return "fstab.png";
}

G_MODULE_EXPORT
void *
module_label(void * p){
    return _("Fstab");
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (IS_PATH(en->type)) return (void *)"Yes";
    
    return NULL;
}


G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en) return NULL;
    if(IS_DIR(en->type)) return (void *)((long)1);
    return NULL;
}

/* NOTE: this function is current for linux only */
#if defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)
G_MODULE_EXPORT
void *entry_tip(void *p){
    static gchar *tip=NULL;
    record_entry_t *en=p;
    const gchar *mnt_point;
    
    struct mntent *m;
    FILE *fstab_fd;

    g_free(tip);
    tip=NULL;
    if (!en || !en->path) return NULL;
    mnt_point=en->path;
    
    
	
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(0);
	}
	while ((m=getmntent(fstab_fd))!=NULL){
	   TRACE("fstab=%s mountpoint=%s\n",m->mnt_dir,mnt_point);
	    
	   if (strcmp(m->mnt_dir,mnt_point)==0){
	        endmntent(fstab_fd);
		/* gotcha */
		tip=g_strdup_printf(_("Filesystem = %s\nMount type = %s\nMount options = %s"),
			m->mnt_fsname, m->mnt_type, m->mnt_opts);
		
		return tip;
	   }	   
	}
	endmntent(fstab_fd);
	return NULL; 
}
#endif
G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The FSTAB plugin keeps track of the mount points listed in /etc/fstab and allows you to easily mount or unmount these volumes with the popup menu, while navigating through the filesystem.");
}


/*******************  rational functions **********************/

G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    set_private_variables(q);
    return(private_get_xfdir(en));
}

