static gboolean is_smb;
static gchar *smb_browse=NULL;

static int childFD;
static xfdir_t fstat_xfdir;
static pid_t Gpid;
static GtkTreeView *fstab_treeview=NULL;
static  GtkTreeRowReference *fstab_reference=NULL;
static icon_view_t *fstab_icon_view_p=NULL;

static widgets_t *fstab_widgets_p=NULL;
/********/

static void set_private_variables(void *q){
	fstab_widgets_p = (widgets_t *)q;
	fstab_reference=NULL;
	fstab_icon_view_p=NULL;
	fstab_treeview=NULL;
	if (fstab_widgets_p->type==ICONVIEW_TYPE) 
	    fstab_icon_view_p=(icon_view_t *)fstab_widgets_p->parent;
}

static gint watch_stop(gpointer data)
{

    if(!fstab_widgets_p->tubo_object) return FALSE;
    if(fstab_widgets_p->stop)
    {
	gchar *m=g_strdup_printf("%d", Gpid);
	print_diagnostics(fstab_widgets_p,"xfce/warning", strerror(ECANCELLED)," pid=", m, "\n",NULL);
	g_free(m);
	/*cancelled = TRUE;*/
	TuboCancel(fstab_widgets_p->tubo_object, NULL);
	/*usleep(250); if(Gpid) kill(Gpid, SIGHUP);*/
	fstab_widgets_p->stop = FALSE;
	fstab_widgets_p->tubo_object = NULL;
	hide_stop(fstab_widgets_p);
	Gpid = 0;
	cursor_reset(fstab_widgets_p->window);
	return FALSE;
    }
    set_progress_generic(fstab_widgets_p,-1, -1,1);
    return TRUE;
}




static int operate_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*D(printf("stderr:%s",line);)*/
    if (strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics(fstab_widgets_p,"xfce/warning",_("Sudo password requested"),"\n", NULL);
	p=xffm_get_password(fstab_widgets_p,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));

	return TRUE;
    }
    if (line[0] != '\n'){
	show_text(fstab_widgets_p->diagnostics);
	print_diagnostics(fstab_widgets_p,"xfce/error", line, NULL);
    }
    return TRUE;
}
static int operate_stdout(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*D(printf("stdout:%s",line);)*/
    print_diagnostics(fstab_widgets_p,NULL, line, NULL);
    return TRUE;
}


static void fork_finished_function(pid_t pid)
{
    char m[32];
    record_entry_t *en;
    int status;
    GtkTreeIter iter;
    sprintf(m, "%d\n", pid);

	hide_stop(fstab_widgets_p);
    /* another wait just in case the one in tubo misses 
     * (shouldn't happen, but it does)*/
    
    waitpid(pid, &status, WNOHANG);
    if (fstab_icon_view_p && fstab_icon_view_p->selected_p && fstab_icon_view_p->selected_p->en){
	en=fstab_icon_view_p->selected_p->en;
    }
    else en = (*xffm_details->arbol->get_selected_entry)(&iter);
     if (!en) {
	TRACE("fork_finished_function all done");
	if (fstab_reference) {
	    gtk_tree_row_reference_free(fstab_reference);
	    fstab_reference=NULL;
	}
	fstab_widgets_p->tubo_object = NULL;
	return;
    }
   status=GPOINTER_TO_INT(is_mounted((void *)(en->path)));
    if (status < 0) TOGGLE_MOUNTED(en->type);
    else {
	    if (status) SET_MOUNTED(en->type);
	    else UNSET_MOUNTED(en->type);
    }
    if (fstab_treeview && fstab_reference && gtk_tree_row_reference_valid(fstab_reference)) {
    	GtkTreeModel *treemodel = gtk_tree_view_get_model(fstab_treeview);
      	GtkTreePath *treepath = gtk_tree_row_reference_get_path(fstab_reference);
	if (treepath && gtk_tree_model_get_iter (treemodel,&iter,treepath)){
	    if (IS_MOUNTED(en->type)){
		int i;
		for (i=0; i<TREECOUNT; i++){
		    gtk_tree_selection_unselect_all(xffm_details->arbol->treestuff[i].selection);
		}
		gtk_tree_selection_select_iter(gtk_tree_view_get_selection(fstab_treeview),&iter);
		xffm_refresh(&(xffm_details->arbol->widgets));
	    }
	    else  {
		gtk_tree_view_collapse_row(fstab_treeview, treepath);
		(*xffm_details->arbol->prune_row)(treemodel, &iter, NULL,en);
		(*xffm_details->arbol->insert_dummy_row)(treemodel, &iter, NULL,en,NULL,NULL);
		(*xffm_details->arbol->update_icon)(treemodel,&iter);
	    }
	    gtk_tree_path_free(treepath);
	}
	gtk_tree_row_reference_free(fstab_reference);
	fstab_reference=NULL;
	if (xffm_details->arbol->widgets.progress) gtk_widget_hide(xffm_details->arbol->widgets.progress); 
    } else if (fstab_icon_view_p){ /* icon view */
      /*record_entry_t *new_en;*/
      gchar *mnt_point;
      
      if (smb_browse && strlen(smb_browse)) mnt_point=g_strdup(smb_browse);
      
      if (!mnt_point) mnt_point=g_strdup(en->path);

#if 0
FIXME
      
      new_en=stat_entry(mnt_point,__ROOT_TYPE | __LOCAL_TYPE);
      
      if (GPOINTER_TO_INT(is_mounted(new_en->path))>0){
	  fstab_icon_view_p=create_iconview(new_en);
	  reload_iconview(fstab_icon_view_p,new_en,TRUE);
      }
#endif
      
      /*new_en=copy_entry(fstab_icon_view_p->en);
      reload_iconview(fstab_icon_view_p,new_en,FALSE);*/
      xffm_refresh(fstab_widgets_p);
	

    }
    fstab_widgets_p->tubo_object = NULL;
 
    TRACE("TRACE:fstab over by fork_finished_function\n");
}

/* NOTE: linux will fail if HAVE_STATFS is before HAVE_GETMNTENT section */
G_MODULE_EXPORT
void *is_mounted (void *p){
    const gchar *mnt_point=(const gchar *)p;
	
#if defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)
	struct mntent *m;
	const gchar *mnttab;
	FILE *mtab_fd;
	FILE *tab_file;

	
#if defined(MNT_MNTTAB)
	mnttab = MNT_MNTTAB;
#else
	/*
	 * try /proc/mounts first
	 */
	if ((mtab_fd = fopen("/proc/mounts", "r")) != NULL) {
		(void)fclose(mtab_fd);
		mnttab = "/proc/mounts";
	}
	else
		mnttab = "/etc/mtab";
#endif
	tab_file=setmntent(mnttab, "r");

	if (!tab_file) {
	      perror("setmntent:");
	      return GINT_TO_POINTER(-1);
	}
	while ((m=getmntent(tab_file))!=NULL){
		/*printf("TRACE2:%s=%s\n",m->mnt_dir,mnt_point);*/
	   if (strcmp(m->mnt_dir,mnt_point)==0){
	        endmntent(tab_file);
		return GINT_TO_POINTER(1);
	   }	   
	}
	endmntent(tab_file);
	return NULL; 
#elif defined(HAVE_STATFS) && defined(HAVE_STRUCT_STATFS_F_MNTONNAME)
      struct statfs statfsbuf;	
      if (statfs(mnt_point, &statfsbuf) == 0) {
	if (strcmp(mnt_point, statfsbuf.f_mntonname) == 0) return GINT_TO_POINTER(1);
	else return NULL;
      }
      return GINT_TO_POINTER(-1); 
#elif defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTTAB_MNT_MOUNTP)
	/*
	 * The Solaris way...
	 */
	struct mnttab mbuf;
	FILE *fp;
	int r=-1;

	if ((fp = fopen("/etc/mnttab", "r")) != NULL) {
		for (;;) {
			if (getmntent(fp, &mbuf) != 0){
				r=0;
				break;
			}

			if (strcmp(mbuf.mnt_mountp,mnt_point) == 0) {
				r=1;
				break;
			}
		}
		(void)fclose(fp);
	}
	return GINT_TO_POINTER(r);
#else
    return GINT_TO_POINTER(-1);
#warning "missing code here. " 
#endif
}

G_MODULE_EXPORT
void *
fstab_mount (void *p,void *q)
{
    gchar *argument[12];
    gchar **ap;
    int i;
    gchar *g=NULL;
    static gchar *sudo_prompt=NULL;
    gboolean use_sudo=FALSE;
    gchar *umount="umount",*mount="mount";
    const char *smb_user;
    gchar *smb_options=NULL;
    gboolean umnt;
    record_entry_t *en=(record_entry_t *)p;
    const gchar *mnt_point;
    
    set_private_variables(q);
   
    if (fstab_widgets_p->tubo_object) {
	g_warning("mount process busy");
	return NULL;
    }
    
    
    if (!en) return NULL;
    if (xffm_details->arbol && xffm_details->arbol->widgets.window){
	GtkTreePath *tpath;
	GtkTreeIter iter;
	int tree_id=(*xffm_details->arbol->get_active_tree_id)();
	(*xffm_details->arbol->get_selected_entry)(&iter);
	tpath = gtk_tree_model_get_path(xffm_details->arbol->treestuff[tree_id].treemodel, &iter);
	fstab_reference = gtk_tree_row_reference_new(xffm_details->arbol->treestuff[tree_id].treemodel, tpath);
	gtk_tree_path_free(tpath);
    }
   
    mnt_point = (const gchar *)en->path;
    umnt = IS_MOUNTED(en->type);
    TRACE("fstab_mount %s status=0x%x iconviewp=0x%x",mnt_point,(unsigned)fstab_widgets_p->status,(unsigned)fstab_icon_view_p);
    g_free(smb_browse);
    smb_browse=NULL;
    /* this will set the is_smb variable: */
    if (!is_in_fstab((void *)mnt_point) && !is_mounted((gchar *)mnt_point)) {
	if (en && IS_XF_NETSHARE(en->subtype))
	{	    
	    is_smb=TRUE;
	    smb_browse=randomTmpName(NULL);
	    unlink(smb_browse);
	    print_diagnostics(fstab_widgets_p,NULL,"$mkdir ",smb_browse,"\n",NULL);
	    mkdir(smb_browse, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
	}
	else {
	    print_diagnostics(fstab_widgets_p,"xfce/error",strerror(ENODEV),":\n","unknown fs type\n",NULL);
	    return 0;
    
	}
    }
    
    if (getenv("XFFM_USE_SUDO") && strlen(getenv("XFFM_USE_SUDO"))) use_sudo=TRUE;
    /*if (smb_browse) use_sudo=FALSE;*/

    if (!getuid()) use_sudo=FALSE;
    ap = argument;

    if (use_sudo) {
       if ((g = g_find_program_in_path("sudo")) != NULL){
	    *ap++ = "sudo";
	    *ap++ = "-S";
	    g_free(g);
       } else {
	   print_diagnostics(fstab_widgets_p,"xfce/error",strerror(ENOENT),": sudo",NULL);
       }
    }
		 
    
    if (smb_browse) i=0;
    else i=GPOINTER_TO_INT(is_mounted((void *)mnt_point));
    
    if (i >= 0){
      if (i) *ap++ = umount;
      else *ap++ =mount;
    } else {
      if (umnt)	*ap++ = umount;
      else	*ap++ = mount;
    }
    if (is_smb && i==0) {
	if (smb_browse) {
	    *ap++="-t";
	    *ap++="smbfs";
	}
	smb_user=xffm_get_smbuserpass(fstab_widgets_p,en);
	if (!smb_user || !strlen(smb_user)){
	  smb_options=g_strdup_printf("guest");
	} else {
	  smb_options=g_strdup_printf("username=%s",smb_user);
	}
     	*ap++ = "-o";
	*ap++ = smb_options;
    }

#if 0
#if !defined(HAVE_GETVFSENT) && !defined(STAT_STATVFS) 
    /* XXX - This test is BAD */
    /* -v is different on Solaris */
    *ap++ = "-v";
#endif
#endif
    *ap++ = (gchar *)mnt_point;
    if (smb_browse){
	*ap++ = smb_browse;
    }
    *ap++ = NULL;

    print_diagnostics(fstab_widgets_p,NULL,"$",argument[0],NULL);
    for (i=1;argument[i];i++){
	if (strstr(argument[i],"username=")) print_diagnostics(fstab_widgets_p,NULL," username=*****",NULL);
	else 
	    print_diagnostics(fstab_widgets_p,NULL," ",argument[i],NULL);
    }
    print_diagnostics(fstab_widgets_p,NULL,"\n",NULL);
    
    chdir(GETWD);

    show_stop(fstab_widgets_p);
	
    /*printf("TRACE: envars=%s\n",env_vars[i]);
    printf("TRACE: value=%s\n",value);*/
    
    /* put in a \n to the password prompt to flush the pipe: fluusshh */
    if (sudo_prompt) g_free(sudo_prompt);
    sudo_prompt = g_strconcat("SUDO_PROMPT=","Password:","\n",NULL);
    putenv(sudo_prompt);
    cursor_wait(fstab_widgets_p->window);
    fstab_widgets_p->tubo_object = 
		Tubo(fork_function, 
				(void *)argument, 
				fork_finished_function, 
				&childFD, 
				operate_stdout, 
				operate_stderr,0,TRUE);
    	
    g_timeout_add(260,(GtkFunction) watch_stop, (gpointer) fstab_treeview);
    	
    Gpid = TuboPID(fstab_widgets_p->tubo_object);
    g_free(smb_options);
    while (fstab_widgets_p->tubo_object){
	while (gtk_events_pending()) gtk_main_iteration();
	usleep(100);
    }
    cursor_reset(fstab_widgets_p->window);
    if (smb_browse && fstab_treeview) {
	return smb_browse;
	/*go_to(xffm_details->arbol->treestuff+get_tree_id(fstab_treeview),smb_browse);*/
    }

    TRACE("fstab_mount %s done ",mnt_point);
    return (void *) (mnt_point);
}


/* NOTE: Cygwin does have FS mounts, but they work differently from
   all other environments. For the moment, we will not support any
   mounting functionality, although in the future we might add
   cygwin specific support
*/
#if defined (__CYGWIN__)
static
xfdir_t *
private_get_xfdir(record_entry_t *en){
	fstat_xfdir.gl=NULL;
	return(NULL);
}

G_MODULE_EXPORT
void *
is_in_fstab (void *p)
{
    is_smb=FALSE;
    return NULL;
}

/* NOTE: FreeBSD will fail if is HAVE_GETVFSENT before HAVE_STATFS */
#elif defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)

/*
 * HP-UX, Linux, SunOS 4.x
 */

#if !defined(MNTTYPE_PROCFS)
#define MNTTYPE_PROCFS	"proc"
#endif

#if !defined(MNTTYPE_SMBFS)
#define MNTTYPE_SMBFS	"smbfs"
#endif

#if !defined(MNTTYPE_DEV)
#define MNTTYPE_DEV	"devpts"
#endif

#if !defined(MNTTYPE_SHM)
#define MNTTYPE_SHM	"tmpfs"
#endif

#if !defined(MNTTYPE_CDFS)
#define	MNTTYPE_CDFS	"hfs"		/* HP-UX */
#endif

#if !defined(MNTTYPE_SWAP)
#define MNTTYPE_SWAP	"swap"
#endif

#if !defined(MNTTYPE_SWAPFS)
#define	MNTTYPE_SWAPFS	"swapfs"	/* HP-UX */
#endif

#if !defined(MNTTYPE_NFS)
#define MNTTYPE_NFS	"nfs"
#endif

#if !defined(MNT_CHECKLIST)
#if defined(_PATH_FSTAB)
#define MNT_CHECKLIST	_PATH_FSTAB
#else
#define MNT_CHECKLIST	"/etc/fstab"
#endif
#endif
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	/*struct mntent *mnt_mounted;*/
        struct mntent *mnt_struct;
	const gchar *mnttab;
	/*struct stat st;*/
	FILE *fstab_fd;
	FILE *mtab_fd;
	int i;

#if defined(MNT_MNTTAB)
	mnttab = MNT_MNTTAB;
#else
	/*
	 * try /proc/mounts first
	 */
	if ((mtab_fd = fopen("/proc/mounts", "r")) != NULL) {
		(void)fclose(mtab_fd);
		mnttab = "/proc/mounts";
	}
	else
		mnttab = "/etc/mtab";
#endif
	
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(0);
	}

	fstat_xfdir.pathc = 0;
	
	for (mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;

#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;

		fstat_xfdir.pathc++;
        }

        (void)endmntent(fstab_fd);
	

	fstat_xfdir.gl = (dir_t *)malloc(fstat_xfdir.pathc * sizeof(dir_t));

        if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		g_free(fstat_xfdir.gl);
		fstat_xfdir.gl=NULL;
		return(0);
	}

	for (i = 0, mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;

#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(mnt_struct->mnt_dir, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(mnt_struct->mnt_dir);

		/*SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);*/
		SET_FSTAB_TYPE(fstat_xfdir.gl[i].en->type);

		if (strcmp(MNTTYPE_NFS, mnt_struct->mnt_type) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			SET_SMB_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_PROCFS, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_DEV, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SHM, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SWAPFS, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CDFS, mnt_struct->mnt_type) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);

		i++;

	}

        (void)endmntent(fstab_fd);


        return(&fstat_xfdir);
}

/* 
 * This should return the fstab type, -1 if default or NULL is not in fstab...
 * Fstab types *are* (or should be) supported in xffm/libs/constants.h.
 */
void *
is_in_fstab (void *p)
{
        struct mntent *mnt_struct;
	FILE *fstab_fd;
	int result=0;
	const gchar *path = (const gchar *)p;
	is_smb=FALSE;
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(NULL);
	}

	
	for (mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;
		if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			is_smb=TRUE;
#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;
		if (strcmp(path,mnt_struct->mnt_dir)==0) {
		    TRACE("%s ---> %s",path,mnt_struct->mnt_type);
		    if (strcmp(MNTTYPE_NFS, mnt_struct->mnt_type) == 0)
			result = __NFS_TYPE;
		    else if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			result = __SMB_TYPE;
		    else if (strcmp(MNTTYPE_PROCFS, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_DEV, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_SHM, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_SWAPFS, mnt_struct->mnt_type) == 0)
			result = __PROC_TYPE;
		    else if (strcmp(MNTTYPE_CDFS, mnt_struct->mnt_type) == 0)
			result = __CDFS_TYPE;
		    else if (strcmp("iso9660", mnt_struct->mnt_type) == 0)
			result = __CDFS_TYPE;
		    else result=-1;
		    break;
		}
        }

        (void)endmntent(fstab_fd);

        return GINT_TO_POINTER(result);
}

/* needs STAT_STATVFS to avert FreeBSD from falling in here,
 * but that does not work with fbsd 5.0, so use HAVE_SYS_STATFS_H
 * instead... */
#elif defined(HAVE_GETVFSENT) && defined (HAVE_SYS_STATFS_H)

/*
 * Solaris
 */

#define MNTTYPE_CACHEFS	"cachefs"
#define MNTTYPE_HSFS	"hsfs"
#define MNTTYPE_NFS	"nfs"
#define MNTTYPE_SWAP	"swap"
#define MNTTYPE_SMB	"smbfs"
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	struct vfstab vbuf;
	struct mnttab mbuf;
   	record_entry_t *en;
	FILE *vfstab_fp;
	FILE *mnttab_fp;
	struct stat st;
	int i;

	if ((vfstab_fp = fopen("/etc/vfstab", "r")) == NULL)
		return(0);

	for (i = 0;; ) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;
		if(strcmp(MNTTYPE_SMB, vbuf.vfs_fstype) == 0)
			is_smb=TRUE;
		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;

		i++;
	}

	if ((mnttab_fp = fopen("/etc/mnttab", "r")) == NULL) {
		(void)fclose(vfstab_fp);
		return(0);
	}

	(void)rewind(vfstab_fp);

	if ((fstat_xfdir.gl = (dir_t *)malloc(i * sizeof(dir_t))) == NULL) {
		(void)fclose(mnttab_fp);
		(void)fclose(vfstab_fp);
		return(0);
	}

	fstat_xfdir.pathc = i;


	for (i = 0;;) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(vbuf.vfs_mountp, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(vbuf.vfs_mountp);

		/*SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);*/
		SET_FSTAB_TYPE(fstat_xfdir.gl[i].en->type);
	
		if (strcmp(MNTTYPE_NFS, vbuf.vfs_fstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_HSFS, vbuf.vfs_fstype) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CACHEFS, vbuf.vfs_fstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);

		/*
		 * Check if filesystem is already mounted
		 *  
		 */
		(void)rewind(mnttab_fp);
		for (;;) {
			if (getmntent(mnttab_fp, &mbuf) != 0)
				break;

			if (strcmp(mbuf.mnt_mountp, vbuf.vfs_mountp) == 0){ 
		    		TOGGLE_MOUNTED(fstat_xfdir.gl[i].en->type);
				break;
			}
		}
		i++;
	}

        (void)fclose(mnttab_fp);
        (void)fclose(vfstab_fp);
	

        return(&fstat_xfdir);
}

void *
is_in_fstab (void *p)
{
	int result=0;
	struct vfstab vbuf;
	FILE *vfstab_fp;
	const gchar *path = (const gchar *)p;
	is_smb=FALSE;

	if ((vfstab_fp = fopen("/etc/vfstab", "r")) == NULL)
		return(NULL);

	while (1) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;
		if (strcmp(path,vbuf.vfs_mountp)==0) {
		    if (strcmp(MNTTYPE_NFS, vbuf.vfs_fstype) == 0)
			result=__NFS_TYPE;
		    else if (strcmp(MNTTYPE_HSFS, vbuf.vfs_fstype) == 0)
			result=__CDFS_TYPE;
		    else if (strcmp(MNTTYPE_CACHEFS, vbuf.vfs_fstype) == 0)
			result=__PROC_TYPE;
		    else result=-1;
		    break;
		}

	}
	(void)fclose(vfstab_fp);
        return GINT_TO_POINTER(result);
}

#elif defined(HAVE_GETFSENT)

/*
 * AIX, BSD, OSF1, ULTRIX
 */

#if defined(MOUNT_CD9660)
#define MNTTYPE_CDFS	MOUNT_CD9660
#else
#define MNTTYPE_CDFS	"cdrfs"		/* AIX */
#endif

#if defined(MOUNT_CFS)
#define MNTTYPE_CODAFS	MOUNT_CFS
#elif defined(MOUNT_CODA)
#define MNTTYPE_CODAFS	MOUNT_CODA
#else
#define MNTTYPE_CODAFS	"coda"
#endif

#if defined(MOUNT_KERNFS)
#define MNTTYPE_KERNFS	MOUNT_KERNFS
#else
#define MNTTYPE_KERNFS	"kernfs"
#endif

#if defined(MOUNT_MFS)
#define MNTTYPE_MFS	MOUNT_MFS
#else
#define MNTTYPE_MFS	"mfs"
#endif

#if defined(MOUNT_NFS)
#define MNTTYPE_NFS	MOUNT_NFS
#else
#define MNTTYPE_NFS	"nfs"
#endif

#if defined(MOUNT_PROCFS)
#define MNTTYPE_PROCFS	MOUNT_PROCFS
#else
#define MNTTYPE_PROCFS "procfs"
#endif

#if defined(MOUNT_SMBFS)
#define MNTTYPE_SMBFS	MOUNT_SMBFS
#else
#define MNTTYPE_SMBFS	"smbfs"
#endif

#define MNTTYPE_SWAP	"swap"
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	struct fstab *fs;
   	record_entry_t *en;
	int i;


	if (!setfsent())
		return(0);

	for (i = 0, fs = getfsent(); fs != NULL;
			fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;

		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;

		i++;
	}

	if (!setfsent())
		return(0);
	
	if ((fstat_xfdir.gl = (dir_t *)malloc(i * sizeof(dir_t))) == NULL) {
		endfsent();
		return(0);
	}

	fstat_xfdir.pathc = i;

	for (i = 0, fs = getfsent(); fs != NULL; 
			fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;

		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(fs->fs_file, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(fs->fs_file);

		/*SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);*/
		SET_FSTAB_TYPE(fstat_xfdir.gl[i].en->type);

		if (strcmp(MNTTYPE_CDFS, fs->fs_vfstype) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CODAFS, fs->fs_vfstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_KERNFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_MFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_NFS, fs->fs_vfstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_PROCFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			SET_SMB_TYPE(fstat_xfdir.gl[i].en->subtype);

		i++;
	}

	endfsent();
	
		
        return(&fstat_xfdir);
}

void *
is_in_fstab (void *p)
{
	int result=0;
	struct fstab *fs;
	const gchar *path = (const gchar *)p;

	is_smb=FALSE;
	if (!setfsent()) return(NULL);

	for ( fs = getfsent(); fs != NULL; fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;
		if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			is_smb=TRUE;
		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;
		
		if (strcmp(path,fs->fs_file)==0) {
		    if (strcmp(MNTTYPE_CDFS, fs->fs_vfstype) == 0)
			result=__CDFS_TYPE;
		    else if (strcmp(MNTTYPE_CODAFS, fs->fs_vfstype) == 0)
			result=__NFS_TYPE;
		    else if (strcmp(MNTTYPE_KERNFS, fs->fs_vfstype) == 0)
			result=__PROC_TYPE;
		    else if (strcmp(MNTTYPE_MFS, fs->fs_vfstype) == 0)
			result=__PROC_TYPE;
		    else if (strcmp(MNTTYPE_NFS, fs->fs_vfstype) == 0)
			result=__NFS_TYPE;
		    else if (strcmp(MNTTYPE_PROCFS, fs->fs_vfstype) == 0)
			result=__PROC_TYPE;
		    else if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			result=__SMB_TYPE;
		    else result=-1;
		    break;
		}
	}
	endfsent();		
        return GINT_TO_POINTER(result);
}


#else
static
xfdir_t *
private_get_xfdir(record_entry_t *en)
{
	fstat_xfdir.gl=NULL;
	return(NULL);
}

void *
is_in_fstab (void *p)
{
    is_smb=FALSE;
    return NULL;
}

#endif


