/*
 * Copywrite 2005 Edscott Wilson Garcia
 */


#define __XFFM_MAIN_C__
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <glib.h>

#include "applications-module.h"
#include "combo-module.h"

#define FILEMANAGER "xffm-iconview"


#ifndef LINKED_MODULES
typedef struct module_info_t {
    void *module_functions;
    GModule *module_cm;
} module_info_t;
    
static
module_info_t  *get_module_info(const gchar *librarydir,const gchar *module_name){
    module_info_t *module_info;
    void *(*module_init)(void);
    
    TRACE("getting module info for %s",module_name);
    
    {
	gchar *full_libdir;
	gchar *module;
	
	if (librarydir) full_libdir=g_build_filename (LIBDIR, "xffm", librarydir,NULL);
	else full_libdir=g_strdup(LIBDIR);
	module = g_module_build_path(full_libdir, module_name);
	g_free(full_libdir);

	TRACE("loading %s",module);
	module_info=(module_info_t *)malloc(sizeof(module_info_t));
	if (!module_info) g_assert_not_reached();
	module_info->module_cm=g_module_open (module, 0);
	if (!module_info->module_cm) {
	    g_warning("g_module_open(%s) == NULL\n",module);
	    g_warning("Module cannot be opened! Check if correctly installed...\n");
	    return NULL;
	}
	if (!g_module_symbol (module_info->module_cm, "module_init",(gpointer) &(module_init)) ) {
	    TRACE("g_module_symbol(module_init) != FALSE\n");
	    return NULL;
	}	
	module_info->module_functions = (*module_init)();
	DBG ("xffm: module %s successfully loaded", module);	    
	g_free(module);
	return module_info;                                      
    }
}


static
void *load_module(const gchar *librarydir,const gchar *module_name){
    module_info_t *module_info;
    module_info=get_module_info(librarydir, module_name);
    TRACE("finished load attempt of module %s (%s)",module_name,librarydir);
    if (!module_info) {
        g_warning("Show stopper: cannot get module info for %s",
    	    module_name);
        return NULL;
    }
    return module_info->module_functions;                                      
}

static
xfc_combo_functions *load_xfc(void){
    xfc_combo_functions *xfc_fun = (xfc_combo_functions *)load_module(NULL,"xffm_combo");
    return xfc_fun;
}


static
xfmime_functions *load_mime_module(void){
    xfmime_functions *xfmime_fun=(xfmime_functions *)load_module(NULL,"xffm_applications");
    return xfmime_fun;
}


#endif

static int version_query(int argc, char *argv[]){
    int i;
    for(i = 0; i < argc; i++){
        if(strcmp(argv[i], "--version") == 0)  {
	    g_print ("\tThis is %s version %s\n", 
                    PACKAGE, VERSION);
	    exit (1);
	}
    }
    return 0;
}

/*****   
 * this gui_get_response_history() function is duplicated
 * from menu.c to avoid loading the entire library 
 * */

static void
activate_entry(GtkEntry *entry, gpointer data){
    gtk_dialog_response  ((GtkDialog *)data,GTK_RESPONSE_YES);
}
static void
cancel_entry(GtkEntry *entry, gpointer data){
    gtk_dialog_response  ((GtkDialog *)data,GTK_RESPONSE_CANCEL);
}


static
const gchar *
get_response_history(		const gchar *title_txt, 
				const gchar *label_txt,
				gchar *history_file,
				const gchar *path){
    static gchar *response_txt=NULL;
    int response = GTK_RESPONSE_NONE;
    GtkWidget *hbox,*label,*button,*dialog ;
    static GtkCombo *combo=NULL;
    xfc_combo_info_t *combo_info=NULL;

    

    dialog = gtk_dialog_new();

    g_free(response_txt);
    response_txt=NULL;
    gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER (dialog), 6);

	
    if (label_txt) label=gtk_label_new(label_txt);
    else label=gtk_label_new(_("Input requested"));
    if (title_txt) gtk_window_set_title (GTK_WINDOW (dialog), title_txt);
    
    combo=(GtkCombo *)gtk_combo_new();
    hbox=gtk_hbox_new(FALSE, 6);
    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), (GtkWidget *)combo, FALSE, FALSE, 0); 
    gtk_widget_show_all (hbox); 
     if (combo_info==NULL){
	combo_info = XFC_init_combo(combo);
    } else {
	XFC_clear_history(combo_info);
    }
    
    combo_info->activate_func = activate_entry;
    combo_info->activate_user_data=dialog;
    combo_info->cancel_func = cancel_entry;
    combo_info->cancel_user_data=dialog;
    XFC_set_combo(combo_info,NULL);
    XFC_read_history(combo_info,history_file);

    if (path) {
	const gchar *p=MIME_command(path);
    	if (p) combo_info->list = g_list_prepend(combo_info->list,g_strdup(p) );
    }
    XFC_set_combo(combo_info,NULL);
	    	    
    button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_from_stock (GTK_STOCK_OK);
    gtk_widget_show (button);

    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);

    /* show dialog and return */
    response = gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_YES){
	const gchar *et=XFC_get_entry(combo_info);
	if (et && strlen(et)){
		  response_txt=g_strdup(et);      
	}		      
    }
    gtk_widget_hide (dialog);
    gtk_widget_destroy (dialog); 

    /* use slocate_string to select... */
    return (const gchar *)(response_txt);
}



/* xffm-run, faster alternative to xfrun 
*/

void runit(int argc, gchar **argv){
      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
      gchar *f=g_build_filename(xdg_dir,RUN_DBH_FILE,NULL); 
      gchar *q;
      GError *error=NULL;
      int argcp;
      gchar **argvp;
      const gchar *g;
      const gchar *path=((argc>=1)?argv[1]:NULL);

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain(GETTEXT_PACKAGE);
#endif
    gtk_set_locale();
    gtk_init(&argc, &argv);
      
      if (path) g=get_response_history(_("Open with..."),_("Open with"),f,path);
      else g=get_response_history(_("Open"),_("Run"),f,path);

      g_free(xdg_dir);
      g_free(f);
      if (!g) exit(1);
      
      if (g_file_test(g,G_FILE_TEST_IS_DIR)){
	  execlp(FILEMANAGER, FILEMANAGER, g, NULL);
	  exit(1);
      }


      
      q=g_strdup_printf("%s \"%s\"",g,path);
      TRACE("command line is=%s",q);
      g_shell_parse_argv (q, &argcp,&argvp,&error);
      if (error){
        g_warning(error->message);
	g_error_free(error);
	return exit(0);
      }
      g_free(q);
      execvp(argvp[0],argvp);
      exit(1);
      
  }


int main(int argc, char *argv[]){
    if (version_query(argc, argv)) exit(1);

    /* check for file existance, first try absolute, then relative
     * and last but not least, relative to homedir */
    if (argc >= 2) {
	int is_absolute=(argv[1][0]=='/');
	int exists=0;
	
	/* if there is a choice between a relative directory
	 * and a program executable, choose the executable */
	if (!is_absolute) {
	    /* XXX try to do this without glib... */
	    gchar *e;
	    gchar *base;
   	    /* is it executable? (this loads glib...) */
	    base=g_path_get_basename(argv[1]);
	    e=g_find_program_in_path(base);
	    if (e) {
		execvp(argv[1],argv+1);
		g_warning("cannot execute %s",e);
		return 0;
	    }
	    g_free(e);
	    g_free(base);
	}
 
	if (access((const gchar *)argv[1],F_OK)==0) exists=1;
	if (getenv("HOME") && strlen(getenv("HOME"))) {
	    char wd[1024];
	    if (getcwd(wd, 1024)){
		chdir(getenv("HOME"));
		if (access((const gchar *)argv[1],F_OK)==0) exists=1;
		else chdir(wd);
	    }
	}
		TRACE("%s exists=%d",argv[1],exists);
	if (exists) {
	    const gchar *prg;
	    DIR *directory;
	    /* is it a directory? */
	    if ((directory = opendir(argv[1]))!=NULL){
		closedir(directory);
		argv[0]=FILEMANAGER;
		execvp(argv[0],argv);
		g_warning("cannot execute %s",argv[0]);
		return 0;
		
	    }
	    else {
		TRACE("cannot open dir %s",argv[1]);
	    }
	    /* is it executable? */
	    if (access((const gchar *)argv[1],X_OK)==0){
		execvp(argv[1],argv+1);
		g_warning("cannot execute %s",argv[1]);
	    }
	    /* does it have an associated mimetype application? */
	    
	    {
		gchar *p=argv[1];
		prg=NULL;
		while (p && !prg){
		    if ((prg = MIME_command (p)) != NULL) break;
		    p=strchr(p+1,'.');
		}
	    }
		    
		
	   /* for (i=1; i<argc; i++){
		TRACE("%d (%s) prg=%s",i,argv[i],((prg)?prg:"null"));
		//if ((prg = MIME_command (argv[i])) != NULL) break;	
		if ((prg = MIME_command (".c")) != NULL) break;	
	    }*/
	    TRACE("prg=%s",((prg)?prg:"null"));
	    if (prg) {
		GError *error=NULL;
		int argcp;
		char **argvp;
	 	const gchar *g;
	 	gchar *arguments = argv[1];
		TRACE("arguments=%s",arguments);
		
	 	g=MIME_mk_command_line(prg,arguments,FALSE,FALSE);
		
		if (g_shell_parse_argv(g,&argcp,&argvp,&error)){
		    execvp(argvp[0],argvp);
		    g_strfreev(argvp);
		    g_warning("could not execute %s",argvp[0]);
		} else {
		    g_warning(error->message);
		    g_error_free(error);
		}
	    }
	}
	
	/* only if no mime association: */
	runit(argc, argv);
	return 1;
    }
    /* no arguments given */
    if (strstr(argv[0],"xffm-run") || strstr(argv[0],"xfrun")) {
	runit(argc, argv);	
	return 1;
    }
    
    argv[0]=FILEMANAGER;
    execvp(argv[0],argv);
    g_warning("cannot execute %s",argv[0]);
    return 0;	 
}


