/* $Id: pointerwrapper.h,v 1.2 2002/11/18 07:06:41 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef __POINTERWRAPPER_H__
#define __POINTERWRAPPER_H__

template <class T>
class PointerWrapper {
public:
	typedef void(*dealloc)(T *);

	PointerWrapper(T *p = NULL, dealloc de = NULL);
	PointerWrapper(const PointerWrapper<T> &pw);
	~PointerWrapper();

	T &operator*();
	T *operator->();

	void setdealloc(dealloc de);

	T *operator=(T *p);
	operator T*() const;

	PointerWrapper<T> &operator=(const PointerWrapper<T> &pw);

private:
	T *_p;
	dealloc _de;

	void ref(const PointerWrapper<T> *ref) const;
	void unref(const PointerWrapper<T> *ref) const;
	mutable vector<PointerWrapper<T> *> refs;
};

#include "pointerwrapper.cpp"

#endif /* __POINTERWRAPPER_H__ */
