/*
 * Copyright (C) 2001-2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gtkxine.h,v 1.15 2005/02/04 04:14:43 brian Exp $
 *
 * the xine engine in a widget - header
 */

#ifndef __GTK_XINE_H__
#define __GTK_XINE_H__

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>

#include <glib.h>
#include <gtk/gtkbox.h>

#include <xine.h>

G_BEGIN_DECLS

#define GTK_TYPE_XINE              (gtk_xine_get_type())
#define GTK_XINE(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), GTK_TYPE_XINE, GtkXine))
#define GTK_XINE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), GTK_TYPE_XINE, GtkXineClass))
#define GTK_IS_XINE(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), GTK_TYPE_XINE))
#define GTK_IS_XINE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE((klass), GTK_TYPE_XINE))

typedef struct _GtkXine GtkXine;
typedef struct _GtkXineClass GtkXineClass;
typedef struct _GtkXinePriv GtkXinePriv;

struct _GtkXine
{
	GtkBox parent;

	/*< private >*/
	GtkXinePriv *priv;
};

struct _GtkXineClass
{
	GtkBoxClass parent_class;
	
	/*< signals >*/
	void (*stream_ended)(GtkXine *gtx);
	void (*set_title)(GtkXine *gtx, const gchar *title);
	void (*ui_message)(GtkXine *gtx, const gchar *message);
	void (*format_changed)(GtkXine *gtx, gint width, gint height);
	void (*progress_message)(GtkXine *gtx, gchar *message, gint percent);
    void (*mrl_reference)(GtkXine *gtx, gchar *mrl, gint alternative);
	
	/*< reserved >*/
	void (*_reserved1)();
	void (*_reserved2)();
	void (*_reserved3)();
};

GtkType      gtk_xine_get_type                   () G_GNUC_CONST;
GtkWidget *  gtk_xine_new                        (const gchar *video_driver_id,
                                                  const gchar *audio_driver_id);
void         gtk_xine_set_visibility             (GtkXine *gtx,
                                                  GdkVisibilityState state);
void         gtk_xine_resize                     (GtkXine *gtx,
                                                  gint x,
                                                  gint y,
                                                  gint width,
                                                  gint height);
gboolean     gtk_xine_open                       (GtkXine *gtx,
                                                  const gchar *mrl);
gboolean     gtk_xine_play                       (GtkXine *gtx,
                                                  gint pos,
                                                  gint start_time);
gboolean     gtk_xine_trick_mode                 (GtkXine *gtx,
                                                  gint mode,
                                                  gint value);
gint         gtk_xine_get_stream_info            (GtkXine *gtx,
                                                  gint info);
G_CONST_RETURN gchar *gtk_xine_get_meta_info     (GtkXine *gtx,
                                                  gint info);
G_CONST_RETURN gchar *gtk_xine_get_current_mrl   (GtkXine *gtx);
gboolean     gtk_xine_get_pos_length             (GtkXine *gtx,
                                                  gint *pos_stream,
                                                  gint *pos_time,
                                                  gint * length_time);
void         gtk_xine_stop                       (GtkXine *gtx);

gint         gtk_xine_get_error                  (GtkXine *gtx);
gint         gtk_xine_get_status                 (GtkXine *gtx);

void         gtk_xine_set_param                  (GtkXine *gtx,
                                                  gint param,
                                                  gint value);
gint         gtk_xine_get_param                  (GtkXine *gtx,
                                                  gint param);

void         gtk_xine_engine_set_param           (GtkXine *gtx,
                                                  gint param,
                                                  gint value);

gint         gtk_xine_engine_get_param           (GtkXine *gtx,
                                                  gint value);

gint         gtk_xine_get_audio_lang             (GtkXine *gtx,
                                                  gint channel,
                                                  gchar *lang);
gint         gtk_xine_get_spu_lang               (GtkXine *gtx,
                                                  gint channel,
                                                  gchar *lang);

void         gtk_xine_set_fullscreen             (GtkXine *gtx,
                                                  gboolean fullscreen);
gint         gtk_xine_is_fullscreen              (GtkXine *gtx);

void         gtk_xine_set_resize_factor          (GtkXine *gtx,
                                                  gdouble factor);

gint         gtk_xine_get_current_frame          (GtkXine *gtx,
                                                  gint *width,
                                                  gint *height,
                                                  gint *ratio_code,
                                                  gint *format,
                                                  guint8 *img);

gint         gtk_xine_get_log_section_count      (GtkXine *gtx);
gchar **     gtk_xine_get_log_names              (GtkXine *gtx);
gchar **     gtk_xine_get_log                    (GtkXine *gtx,
                                                  gint buf);
void         gtk_xine_register_log_cb            (GtkXine *gtx,
                                                  xine_log_cb_t cb,
                                                  gpointer user_data);

gchar **     gtk_xine_get_browsable_input_plugin_ids
                                                 (GtkXine * gtx);
xine_mrl_t **gtk_xine_get_browse_mrls            (GtkXine *gtx,
                                                  const gchar *plugin_id,
                                                  const gchar *start_mrl,
                                                  gint *num_mrls);
GList *      gtk_xine_get_autoplay_input_plugin_ids
                                                 (GtkXine *gtx);
GList *      gtk_xine_get_autoplay_mrls          (GtkXine *gtx,
                                                  const gchar *plugin_id);
gchar *      gtk_xine_get_file_extensions        (GtkXine *gtx);
gchar *      gtk_xine_get_mime_types             (GtkXine *gtx);

G_CONST_RETURN gchar *gtk_xine_config_register_string
                                                 (GtkXine *gtx,
                                                  const gchar *key,
                                                  const gchar *def_value,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         gtk_xine_config_register_range      (GtkXine *gtx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  gint min,
                                                  gint max,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         gtk_xine_config_register_enum       (GtkXine *gtx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  gchar **values,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         gtk_xine_config_register_num        (GtkXine *gtx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         gtk_xine_config_register_bool       (GtkXine *gtx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         gtk_xine_config_get_first_entry     (GtkXine *gtx,
                                                  xine_cfg_entry_t *entry);
gint         gtk_xine_config_get_next_entry      (GtkXine *gtx,
                                                  xine_cfg_entry_t * entry);
gint         gtk_xine_config_lookup_entry        (GtkXine *gtx,
                                                  const gchar *key,
                                                  xine_cfg_entry_t *entry);
void         gtk_xine_config_update_entry        (GtkXine *gtx,
                                                  xine_cfg_entry_t *entry);
void         gtk_xine_config_load                (GtkXine *gtx,
                                                  const gchar *cfg_filename);
void         gtk_xine_config_save                (GtkXine *gtx,
                                                  const gchar *cfg_filename);
void         gtk_xine_config_reset               (GtkXine *gtx);

xine_event_queue_t *gtk_xine_event_new_queue     (GtkXine *gtx);

void         gtk_xine_event_send                 (GtkXine *gtx,
                                                  const xine_event_t *event);

GList *      gtk_xine_list_post_plugins_typed    (GtkXine *gtx,
                                                  gint type);

void         gtk_xine_set_vis                    (GtkXine *gtx,
                                                  const gchar *id);

xine_t *gtk_xine_get_raw_xine_engine             (GtkXine *gtx);
xine_stream_t *gtk_xine_get_raw_stream           (GtkXine *gtx);
xine_audio_port_t *gtk_xine_get_raw_audio_port   (GtkXine *gtx);
xine_video_port_t *gtk_xine_get_raw_video_port   (GtkXine *gtx);
xine_post_t *gtk_xine_get_raw_post_plugin        (GtkXine *gtx);

GdkWindow *gtk_xine_get_fullscreen_window        (GtkXine *gtx);

void gtk_xine_port_send_gui_data                 (GtkXine *gtx,
                                                  gint type,
                                                  gpointer data);

/* FIXME: OSD missing */

G_END_DECLS

#endif
