/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * xfmedia's media mark system only allows unique entries.  an entry is
 * judged to be a duplicate if both the path and uri are identical.  the
 * path is the menu-hierarchy path of the item, not including the actual
 * name of the item.
 */

#ifndef __XFMEDIA_MEDIAMARKS_H__
#define __XFMEDIA_MEDIAMARKS_H__

#include <glib.h>
#include <gtk/gtkwidget.h>

#include "xfmedia-common.h"

G_BEGIN_DECLS

/* if |uri| is NULL, it's a branch (folder) */
typedef struct
{
    gchar *name;
    gchar *uri;
    gint index;
} XfMediaMediamark;

typedef void (*MMChangedCallback)(gpointer data);

void xfmedia_mediamarks_init();
void xfmedia_mediamarks_cleanup();

gboolean xfmedia_mediamarks_load(const gchar *filename);
gboolean xfmedia_mediamarks_save(const gchar *filename);

GNode *xfmedia_mediamarks_insert_folder(GNode *parent, const gchar *name, gint index);
gboolean xfmedia_mediamarks_remove_folder(GNode *folder_node);

GNode *xfmedia_mediamarks_insert_mark(GNode *parent, const gchar *name, const gchar *uri, gint index);
gboolean xfmedia_mediamarks_remove_mark(GNode *mmark_node);

void xfmedia_mediamarks_hook_changed(MMChangedCallback callback, gpointer data);

GNode *xfmedia_mediamarks_get_tree();

GtkWidget *xfmedia_mediamarks_create_menu(XfMediaMainwin *mwin);
GNode *xfmedia_mediamarks_add(XfMediaMainwin *mwin, GtkWindow *parent, const gchar *title, const gchar *uri);

G_END_DECLS

#endif
