<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">
  <xsl:output method="xml" encoding="UTF-8"/>
  <xsl:param name="file-b"/>
  <xsl:param name="prep-mode" select="'merge'"/>
  <xsl:param name="skip-b-no-compile" select="'yes'"/>
  <xsl:param name="use-compile-globals" select="'no'"/>
  <xsl:variable name="newline">
    <xsl:text>
</xsl:text>
  </xsl:variable>
  <xsl:variable name="ubg">
    <xsl:choose>
      <xsl:when test="$use-compile-globals = 'yes'">
	<xsl:choose>
	  <xsl:when test="document($file-b)/xgridfit/default[@type='compile-globals' and @value='no']">
	    <xsl:text>no</xsl:text>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:text>yes</xsl:text>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>yes</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="use-b-globals" select="$ubg='yes'"/>

  <xsl:template match="/">
    <xsl:apply-templates select="xgridfit"/>
  </xsl:template>

  <xsl:template match="xgridfit">
    <xgridfit>
      <xsl:value-of select="$newline"/>
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/glyph-select">
	  <xsl:apply-templates select="document($file-b)/xgridfit/glyph-select" mode="add-newline"/>
	</xsl:when>
	<xsl:when test="glyph-select">
	  <xsl:apply-templates select="glyph-select" mode="add-newline"/>
	</xsl:when>
      </xsl:choose>
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/infile">
	  <xsl:apply-templates select="document($file-b)/xgridfit/infile" mode="add-newline"/>
	</xsl:when>
	<xsl:when test="infile">
	  <xsl:apply-templates select="infile" mode="add-newline"/>
	</xsl:when>
      </xsl:choose>
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/outfile">
	  <xsl:apply-templates select="document($file-b)/xgridfit/outfile" mode="add-newline"/>
	</xsl:when>
	<xsl:when test="outfile">
	  <xsl:apply-templates select="outfile" mode="add-newline"/>
	</xsl:when>
      </xsl:choose>
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/outfile-base">
	  <xsl:apply-templates select="document($file-b)/xgridfit/outfile-base"
			       mode="add-newline"/>
	</xsl:when>
	<xsl:when test="outfile-base">
	  <xsl:apply-templates select="outfile-base" mode="add-newline"/>
	</xsl:when>
      </xsl:choose>
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/outfile-script-name">
	  <xsl:apply-templates select="document($file-b)/xgridfit/outfile-script-name"
			       mode="add-newline"/>
	</xsl:when>
	<xsl:when test="outfile-script-name">
	  <xsl:apply-templates select="outfile-script-name" mode="add-newline"/>
	</xsl:when>
      </xsl:choose>
      <xsl:if test="$skip-b-no-compile = 'no'">
	<xsl:choose>
	  <xsl:when test="no-compile">
	    <xsl:apply-templates select="no-compile" mode="global-a"/>
	  </xsl:when>
	  <xsl:when test="$use-b-globals">
	    <xsl:apply-templates select="document($file-b)/xgridfit/no-compile" mode="global-b"/>
	  </xsl:when>
	</xsl:choose>
      </xsl:if>
      <xsl:call-template name="make-storage-default"/>
      <xsl:call-template name="make-stack-default"/>
      <xsl:apply-templates select="default[@type != 'max-storage' and @type != 'max-stack']"
			   mode="global-a"/>
      <xsl:if test="$use-b-globals">
	<xsl:apply-templates select="document($file-b)/xgridfit/default[@type != 'max-storage'
				     and @type != 'max-stack' and @type != 'compile-globals']"
			     mode="add-newline"/>
      </xsl:if>
      <xsl:apply-templates select="constant" mode="global-a"/>
      <xsl:apply-templates select="document($file-b)/xgridfit/constant" mode="add-newline"/>
      <xsl:apply-templates select="alias" mode="global-a"/>
      <xsl:apply-templates select="document($file-b)/xgridfit/alias" mode="add-newline"/>
      <xsl:apply-templates select="variable" mode="global-a"/>
      <xsl:apply-templates select="document($file-b)/xgridfit/variable" mode="add-newline"/>
      <xsl:apply-templates select="round-state" mode="global-a"/>
      <xsl:apply-templates select="document($file-b)/xgridfit/round-state" mode="add-newline"/>
      <xsl:apply-templates select="control-value" mode="global-a"/>
      <xsl:comment>
<xsl:text>
  Warning: control values above this point should not be added,
  deleted or reordered. They may be renamed and their values
  changed.
</xsl:text>
      </xsl:comment>
      <xsl:value-of select="$newline"/>
      <xsl:if test="$use-b-globals">
	<xsl:apply-templates select="document($file-b)/xgridfit/control-value" mode="global-b">
	  <xsl:with-param name="xg" select="."/>
	</xsl:apply-templates>
      </xsl:if>
      <xsl:apply-templates select="legacy-functions"/>
      <xsl:value-of select="$newline"/>
      <xsl:apply-templates select="function" mode="global-a"/>
      <xsl:if test="$use-b-globals">
	<xsl:apply-templates select="document($file-b)/xgridfit/function" mode="add-newline"/>
      </xsl:if>
      <xsl:apply-templates select="macro" mode="global-a"/>
      <xsl:if test="$use-b-globals">
	<xsl:apply-templates select="document($file-b)/xgridfit/macro" mode="add-newline"/>
      </xsl:if>
      <xsl:choose>
	<xsl:when test="$use-b-globals and pre-program and $prep-mode='merge'">
	  <xsl:apply-templates select="pre-program"/>
	</xsl:when>
	<xsl:when test="pre-program and $prep-mode='priority'">
	  <xsl:choose>
	    <xsl:when test="$use-b-globals and document($file-b)/xgridfit/pre-program">
	      <xsl:copy-of select="document($file-b)/xgridfit/pre-program"/>
	    </xsl:when>
	    <xsl:when test="pre-program">
	      <xsl:copy-of select="pre-program"/>
	    </xsl:when>
	  </xsl:choose>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:copy-of select="pre-program"/>
	</xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="glyph" mode="global-a"/>
      <xsl:apply-templates select="document($file-b)/xgridfit/glyph" mode="add-newline"/>
    </xgridfit>
  </xsl:template>

  <xsl:template name="make-storage-default">
    <xsl:variable name="local-max">
      <xsl:variable name="m">
	<xsl:choose>
	  <xsl:when test="default[@type='max-storage']">
	    <xsl:value-of select="default[@type='max-storage']/@value"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="64"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:variable>
      <xsl:variable name="l">
	<xsl:choose>
	  <xsl:when test="default[@type='legacy-storage']">
	    <xsl:value-of select="default[@type='legacy-storage']/@value"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="64"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:variable>
      <xsl:choose>
	<xsl:when test="number($m) &gt; number($l)">
	  <xsl:value-of select="$m"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$l"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="other-max">
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/default[@type='max-storage']">
	  <xsl:value-of select="document($file-b)/xgridfit/default[@type='max-storage']/@value"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="64"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <default>
      <xsl:attribute name="type">
	<xsl:value-of select="'max-storage'"/>
      </xsl:attribute>
      <xsl:attribute name="value">
	<xsl:value-of select="number($local-max) + number($other-max)"/>
      </xsl:attribute>
    </default>
  </xsl:template>

  <xsl:template name="make-stack-default">
    <xsl:variable name="local-val">
      <xsl:choose>
	<xsl:when test="default[@type='max-stack']">
	  <xsl:value-of select="default[@type='max-stack']/@value"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="256"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="other-val">
      <xsl:choose>
	<xsl:when test="document($file-b)/xgridfit/default[@type='max-stack']">
	  <xsl:value-of select="document($file-b)/xgridfit/default[@type='max-stack']/@value"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="256"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="larger-val">
      <xsl:choose>
	<xsl:when test="number($local-val) &gt; number($other-val)">
	  <xsl:value-of select="$local-val"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$other-val"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="number($larger-val) != 256">
      <default>
	<xsl:attribute name="type">
	  <xsl:text>max-stack</xsl:text>
	</xsl:attribute>
	<xsl:attribute name="value">
	  <xsl:value-of select="$larger-val"/>
	</xsl:attribute>
      </default>
    </xsl:if>
  </xsl:template>

  <xsl:template match="node()|@*" priority="-0.5">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="node()|@*" priority="-0.5" mode="add-newline">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <xsl:template match="constant" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not(document($file-b)/xgridfit/constant[@name=$n])">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="alias" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not(document($file-b)/xgridfit/alias[@name=$n])">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="variable" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not(document($file-b)/xgridfit/variable[@name=$n])">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="round-state" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not(document($file-b)/xgridfit/round-state[@name=$n])">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="default" mode="global-a">
    <xsl:variable name="t" select="@type"/>
    <xsl:if test="not(use-b-globals) or
		  ($use-b-globals and not(document($file-b)/xgridfit/default[@type=$t]))">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="control-value" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:choose>
      <xsl:when test="$use-b-globals and document($file-b)/xgridfit/control-value[@name=$n]">
	<control-value>
	  <xsl:attribute name="name">
	    <xsl:value-of select="$n"/>
	  </xsl:attribute>
	  <xsl:attribute name="value">
	    <xsl:value-of select="document($file-b)/xgridfit/control-value/@value"/>
	  </xsl:attribute>
	</control-value>
	<xsl:value-of select="$newline"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:apply-templates select="." mode="add-newline"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="control-value" mode="global-b">
    <xsl:param name="xg"/>
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not($xg/control-value[@name=$n])">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="no-compile" mode="global-a">
    <no-compile>
      <xsl:choose>
	<xsl:when test="$use-b-globals">
	  <xsl:for-each select="glyph">
	    <xsl:variable name="n" select="@ps-name"/>
	    <xsl:if test="not(document($file-b)/xgridfit/no-compile/glyph[@ps-name=$n])">
	      <xsl:apply-templates select="." mode="add-newline"/>
	    </xsl:if>
	  </xsl:for-each>
	  <xsl:apply-templates select="document($file-b)/xgridfit/no-compile/glyph" mode="add-newline"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:apply-templates select="glyph" mode="add-newline"/>
	</xsl:otherwise>
      </xsl:choose>
    </no-compile>
  </xsl:template>

  <xsl:template match="no-compile" mode="global-b">
    <no-compile>
      <xsl:apply-templates select="glyph" mode="add-newline"/>
    </no-compile>
  </xsl:template>

  <xsl:template match="function" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not($use-b-globals) or
		  ($use-b-globals and not(document($file-b)/xgridfit/function[@name=$n]))">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="macro" mode="global-a">
    <xsl:variable name="n" select="@name"/>
    <xsl:if test="not($use-b-globals) or
		  ($use-b-globals and not(document($file-b)/xgridfit/macro[@name=$n]))">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="pre-program">
    <pre-program>
      <xsl:if test="document($file-b)/xgridfit/pre-program/@xml:id">
	<xsl:attribute name="xml:id">
	  <xsl:value-of select="document($file-b)/xgridfit/pre-program/@xml:id"/>
	</xsl:attribute>
      </xsl:if>
      <xsl:value-of select="$newline"/>
      <xsl:if test="variable|alias">
	<xsl:apply-templates select="variable|alias" mode="add-newline"/>
      </xsl:if>
      <xsl:if test="document($file-b)/xgridfit/pre-program/variable |
		    document($file-b)/xgridfit/pre-program/alias">
	<xsl:apply-templates select="document($file-b)/xgridfit/pre-program/variable |
				     document($file-b)/xgridfit/pre-program/alias"
			     mode="add-newline"/>
      </xsl:if>
      <xsl:apply-templates select="./*[local-name() != 'variable' and local-name() != 'alias']"
			   mode="add-newline"/>
      <xsl:if test="document($file-b)/xgridfit/pre-program">
	<xsl:apply-templates
	    select="document($file-b)/xgridfit/pre-program/*[local-name() != 'variable' and
		    local-name() != 'alias']"
		    mode="add-newline"/>
      </xsl:if>
    </pre-program>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <xsl:template match="glyph" mode="global-a">
    <xsl:variable name="p" select="@ps-name"/>
    <xsl:if test="not(document($file-b)/xgridfit/glyph[@ps-name=$p])">
      <xsl:apply-templates select="." mode="add-newline"/>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
