/*
    $Id: parse.h,v 1.7 2002/05/24 05:51:59 belyi Exp $

    xkeysw - window bound/multi code keyboard switch
    Copyright (C) 1999  Dima Barsky, Igor Belyi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef XKEYSW_PARSE_H
#define XKEYSW_PARSE_H

#include <stdio.h>

/* Parsed config file is translated into this type of records */
struct parsedCodeRecord_t;

typedef struct parsedSwitchKey_t {
    char* codeName;
    char* keyName;
    char* newName;
    unsigned int modifiers;
    struct parsedCodeRecord_t* code;
    struct parsedSwitchKey_t* next;
} parsedSwitchKey_t;

typedef struct parsedCodeRecord_t {
    char* name;
    char* prefix;
    char* xmmfile;
    int hasSpecific;
    int index;
    parsedSwitchKey_t* switchKeys;
    struct parsedCodeRecord_t* next;
} parsedCodeRecord_t;

extern parsedCodeRecord_t *ParsedConfFile;
extern parsedCodeRecord_t *DefaultRecord;

int ParseConfigFile(FILE* cfd);
int AdjustParsedRecords();
void freeParsedRecords();

#endif
